/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.coordsys.proj;

import com.mapinfo.coordsys.Ellipsoid;
import com.mapinfo.coordsys.MIProProjection;
import com.mapinfo.coordsys.Projection;
import com.mapinfo.unit.Angle;
import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.MeasuredQuantity;
import com.mapinfo.util.ComplexNumber;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.MathUtil;

public class TransverseMercator
extends MIProProjection {
    private DoublePoint a;
    private double b;
    private double c;
    private double d;
    private int e;
    private Angle f;
    private Angle g;
    private Distance h;
    private Distance i;
    private double j;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    private double u;
    private ComplexNumber v = new ComplexNumber();
    private ComplexNumber w = new ComplexNumber();
    private ComplexNumber x = new ComplexNumber();
    private DoubleRect y;
    private DoubleRect z;
    private static final double[][] aa = new double[][]{{199371.14647, -265381.72775}, {1.0001365021, 0.019995520454}, {-1.648605326E-11, 3.4452862838E-10}, {-1.8877421278E-17, -9.6740792784E-17}};
    private static final double[][] ab = new double[][]{{6232935.0512, 595335.58288}, {0.99950870832, -0.019984265541}, {-2.27324697E-11, -3.3921905837E-10}, {2.6264691305E-17, 9.4810550416E-17}};
    private static final double[][] ac = new double[][]{{96432.190004, -119353.22229}, {0.99980074884, 0.019555849611}, {-7.207782018E-12, 2.1675209626E-9}, {6.2510854612E-17, -2.521500272E-16}};
    private static final double[][] ad = new double[][]{{6232935.6122, 595335.3482}, {0.9994550822, -0.019979251874}, {-7.3897597436E-11, -2.0717946709E-9}, {-5.2080308192E-17, 2.5703781294E-16}};
    private static final double[][] ae = new double[][]{{42579.934018, -42993.547686}, {1.0004053319, -0.0014643915438}, {-7.7039294168E-11, -4.7898338026E-10}, {4.7460391692E-15, 3.7432077762E-14}, {1.8259975589E-18, -4.8899686702E-18}, {-2.072795996E-22, 2.0540300545E-22}, {7.0257273976E-27, -2.9421011013E-27}, {-8.0529957628E-32, 1.5387577766E-33}};
    private static final double[][] af = new double[][]{{6107427.3382, 493007.25696}, {0.99959968336, 0.0014686762273}, {1.2072957024E-10, 5.4905973626E-10}, {-9.459344988E-15, 2.151083324E-15}, {6.5994864072E-19, -1.0163477904E-18}, {2.4410466467E-23, 4.4726583308E-23}, {-2.8946629725E-27, -1.1066966998E-27}, {8.0282195772E-32, -5.8658108998E-34}};
    private static final double ag = 1.0000007515;
    private static final double ah = 4.3933E-6;
    private static final double ai = -61.5805;
    private static final double aj = 95.6691;

    public TransverseMercator() {
        super("Transverse Mercator");
    }

    public TransverseMercator(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, DoublePoint doublePoint, double d2, double d3, double d4, int n) {
        this();
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = new DoublePoint(doublePoint);
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = n;
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Distance(d3, linearUnit);
        this.i = new Distance(d4, linearUnit);
        this.a();
    }

    public void init(AngularUnit angularUnit, LinearUnit linearUnit, Ellipsoid ellipsoid, MeasuredQuantity[] measuredQuantityArray) {
        DoublePoint doublePoint;
        this.init(angularUnit, linearUnit, ellipsoid);
        this.a = doublePoint = new DoublePoint(measuredQuantityArray[0].getScalarValue(angularUnit), measuredQuantityArray[1].getScalarValue(angularUnit));
        this.b = measuredQuantityArray[2].getScalarValue();
        this.c = measuredQuantityArray[3].getScalarValue(linearUnit);
        this.d = measuredQuantityArray[4].getScalarValue(linearUnit);
        this.f = new Angle(doublePoint.x, angularUnit);
        this.g = new Angle(doublePoint.y, angularUnit);
        this.h = new Distance(this.c, linearUnit);
        this.i = new Distance(this.d, linearUnit);
        this.e = measuredQuantityArray.length == 6 ? (int)measuredQuantityArray[5].getScalarValue() : 8;
        this.a();
    }

    public String getWellKnownText() {
        return "PROJECTION[\"" + this.getName() + "\"]," + "PARAMETER[\"Central_Meridian\"," + this.a.x + "]," + "PARAMETER[\"Latitude_of_Origin\"," + this.a.y + "]," + "PARAMETER[\"Scale_Factor\"," + this.b + "]," + "PARAMETER[\"False_Easting\"," + this.c + "]," + "PARAMETER[\"False_Northing\"," + this.d + "]";
    }

    public boolean equals(Projection projection) {
        if (projection instanceof TransverseMercator) {
            TransverseMercator transverseMercator = (TransverseMercator)projection;
            return super.equals(transverseMercator) && this.a.equals(transverseMercator.a) && this.b == transverseMercator.b && this.c == transverseMercator.c && this.d == transverseMercator.d && this.e == transverseMercator.e;
        }
        return false;
    }

    public boolean equivalent(Projection projection) {
        if (projection instanceof TransverseMercator) {
            TransverseMercator transverseMercator = (TransverseMercator)projection;
            boolean bl = super.equivalent(transverseMercator) && this.f.equivalent(transverseMercator.f) && this.g.equivalent(transverseMercator.g) && this.b == transverseMercator.b && this.h.equivalent(transverseMercator.h) && this.i.equivalent(transverseMercator.i) && this.e == transverseMercator.e;
            return bl;
        }
        return false;
    }

    public static boolean isValidType(int n) {
        return n == 8 || n == 21 || n == 22 || n == 23 || n == 24;
    }

    public int getType() {
        return this.e;
    }

    public double[] getParamArray(AngularUnit angularUnit, LinearUnit linearUnit) {
        return new double[]{angularUnit.convert(this.a.x, this.m_AngularUnit), angularUnit.convert(this.a.y, this.m_AngularUnit), this.b, linearUnit.convert(this.c, this.m_LinearUnit), linearUnit.convert(this.d, this.m_LinearUnit)};
    }

    private void a() {
        if (!TransverseMercator.isValidType(this.e)) {
            this.e = 8;
        }
        this.j = this.m_Ellipsoid.e2() / (1.0 - this.m_Ellipsoid.e2());
        this.k = AngularUnit.radian.convertClipX(this.a.x, this.m_AngularUnit);
        double d2 = AngularUnit.radian.convertClipY(this.a.y, this.m_AngularUnit);
        this.l = this.b;
        if (this.l == 0.0) {
            this.l = 1.0;
        }
        double d3 = this.m_Ellipsoid.e2() * this.m_Ellipsoid.e2();
        double d4 = this.m_Ellipsoid.e2() * d3;
        this.n = this.m_Ellipsoid.a() * (1.0 - this.m_Ellipsoid.e2() / 4.0 - 3.0 * d3 / 64.0 - 5.0 * d4 / 256.0);
        double d5 = this.m_Ellipsoid.a() * -(3.0 * this.m_Ellipsoid.e2() / 8.0 + 3.0 * d3 / 32.0 + 45.0 * d4 / 1024.0);
        double d6 = this.m_Ellipsoid.a() * (15.0 * d3 / 256.0 + 45.0 * d4 / 1024.0);
        double d7 = this.m_Ellipsoid.a() * -35.0 * d4 / 3072.0;
        this.o = d5 - d7;
        this.p = 2.0 * d6;
        this.q = 4.0 * d7;
        double d8 = d2 * 2.0;
        double d9 = Math.cos(d8);
        this.m = this.n * d2 + Math.sin(d8) * (this.o + d9 * (this.p + d9 * this.q));
        double d10 = Math.sqrt(1.0 - this.m_Ellipsoid.e2());
        double d11 = (1.0 - d10) / (1.0 + d10);
        double d12 = d11 * d11;
        double d13 = d12 * d11;
        double d14 = d12 * d12;
        d5 = 3.0 * d11 / 2.0 - 27.0 * d13 / 32.0;
        d6 = 21.0 * d12 / 16.0 - 55.0 * d14 / 32.0;
        d7 = 151.0 * d13 / 96.0;
        double d15 = 1097.0 * d14 / 512.0;
        this.r = d5 - d7;
        this.s = 2.0 * d6 - 4.0 * d15;
        this.t = 4.0 * d7;
        this.u = 8.0 * d15;
        if (this.e == 23) {
            this.y = new DoubleRect(14.3, 54.8, 15.6, 55.6);
            this.m_AngularUnit.convert(this.y, AngularUnit.degree);
            double[] dArray = new double[8];
            this.y.get(dArray, 4);
            this.forward(dArray, 0, dArray, 0, 4);
            this.z = new DoubleRect(dArray, 4);
        }
    }

    public double getScaleFactor(double d2, double d3) {
        double d4;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double d5 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
        double d6 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit);
        double d7 = Math.cos(d5);
        if (d7 == 0.0) {
            d4 = this.l;
        } else {
            dArray2[0] = d2;
            dArray2[1] = d3;
            switch (this.e) {
                case 21: {
                    this.forward(dArray2, 0, dArray, 0, 1);
                    double d8 = -2.65 - dArray[0] * 1.0E-5;
                    d4 = 0.99995 + 1.2259E-4 * d8 * d8;
                    break;
                }
                case 22: {
                    this.forward(dArray2, 0, dArray, 0, 1);
                    double d9 = -1.19 - dArray[0] * 1.0E-5;
                    d4 = 0.999978 + 1.2261E-4 * d9 * d9;
                    break;
                }
                case 23: {
                    d4 = 1.0;
                    break;
                }
                default: {
                    double d10 = Math.tan(d5);
                    double d11 = d10 * d10;
                    double d12 = d11 * d11;
                    double d13 = this.j * d7 * d7;
                    double d14 = d13 * d13;
                    double d15 = (d6 - this.k) * d7;
                    double d16 = d15 * d15;
                    double d17 = d16 * d16;
                    double d18 = d17 * d16;
                    d4 = this.l * (1.0 + (1.0 + d13) * d16 / 2.0 + (5.0 - 4.0 * d11 + 42.0 * d13 + 13.0 * d14 - 28.0 * this.j) * d17 / 24.0 + (61.0 - 148.0 * d11 + 16.0 * d12) * d18 / 720.0);
                }
            }
        }
        return d4;
    }

    public synchronized void forward(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        double[][] dArray3 = null;
        boolean bl = false;
        while (n3-- > 0) {
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            if (this.e == 24) {
                d2 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit);
                d3 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
                double d4 = this.m_Ellipsoid.f() / (2.0 - this.m_Ellipsoid.f());
                double d5 = this.m_Ellipsoid.a() * (1.0 + d4 * d4 / 4.0 + d4 * d4 * d4 * d4 / 64.0) / (1.0 + d4);
                double d6 = Math.sqrt(this.m_Ellipsoid.e2());
                double d7 = d4 * d4;
                double d8 = d7 * d4;
                double d9 = d8 * d4;
                d2 -= this.k;
                double d10 = Math.tan(d3);
                double d11 = Math.log(d10 + Math.sqrt(d10 * d10 + 1.0));
                d10 = d6 * Math.sin(d3);
                double d12 = 0.5 * Math.log((1.0 + d10) / (1.0 - d10));
                double d13 = d11 - d6 * d12;
                double d14 = d2;
                double d15 = d4 / 2.0 - 2.0 * d7 / 3.0 + 5.0 * d8 / 16.0 + 41.0 * d9 / 180.0;
                double d16 = 13.0 * d7 / 48.0 - 3.0 * d8 / 5.0 + 557.0 * d9 / 1440.0;
                double d17 = 61.0 * d8 / 240.0 - 103.0 * d9 / 140.0;
                double d18 = 49561.0 * d9 / 161280.0;
                d10 = (Math.exp(d13) - Math.exp(-d13)) / 2.0;
                double d19 = Math.atan(d10);
                d10 = Math.cos(d19) * Math.sin(d14);
                double d20 = 0.5 * Math.log((1.0 + d10) / (1.0 - d10));
                d10 = 2.0 / (Math.exp(d20) + Math.exp(-d20));
                double d21 = Math.asin(MathUtil.clip((double)(Math.sin(d19) / d10), (double)-1.0, (double)1.0));
                double d22 = d21 + d15 * Math.sin(2.0 * d21) * (Math.exp(2.0 * d20) + Math.exp(-2.0 * d20)) / 2.0 + d16 * Math.sin(4.0 * d21) * (Math.exp(4.0 * d20) + Math.exp(-4.0 * d20)) / 2.0 + d17 * Math.sin(6.0 * d21) * (Math.exp(6.0 * d20) + Math.exp(-6.0 * d20)) / 2.0 + d18 * Math.sin(8.0 * d21) * (Math.exp(8.0 * d20) + Math.exp(-8.0 * d20)) / 2.0;
                double d23 = d20 + d15 * Math.cos(2.0 * d21) * (Math.exp(2.0 * d20) - Math.exp(-2.0 * d20)) / 2.0 + d16 * Math.cos(4.0 * d21) * (Math.exp(4.0 * d20) - Math.exp(-4.0 * d20)) / 2.0 + d17 * Math.cos(6.0 * d21) * (Math.exp(6.0 * d20) - Math.exp(-6.0 * d20)) / 2.0 + d18 * Math.cos(8.0 * d21) * (Math.exp(8.0 * d20) - Math.exp(-8.0 * d20)) / 2.0;
                d3 = d5 * d22;
                d2 = d5 * d23;
                d2 = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit) + this.c;
                d3 = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.d;
            } else {
                if (this.e == 23) {
                    d2 = MathUtil.clip((double)d2, (double)this.y.xmin, (double)this.y.xmax);
                    d3 = MathUtil.clip((double)d3, (double)this.y.ymin, (double)this.y.ymax);
                }
                d2 = AngularUnit.radian.convertClipX(d2, this.m_AngularUnit);
                double d24 = d3 = AngularUnit.radian.convertClipY(d3, this.m_AngularUnit);
                double d25 = d24 * 2.0;
                double d26 = Math.cos(d25);
                double d27 = this.n * d24 + Math.sin(d25) * (this.o + d26 * (this.p + d26 * this.q));
                double d28 = Math.cos(d24);
                if (d28 == 0.0) {
                    d2 = 0.0;
                    d3 = this.l * (d27 - this.m);
                } else {
                    double d29 = Math.sin(d24);
                    double d30 = this.m_Ellipsoid.a() / Math.sqrt(1.0 - this.m_Ellipsoid.e2() * d29 * d29);
                    double d31 = Math.tan(d24);
                    double d32 = d31 * d31;
                    double d33 = d32 * d32;
                    double d34 = this.j * d28 * d28;
                    double d35 = d34 * d34;
                    double d36 = (d2 - this.k) * d28;
                    double d37 = d36 * d36;
                    double d38 = d36 * d37;
                    double d39 = d37 * d37;
                    double d40 = d37 * d38;
                    double d41 = d38 * d38;
                    d2 = this.l * d30 * (d36 + (1.0 - d32 + d34) * d38 / 6.0 + (5.0 - 18.0 * d32 + d33 + 72.0 * d34 - 58.0 * this.j) * d40 / 120.0);
                    d3 = this.l * (d27 - this.m + d30 * d31 * (d37 / 2.0 + (5.0 - d32 + 9.0 * d34 + 4.0 * d35) * d39 / 24.0 + (61.0 - 58.0 * d32 + d33 + 600.0 * d34 - 330.0 * this.j) * d41 / 720.0));
                }
                d2 = this.m_LinearUnit.convert(d2, this.m_EllipsoidUnit) + this.c;
                d3 = this.m_LinearUnit.convert(d3, this.m_EllipsoidUnit) + this.d;
                if (this.e == 21) {
                    this.v.set(d3 - 6231000.0, d2 - 530000.0);
                    dArray3 = aa;
                    bl = true;
                }
                if (this.e == 22) {
                    this.v.set(d3 - 6131000.0, d2 - 678000.0);
                    dArray3 = ac;
                    bl = true;
                }
                if (this.e == 23) {
                    this.v.set(d3 - 6100000.0, d2 - 500000.0);
                    dArray3 = ae;
                    bl = true;
                }
                if (bl) {
                    this.w.set(0.0, 0.0);
                    int n4 = dArray3.length - 1;
                    while (n4 >= 0) {
                        this.x.set(dArray3[n4][0], dArray3[n4][1]);
                        this.w.mult(this.v);
                        this.w.add(this.x);
                        --n4;
                    }
                    d2 = this.w.getImaginary();
                    d3 = this.w.getReal();
                }
            }
            dArray2[n2++] = d2;
            dArray2[n2++] = d3;
        }
    }

    public synchronized void inverse(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        boolean bl = false;
        double[][] dArray3 = null;
        while (n3-- > 0) {
            int n4;
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            if (this.e == 24) {
                double d4;
                d2 -= this.c;
                d3 -= this.d;
                double d5 = this.m_Ellipsoid.f() / (2.0 - this.m_Ellipsoid.f());
                double d6 = this.m_Ellipsoid.a() * (1.0 + d5 * d5 / 4.0 + d5 * d5 * d5 * d5 / 64.0) / (1.0 + d5);
                double d7 = Math.sqrt(this.m_Ellipsoid.e2());
                double d8 = d5 * d5;
                double d9 = d8 * d5;
                double d10 = d9 * d5;
                double d11 = d3 / d6;
                double d12 = d2 / d6;
                double d13 = d5 / 2.0 - 2.0 * d8 / 3.0 + 37.0 * d9 / 96.0 - d10 / 360.0;
                double d14 = d8 / 48.0 + d9 / 45.0 - 437.0 * d10 / 1440.0;
                double d15 = 17.0 * d9 / 480.0 - 37.0 * d10 / 840.0;
                double d16 = 4397.0 * d10 / 161280.0;
                double d17 = d11 - d13 * Math.sin(2.0 * d11) * (Math.exp(2.0 * d12) + Math.exp(-2.0 * d12)) / 2.0 - d14 * Math.sin(4.0 * d11) * (Math.exp(4.0 * d12) + Math.exp(-4.0 * d12)) / 2.0 - d15 * Math.sin(6.0 * d11) * (Math.exp(6.0 * d12) + Math.exp(-6.0 * d12)) / 2.0 - d16 * Math.sin(8.0 * d11) * (Math.exp(8.0 * d12) + Math.exp(-8.0 * d12)) / 2.0;
                double d18 = d12 - d13 * Math.cos(2.0 * d11) * (Math.exp(2.0 * d12) - Math.exp(-2.0 * d12)) / 2.0 - d14 * Math.cos(4.0 * d11) * (Math.exp(4.0 * d12) - Math.exp(-4.0 * d12)) / 2.0 - d15 * Math.cos(6.0 * d11) * (Math.exp(6.0 * d12) - Math.exp(-6.0 * d12)) / 2.0 - d16 * Math.cos(8.0 * d11) * (Math.exp(8.0 * d12) - Math.exp(-8.0 * d12)) / 2.0;
                double d19 = 2.0 / (Math.exp(d18) + Math.exp(-d18));
                double d20 = Math.asin(MathUtil.clip((double)(d19 * Math.sin(d17)), (double)-1.0, (double)1.0));
                d19 = (Math.exp(d18) - Math.exp(-d18)) / (Math.exp(d18) + Math.exp(-d18));
                double d21 = Math.asin(MathUtil.clip((double)(d19 / Math.cos(d20)), (double)-1.0, (double)1.0));
                d19 = Math.tan(d20);
                double d22 = d4 = Math.log(d19 + Math.sqrt(d19 * d19 + 1.0));
                n4 = 0;
                while (n4 < 10) {
                    d19 = d7 * (Math.exp(d22) - Math.exp(-d22)) / (Math.exp(d22) + Math.exp(-d22));
                    d22 = d4 + d7 * 0.5 * Math.log((1.0 + d19) / (1.0 - d19));
                    ++n4;
                }
                d2 = d21;
                d3 = Math.atan((Math.exp(d22) - Math.exp(-d22)) / 2.0);
                d2 += this.k;
            } else {
                if (this.e == 23) {
                    d2 = MathUtil.clip((double)d2, (double)this.z.xmin, (double)this.z.xmax);
                    d3 = MathUtil.clip((double)d3, (double)this.z.ymin, (double)this.z.ymax);
                }
                if (this.e == 21) {
                    this.v.set(d3 - 200000.0, d2 + 200000.0);
                    dArray3 = ab;
                    bl = true;
                }
                if (this.e == 22) {
                    this.v.set(d3 - 200000.0, d2 + 200000.0);
                    dArray3 = ad;
                    bl = true;
                }
                if (this.e == 23) {
                    this.v.set(d3 - 50000.0, d2 + 50000.0);
                    dArray3 = af;
                    bl = true;
                }
                if (bl) {
                    this.w.set(0.0, 0.0);
                    n4 = dArray3.length - 1;
                    while (n4 >= 0) {
                        this.x.set(dArray3[n4][0], dArray3[n4][1]);
                        this.w.mult(this.v);
                        this.w.add(this.x);
                        --n4;
                    }
                    d2 = this.w.getImaginary();
                    d3 = this.w.getReal();
                }
                d2 = this.m_EllipsoidUnit.convert(d2 - this.c, this.m_LinearUnit);
                d3 = this.m_EllipsoidUnit.convert(d3 - this.d, this.m_LinearUnit);
                d3 = MathUtil.clip((double)d3, (double)-1.0E9, (double)1.0E9);
                double d23 = this.m + d3 / this.l;
                double d24 = d23 / this.n;
                double d25 = 2.0 * d24;
                double d26 = Math.cos(d25);
                double d27 = d24 + Math.sin(d25) * (this.r + d26 * (this.s + d26 * (this.t + d26 * this.u)));
                double d28 = Math.cos(d27);
                if (d28 == 0.0) {
                    d2 = this.k;
                    d3 = d3 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
                } else {
                    double d29 = this.j * d28 * d28;
                    double d30 = d29 * d29;
                    double d31 = Math.tan(d27);
                    double d32 = d31 * d31;
                    double d33 = d32 * d32;
                    double d34 = Math.sin(d27);
                    double d35 = 1.0 - this.m_Ellipsoid.e2() * d34 * d34;
                    double d36 = this.m_Ellipsoid.a() / Math.sqrt(d35);
                    double d37 = this.m_Ellipsoid.a() * (1.0 - this.m_Ellipsoid.e2()) / Math.pow(d35, 1.5);
                    double d38 = d2 / (d36 * this.l);
                    double d39 = d38 * d38;
                    double d40 = d38 * d39;
                    double d41 = d39 * d39;
                    double d42 = d39 * d40;
                    double d43 = d40 * d40;
                    d3 = d27 - d36 * d31 / d37 * (d39 / 2.0 - (5.0 + 3.0 * d32 + 10.0 * d29 - 4.0 * d30 - 9.0 * this.j) * d41 / 24.0 + (61.0 + 90.0 * d32 + 298.0 * d29 + 45.0 * d33 - 252.0 * this.j - 3.0 * d30) * d43 / 720.0);
                    d2 = this.k + (d38 - (1.0 + 2.0 * d32 + d29) * d40 / 6.0 + (5.0 - 2.0 * d29 + 28.0 * d32 - 3.0 * d30 + 8.0 * this.j + 24.0 * d33) * d42 / 120.0) / d28;
                }
            }
            dArray2[n2++] = this.m_AngularUnit.convertClipX(d2, AngularUnit.radian);
            dArray2[n2++] = this.m_AngularUnit.convertClipY(d3, AngularUnit.radian);
        }
    }

    static {
        ag = 1.0000007515;
        ah = 4.3933E-6;
        ai = -61.5805;
        aj = 95.6691;
    }
}

