/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.MeasuredQuantity;

public class Angle
extends MeasuredQuantity {
    public Angle(double d2, AngularUnit angularUnit) {
        super(d2, angularUnit);
    }

    public double getScalarValue(AngularUnit angularUnit) {
        return angularUnit.convert(this.a, this.b);
    }

    public AngularUnit getAngularUnit() {
        return (AngularUnit)this.b;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Angle)) {
            return false;
        }
        Angle angle = (Angle)object;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(angle.a)) {
            return false;
        }
        return this.b.equals(angle.b);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity) {
        return this.equivalent(measuredQuantity, 0.0);
    }

    public boolean equivalent(MeasuredQuantity measuredQuantity, double d2) {
        if (measuredQuantity.getUnit() instanceof AngularUnit) {
            double d3;
            double d4 = ((AngularUnit)measuredQuantity.getUnit()).getRadiansPerUnit() * measuredQuantity.getScalarValue();
            return Math.abs(d4 - (d3 = ((AngularUnit)this.b).getRadiansPerUnit() * this.a)) <= d2;
        }
        return false;
    }
}

