/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Unit;
import com.mapinfo.util.DoublePoint;
import com.mapinfo.util.DoubleRect;
import com.mapinfo.util.ObjectUtils;
import java.util.Hashtable;

public class LinearUnit
extends Unit {
    protected double a;
    protected double b;
    public static final short INDEX_MILE = 0;
    public static final short INDEX_KILOMETER = 1;
    public static final short INDEX_INCH = 2;
    public static final short INDEX_FOOT = 3;
    public static final short INDEX_YARD = 4;
    public static final short INDEX_MILLIMETER = 5;
    public static final short INDEX_CENTIMETER = 6;
    public static final short INDEX_METER = 7;
    public static final short INDEX_SURVEY_FOOT = 8;
    public static final short INDEX_NAUTICAL_MILE = 9;
    public static final short INDEX_TWIP = 10;
    public static final short INDEX_POINT = 11;
    public static final short INDEX_PICA = 12;
    public static final short INDEX_LINK = 30;
    public static final short INDEX_CHAIN = 31;
    public static final short INDEX_ROD = 32;
    private static final double[] c;
    private static final String[] d;
    private static final String[] e;
    private static final String[] f;
    public static final LinearUnit mile;
    public static final LinearUnit kilometer;
    public static final LinearUnit inch;
    public static final LinearUnit foot;
    public static final LinearUnit yard;
    public static final LinearUnit millimeter;
    public static final LinearUnit centimeter;
    public static final LinearUnit meter;
    public static final LinearUnit surveyFoot;
    public static final LinearUnit nauticalMile;
    public static final LinearUnit twip;
    public static final LinearUnit point;
    public static final LinearUnit pica;
    public static final LinearUnit link;
    public static final LinearUnit chain;
    public static final LinearUnit rod;
    private static Hashtable g;

    public LinearUnit(String string, double d2) {
        this.a(string, d2);
    }

    public LinearUnit(String string, String string2, double d2) {
        this.a(string, string2, d2);
    }

    public LinearUnit(String string, String string2) {
        LinearUnit linearUnit = null;
        String string3 = string2.toLowerCase() + ":" + string.toLowerCase();
        linearUnit = (LinearUnit)g.get(string3);
        if (linearUnit != null) {
            this.a(((Unit)linearUnit).c, ((Unit)linearUnit).d, linearUnit.a, ((Unit)linearUnit).f, ((Unit)linearUnit).e);
            return;
        }
        throw new IllegalArgumentException("code/codeSpace not found: " + string + "/" + string2);
    }

    protected LinearUnit(int n) {
        this.b(n);
    }

    LinearUnit(String string) {
        this.a(string);
    }

    private LinearUnit(LinearUnit linearUnit) {
        this.a(((Unit)linearUnit).c, ((Unit)linearUnit).d, linearUnit.a, ((Unit)linearUnit).f, ((Unit)linearUnit).e);
    }

    protected LinearUnit() {
    }

    static boolean a(int n) {
        return n >= 0 && n <= 12 || n >= 30 && n <= 32;
    }

    int a() {
        int n = 0;
        while (n < c.length) {
            if (this.a == c[n]) {
                return n <= 12 ? n : n + 17;
            }
            ++n;
        }
        return -1;
    }

    public double getMetersPerUnit() {
        return this.a;
    }

    public String getWellKnownText() {
        return "UNIT[\"" + ((Unit)this).c + "\"," + this.a + "]";
    }

    public double convert(double d2, Unit unit) {
        if (unit instanceof LinearUnit) {
            return this.convert(d2, (LinearUnit)unit);
        }
        if (unit instanceof AngularUnit) {
            return this.convert(d2, (AngularUnit)unit);
        }
        throw new UnsupportedOperationException("Conversion not allowed: LinearUnit to " + unit.getName());
    }

    public double convert(double d2, AngularUnit angularUnit) {
        d2 = AngularUnit.radian.convert(d2, angularUnit);
        return this.convert(d2 * 6370997.0, meter);
    }

    public double convert(double d2, LinearUnit linearUnit) {
        if (linearUnit.a == this.a) {
            return d2;
        }
        return d2 * linearUnit.a * this.b;
    }

    public void convert(DoublePoint doublePoint, LinearUnit linearUnit) {
        this.convert(doublePoint, doublePoint, linearUnit);
    }

    public void convert(DoublePoint doublePoint, DoublePoint doublePoint2, LinearUnit linearUnit) {
        doublePoint2.x = this.convert(doublePoint.x, linearUnit);
        doublePoint2.y = this.convert(doublePoint.y, linearUnit);
    }

    public void convert(DoubleRect doubleRect, LinearUnit linearUnit) {
        this.convert(doubleRect, doubleRect, linearUnit);
    }

    public void convert(DoubleRect doubleRect, DoubleRect doubleRect2, LinearUnit linearUnit) {
        doubleRect2.xmin = this.convert(doubleRect.xmin, linearUnit);
        doubleRect2.ymin = this.convert(doubleRect.ymin, linearUnit);
        doubleRect2.xmax = this.convert(doubleRect.xmax, linearUnit);
        doubleRect2.ymax = this.convert(doubleRect.ymax, linearUnit);
    }

    public void convert(double[] dArray, int n, int n2, LinearUnit linearUnit) {
        this.convert(dArray, n, dArray, n, n2, linearUnit);
    }

    public void convert(double[] dArray, int n, double[] dArray2, int n2, int n3, LinearUnit linearUnit) {
        while (n3-- > 0) {
            dArray2[n2++] = this.convert(dArray[n++], linearUnit);
            dArray2[n2++] = this.convert(dArray[n++], linearUnit);
        }
    }

    public boolean equals(Object object) {
        LinearUnit linearUnit = null;
        if (!(object instanceof LinearUnit)) {
            return false;
        }
        linearUnit = (LinearUnit)object;
        return this == linearUnit || this.a == linearUnit.a && ((Unit)this).c.equals(((Unit)linearUnit).c) && ((Unit)this).f.equals(((Unit)linearUnit).f) && ((Unit)this).e.equals(((Unit)linearUnit).e) && ((Unit)this).d.equals(((Unit)linearUnit).d);
    }

    public boolean equivalent(LinearUnit linearUnit) {
        return this == linearUnit || this.a == linearUnit.a;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + ((Unit)this).c.hashCode();
        n = n * 37 + ((Unit)this).d.hashCode();
        n = n * 37 + ((Unit)this).e.hashCode();
        n = n * 37 + ((Unit)this).f.hashCode();
        n = n * 37 + ObjectUtils.hashCode((double)this.a);
        return n;
    }

    void a(String string, String string2, double d2, String string3, String string4) {
        this.a(string, string2, d2);
        this.a(string3, string4);
    }

    void b(int n) {
        if (!LinearUnit.a(n)) {
            n = 7;
        }
        if (n >= 30) {
            n -= 17;
        }
        this.a(d[n], e[n], c[n], f[n * 2 + 1], f[n * 2]);
    }

    void a(String string) {
        int n = 0;
        while (n < e.length) {
            if (string.equals(e[n])) {
                this.a(d[n], e[n], c[n], f[n * 2 + 1], f[n * 2]);
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("Unable to initialize with abbreviation: " + string);
    }

    private void a(String string, double d2) {
        this.a(string, this.a(d2), d2);
    }

    private void a(String string, String string2, double d2) {
        this.b(string);
        this.c(string2);
        this.a = d2;
        this.b = 1.0 / this.a;
    }

    private String a(double d2) {
        int n = 0;
        while (n < c.length) {
            if (d2 == c[n]) {
                return e[n];
            }
            ++n;
        }
        return null;
    }

    static {
        INDEX_MILE = 0;
        INDEX_KILOMETER = 1;
        INDEX_INCH = (short)2;
        INDEX_FOOT = (short)3;
        INDEX_YARD = (short)4;
        INDEX_MILLIMETER = (short)5;
        INDEX_CENTIMETER = (short)6;
        INDEX_METER = (short)7;
        INDEX_SURVEY_FOOT = (short)8;
        INDEX_NAUTICAL_MILE = (short)9;
        INDEX_TWIP = (short)10;
        INDEX_POINT = (short)11;
        INDEX_PICA = (short)12;
        INDEX_LINK = (short)30;
        INDEX_CHAIN = (short)31;
        INDEX_ROD = (short)32;
        c = new double[]{1609.344, 1000.0, 0.0254, 0.3048, 0.9144, 0.001, 0.01, 1.0, 0.30480060960121924, 1852.0, 1.763888888888889E-5, 3.5277777777777776E-4, 0.004233333333333333, 0.201168, 20.1168, 5.0292};
        d = new String[]{"mile", "kilometer", "inch", "foot", "yard", "millimeter", "centimeter", "meter", "US Survey foot", "nautical mile", "twip", "point", "pica", "link", "chain", "rod"};
        e = new String[]{"mi", "km", "in", "ft", "yd", "mm", "cm", "m", "survey ft", "nmi", "twip", "pt", "pica", "li", "ch", "rd"};
        f = new String[]{"EPSG", "9093", "EPSG", "9036", "MAPINFO", "linearunit2", "EPSG", "9002", "MAPINFO", "linearunit4", "MAPINFO", "linearunit5", "MAPINFO", "linearunit6", "EPSG", "9001", "EPSG", "9003", "EPSG", "9030", "MAPINFO", "linearunit10", "MAPINFO", "linearunit11", "MAPINFO", "linearunit12", "EPSG", "9034", "EPSG", "9033", "MAPINFO", "linearunit32"};
        mile = new LinearUnit(0);
        kilometer = new LinearUnit(1);
        inch = new LinearUnit(2);
        foot = new LinearUnit(3);
        yard = new LinearUnit(4);
        millimeter = new LinearUnit(5);
        centimeter = new LinearUnit(6);
        meter = new LinearUnit(7);
        surveyFoot = new LinearUnit(8);
        nauticalMile = new LinearUnit(9);
        twip = new LinearUnit(10);
        point = new LinearUnit(11);
        pica = new LinearUnit(12);
        link = new LinearUnit(30);
        chain = new LinearUnit(31);
        rod = new LinearUnit(32);
        g = new Hashtable(16);
        g.put(mile.getSrsName().toLowerCase(), mile);
        g.put(kilometer.getSrsName().toLowerCase(), kilometer);
        g.put(inch.getSrsName().toLowerCase(), inch);
        g.put(foot.getSrsName().toLowerCase(), foot);
        g.put(yard.getSrsName().toLowerCase(), yard);
        g.put(millimeter.getSrsName().toLowerCase(), millimeter);
        g.put(centimeter.getSrsName().toLowerCase(), centimeter);
        g.put(meter.getSrsName().toLowerCase(), meter);
        g.put(surveyFoot.getSrsName().toLowerCase(), surveyFoot);
        g.put(nauticalMile.getSrsName().toLowerCase(), nauticalMile);
        g.put(twip.getSrsName().toLowerCase(), twip);
        g.put(point.getSrsName().toLowerCase(), point);
        g.put(pica.getSrsName().toLowerCase(), pica);
        g.put(link.getSrsName().toLowerCase(), link);
        g.put(chain.getSrsName().toLowerCase(), chain);
        g.put(rod.getSrsName().toLowerCase(), rod);
    }
}

