/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.AngularUnit;
import com.mapinfo.unit.Distance;
import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.Time;
import com.mapinfo.unit.TimeUnit;
import com.mapinfo.util.Verify;

public final class UnitUtil {
    private UnitUtil() {
    }

    public static final int getLinearUnitIndex(LinearUnit linearUnit) {
        return linearUnit.a();
    }

    public static final boolean isValidLinearUnitIndex(int n) {
        return LinearUnit.a(n);
    }

    public static final int getAngularUnitIndex(AngularUnit angularUnit) {
        return 13;
    }

    public static final boolean isValidAngularUnitIndex(AngularUnit angularUnit, int n) {
        return n == 13;
    }

    public static final double convert(double d2, LinearUnit linearUnit, AngularUnit angularUnit) {
        d2 = LinearUnit.meter.convert(d2, linearUnit);
        return angularUnit.convert(d2 / 6370997.0, AngularUnit.radian);
    }

    public static final double convert(double d2, AngularUnit angularUnit, LinearUnit linearUnit) {
        d2 = AngularUnit.radian.convert(d2, angularUnit);
        return linearUnit.convert(d2 * 6370997.0, LinearUnit.meter);
    }

    public static final Time add(Time time, Time time2, TimeUnit timeUnit) {
        Verify.notNull((Object)time, (String)"time1");
        Verify.notNull((Object)time2, (String)"time2");
        Verify.notNull((Object)timeUnit, (String)"unit");
        double d2 = time.getScalarValue(timeUnit);
        double d3 = time2.getScalarValue(timeUnit);
        return new Time(d2 + d3, timeUnit);
    }

    public static final Distance add(Distance distance, Distance distance2, LinearUnit linearUnit) {
        Verify.notNull((Object)distance, (String)"distance1");
        Verify.notNull((Object)distance2, (String)"distance2");
        Verify.notNull((Object)linearUnit, (String)"unit");
        double d2 = distance.getScalarValue(linearUnit);
        double d3 = distance2.getScalarValue(linearUnit);
        return new Distance(d2 + d3, linearUnit);
    }
}

