/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.unit;

import com.mapinfo.unit.LinearUnit;
import com.mapinfo.unit.TimeUnit;
import com.mapinfo.unit.Unit;

public class VelocityUnit
extends Unit {
    private TimeUnit a;
    private LinearUnit b;
    public static final VelocityUnit MPH = new VelocityUnit(LinearUnit.mile, TimeUnit.HOUR);
    public static final VelocityUnit KPH = new VelocityUnit(LinearUnit.kilometer, TimeUnit.HOUR);
    public static final VelocityUnit MTPS = new VelocityUnit(LinearUnit.meter, TimeUnit.SECOND);

    public VelocityUnit(LinearUnit linearUnit, TimeUnit timeUnit) {
        this.a = timeUnit;
        this.b = linearUnit;
    }

    public double convert(double d2, Unit unit) {
        if (unit instanceof VelocityUnit) {
            return this.convert(d2, (VelocityUnit)unit);
        }
        throw new IllegalArgumentException("Can't convert from " + unit.getName() + " to " + this.getName());
    }

    public double convert(double d2, VelocityUnit velocityUnit) {
        double d3 = d2;
        d3 = velocityUnit.getTimeUnit().convert(d3, this.getTimeUnit());
        d3 = this.getLinearUnit().convert(d3, velocityUnit.getLinearUnit());
        return d3;
    }

    public TimeUnit getTimeUnit() {
        return this.a;
    }

    public LinearUnit getLinearUnit() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof VelocityUnit) {
            VelocityUnit velocityUnit = (VelocityUnit)object;
            if (this.b.equals(velocityUnit.b) && this.a.equals(velocityUnit.a)) {
                return true;
            }
        }
        return false;
    }

    public boolean equivalent(VelocityUnit velocityUnit) {
        return this == velocityUnit || this.b.equivalent(velocityUnit.b) && this.a.equivalent(velocityUnit.a);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.b.hashCode();
        n = 37 * n + this.a.hashCode();
        return n;
    }

    public int getIndex() {
        throw new UnsupportedOperationException("Method getIndex() not yet implemented.");
    }
}

