/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.pb.spectrum.autosuggest.api.DefaultTypeAheadConverter;
import com.pb.spectrum.gav.data.Options;
import com.pb.spectrum.gav.data.TypeAheadException;
import java.util.Locale;
import java.util.Map;

public class TypeAheadConverter
extends DefaultTypeAheadConverter {
    private static final String AUTOSUGGEST_SEARCH_LEVEL = "SearchLevel";
    private static final String SEARCH_DISTANCE = "SearchDistance";
    private static final String SEARCH_DISTANCE_UNIT = "SearchRadiusUnit";
    private static final String LOCALE = "Locale";
    private static final String BBOX_WEST = "BBoxWest";
    private static final String BBOX_SOUTH = "BBoxSouth";
    private static final String BBOX_NORTH = "BBoxNorth";
    private static final String BBOX_EAST = "BBoxEast";

    @Override
    public IAutoSuggestConstraints convertOptions(Map options) throws TypeAheadException {
        IAutoSuggestConstraints constraints = super.convertOptions(options);
        constraints.setMatchOnAddressNumber(TypeAheadConverter.parseBoolean(options.get(Options.MATCH_ON_ADDRESS_NUMBER.getValue())));
        if (!StringUtilities.isEmpty((String)((String)options.get("MaxCandidates")))) {
            try {
                constraints.setMaxCandidates(Integer.valueOf((String)options.get("MaxCandidates")).intValue());
            }
            catch (NumberFormatException e) {
                throw new TypeAheadException("Invalid Max Candidate Value");
            }
        }
        if (!StringUtilities.isEmpty((String)((String)options.get(SEARCH_DISTANCE)))) {
            try {
                double searchDistance = Double.valueOf((String)options.get(SEARCH_DISTANCE));
                constraints.setSearchDistance(searchDistance);
            }
            catch (NumberFormatException e) {
                throw new TypeAheadException("Invalid Search Distance Value");
            }
        }
        if (!StringUtilities.isEmpty((String)((String)options.get(LOCALE)))) {
            String locale = (String)options.get(LOCALE);
            if (Locales.ENGLISH.name().equalsIgnoreCase(locale)) {
                constraints.setLocale(new Locale("en"));
            }
        }
        if (!StringUtilities.isEmpty((String)((String)options.get(SEARCH_DISTANCE_UNIT)))) {
            String distanceUnit = (String)options.get(SEARCH_DISTANCE_UNIT);
            if (IAutoSuggestConstraints.DistanceUnits.KILOMETERS.name().equalsIgnoreCase(distanceUnit)) {
                constraints.setUnits(IAutoSuggestConstraints.DistanceUnits.KILOMETERS);
            } else if (IAutoSuggestConstraints.DistanceUnits.METERS.name().equalsIgnoreCase(distanceUnit)) {
                constraints.setUnits(IAutoSuggestConstraints.DistanceUnits.METERS);
            } else if (IAutoSuggestConstraints.DistanceUnits.FEET.name().equalsIgnoreCase(distanceUnit)) {
                constraints.setUnits(IAutoSuggestConstraints.DistanceUnits.FEET);
            } else if (IAutoSuggestConstraints.DistanceUnits.MILES.name().equalsIgnoreCase(distanceUnit)) {
                constraints.setUnits(IAutoSuggestConstraints.DistanceUnits.MILES);
            }
        }
        if (!StringUtilities.isEmpty((String)((String)options.get("FuzzyMatch")))) {
            String fuzzyMatchModeString = ((String)options.get("FuzzyMatch")).toUpperCase();
            constraints.setFuzzyMatchMode(IAutoSuggestConstraints.FuzzyMatchMode.valueOf((String)fuzzyMatchModeString));
        }
        double easternLimit = 0.0;
        double northernLimit = 0.0;
        double westernLimit = 0.0;
        double southernLimit = 0.0;
        try {
            if (!StringUtilities.isEmpty((String)((String)options.get(BBOX_NORTH)))) {
                northernLimit = Double.valueOf((String)options.get(BBOX_NORTH));
            }
            if (!StringUtilities.isEmpty((String)((String)options.get(BBOX_EAST)))) {
                easternLimit = Double.valueOf((String)options.get(BBOX_EAST));
            }
            if (!StringUtilities.isEmpty((String)((String)options.get(BBOX_SOUTH)))) {
                southernLimit = Double.valueOf((String)options.get(BBOX_SOUTH));
            }
            if (!StringUtilities.isEmpty((String)((String)options.get(BBOX_WEST)))) {
                westernLimit = Double.valueOf((String)options.get(BBOX_WEST));
            }
            if (easternLimit != westernLimit || easternLimit != northernLimit || easternLimit != southernLimit || easternLimit != 0.0) {
                constraints.setBoundingBox(new BoundingBox(westernLimit, southernLimit, easternLimit, northernLimit));
            }
        }
        catch (NumberFormatException e) {
            throw new TypeAheadException("Invalid Bounding Box Value");
        }
        return constraints;
    }

    private static boolean parseBoolean(Object value) {
        return "Y".equals(value);
    }

    public static enum Locales {
        ENGLISH,
        NATIVE;

    }
}

