/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestAPI;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestDictionaryMetaData;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestEngine;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestFactorySettingsProvider;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidates;
import com.mapinfo.mapmarker.autosuggest.exception.InitializationFailureException;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.common.Address;
import com.pb.addressing.util.ValidationUtils;
import com.pb.spectrum.autosuggest.TypeAheadDictionaryManager;
import com.pb.spectrum.autosuggest.TypeAheadMapOptionUtil;
import com.pb.spectrum.autosuggest.api.TypeAheadConverter;
import com.pb.spectrum.autosuggest.api.iTypeAheadConverter;
import com.pb.spectrum.gav.address.TypeAhead;
import com.pb.spectrum.gav.data.DictionaryDataSet;
import com.pb.spectrum.gav.data.DictionaryInfo;
import com.pb.spectrum.gav.data.DictionaryManagerException;
import com.pb.spectrum.gav.data.DictionaryPath;
import com.pb.spectrum.gav.data.DictionaryResource;
import com.pb.spectrum.gav.data.SpdInfo;
import com.pb.spectrum.gav.data.TypeAheadConstants;
import com.pb.spectrum.gav.data.TypeAheadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeAheadEngine
implements TypeAhead {
    protected String countryCode;
    protected iTypeAheadConverter converter;
    private static final String DATABASE_SEARCH_ORDER = "DatabaseSearchOrder";
    protected AutoSuggestAPI autoSuggestEngine;
    protected TypeAheadDictionaryManager dictionaryManager;
    protected DictionaryResource dictionaryResource;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final Log log = LogFactory.getLog(TypeAheadEngine.class);
    private static final String POI_DATA_IDENTIFIER = "POI_";
    private static final String TA_VERINFO_IDENTIFIER = "TA. ";
    private static final String key = "1A22440ED3A39F98";
    private static final String initVector = "DDF15FDC5176015B";
    private AutoSuggestFactorySettingsProvider factorySettingProvider = AutoSuggestFactorySettingsProvider.getInstance();
    private HashMap<String, List<String>> licenseProductCodesMap = new HashMap();
    private Map<String, Set<String>> typeAheadVersionInfo;
    private ArrayList<String> configuredCountryList = new ArrayList();
    String[] baseDBPaths;
    private static final String AUTOSUGGEST_SEARCH_LEVEL = "SearchLevel";

    public TypeAheadEngine(DictionaryResource dictResource, ArrayList<SpdInfo> gavSPDProperty) throws TypeAheadException {
        try {
            this.converter = new TypeAheadConverter();
            this.dictionaryResource = dictResource;
            if (!this.dictionaryResource.getSelectGTACountryList().isEmpty()) {
                this.initTypeAheadEngine(this.dictionaryResource, gavSPDProperty);
            }
        }
        catch (Exception e) {
            throw new TypeAheadException((Throwable)e);
        }
    }

    private void initTypeAheadEngine(DictionaryResource dictionaryResource, ArrayList<SpdInfo> gavSPDProperty) throws TypeAheadException, IOException {
        int i;
        DictionaryDataSet[] datasets = this.dictionaryResource.getDictionaryDataSetArray();
        int[] numberOfEntriesperDataSet = new int[datasets.length];
        int[] startingPerDataSet = new int[datasets.length];
        for (i = 0; i < datasets.length; ++i) {
            Map<String, Properties> countryToPropertiesMap = this.getPropertiesForDataSet(datasets[i], gavSPDProperty);
            datasets[i].setCountryToPropertiesMap(countryToPropertiesMap);
            Set<String> countryCodeSet = countryToPropertiesMap.keySet();
            for (String string : countryCodeSet) {
                Properties properties = countryToPropertiesMap.get(string);
                try {
                    this.factorySettingProvider.setDataSettingsForCountry(string, properties);
                }
                catch (InitializationFailureException e) {
                    throw new TypeAheadException("INITIALIZTION_FAILURE_EXCEPTION", e.getMessage(), e.getCause());
                }
                int n = i;
                numberOfEntriesperDataSet[n] = numberOfEntriesperDataSet[n] + properties.keySet().size();
            }
        }
        this.factorySettingProvider.setDefaultCountry(this.dictionaryResource.getDefaultCountry());
        for (i = 0; i < numberOfEntriesperDataSet.length; ++i) {
            startingPerDataSet[i] = i == 0 ? 0 : startingPerDataSet[i - 1] + numberOfEntriesperDataSet[i - 1];
        }
        this.dictionaryResource.setNumberOfItemsPerDataSet(numberOfEntriesperDataSet);
        this.dictionaryResource.setStartingIndexPerDataSet(startingPerDataSet);
        this.autoSuggestEngine = new AutoSuggestEngine();
    }

    public Map<String, Properties> getPropertiesForDataSet(DictionaryDataSet dictionaryDataSet, ArrayList<SpdInfo> gtaSpdProp) throws TypeAheadException, IOException {
        HashMap<String, Properties> countryToPropertiesMap = new HashMap<String, Properties>();
        HashMap countryNameToListOfFile = new HashMap();
        File searchDir = null;
        File[] availableCountry = null;
        ArrayList filteredCountryList = new ArrayList();
        List<Object> allfilteredCountry = new ArrayList();
        ArrayList<File> listOfAvailableCountry = new ArrayList<File>();
        for (SpdInfo spdInfo : gtaSpdProp) {
            if (!spdInfo.getSpdType().equals("GTA")) continue;
            String path = spdInfo.getSpdPath();
            searchDir = new File((String)path + File.separator + "TypeAhead");
            if (searchDir.listFiles() != null) {
                for (File file : searchDir.listFiles()) {
                    if (!file.isDirectory() || !file.exists()) continue;
                    File dictionaryDescProp = new File(file + File.separator + "dictionarydesc.properties");
                    Properties desc = TypeAheadEngine.loadProperties(dictionaryDescProp);
                    String country = desc.getProperty("supportedCountries");
                    ArrayList<String> productCodeList = new ArrayList<String>();
                    String encProductCodeString = desc.getProperty("productCode");
                    if (!StringUtils.isEmpty((CharSequence)encProductCodeString)) {
                        String decProductCodeString = TypeAheadEngine.decrypt(encProductCodeString);
                        List<String> updatedproductCode = null;
                        if (this.licenseProductCodesMap.containsKey(country) && !this.licenseProductCodesMap.get(country).contains(decProductCodeString)) {
                            updatedproductCode = this.licenseProductCodesMap.get(country);
                            updatedproductCode.add(decProductCodeString);
                        } else {
                            productCodeList.add(decProductCodeString);
                        }
                        if (this.licenseProductCodesMap.containsKey(country) && updatedproductCode != null) {
                            this.licenseProductCodesMap.put(country, updatedproductCode);
                        } else {
                            this.licenseProductCodesMap.put(country, productCodeList);
                        }
                    }
                    availableCountry = file.listFiles(CountryIdentifierFilter.getInstance());
                    for (int i = 0; i < availableCountry.length; ++i) {
                        listOfAvailableCountry.add(availableCountry[i]);
                    }
                    allfilteredCountry = this.getFilteredCountryList(spdInfo.getCountryCode(), listOfAvailableCountry);
                }
            }
            filteredCountryList.add(allfilteredCountry);
        }
        this.typeAheadVersionInfo = new HashMap<String, Set<String>>(){

            @Override
            public Set<String> get(Object key) {
                HashSet set = (HashSet)super.get(key);
                if (set == null) {
                    set = new HashSet();
                    this.put((String)key, set);
                }
                return set;
            }
        };
        for (List list : filteredCountryList) {
            for (File file : list) {
                List<File> filesList;
                String countryCode;
                List supportedCountries;
                try {
                    supportedCountries = AutoSuggestFactorySettingsProvider.getSupportedCountriesFromDictionary((File)file);
                    AutoSuggestDictionaryMetaData metadata = AutoSuggestFactorySettingsProvider.getAutoSuggestDictionaryMetaData((File)file);
                    List supportedCountry = metadata.getSupportedCountriesFromDictionary();
                    if (!this.configuredCountryList.contains(supportedCountry.get(0))) {
                        this.configuredCountryList.add((String)supportedCountry.get(0));
                    }
                    assert (metadata != null);
                    if (supportedCountries.size() <= 1) {
                        String typeAheadVersionInfoMapValue;
                        String typeAheadVersionInfoMapKey = TA_VERINFO_IDENTIFIER + (String)supportedCountry.get(0) + ". " + metadata.getDataTypeString();
                        String string = typeAheadVersionInfoMapValue = !metadata.getDictionaryDataVintage().isEmpty() ? metadata.getDictionaryDataVintage() : "NA";
                        if (!this.typeAheadVersionInfo.get(typeAheadVersionInfoMapKey).contains(typeAheadVersionInfoMapValue.toUpperCase())) {
                            this.typeAheadVersionInfo.get(typeAheadVersionInfoMapKey).add(typeAheadVersionInfoMapValue.toUpperCase());
                        }
                    } else {
                        for (String supportCountries : supportedCountry) {
                            String typeAheadVersionInfoMapValue;
                            String typeAheadVersionInfoMapKey = TA_VERINFO_IDENTIFIER + supportCountries + ". " + metadata.getDataTypeString();
                            String string = typeAheadVersionInfoMapValue = !metadata.getDictionaryDataVintage().isEmpty() ? metadata.getDictionaryDataVintage() : "NA";
                            if (this.typeAheadVersionInfo.get(typeAheadVersionInfoMapKey).contains(typeAheadVersionInfoMapValue.toUpperCase())) continue;
                            this.typeAheadVersionInfo.get(typeAheadVersionInfoMapKey).add(typeAheadVersionInfoMapValue.toUpperCase());
                        }
                    }
                }
                catch (InitializationFailureException e) {
                    throw new TypeAheadException("INITIALIZATION_FAILURE_EXCEPTION", e.getMessage(), e.getCause());
                }
                if (supportedCountries != null && supportedCountries.size() == 0) {
                    supportedCountries.add(this.IdentifyCoutryNameList(file));
                }
                if (countryNameToListOfFile.containsKey(countryCode = (String)supportedCountries.get(0))) {
                    filesList = (List)countryNameToListOfFile.get(countryCode);
                    filesList.add(file);
                    countryNameToListOfFile.put(countryCode, filesList);
                    continue;
                }
                filesList = new ArrayList();
                filesList.add(file);
                countryNameToListOfFile.put(countryCode, filesList);
            }
        }
        Iterator countryIterator = countryNameToListOfFile.keySet().iterator();
        while (countryIterator.hasNext()) {
            Properties properties = new Properties();
            String countryName = (String)countryIterator.next();
            List fileLists = (List)countryNameToListOfFile.get(countryName);
            int count = 1;
            for (File file : fileLists) {
                properties.put("dictionary_index_file_" + count, file.getAbsolutePath());
                ++count;
            }
            countryToPropertiesMap.put(countryName, properties);
        }
        return this.sortTheAutoSuggestDictionaries(countryToPropertiesMap);
    }

    private String IdentifyCoutryNameList(File searchFile) {
        String dbNameIdentifier;
        String countryName = null;
        countryName = searchFile.getName().startsWith(POI_DATA_IDENTIFIER) ? ((dbNameIdentifier = searchFile.getName().substring(POI_DATA_IDENTIFIER.length(), searchFile.getName().length() - ".rdx".length())).length() > 3 ? dbNameIdentifier.substring(0, 3) : dbNameIdentifier) : ((dbNameIdentifier = searchFile.getName().substring(0, searchFile.getName().length() - ".rdx".length())).length() > 3 ? dbNameIdentifier.substring(0, 3) : dbNameIdentifier);
        return countryName;
    }

    private static String decrypt(String encrypted) {
        try {
            IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)skeySpec, iv);
            byte[] original = cipher.doFinal(Base64.decodeBase64((String)encrypted));
            return new String(original);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            if (input == null) {
                throw new FileNotFoundException(file.getName());
            }
            InputStreamReader reader = new InputStreamReader((InputStream)input, Charset.forName("UTF-8"));
            properties.load(reader);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public ArrayList<HashMap<String, Object>> suggest(HashMap<String, Object> options, HashMap<String, String> input) throws TypeAheadException {
        if (this.converter == null) {
            throw new TypeAheadException("TypeAhead engine has not been initialized");
        }
        try {
            IAutoSuggestConstraints constraints = this.converter.convertOptions(options);
            this.configuredictionarySearchOrder(constraints, options);
            this.setDictionaryPreference(constraints, options);
            Address address = this.converter.convertInput(input);
            this.prepareInputConstraint(constraints, address, options);
            ISuggestedCandidates response = this.suggest(constraints, address);
            ArrayList<HashMap<String, Object>> outputs = this.createSuggestedResponse(this.countryCode, response, options);
            return outputs;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TypeAheadException("EXCEPTION_OCCURED_WHILE_TYPE_AHEAD", "Exception Occured while TypeAhead operation");
        }
    }

    private void prepareInputConstraint(IAutoSuggestConstraints constraints, Address address, HashMap<String, Object> options) {
        constraints.setCompressAreaResults(true);
        String suggestTypeLevel = TypeAheadMapOptionUtil.SearchLevelMaping.get((String)options.get(AUTOSUGGEST_SEARCH_LEVEL));
        if (suggestTypeLevel == null || suggestTypeLevel.equalsIgnoreCase("") || suggestTypeLevel.equalsIgnoreCase("GeoCompleteAddress")) {
            constraints.setCompressAreaResults(false);
            constraints.setSearchType(124);
            return;
        }
        if (suggestTypeLevel.equalsIgnoreCase("GeoCompleteCity")) {
            address.setMainAddress(address.getAreaName3());
            address.setAreaName3("");
            constraints.setSearchType(8);
            return;
        }
        if (suggestTypeLevel.equalsIgnoreCase("GeoCompleteState")) {
            address.setMainAddress(address.getAreaName1());
            address.setAreaName1("");
            constraints.setSearchType(64);
            return;
        }
        if (suggestTypeLevel.equalsIgnoreCase("GeoCompletePostal")) {
            address.setMainAddress(address.getPostCode1());
            address.setPostCode1("");
            constraints.setSearchType(4);
            return;
        }
        if (suggestTypeLevel.equalsIgnoreCase("GeoCompletePOI")) {
            constraints.setCompressAreaResults(false);
            constraints.setSearchType(3);
        }
    }

    private void setDictionaryPreference(IAutoSuggestConstraints constraints, HashMap<String, Object> options) {
        IDictionarySearchPriority priority = constraints.getDictionarySearchPriority();
        if (priority == null) {
            priority = this.factorySettingProvider.getDictionarySearchPriority();
        }
        priority.setDictionaryUsagePreference(IDictionarySearchPriority.DictionaryUsagePreference.STD_ONLY);
        constraints.setDictionarySearchPriority(priority);
    }

    private void configuredictionarySearchOrder(IAutoSuggestConstraints constraints, HashMap<String, Object> options) throws TypeAheadException {
        int[] startPositions = this.dictionaryResource.getStartingIndexPerDataSet();
        int[] elementCount = this.dictionaryResource.getNumberOfItemsPerDataSet();
        IDictionarySearchPriority dsp = this.factorySettingProvider.getDictionarySearchPriority();
        int x = 0;
        String searchOrder = (String)options.get(DATABASE_SEARCH_ORDER);
        if (searchOrder != null && searchOrder.length() > 0 && !"null".equalsIgnoreCase(searchOrder)) {
            String[] searchOrderArray = searchOrder.split(",");
            try {
                for (String string : searchOrderArray) {
                    int intValue = Integer.parseInt(string);
                    int startIndex = startPositions[intValue - 1];
                    int eCount = elementCount[intValue - 1];
                    for (int j = startIndex; j < startIndex + eCount; ++j) {
                        dsp.setSearchPriorityForDictionary(j + 1, x + 1);
                        ++x;
                    }
                }
                constraints.setDictionarySearchPriority(dsp);
            }
            catch (NumberFormatException e) {
                throw new TypeAheadException("TYPE-AHEAD_DICTIONARY_CONFIGURATION_EXCEPTIONEXCEPTION", "Unable to Apply Dictionary Search Order", e.getCause());
            }
            catch (Exception e) {
                throw new TypeAheadException("Unable to Apply Dictionary Search Order");
            }
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private ArrayList<HashMap<String, Object>> createSuggestedResponse(String countryCode, ISuggestedCandidates response, HashMap<String, Object> options) {
        ArrayList<HashMap<String, Object>> outputs = new ArrayList<HashMap<String, Object>>();
        int count = response.getCount();
        if (count == 0) {
            outputs.add(TypeAheadConstants.getdefaultOutputMap((String)"NO_MATCH_FOUND", (String)"No Candidates Returned "));
        } else {
            for (int i = 0; i < count; ++i) {
                HashMap<String, Object> output = this.converter.convertAutoSuggestOutput(response.getCandidateAt(i), countryCode);
                outputs.add(output);
            }
        }
        return outputs;
    }

    protected ISuggestedCandidates suggest(IAutoSuggestConstraints constraints, Address address) throws TypeAheadException {
        ISuggestedCandidates isSuggestedCandidates = null;
        try {
            isSuggestedCandidates = this.autoSuggestEngine.suggest(address, constraints);
        }
        catch (SuggestFailureException e) {
            throw new TypeAheadException("SUGGEST_FAILURE_EXCEPTION", e.getMessage().toString(), e.getCause());
        }
        return isSuggestedCandidates;
    }

    protected ISuggestedCandidates findNearestPOIs(IAutoSuggestConstraints constraints) throws TypeAheadException {
        ISuggestedCandidates isSuggestedCandidates = null;
        try {
            isSuggestedCandidates = this.autoSuggestEngine.findNearestPOIs(constraints);
        }
        catch (SuggestFailureException e) {
            throw new TypeAheadException("SUGGEST_FAILURE_EXCEPTION", e.getMessage().toString(), e.getCause());
        }
        return isSuggestedCandidates;
    }

    public DictionaryInfo[] getDictionaryInfos() throws TypeAheadException {
        return this.dictionaryManager.getDictionaryInfos();
    }

    public DictionaryInfo[] updateDictionaryInfos(DictionaryPath[] dictionaryPaths) throws TypeAheadException, DictionaryManagerException {
        try {
            DictionaryInfo[] dictinfo = this.dictionaryManager.updateDictionaryInfos(dictionaryPaths);
            try {
                this.initTypeAheadEngine(this.dictionaryResource, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return dictinfo;
        }
        catch (DictionaryManagerException e) {
            throw new DictionaryManagerException((Throwable)e);
        }
        catch (TypeAheadException e) {
            throw new TypeAheadException((Throwable)e);
        }
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    private List<File> getFilteredCountryList(String list, List<File> fileList) {
        ArrayList<File> finalFileList = new ArrayList<File>();
        if (list.contains("ALL")) {
            for (File file : fileList) {
                finalFileList.add(file);
            }
        } else {
            for (File file : fileList) {
                try {
                    List supportedCountries = AutoSuggestFactorySettingsProvider.getSupportedCountriesFromDictionary((File)file);
                    for (String supportedCountry : supportedCountries) {
                        if (!list.contains(supportedCountry)) continue;
                        finalFileList.add(file);
                    }
                }
                catch (InitializationFailureException e) {
                    e.printStackTrace();
                }
            }
        }
        return finalFileList;
    }

    public Map<String, Set<String>> getTypeheadVersionInfo() {
        return this.typeAheadVersionInfo;
    }

    public HashMap<String, List<String>> getDataLicenseCodes() throws TypeAheadException {
        return this.licenseProductCodesMap;
    }

    public DictionaryDataSet[] getDictionaryInformation() throws TypeAheadException {
        return this.dictionaryResource.getDictionaryDataSetArray();
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Properties> sortTheAutoSuggestDictionaries(Map<String, Properties> countryToPropertiesMap) throws TypeAheadException {
        for (Map.Entry<String, Properties> entry : countryToPropertiesMap.entrySet()) {
            void var10_10;
            Properties prop = entry.getValue();
            Collection<Object> c = prop.values();
            ArrayList<String> poi = new ArrayList<String>();
            ArrayList<String> street = new ArrayList<String>();
            ArrayList<String> ud = new ArrayList<String>();
            for (String string : c) {
                boolean isUD;
                int poiOrStreet;
                File f = new File(string);
                try {
                    poiOrStreet = AutoSuggestFactorySettingsProvider.getDictionaryType((File)f);
                    isUD = AutoSuggestFactorySettingsProvider.isUserDictionary((File)f);
                }
                catch (InitializationFailureException e) {
                    throw new TypeAheadException("INITIALIZATION_FAILURE_EXCEPTION", e.getMessage(), e.getCause());
                }
                if (poiOrStreet == 1) {
                    poi.add(string);
                    continue;
                }
                if (poiOrStreet == 0) {
                    street.add(string);
                    continue;
                }
                if (!isUD) continue;
                ud.add(string);
            }
            street.addAll(ud);
            poi.addAll(street);
            String[] nArr = new String[c.size()];
            nArr = poi.toArray(nArr);
            boolean bl = false;
            while (var10_10 < nArr.length) {
                prop.put("dictionary_index_file_" + (int)(var10_10 + true), nArr[var10_10]);
                ++var10_10;
            }
        }
        return countryToPropertiesMap;
    }

    public ArrayList<String> getGTAConfiguredCountries() throws TypeAheadException {
        return this.configuredCountryList;
    }

    public String getValidCountry(String inputCountry, boolean flag) {
        if (flag) {
            return ValidationUtils.getFullCountryName((String)inputCountry);
        }
        return ValidationUtils.getISO3Country((String)inputCountry);
    }

    private String getInputContent(String s) {
        if (s == null) {
            return "";
        }
        return s.toUpperCase().trim();
    }

    static final class CountryIdentifierFilter
    implements FilenameFilter {
        private static final String FILENAMEFILTER = ".rdx";
        private static CountryIdentifierFilter instance = new CountryIdentifierFilter();

        CountryIdentifierFilter() {
        }

        public static CountryIdentifierFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().contains(FILENAMEFILTER);
        }
    }
}

