/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav;

import com.pb.addressing.util.ValidationUtils;
import com.pb.spectrum.gav.data.GAVException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountryDataMappingCreator {
    private static Log log = LogFactory.getLog(CountryDataMappingCreator.class);
    private static final String DICTIONARY_DESC = "dictionarydesc.properties";
    private static final String DICTIONARY_PATH = "DICTIONARY_PATH";
    private static final String US = "US";
    private static final String US_DOMESTIC_FILE = "dpv.db";
    private static final String US_NON_DOMESTIC_FILE = "city.dir";
    private static final String US_DOMESTIC = "GAV_US_DOM";
    private static final String US_NON_DOMESTIC = "GAV_US_NON_DOM";
    private HashMap<String, List<String>> countryDictionaryMap;
    private Set<String> configCountryPropertySet;
    private Map<String, String> countryPathMap;
    private boolean isInitDone = false;
    private Map<String, String> getCountryCodeMap;

    private void init() {
        this.countryPathMap = new HashMap<String, String>();
        this.countryDictionaryMap = new HashMap();
        this.configCountryPropertySet = new HashSet<String>();
        this.getCountryCodeMap = new HashMap<String, String>();
        this.isInitDone = true;
    }

    public void scanRootDir(File rootDir, String selectedGAVCountryList, String spdInfo) throws IOException, GAVException {
        if (!this.isInitDone) {
            this.init();
        }
        if (rootDir.listFiles() != null) {
            if (spdInfo.equals(US_DOMESTIC) || spdInfo.equals(US_NON_DOMESTIC)) {
                this.configureUSDBPath(rootDir);
                return;
            }
            for (File file : rootDir.listFiles()) {
                if (!file.isDirectory() || file.getName().equals("lib")) continue;
                this.handleDataDir(file, selectedGAVCountryList);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureUSDBPath(File rootDir) throws GAVException {
        ArrayList<String> usDBList = new ArrayList<String>(1);
        if (!this.countryDictionaryMap.containsKey(US)) {
            if (!CountryDataMappingCreator.isValidDataDirectory(rootDir, US_NON_DOMESTIC_FILE)) throw new GAVException("No valid US dictionary: " + rootDir.getPath());
            usDBList.add(rootDir.getPath());
            this.countryDictionaryMap.put(US, usDBList);
            return;
        } else {
            if (CountryDataMappingCreator.isValidDataDirectory(new File(this.countryDictionaryMap.get(US).get(0)), US_DOMESTIC_FILE) || !CountryDataMappingCreator.isValidDataDirectory(rootDir, US_DOMESTIC_FILE)) return;
            this.countryDictionaryMap.get(US).remove(0);
            ArrayList<String> usUpdatedDBList = new ArrayList<String>(1);
            usUpdatedDBList.add(rootDir.getPath());
            this.countryDictionaryMap.put(US, usUpdatedDBList);
        }
    }

    private static boolean isValidDataDirectory(File file, String fileName) {
        File file1 = new File(file.getAbsolutePath() + "/" + fileName);
        boolean isthere = false;
        if (file1.exists()) {
            isthere = true;
        }
        return isthere;
    }

    private void handleDataDir(File dataDir, String selectedGAVCountryList) throws GAVException {
        String countryCode = null;
        for (File file : dataDir.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).equals(DICTIONARY_DESC) || (countryCode = this.getCountryCode(file)) == null) continue;
            String countryCodeVal = countryCode.contains("XWG") ? "World" : ValidationUtils.getFullCountryName((String)countryCode);
            this.getCountryCodeMap.put(countryCode, countryCodeVal);
            this.CreateMapping(dataDir, countryCode, selectedGAVCountryList);
        }
        this.setGetCountryCodeMap(this.getCountryCodeMap);
    }

    private void CreateMapping(File dataDir, String countryCode, String selectedGAVCountryList) {
        int count = 1;
        ArrayList dictionary = new ArrayList();
        StringBuffer pathStr = new StringBuffer();
        List<String> selectedCountry = null;
        if (selectedGAVCountryList != null && ((selectedCountry = Arrays.asList(selectedGAVCountryList.split("\\s*,\\s*"))).contains(countryCode) || selectedCountry.get(0).equals("ALL"))) {
            if (this.countryPathMap.containsKey(countryCode)) {
                pathStr = pathStr.append(this.countryPathMap.get(countryCode));
            }
            if (this.countryDictionaryMap.containsKey(countryCode)) {
                dictionary = (ArrayList)this.countryDictionaryMap.get(countryCode);
                count = dictionary.size();
                ++count;
            }
            if (this.isValidDataDir(dataDir) && !this.configCountryPropertySet.contains(dataDir.getPath())) {
                dictionary.add(dataDir.getPath());
                this.configCountryPropertySet.add(dataDir.getPath());
                this.countryDictionaryMap.put(countryCode, dictionary);
                if (pathStr.length() > 0) {
                    pathStr.append(";");
                }
                pathStr.append(dataDir.getParent());
                ++count;
            }
            this.countryPathMap.put(countryCode, pathStr.toString());
        }
    }

    private boolean isValidDataDir(File dataDir) {
        FilenameFilter dataFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("adr") || name.endsWith("jdr");
            }
        };
        File[] files = dataDir.listFiles(dataFileFilter);
        return files != null && files.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCountryCode(File dictionaryDescFile) throws GAVException {
        String countryCode = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(dictionaryDescFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            String supportedCountries = properties.getProperty("supportedCountries");
            countryCode = supportedCountries.contains(",") ? supportedCountries.split(",")[0] : supportedCountries;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("No dictionary description file for: " + dictionaryDescFile.getPath()));
            throw new GAVException("No dictionary description file for: " + dictionaryDescFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return countryCode;
    }

    public HashMap<String, List<String>> getCountryDictionaryMap() {
        return this.countryDictionaryMap;
    }

    public Map<String, String> getGetCountryCodeMap() {
        return this.getCountryCodeMap;
    }

    public void setGetCountryCodeMap(Map<String, String> getCountryCodeMap) {
        this.getCountryCodeMap = getCountryCodeMap;
    }
}

