/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;

public abstract class AbstractRadixTreeSearcher<V> {
    protected abstract RadixTree<V> getRadixTree();

    public RadixTreeMatchResult<V> searchRadixTree(String searchKey, String[] searchKeyExts, boolean matchFully, boolean incrementalSearch, NodeFilter<V> nodeFilter) {
        RadixTree<V> radixTree = this.getRadixTree();
        NodeFilter<V> nodeFilterForSearching = this.getEmptyValueNodeFilter(nodeFilter);
        RadixTreeMatchResult<V> results = null;
        results = incrementalSearch ? radixTree.findAllIncludingIntermediateWords(searchKey, searchKeyExts, nodeFilterForSearching) : (matchFully ? radixTree.find(searchKey, nodeFilterForSearching) : radixTree.findAll(searchKey, nodeFilterForSearching));
        if (results != null && nodeFilterForSearching != nodeFilter) {
            results = results.copyOf(nodeFilter);
        }
        return results;
    }

    private NodeFilter<V> getEmptyValueNodeFilter(NodeFilter<V> nodeFilter) {
        NodeFilter<V> copy;
        if (nodeFilter != null && (copy = this.makeEmptyValueNodeFilter(nodeFilter)) != null) {
            nodeFilter = copy;
        }
        return nodeFilter;
    }

    protected abstract NodeFilter<V> makeEmptyValueNodeFilter(NodeFilter<V> var1);
}

