/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrMapReadingFilter;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPtrFilter
implements INodeValueFilter<AddressPtrMap>,
IAddressPtrMapReadingFilter,
IAreaIDReadingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AddressPtrFilter.class);
    private List<Integer> m_allowedTypes;
    private Map<Integer, List<AddressPtr>> m_allowedAreaAddressPtrMap;
    private Set<Integer> m_ignoreTypes;
    private SearchAreas m_allowedAreas;
    private List<IAddressPtrFilter> m_additionalFilters;
    private List<IAreaIDReadingFilter> m_additionalAreaFilters;

    public AddressPtrFilter(SearchRequest sr, SearchAreas allowedAreas) {
        this.m_allowedTypes = sr.getAllowedTypes();
        this.m_allowedAreas = allowedAreas;
        this.createIgnoreTypes(sr);
        this.setAllowedAddressPtrs(sr);
        this.setAdditionalFilters(sr.getAdditionalFilters());
    }

    private void createIgnoreTypes(SearchRequest sr) {
        List<Integer> list = sr.getIgnoreTypes();
        this.m_ignoreTypes = list != null ? new HashSet<Integer>(list) : new HashSet<Integer>();
    }

    private void setAllowedAddressPtrs(SearchRequest sr) {
        List<AddressPtr> allowedAddrPtrList = sr.getAllowedAddrPtrList();
        if (allowedAddrPtrList != null) {
            this.m_allowedAreaAddressPtrMap = new HashMap<Integer, List<AddressPtr>>();
            this.addToAreaAddressPtrMap(this.m_allowedAreaAddressPtrMap, allowedAddrPtrList);
        }
    }

    private void addToAreaAddressPtrMap(Map<Integer, List<AddressPtr>> map, Iterable<AddressPtr> allowedAddressPtr) {
        for (AddressPtr addrPtr : allowedAddressPtr) {
            List<AddressPtr> areaAddrPtrList = map.get(addrPtr.getAreaID());
            if (areaAddrPtrList == null) {
                areaAddrPtrList = new ArrayList<AddressPtr>(2);
                map.put(addrPtr.getAreaID(), areaAddrPtrList);
            }
            areaAddrPtrList.add(addrPtr);
        }
    }

    @Override
    public AddressPtrMap filter(AddressPtrMap v) {
        HashMap<Integer, List<AddressPtr>> filteredMap = new HashMap<Integer, List<AddressPtr>>();
        if (v.size() > 0) {
            for (Map.Entry<Integer, List<AddressPtr>> en : v.getEntrySet()) {
                int fieldID = en.getKey();
                if (this.allowType(fieldID)) {
                    List<AddressPtr> filteredList = this.filterAddressPtrs(en.getValue());
                    if (filteredList.isEmpty()) continue;
                    filteredMap.put(fieldID, filteredList);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("filtered out by field type: " + (en.getValue() == null ? "" : Arrays.toString(en.getValue().toArray())));
            }
            if (!filteredMap.isEmpty()) {
                AddressPtrMap filteredAddrPtrMap = new AddressPtrMap();
                filteredAddrPtrMap.setMap(filteredMap);
                return filteredAddrPtrMap;
            }
        }
        return null;
    }

    private List<AddressPtr> filterAddressPtrs(List<AddressPtr> addrPtrList) {
        int size = addrPtrList.size();
        ArrayList<AddressPtr> filteredList = new ArrayList<AddressPtr>(size > 30 ? size : addrPtrList.size() / 2);
        for (AddressPtr ptr : addrPtrList) {
            AddressPtr addrPtr = ptr;
            if (this.allowArea(addrPtr.getAreaID())) {
                if ((addrPtr = this.filterAddressPtr(addrPtr)) == null) continue;
                filteredList.add(addrPtr);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("filtered out by search area: " + ptr);
        }
        return filteredList;
    }

    private AddressPtr filterAddressPtr(AddressPtr addrPtr) {
        if (this.checkAdditionalFilters(addrPtr)) {
            List<AddressPtr> allowedAddrPtrList;
            List<AddressPtr> list = allowedAddrPtrList = this.m_allowedAreaAddressPtrMap == null ? null : this.m_allowedAreaAddressPtrMap.get(addrPtr.getAreaID());
            if (allowedAddrPtrList != null) {
                addrPtr = this.filterAddressIds(addrPtr, allowedAddrPtrList);
            }
        } else {
            addrPtr = null;
        }
        return addrPtr;
    }

    private AddressPtr filterAddressIds(AddressPtr addrPtr, List<AddressPtr> allowedAddrPtrList) {
        AddressPtr filteredAddressPtr = null;
        for (AddressPtr allowedAddrPtr : allowedAddrPtrList) {
            AddressPtr filterPtr = addrPtr.getIntersectingAddressIDs(allowedAddrPtr);
            if (filteredAddressPtr == null) {
                filteredAddressPtr = filterPtr;
                continue;
            }
            filteredAddressPtr.combine(filterPtr);
        }
        return filteredAddressPtr;
    }

    private boolean allowType(int type) {
        boolean allowed;
        boolean bl = allowed = this.m_allowedTypes == null || this.m_allowedTypes.contains(type);
        if (allowed) {
            allowed = !this.m_ignoreTypes.contains(type);
        }
        return allowed;
    }

    private boolean allowArea(int areaID) {
        if (this.m_allowedAreaAddressPtrMap != null && !this.m_allowedAreaAddressPtrMap.containsKey(areaID)) {
            return false;
        }
        if (!this.checkAdditionalAreaFilters(areaID)) {
            return false;
        }
        return this.m_allowedAreas == null || this.m_allowedAreas.containsArea(areaID);
    }

    private boolean checkAdditionalAreaFilters(int areaID) {
        List<IAreaIDReadingFilter> filters = this.getAdditionalAreaFilters();
        int s = filters == null ? 0 : filters.size();
        for (int i = 0; i < s; ++i) {
            if (filters.get(i).readArea(areaID)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IAreaIDReadingFilter getAddressIDReadingFilter(int fieldID) {
        return this.allowType(fieldID) ? this : null;
    }

    @Override
    public boolean readArea(int areaID) {
        return this.allowArea(areaID);
    }

    private boolean checkAdditionalFilters(AddressPtr addrPtr) {
        List<IAddressPtrFilter> filters = this.getAdditionalFilters();
        if (!ListUtils.isEmpty(filters)) {
            for (IAddressPtrFilter filter : filters) {
                if (filter.allowAddressPtr(addrPtr)) continue;
                return false;
            }
        }
        return true;
    }

    public void setAdditionalFilters(List<IAddressPtrFilter> additionalFilters) {
        this.m_additionalFilters = additionalFilters;
    }

    public List<IAddressPtrFilter> getAdditionalFilters() {
        return this.m_additionalFilters;
    }

    public void setAdditionalAreaFilters(List<IAreaIDReadingFilter> areaFilters) {
        this.m_additionalAreaFilters = areaFilters;
    }

    public List<IAreaIDReadingFilter> getAdditionalAreaFilters() {
        return this.m_additionalAreaFilters;
    }

    public SearchAreas getAllowedAreas() {
        return this.m_allowedAreas;
    }

    public String toString() {
        return "addressPtrFilter";
    }
}

