/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddrNumHashFilter;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResults;
import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.AddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.CategorySearchHandler;
import com.mapinfo.mapmarker.autosuggest.IAddressSearchResult;
import com.mapinfo.mapmarker.autosuggest.InputAddress;
import com.mapinfo.mapmarker.autosuggest.MultiFieldSearchHandler;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SearchResults;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.WeightedInternalResultFetcher;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressUtil;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.dp.RadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.filters.GeocompleteFilters;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionSetManager;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSearchHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)AddressSearchHandler.class.getName());
    private static int WORD_TYPES_TO_REMOVE = 41;
    private static final Pattern m_hnrpattern = Pattern.compile("\\b\\d+([A-Z])?((-|/|\\\\)\\d+([A-Z])?)?\\b");
    private static final int MAX_PROBABLE_ADDRESS_FOR_PSEUDO_SEARCH = 100;
    private static final int MIN_PROBABLE_ADDRESS_FOR_FULL_SEARCH = 10;
    private static final int STREET_FIELD = 8;
    private static final SearchResults EMPTY_SEARCHRESULTS = new SearchResults(null, null);
    private static final AddressSearchPreferences DEFAULT_PREFERENCES = new AddressSearchPreferences();
    private final AutoSuggestHandler autoSuggestHandler;
    private final CategorySearchHandler categorySearchHandler;

    public AddressSearchHandler(AutoSuggestHandler autosuggestHandler) {
        this.autoSuggestHandler = autosuggestHandler;
        this.categorySearchHandler = new CategorySearchHandler(autosuggestHandler);
    }

    AddressSearchHandler() {
        this.autoSuggestHandler = null;
        this.categorySearchHandler = null;
    }

    public IAddressSearchResult searchAddress(String str) throws SuggestFailureException {
        return this.searchAddress(str, null, null);
    }

    public IAddressSearchResult searchAddress(String str, Rectangle bounds, double[] location) throws SuggestFailureException {
        return this.searchAddress(str, bounds, location, (AddressSearchPreferences)null);
    }

    public IAddressSearchResult searchAddress(InputAddress inAddress, Rectangle bounds, double[] location, AddressSearchPreferences addrPrefs) throws SuggestFailureException {
        if (addrPrefs == null) {
            addrPrefs = DEFAULT_PREFERENCES;
        }
        this.verifyLocationAndBounds(bounds, location);
        SearchAreas searchAreas = this.getSearchAreas(bounds, location);
        MultiFieldSearchHandler multiFieldSearchHandler = new MultiFieldSearchHandler(this);
        return multiFieldSearchHandler.searchAddress(inAddress, searchAreas, addrPrefs);
    }

    protected void verifyLocationAndBounds(Rectangle bounds, double[] location) {
        if (bounds != null && location != null && !bounds.pointInRect(location[0], location[1])) {
            throw new IllegalArgumentException("Location cannot be outside of bounds");
        }
    }

    AddressSearchPreferences getDefaultSearchPreferences() {
        return new AddressSearchPreferences();
    }

    public IAddressSearchResult searchAddress(String str, Rectangle bounds, double[] location, AddressSearchPreferences addrPrefs) throws SuggestFailureException {
        if (addrPrefs == null) {
            addrPrefs = DEFAULT_PREFERENCES;
        }
        SearchInput searchInput = this.prepareInputSearchString(str, addrPrefs);
        if (LOG.isDebugEnabled() && searchInput != null) {
            LOG.debug("searchAddress('" + str + "') - using search string '" + searchInput + "'");
        }
        IAddressSearchResult returnValue = null;
        if (searchInput != null) {
            this.verifyLocationAndBounds(bounds, location);
            SearchAreas searchAreas = this.getSearchAreas(bounds, location);
            searchInput.setSearchAreas(searchAreas);
            returnValue = this.searchAddress(searchInput, null, addrPrefs);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("searchAddress('" + str + "'): found [");
            if (returnValue != null) {
                Iterator<SimpleAddress> iter = returnValue.getResultIterator(200);
                while (iter != null && iter.hasNext()) {
                    SimpleAddress addr = iter.next();
                    sb.append(" '" + addr + "'");
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return returnValue;
    }

    IAddressSearchResult searchAddress(SearchInput searchInput, AddressSearchInternalResults preFetchedResults, AddressSearchPreferences addrSearchPrefs) throws SuggestFailureException {
        IAddressSearchResult result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("searchAddress('" + searchInput.getInputString() + "') - unconditionally creating iterable results object ('" + searchInput + "')");
        }
        try {
            WeightedInternalResultFetcher resultFetcher = new WeightedInternalResultFetcher(this, searchInput, addrSearchPrefs, preFetchedResults);
            if (!resultFetcher.isEmpty()) {
                result = this.makeSearchResult(resultFetcher, addrSearchPrefs, searchInput);
            }
        }
        catch (Exception ioe) {
            throw new SuggestFailureException(ioe);
        }
        return result;
    }

    IAddressSearchResult makeSearchResult(Iterable<AddressSearchInternalResult> results, AddressSearchPreferences addrSearchPrefs, SearchInput searchInput) {
        return new AddressSearchResult(this.autoSuggestHandler, results, addrSearchPrefs, searchInput.getSearchString(), searchInput.getSearchAreas());
    }

    private SearchInput prepareInputSearchString(String str, AddressSearchPreferences addrPrefs) {
        SearchInput searchInput = this.makeSearchInput(str, addrPrefs);
        if (searchInput != null && addrPrefs.isUseShortenedSearchString() && !searchInput.isShortenedInput()) {
            return null;
        }
        return searchInput;
    }

    protected SearchAreas getSearchAreas(Rectangle bounds, double[] location) {
        AutoSuggestHandler autoSuggestHandler = this.getAutoSuggestHandler();
        SearchAreas searchAreas = null;
        if ((bounds != null || location != null) && (searchAreas = autoSuggestHandler.getSearchAreas(bounds == null ? autoSuggestHandler.getExtent() : bounds, location)) != null) {
            searchAreas.setInputBounds(bounds);
        }
        return searchAreas;
    }

    protected SearchInput makeSearchInput(String inputStr, AddressSearchPreferences addrPrefs) {
        String cleansedStr = this.cleanString(inputStr);
        if (!MMUtils.isEmpty((String)cleansedStr)) {
            String shortenedStr = addrPrefs.isUseShortenedSearchString() ? this.getShortenedVersion(cleansedStr) : null;
            String searchStr = shortenedStr == null ? cleansedStr : shortenedStr;
            ArrayList<String> stdWords = new ArrayList<String>();
            ArrayList<String> lastWordAndAlts = new ArrayList<String>();
            this.populateStdWords(searchStr, addrPrefs, stdWords, lastWordAndAlts);
            SearchInput searchInput = new SearchInput(inputStr, searchStr, stdWords, lastWordAndAlts.isEmpty() ? null : lastWordAndAlts.toArray(new String[lastWordAndAlts.size()]), shortenedStr != null);
            return searchInput;
        }
        return null;
    }

    private String getShortenedVersion(String str) {
        String shorter;
        SubstitutionSetManager substitutionSetManager = this.getAutoSuggestHandler().getSubstitutionSetManager();
        if (substitutionSetManager != null && !StringUtilities.isEmpty((String)(shorter = substitutionSetManager.getShortestVersion(str, WORD_TYPES_TO_REMOVE))) && !StringUtilities.equalStrings((String)shorter, (String)str)) {
            return shorter;
        }
        return null;
    }

    private void populateStdWords(String str, AddressSearchPreferences addrSearchPrefs, List<String> stdWords, List<String> lastWordAlts) {
        TokenStandardiser tokenStandardiser = this.getAutoSuggestHandler().getTokenStandardiser();
        if (tokenStandardiser != null && str != null) {
            String[] words = str.split(" ");
            int wordCount = words.length;
            for (int wordNdx = 0; wordNdx < wordCount - 1; ++wordNdx) {
                String stdWord;
                String word = words[wordNdx];
                String string = stdWord = tokenStandardiser == null ? null : tokenStandardiser.standardiseWord(word, addrSearchPrefs);
                if (word.equals(stdWord)) {
                    stdWord = null;
                }
                stdWords.add(stdWord);
            }
            String word = words[wordCount - 1];
            stdWords.add(null);
            List<String> alts = this.getPossibleAltTokens(tokenStandardiser, word);
            if (alts != null) {
                lastWordAlts.addAll(alts);
            }
        }
    }

    protected String cleanString(String str) {
        return StringNormalizer.normalise(str);
    }

    protected AddressSearchInternalResults internalSearchNext(SearchInput searchInput, AddressSearchInternalResult previousSearchResult, AddressSearchPreferences searchPrefs) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("internalSearchNext(actual: '%s', search-key: '%s', alts: %s, prior search words: %s)", searchInput.getCleansedString(), searchInput.getSearchString(), searchInput.getLastWordAlts(), previousSearchResult == null ? "null" : Arrays.toString(previousSearchResult.getSearchWords())));
        }
        int inputCharsMatched = 0;
        if (previousSearchResult != null && searchInput.isSameInputField(previousSearchResult.getSearchInput())) {
            inputCharsMatched = previousSearchResult.getMatchedLen();
        }
        String str = searchInput.getSearchString();
        AddressSearchInternalResults results = null;
        if (inputCharsMatched < str.length()) {
            AddressSearchInternalResult hnrMatchResult;
            SearchInput subInput = searchInput.getSubInput(inputCharsMatched);
            String nextWord = subInput.getWordStartingAt(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("internalSearch(actual: %s, search-key: '%s'): before end-of-string (%d vs %d) so about to call internalSearch('%s')", searchInput.getStdString(), searchInput.getSearchString(), previousSearchResult == null ? 0 : previousSearchResult.getSearchWordEnd(), str.length(), subInput.getSearchString()));
            }
            results = this.internalSearch(subInput, previousSearchResult, searchPrefs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalSearch('" + subInput.getSearchString() + "') internalSearch found: " + results);
            }
            if (this.canSearchAddressNumber(searchPrefs, previousSearchResult, subInput) && (hnrMatchResult = this.getPossibleHnrMatchResult(subInput, nextWord, previousSearchResult, null)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("internalSearch('" + str + "') we perform an addition search of word follows HNR pattern: '" + hnrMatchResult + "'");
                }
                results = this.combineResults(results, hnrMatchResult, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("internalSearch('" + str + "') combineResults found: " + results);
                }
            }
            if (this.canSearchOnExtendedHNR(previousSearchResult, subInput)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("internalSearch('" + str + "', '" + nextWord + "'): checking for extended house number");
                }
                if ((hnrMatchResult = this.getPossibleExtendedHNRMatchResults(previousSearchResult, subInput, nextWord)) != null) {
                    results = this.combineResults(results, hnrMatchResult);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(String.format("internalSearchNext(actual: '%s', search-key: '%s', las word alts: %s, prior search words: %s): found [", searchInput.getStdString(), searchInput.getSearchString(), Arrays.toString(searchInput.getLastWordAlts()), previousSearchResult == null ? "[ ]" : Arrays.toString(previousSearchResult.getSearchWords())));
            if (results != null && results.iterator() != null) {
                for (AddressSearchInternalResult r : results) {
                    sb.append(" ");
                    if (r.getSearchResult() != null) {
                        sb.append(r.getSearchResult().getWord());
                    } else {
                        sb.append("***");
                    }
                    sb.append("(");
                    sb.append(r.getMatchedFieldType());
                    sb.append(")");
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return results;
    }

    private boolean canSearchOnExtendedHNR(AddressSearchInternalResult previousSearchResult, SearchInput searchInput) {
        if (previousSearchResult != null && previousSearchResult.isHNRMatchResult() && !previousSearchResult.isExtendedHNRMatchResult()) {
            return searchInput.isOnLastWord() ? previousSearchResult.containsFieldMatch(8) : true;
        }
        return false;
    }

    AddressSearchInternalResult getPossibleExtendedHNRMatchResults(AddressSearchInternalResult previousSearchResult, SearchInput searchInput, String word) {
        String extendedHouseNumber = AddressUtil.buildExtendedHouseNumber(searchInput.getInputString(), previousSearchResult.getHnr());
        if (extendedHouseNumber != null) {
            return this.getPossibleHnrMatchResult(searchInput, word, previousSearchResult, extendedHouseNumber);
        }
        return null;
    }

    AddressSearchInternalResult getPossibleHnrMatchResult(SearchInput sr, String searchWord, AddressSearchInternalResult previousSearchResult, String extendedHouseNumber) {
        String possibleHnrWord = null;
        possibleHnrWord = extendedHouseNumber != null ? extendedHouseNumber : sr.getInputWordStartingAt(0);
        if (possibleHnrWord != null && this.isHnrPattern(possibleHnrWord)) {
            int searchEndNdx = AddressSearchHandler.calculateLastSearchWordEnd(previousSearchResult, sr) + AddressSearchHandler.calculateMatchLength(searchWord, sr.getSearchString(), searchWord.length());
            if (extendedHouseNumber != null) {
                sr = previousSearchResult.getSearchInput();
                previousSearchResult = previousSearchResult.getPreviousResult();
                return AddressSearchInternalResult.getExtendedHNRResultInstance(searchEndNdx, possibleHnrWord, previousSearchResult, sr);
            }
            return AddressSearchInternalResult.getHNRResultInstance(searchEndNdx, possibleHnrWord, previousSearchResult, sr);
        }
        return null;
    }

    boolean canSearchAddressNumber(AddressSearchPreferences searchPrefs, AddressSearchInternalResult previousSearchResult, SearchInput searchInput) {
        if (searchPrefs == null || searchPrefs.canSearchStreetField()) {
            if (previousSearchResult == null) {
                return true;
            }
            if (previousSearchResult.getHnr() == null && (!searchInput.isOnLastWord() || previousSearchResult.containsFieldMatch(8))) {
                return true;
            }
        }
        return false;
    }

    private AddressSearchInternalResults combineResults(AddressSearchInternalResults results, AddressSearchInternalResult result) {
        return this.combineResults(results, result, false);
    }

    private AddressSearchInternalResults combineResults(AddressSearchInternalResults results, AddressSearchInternalResult result, boolean addFirst) {
        if (results == null) {
            results = new AddressSearchInternalResults();
        }
        if (addFirst) {
            results.addFirst(result);
        } else {
            results.add(result);
        }
        return results;
    }

    AddressSearchInternalResults combineResults(AddressSearchInternalResults results, AddressSearchInternalResults otherResults) {
        if (otherResults != null) {
            if (results == null) {
                results = otherResults;
            } else {
                results.combine(otherResults);
            }
        }
        return results;
    }

    private boolean isHnrPattern(String str) {
        Matcher m = m_hnrpattern.matcher(str);
        return m.find();
    }

    boolean moreCharactersLeftToMatch(SearchInput searchInput, AddressSearchInternalResult currResult) {
        return !currResult.isFullInputMatch();
    }

    protected AddressSearchInternalResults internalSearch(SearchInput searchInput, AddressSearchInternalResult previousSearchResult, AddressSearchPreferences searchPrefs) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("internalSearch(actual: '" + searchInput.getStdString() + "', search-key: '" + searchInput.getSearchString() + "')");
        }
        if (searchInput.isOnLastWord()) {
            AddressSearchInternalResults fullResults = null;
            AddressSearchInternalResult pseudoResult = this.doPseudoSearch(searchInput, previousSearchResult, searchPrefs);
            if (pseudoResult == null) {
                AddressSearchInternalResults results = this.internalSearch1(searchInput, previousSearchResult, searchPrefs, false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("internalSearch(actual: '" + searchInput.getSearchString() + " has results " + results);
                }
                fullResults = this.combineResults(fullResults, results);
                boolean savedFuzzySearchFlag = searchPrefs.getFuzzySearch();
                searchPrefs.setFuzzySearch(false);
                for (SearchInput altInput : searchInput.getLastWordAltSearchInputs()) {
                    AddressSearchInternalResults altResults = this.internalSearch1(altInput, previousSearchResult, searchPrefs, false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("internalSearch(actual: '" + searchInput.getSearchString() + "', search-key: '" + altInput.getSearchString() + "'): alt word '" + altInput.getSearchString() + "' has results " + altResults);
                    }
                    fullResults = this.combineResults(fullResults, altResults);
                }
                searchPrefs.setFuzzySearch(savedFuzzySearchFlag);
            } else {
                fullResults = this.combineResults(fullResults, pseudoResult);
            }
            return fullResults;
        }
        AddressSearchInternalResults results = this.internalSearch1(searchInput, previousSearchResult, searchPrefs, false);
        return results;
    }

    AddressSearchInternalResults internalSearch1(SearchInput searchInput, AddressSearchInternalResult previousSearchResult, AddressSearchPreferences searchPrefs, boolean matchFully) throws SuggestFailureException {
        AutoSuggestHandler autoSuggestHandler = this.getAutoSuggestHandler();
        AddressSearchInternalResults combinedResults = null;
        for (SearchInput currSearchInput : this.makeAllPossibleInputs(searchInput, searchPrefs)) {
            SearchRequest req = this.makeSearchRequest(currSearchInput, previousSearchResult, searchPrefs, matchFully);
            if (this.hasNonCategorySearchFields(req)) {
                SearchResults searchResults = null;
                SearchResults savedResults = currSearchInput.getResults();
                if (savedResults != null) {
                    if (savedResults != EMPTY_SEARCHRESULTS) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("internalSearch1(search-key: '" + currSearchInput + "') found existing result, making a copy");
                        }
                        searchResults = autoSuggestHandler.makeResultCopyForRequest(req, savedResults);
                    }
                } else {
                    if (currSearchInput.isOnLastWord()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("internalSearch1(search-key: '" + currSearchInput + "') calling autoSuggestHandler.search()");
                        }
                        searchResults = autoSuggestHandler.search(req);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("internalSearch1(search-key: '" + currSearchInput + "') calling autoSuggestHandler.doIncrementalWordSearch()");
                        }
                        searchResults = autoSuggestHandler.doIncrementalWordSearch(req);
                    }
                    currSearchInput.setResults(searchResults == null ? EMPTY_SEARCHRESULTS : searchResults);
                }
                AddressSearchInternalResults results = null;
                if (searchResults != null) {
                    results = new AddressSearchInternalResults();
                    results.createAndAddNewInternalResult(searchResults, previousSearchResult, currSearchInput);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("internalSearch1(search-key: '" + currSearchInput + "') results from autoSuggestHandler.*: " + results);
                    }
                }
                combinedResults = this.combineResults(combinedResults, results);
            }
            AddressSearchInternalResults categorySearchResult = this.getCategorySearchResults(previousSearchResult, currSearchInput, req);
            combinedResults = this.combineResults(combinedResults, categorySearchResult);
        }
        return combinedResults;
    }

    private boolean hasNonCategorySearchFields(SearchRequest req) {
        if (this.categorySearchHandler == null) {
            return true;
        }
        List<Integer> allowedTypes = req.getAllowedTypes();
        if (allowedTypes == null) {
            return true;
        }
        int catField = this.categorySearchHandler.getCategoryFieldID();
        int subCatField = this.categorySearchHandler.getSubCategoryFieldID();
        for (Integer type : allowedTypes) {
            if (type == catField || type == subCatField) continue;
            return true;
        }
        return false;
    }

    AddressSearchInternalResults getCategorySearchResults(AddressSearchInternalResult prevResult, SearchInput searchInput, SearchRequest searchRequest) throws SuggestFailureException {
        try {
            if (this.isPOIDataSet()) {
                return this.categorySearchHandler.searchCategories(prevResult, searchInput, searchRequest);
            }
        }
        catch (Exception ioe) {
            throw new SuggestFailureException(ioe);
        }
        return null;
    }

    protected boolean isPOIDataSet() {
        return this.getAutoSuggestHandler().getDataSetType() == 1;
    }

    private Iterable<SearchInput> makeAllPossibleInputs(SearchInput searchInput, AddressSearchPreferences addrSearchPreferences) {
        if (this.fuzzySearch(addrSearchPreferences) && searchInput.isStandardVersion()) {
            ArrayList<SearchInput> searchInputList = new ArrayList<SearchInput>(3);
            SearchInput nonStdInput = searchInput.getNonStdVersion();
            if (nonStdInput != null) {
                searchInputList.add(searchInput.getNonStdVersion());
            }
            searchInputList.add(searchInput);
            if (searchInput.getNumberOfStdWords() > 2) {
                searchInputList.add(searchInput.getPartialStdVersion(2));
            }
            if (searchInput.getNumberOfStdWords() > 1) {
                searchInputList.add(searchInput.getPartialStdVersion(1));
            }
            return searchInputList;
        }
        return Collections.singletonList(searchInput);
    }

    private List<String> getPossibleAltTokens(TokenStandardiser tokenStandardiser, String prefix) {
        int n;
        Set<String> altTokens = tokenStandardiser.getStandardisedWordsForPrefix(prefix);
        int n2 = n = altTokens == null ? 0 : altTokens.size();
        if (n > 0) {
            return new ArrayList<String>(altTokens);
        }
        return null;
    }

    public AddressMetaData getAddressMetaData() {
        return this.autoSuggestHandler.getAddressMetaData();
    }

    protected AddressSearchInternalResult doPseudoSearch(SearchInput searchInput, AddressSearchInternalResult previousSearchResult, AddressSearchPreferences searchPrefs) {
        String searchStr;
        int searchWordLen;
        if (previousSearchResult == null || !this.allowPsuedoSearch(searchInput, searchPrefs)) {
            return null;
        }
        AddressSearchInternalResult psuedoResult = null;
        AddressSearchInternalResult usableSearchResult = previousSearchResult.getRealResult();
        if (usableSearchResult != null && ((searchWordLen = (searchStr = searchInput.getSearchString()).length()) < 2 && !usableSearchResult.hasMoreResultsThanMinimum(100) || !usableSearchResult.hasMoreResultsThanMinimum(10))) {
            int wordMatchLen = AddressSearchHandler.calculateLastSearchWordEnd(previousSearchResult, searchInput) + searchWordLen;
            SearchResult searchResult = SearchResult.getInstance(searchStr, null, usableSearchResult.getSearchResult().getSearchRequest(), wordMatchLen, 100, true);
            String[] lastWordAndAlts = this.getLastWordAndAlts(searchInput);
            psuedoResult = AddressSearchInternalResult.getPsuedoResultInstance(lastWordAndAlts, wordMatchLen, searchResult, previousSearchResult, searchInput);
        }
        return psuedoResult;
    }

    private String[] getLastWordAndAlts(SearchInput searchInput) {
        String[] lastWordAlts = searchInput.getLastWordAlts();
        if (lastWordAlts != null) {
            String[] lastWords = new String[lastWordAlts.length + 1];
            lastWords[0] = StringNormalizer.getLastWord(searchInput.getSearchString());
            System.arraycopy(lastWordAlts, 0, lastWords, 1, lastWordAlts.length);
            return lastWords;
        }
        return new String[]{searchInput.getSearchString()};
    }

    SearchRequest makeSearchRequest(SearchInput searchInput, AddressSearchInternalResult previousSearchResult, AddressSearchPreferences searchPrefs, boolean matchFully) {
        SearchRequest req = new SearchRequest();
        this.applyAddressSearchPreferences(req, searchPrefs);
        req.setSearchAreas(searchInput.getSearchAreas());
        if (previousSearchResult != null) {
            previousSearchResult.setFilterList(req);
            req.setFilterWithinBounds(!previousSearchResult.hasNonHNRMatch());
        } else {
            req.setFilterWithinBounds(true);
        }
        String[] lastWordAlts = searchInput.getLastWordAlts();
        if (!searchInput.isOnLastWord() && lastWordAlts != null) {
            req.setSearchKey(StringNormalizer.removeLastWord(searchInput.getSearchString(), true));
            req.setSearchKeyExtensions(this.getLastWordAndAlts(searchInput));
        } else {
            req.setSearchKey(searchInput.getSearchString());
            req.setSearchKeyExtensions(null);
        }
        req.setKeyFilter(GeocompleteFilters.getKeyFilter(req.getSearchkey(), req.getSearchKeyExtensions(), searchInput.isLastWordAlt(), matchFully, searchPrefs, searchInput.getStdWordPositions()));
        req.setAdditionalFilters(this.makeAdditionalFilters(previousSearchResult));
        req.setFuzzySearch(searchPrefs.getFuzzySearch());
        req.setMatchFully(matchFully);
        return req;
    }

    List<IAddressPtrFilter> makeAdditionalFilters(AddressSearchInternalResult previousSearchResult) {
        List<IAddressPtrFilter> filters = null;
        return filters;
    }

    IAddressPtrFilter makeAddressNumberFilter(AddressSearchInternalResult previousSearchResult) {
        int numericHNR;
        String hnr;
        String string = hnr = previousSearchResult == null ? null : previousSearchResult.getHnr();
        if (hnr != null && (numericHNR = AddressUtil.getNumericAddressNumber(hnr)) > -1) {
            return new AddrNumHashFilter(numericHNR);
        }
        return null;
    }

    private boolean fuzzySearch(AddressSearchPreferences searchPrefs) {
        return searchPrefs.getFuzzySearch();
    }

    private boolean allowPsuedoSearch(SearchInput searchInput, AddressSearchPreferences searchPrefs) {
        if (searchPrefs.getFuzzySearch()) {
            return searchInput.getSearchString().length() <= searchPrefs.getMinMatchCharacters();
        }
        return true;
    }

    void applyAddressSearchPreferences(SearchRequest req, AddressSearchPreferences addrSearchPrefs) {
        if (addrSearchPrefs != null) {
            List<Integer> searchableFieldIds = addrSearchPrefs.getSearchableFields();
            if (searchableFieldIds != null && !searchableFieldIds.isEmpty()) {
                RadixTreeMetaData treeMetadata = this.getAutoSuggestHandler().getRadixTreeMetaData();
                if (null != treeMetadata) {
                    Set<Integer> dataIndexedSearchFieldIds = treeMetadata.getFieldIDs();
                    searchableFieldIds = new ArrayList<Integer>(searchableFieldIds);
                    searchableFieldIds.retainAll(dataIndexedSearchFieldIds);
                }
                req.setAllowedTypes(searchableFieldIds);
            } else {
                List<Integer> fieldsToOmit = addrSearchPrefs.getOmittedFields();
                if (fieldsToOmit != null && !fieldsToOmit.isEmpty()) {
                    req.setIgnoreTypes(fieldsToOmit);
                }
            }
        }
    }

    static int calculateMatchLength(String resultStr, String searchString, int keyMatchLen) {
        if (keyMatchLen < searchString.length() - 1 && searchString.charAt(keyMatchLen) == ' ') {
            return keyMatchLen + 1;
        }
        return keyMatchLen;
    }

    static int calculateMatchLength(String resultStr, SearchInput searchInput, int keyMatchLen) {
        String searchString = searchInput.getSearchString();
        if (keyMatchLen < searchString.length() - 1 && searchString.charAt(keyMatchLen) == ' ') {
            return keyMatchLen + 1;
        }
        return keyMatchLen;
    }

    static int calculateLastSearchWordEnd(AddressSearchInternalResult previousResult, SearchInput currSearchInput) {
        if (previousResult == null) {
            return 0;
        }
        if (currSearchInput.getInputField() != previousResult.getSearchInput().getInputField()) {
            return 0;
        }
        return previousResult.getSearchWordEnd();
    }

    public String getFieldName(int id) {
        return this.autoSuggestHandler.getFieldName(id);
    }

    public List<Integer> getAddressFields() {
        return this.autoSuggestHandler.getAddressFields();
    }

    protected AutoSuggestHandler getAutoSuggestHandler() {
        return this.autoSuggestHandler;
    }

    public List<SimpleAddress> doPointDistanceSearch(DirectPosition origin, double radius, int maxCandidates) throws SuggestFailureException {
        return this.autoSuggestHandler.doPointBoundsSearch(origin, radius, maxCandidates);
    }
}

