/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.FormattedString;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AddressStringFormatter {
    private final Map<Integer, FieldMatchInfo> fieldMatchInfos;
    private InternalSimpleAddress streetAddr;
    private SimpleRange range;
    private SimpleUnit rangeUnit;
    private FieldType.FieldLevel currentFieldLevel = null;

    public AddressStringFormatter(Map<Integer, FieldMatchInfo> fieldMatchInfos, InternalSimpleAddress addr) {
        this.fieldMatchInfos = fieldMatchInfos;
        this.streetAddr = addr;
    }

    public AddressStringFormatter(Map<Integer, FieldMatchInfo> fieldMatchInfos, SimpleRange range) {
        this.fieldMatchInfos = fieldMatchInfos;
        this.range = range;
    }

    public AddressStringFormatter(Map<Integer, FieldMatchInfo> fieldMatchInfos, SimpleUnit rangeUnit) {
        this.fieldMatchInfos = fieldMatchInfos;
        this.rangeUnit = rangeUnit;
    }

    public AddressStringFormatter(Map<Integer, FieldMatchInfo> fieldMatchInfos, InternalSimpleAddress addr, SimpleRange range, SimpleUnit rangeUnit) {
        this.fieldMatchInfos = fieldMatchInfos;
        this.streetAddr = addr;
        this.range = range;
        this.rangeUnit = rangeUnit;
    }

    public FormattedString getFormattedAddressString(boolean usePrefferedName, int ... fields) {
        ArrayList<Integer> fieldList = new ArrayList<Integer>(fields.length);
        for (int field : fields) {
            fieldList.add(field);
        }
        return this.getFormattedAddressString(usePrefferedName, fieldList);
    }

    public FormattedString getFormattedAddressString(boolean usePrefferedName, Collection<Integer> fields) {
        IntArray fieldMatchPositions = new IntArray(10);
        StringBuilder sb = new StringBuilder(100);
        boolean isLastSpaceAddedForUnits = false;
        for (int field : fields) {
            boolean isRangeFieldValue = false;
            boolean isUnitFieldValue = false;
            String fv = "";
            FieldMatchInfo fieldMatchInfo = this.fieldMatchInfos.get(field);
            if (this.streetAddr != null) {
                if (field == FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey() && this.range != null) {
                    isRangeFieldValue = true;
                    isLastSpaceAddedForUnits = true;
                    fv = this.range.getFrom();
                    if (!StringUtilities.isEmpty((String)fv) && !StringUtilities.isEmpty((String)this.range.getTo())) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(fv);
                        if (!this.range.getTo().equalsIgnoreCase(fv)) {
                            builder.append("-").append(this.range.getTo());
                            fv = builder.toString();
                        }
                    }
                }
                if (field == FieldType.RANGE_PLACE_NAME_FIELD_TYPE.getKey() && this.range != null) {
                    isRangeFieldValue = true;
                    fv = this.range.getFieldValue(field);
                }
                if (StringUtilities.isEmpty((String)fv) && !isRangeFieldValue) {
                    fv = !usePrefferedName && fieldMatchInfo != null ? this.streetAddr.getFieldValue(field, fieldMatchInfo.getMatchedValueNdx()) : this.streetAddr.getFieldValue(field);
                }
            }
            if (this.range != null && StringUtilities.isEmpty((String)fv)) {
                fv = this.range.getFieldValue(field);
            }
            if (StringUtilities.isEmpty((String)fv) && this.rangeUnit != null && !StringUtilities.isEmpty((String)(fv = this.rangeUnit.getFieldValue(field)))) {
                isUnitFieldValue = true;
            }
            if (fv == null) continue;
            if (!isRangeFieldValue && isUnitFieldValue && (fv.length() == 1 && Character.isLetter(fv.charAt(0)) || StringUtilities.hasNumeric((String)fv))) {
                this.addDelimiter(sb, " ");
                isLastSpaceAddedForUnits = true;
            } else if (isLastSpaceAddedForUnits) {
                this.addDelimiter(sb, ", ");
                isLastSpaceAddedForUnits = false;
            } else {
                StringNormalizer.addDelim(sb, fv);
            }
            int startPos = sb.length();
            sb.append(fv);
            if (fieldMatchInfo == null) continue;
            fieldMatchPositions.add(startPos);
            fieldMatchPositions.add(fieldMatchInfo.getMatchedLength());
        }
        FormattedString fmtStr = new FormattedString(sb.toString().trim(), fieldMatchPositions.asArray());
        return fmtStr;
    }

    private void addDelimiter(StringBuilder sb, String delimiter) {
        if (sb.length() == 0) {
            return;
        }
        sb.append(delimiter);
    }

    public FormattedString getFormattedAddressString(boolean usePrefferedName, String[] formatingPattern) {
        IntArray fieldMatchPositions = new IntArray(10);
        StringBuilder stringBuilder = new StringBuilder();
        if (formatingPattern != null) {
            String currentDelim = null;
            String previousDelim = null;
            String delimPostLastNotNullValue = null;
            FieldType.FieldLevel previousFieldLevel = null;
            boolean isLevelChanged = false;
            boolean isProcessed = false;
            for (String pattern : formatingPattern) {
                this.currentFieldLevel = null;
                int field = -1;
                if (StringUtilities.isEmpty((String)pattern) || pattern.startsWith("[") || pattern.endsWith("]")) continue;
                if (pattern.startsWith("{") && pattern.endsWith("}")) {
                    currentDelim = pattern.substring(pattern.indexOf("{") + 1, pattern.indexOf("}"));
                    if (!isLevelChanged) {
                        delimPostLastNotNullValue = currentDelim;
                    }
                    if (isProcessed || StringUtilities.isEmpty(previousDelim)) continue;
                    currentDelim = previousDelim;
                    continue;
                }
                field = Integer.valueOf(pattern);
                if (field <= -1) continue;
                FieldMatchInfo fieldMatchInfo = this.fieldMatchInfos.get(field);
                boolean isRangeFieldValue = false;
                String fv = this.getFormattedFieldValue(usePrefferedName, field, fieldMatchInfo, isRangeFieldValue);
                if (this.currentFieldLevel == null) {
                    this.currentFieldLevel = previousFieldLevel;
                }
                if (this.currentFieldLevel == FieldType.FieldLevel.LEVEL_UNIT && previousFieldLevel == FieldType.FieldLevel.LEVEL_RANGE || previousFieldLevel == FieldType.FieldLevel.LEVEL_UNIT && this.currentFieldLevel == FieldType.FieldLevel.LEVEL_RANGE) {
                    currentDelim = delimPostLastNotNullValue;
                    isLevelChanged = true;
                }
                if (!(StringUtilities.isEmpty((String)currentDelim) || StringUtilities.isEmpty((String)fv) || StringUtilities.isEmpty((String)stringBuilder.toString().trim()))) {
                    stringBuilder.append(currentDelim);
                    previousDelim = currentDelim;
                }
                if (!StringUtilities.isEmpty((String)fv)) {
                    stringBuilder.append(fv);
                    isProcessed = true;
                    previousFieldLevel = this.currentFieldLevel;
                    continue;
                }
                isProcessed = false;
                previousDelim = currentDelim;
            }
        }
        FormattedString fmtStr = new FormattedString(stringBuilder.toString().trim(), fieldMatchPositions.asArray());
        return fmtStr;
    }

    private String getFormattedFieldValue(boolean usePrefferedName, int field, FieldMatchInfo fieldMatchInfo, boolean isRangeFieldValue) {
        String fv = "";
        if (this.streetAddr != null) {
            if (field == FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey() && this.range != null) {
                isRangeFieldValue = true;
                this.currentFieldLevel = FieldType.FieldLevel.LEVEL_RANGE;
                fv = this.range.getFrom();
                if (!StringUtilities.isEmpty((String)fv) && !StringUtilities.isEmpty((String)this.range.getTo())) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(fv);
                    if (!this.range.getTo().equalsIgnoreCase(fv)) {
                        builder.append("-").append(this.range.getTo());
                        fv = builder.toString();
                    }
                }
            }
            if (field == FieldType.RANGE_PLACE_NAME_FIELD_TYPE.getKey() && this.range != null) {
                isRangeFieldValue = true;
                fv = this.range.getFieldValue(field);
                this.currentFieldLevel = FieldType.FieldLevel.LEVEL_RANGE;
            }
            if (StringUtilities.isEmpty((String)fv) && !isRangeFieldValue && !MMUtils.isEmpty((String)(fv = !usePrefferedName && fieldMatchInfo != null && fieldMatchInfo.getMatchedValueNdx() >= 0 ? this.streetAddr.getFieldValue(field, fieldMatchInfo.getMatchedValueNdx()) : this.streetAddr.getFieldValue(field)))) {
                FieldType type = FieldType.getPredefinedField((int)field);
                this.currentFieldLevel = type != null ? FieldType.getPredefinedField((int)field).getLevel() : FieldType.FieldLevel.LEVEL_UNKNOWN;
            }
        }
        if (this.range != null && StringUtilities.isEmpty((String)fv) && !MMUtils.isEmpty((String)(fv = this.range.getFieldValue(field)))) {
            this.currentFieldLevel = FieldType.FieldLevel.LEVEL_RANGE;
        }
        if (StringUtilities.isEmpty((String)fv) && this.rangeUnit != null && !MMUtils.isEmpty((String)(fv = this.rangeUnit.getFieldValue(field)))) {
            this.currentFieldLevel = FieldType.FieldLevel.LEVEL_UNIT;
        }
        return fv;
    }
}

