/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AbstractRadixTreeSearcher;
import com.mapinfo.mapmarker.autosuggest.AddressPtrFilter;
import com.mapinfo.mapmarker.autosuggest.IAddressFilter;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.SearchResult;
import com.mapinfo.mapmarker.autosuggest.SearchResultAddressIterator;
import com.mapinfo.mapmarker.autosuggest.SearchResults;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.TokenStandardiser;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.dp.AddressGeomItem;
import com.mapinfo.mapmarker.autosuggest.dp.AddressIOHandler;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.AreaGeomItem;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryInfoManager;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrMapReadingFilter;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.dp.IDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.RadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.StringDataItem;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.exception.InitializationFailureException;
import com.mapinfo.mapmarker.autosuggest.exception.SuggestFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DiskRadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IRadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.substitution.SubstitutionSetManager;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.compress.CompHeader;
import com.mapinfo.mapmarker.cgge.utils.compress.StringCompressor;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEConcurrentDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggestHandler
extends AbstractRadixTreeSearcher<AddressPtrMap> {
    static final Logger LOG = LoggerFactory.getLogger((String)AutoSuggestHandler.class.getName());
    private static final int MAX_SEARCH_AREA_FOR_ADDR_FILTERING = 10000;
    public static final String TYPEAHEAD_DICT_SUFFIX = ".rdx";
    public static final String QUAD_TREE_FILE_EXT = ".qad";
    public static final String SUBSTITUTION_FILE_EXT = ".ssm";
    public static final String CATEGORY_LOOKUP_INDEX_EXT = ".cdx";
    public static final String STREET_TYPE_STRING = "Street";
    public static final String POI_TYPE_STRING = "POI";
    public static final int DATA_TYPE_STREET = 0;
    public static final int DATA_TYPE_POI = 1;
    private RadixTree<AddressPtrMap> m_radixTree;
    private QuadTree<AreaGeomItem> m_quadTree;
    private RadixTreeMetaData m_metaData;
    private IDataReader m_dataSetReader;
    private ICGGEConcurrentDataInputStream m_quadTreeDataStream;
    private TokenStandardiser m_tokenStandardiser;
    private SubstitutionSetManager m_substitutionSetManager;
    private CategoryInfoManager m_categoryInfoManager;
    private boolean isMetaDataLoaded = false;
    private static final double HALF_EARTH = 2.003758E7;

    public Rectangle load(String path, String dataSetPath) throws InitializationFailureException {
        return this.load(path, dataSetPath, false);
    }

    public Rectangle load(String path, String dataSetPath, boolean memoryMapped) throws InitializationFailureException {
        this.loadMetadata(path, dataSetPath);
        RadixTreeMetaData metaData = this.getRadixTreeMetaData();
        this.loadTokenStandardiser(metaData);
        String folderPath = new File(path).getParent();
        this.loadQuadTree(folderPath, metaData.getDataSetName());
        this.loadSubstitutionSet(path, metaData.getDataSetName());
        if (metaData.getDataType() == 1) {
            this.loadCategoryInfoManager(folderPath, metaData.getDataSetName());
        }
        return this.getExtent();
    }

    public void loadMetadata(String path, String dataSetPath) throws InitializationFailureException {
        if (!this.isMetaDataLoaded) {
            this.loadRadixTree(path, false);
            if (dataSetPath != null) {
                try {
                    this.loadDataSetReader(dataSetPath, this.getRadixTreeMetaData());
                }
                catch (IOException ioe) {
                    String message = "Could not load the meta data from " + dataSetPath;
                    message = message + (path == null ? " , path to the RDX file is null" : " , " + path);
                    AutoSuggestLog.getLog().error((Object)message);
                    throw new InitializationFailureException(message, ioe);
                }
            }
        }
        this.isMetaDataLoaded = true;
    }

    protected void loadCategoryInfoManager(String path, String dataName) throws InitializationFailureException {
        String fullPath = MMUtils.appendToPath((String)path, (String)(dataName + CATEGORY_LOOKUP_INDEX_EXT));
        File file = new File(fullPath);
        if (!file.exists() || !file.isFile()) {
            String message = "Cannot load category info manager from " + file.getAbsolutePath() + " , isn't a file.";
            AutoSuggestLog.getLog().error((Object)message);
            throw new InitializationFailureException(message);
        }
        this.m_categoryInfoManager = new CategoryInfoManager();
        try {
            this.m_categoryInfoManager.load(path, dataName);
        }
        catch (CGGELevelException cggeLevelException) {
            throw new InitializationFailureException(cggeLevelException);
        }
        catch (IOException ioe) {
            throw new InitializationFailureException(ioe);
        }
    }

    protected void loadDataSetReader(String path, RadixTreeMetaData metaData) throws IOException {
        AddressIOHandler dataSetReader = new AddressIOHandler();
        dataSetReader.load(path, metaData.getDataSetName(), this.getCompressor(metaData));
        this.setDataSetReader(dataSetReader);
    }

    protected void setQuadTree(QuadTree<AreaGeomItem> quadTree) {
        this.m_quadTree = quadTree;
    }

    protected QuadTree<AreaGeomItem> getQuadTree() {
        return this.m_quadTree;
    }

    protected void setDataSetReader(IDataReader dataReader) {
        this.m_dataSetReader = dataReader;
    }

    protected IDataReader getDataSetReader() {
        return this.m_dataSetReader;
    }

    void setRadixTreeMetaData(RadixTreeMetaData metaData) {
        this.m_metaData = metaData;
    }

    protected RadixTreeMetaData getRadixTreeMetaData() {
        return this.m_metaData;
    }

    void setRadixTree(RadixTree<AddressPtrMap> radixTree) {
        this.m_radixTree = radixTree;
    }

    protected StringCompressor getCompressor(RadixTreeMetaData metaData) {
        CompHeader compHeader = metaData.getCompHeader();
        if (compHeader != null) {
            return new StringCompressor(compHeader);
        }
        return null;
    }

    public Rectangle getExtent() {
        return this.m_quadTree.getExtends();
    }

    void loadRadixTree(String path, boolean memoryMapped) throws InitializationFailureException {
        RadixTreeMetaData metaData = new RadixTreeMetaData();
        DiskRadixTree<AddressPtrMap> radixTree = new DiskRadixTree<AddressPtrMap>(new AddressPtrMap());
        try {
            radixTree.load(path, (IRadixTreeMetaData)metaData, memoryMapped);
        }
        catch (CGGELevelException cggeLevelException) {
            throw new InitializationFailureException(cggeLevelException);
        }
        catch (IOException ioe) {
            throw new InitializationFailureException(ioe);
        }
        this.setRadixTreeMetaData(metaData);
        this.setRadixTree(radixTree);
    }

    void loadTokenStandardiser(IRadixTreeMetaData metaData) throws InitializationFailureException {
        byte[] altLookupTreeBytes = metaData.getAdditionalBytes();
        TokenStandardiser tokenStandardiser = null;
        if (altLookupTreeBytes != null) {
            ICGGEDataInputStream dataStream = null;
            DiskRadixTree<StringDataItem> radixTree = null;
            try {
                dataStream = DataStreamFactory.getInputDataStream((byte[])altLookupTreeBytes);
                radixTree = new DiskRadixTree<StringDataItem>(new StringDataItem(""));
                radixTree.load(dataStream, (IRadixTreeMetaData)new RadixTreeMetaData(), false);
            }
            catch (CGGELevelException cgge) {
                throw new InitializationFailureException(cgge);
            }
            catch (IOException ioe) {
                throw new InitializationFailureException(ioe);
            }
            finally {
                if (dataStream != null) {
                    try {
                        dataStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            RadixTree<StringDataItem> altWordLookupTree = radixTree.readFully();
            tokenStandardiser = new TokenStandardiser(altWordLookupTree);
        }
        this.setTokenStandiser(tokenStandardiser);
        if (AutoSuggestLog.getLog().isDebugEnabled()) {
            AutoSuggestLog.getLog().debug((Object)"Loaded token standariser");
        }
    }

    void loadQuadTree(String path, String name) throws InitializationFailureException {
        String fullPath = MMUtils.appendToPath((String)path, (String)(name + QUAD_TREE_FILE_EXT));
        ICGGEConcurrentDataInputStream dataStream = null;
        try {
            dataStream = DataStreamFactory.getConcurrentDataInputStream((String)fullPath, (int)8192, (int)100);
            this.setQuadTree(DiskQuadTree.read((ICGGEDataInputStream)dataStream, new AreaGeomItem(-1, null)));
        }
        catch (IOException ioe) {
            throw new InitializationFailureException(ioe);
        }
        this.setQuadTreeDataStream(dataStream);
        if (AutoSuggestLog.getLog().isDebugEnabled()) {
            AutoSuggestLog.getLog().debug((Object)("Loaded quad tree for '" + fullPath + "'"));
        }
    }

    void loadSubstitutionSet(String path, String name) throws InitializationFailureException {
        String fullPath = FileUtilities.normalizePath((String)path);
        if (fullPath.endsWith(TYPEAHEAD_DICT_SUFFIX)) {
            File substitutionSetFile = new File(fullPath = fullPath.replace(TYPEAHEAD_DICT_SUFFIX, SUBSTITUTION_FILE_EXT));
            if (substitutionSetFile.exists() && substitutionSetFile.isFile()) {
                this.m_substitutionSetManager = new SubstitutionSetManager();
                try {
                    this.m_substitutionSetManager.read(fullPath);
                }
                catch (IOException ioe) {
                    throw new InitializationFailureException(ioe);
                }
            } else {
                AutoSuggestLog.getLog().info((Object)("Unable to load substitutions for data at " + fullPath));
            }
        } else if (AutoSuggestLog.getLog().isDebugEnabled()) {
            AutoSuggestLog.getLog().debug((Object)("Loading substitution - invalid filename with '" + fullPath + "'"));
        }
    }

    void setQuadTreeDataStream(ICGGEConcurrentDataInputStream dataStream) {
        this.m_quadTreeDataStream = dataStream;
    }

    public TokenStandardiser getTokenStandardiser() {
        return this.m_tokenStandardiser;
    }

    void setTokenStandiser(TokenStandardiser tokenStandardiser) {
        this.m_tokenStandardiser = tokenStandardiser;
    }

    public SearchResults search(SearchRequest req) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("search('" + req.getSearchkey() + "')");
        }
        return this.internalSearch(req, false);
    }

    SearchResults internalSearch(SearchRequest req, boolean doIncrementalSearch) throws SuggestFailureException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("internalSearch('" + req.getSearchkey() + "')");
        }
        RadixTreeMatchResult<AddressPtrMap> entries = null;
        AddressPtrFilter filter = this.makeAddressPtrFilter(req);
        if (filter != null) {
            NodeFilter<AddressPtrMap> nodeFilter = this.getTreeNodeFilter(req, filter);
            entries = this.searchRadixTree(req, doIncrementalSearch, nodeFilter);
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("internalSearch('" + req.getSearchkey() + "'): found [");
            if (entries != null) {
                for (IMatchResult<AddressPtrMap> iMatchResult : entries) {
                    sb.append(" ");
                    sb.append(iMatchResult);
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return entries == null ? null : new SearchResults(entries, req);
    }

    protected RadixTreeMatchResult<AddressPtrMap> searchRadixTree(SearchRequest req, boolean incrementalSearch, NodeFilter<AddressPtrMap> nodeFilter) {
        if (LOG.isDebugEnabled()) {
            if (incrementalSearch && req.getSearchKeyExtensions() != null) {
                LOG.debug(String.format("searchRadixTree('%s', %s, %s, %s)", req.getSearchkey(), Arrays.toString(req.getSearchKeyExtensions()), req.isMatchFully(), incrementalSearch));
            } else {
                LOG.debug(String.format("searchRadixTree('%s', %s, %s)", req.getSearchkey(), req.isMatchFully(), incrementalSearch));
            }
        }
        RadixTreeMatchResult<AddressPtrMap> results = super.searchRadixTree(req.getSearchkey(), req.getSearchKeyExtensions(), req.isMatchFully(), incrementalSearch, nodeFilter);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (incrementalSearch && req.getSearchKeyExtensions() != null) {
                sb.append(String.format("searchRadixTree('%s', %s, %s, %s)", req.getSearchkey(), Arrays.toString(req.getSearchKeyExtensions()), req.isMatchFully(), incrementalSearch));
            } else {
                sb.append(String.format("searchRadixTree('%s', %s, %s)", req.getSearchkey(), req.isMatchFully(), incrementalSearch));
            }
            sb.append(": found [");
            if (results != null) {
                for (IMatchResult<AddressPtrMap> iMatchResult : results) {
                    sb.append(" ");
                    sb.append(iMatchResult.getValue());
                }
                sb.append(" ] - [");
                for (IMatchResult<AddressPtrMap> iMatchResult : results.getMatchingEdgeNodes()) {
                    AddressPtrMap map = iMatchResult.getValue();
                    if (map == null) continue;
                    for (Map.Entry<Integer, List<AddressPtr>> entry : map.getEntrySet()) {
                        sb.append(" {");
                        sb.append(entry.getKey());
                        sb.append("}");
                        if (entry.getValue() == null) continue;
                        sb.append(Arrays.toString(entry.getValue().toArray()));
                    }
                }
            }
            sb.append(" ]");
            LOG.debug(sb.toString());
        }
        return results;
    }

    NodeFilter<AddressPtrMap> getTreeNodeFilter(SearchRequest req, AddressPtrFilter filter) {
        return new NodeFilter<AddressPtrMap>(req.getKeyFilter(), filter);
    }

    public SearchResults doIncrementalWordSearch(SearchRequest req) throws SuggestFailureException {
        return this.internalSearch(req, true);
    }

    AddressPtrFilter makeAddressPtrFilter(SearchRequest req) throws SuggestFailureException {
        Rectangle searchBounds = this.getSearchBounds(req);
        List<AddressPtr> allowedAddrIDs = null;
        SearchAreas allowedAreas = null;
        if (req.doFilterWithinBounds()) {
            int area;
            allowedAreas = req.getSearchAreas();
            if (allowedAreas == null || allowedAreas.size() == 0) {
                allowedAreas = this.getSearchAreas(searchBounds, req.getSearchPoint());
            }
            if (allowedAreas != null && allowedAreas.size() > 0 && (area = GeomUtil.area(searchBounds)) <= 10000) {
                allowedAddrIDs = this.getAllowedAddrPtrs(searchBounds, allowedAreas);
            }
            if (allowedAreas.size() == 0 && allowedAddrIDs == null) {
                return null;
            }
        }
        if (allowedAddrIDs != null) {
            SearchRequest reqCopy = new SearchRequest(req);
            if (allowedAddrIDs != null) {
                reqCopy.appendAllowedAddressPtrList(allowedAddrIDs);
            }
            req = reqCopy;
        }
        return new AddressPtrFilter(req, allowedAreas);
    }

    private Rectangle getSearchBounds(SearchRequest req) {
        Rectangle searchBounds = req.getSearchBounds();
        if (searchBounds == null && req.getSearchPoint() != null) {
            searchBounds = this.getExtent();
        }
        return searchBounds;
    }

    private List<AddressPtr> getAllowedAddrPtrs(Rectangle searchBounds, SearchAreas areas) throws SuggestFailureException {
        List allowedAddrPtrs = null;
        if (areas != null) {
            for (AreaGeomItem area : areas) {
                AddressPtr addrPtr = this.filterAddressesInBounds(area, searchBounds);
                if (addrPtr == null) continue;
                allowedAddrPtrs = ListUtils.addToList(allowedAddrPtrs, (Object)addrPtr);
            }
        }
        return allowedAddrPtrs;
    }

    private AddressPtr filterAddressesInBounds(AreaGeomItem areaItem, Rectangle searchBounds) throws SuggestFailureException {
        List<AddressGeomItem> addrGeomList = this.readAddressGeomItems(areaItem);
        boolean added = false;
        AddressPtr addrPtr = null;
        if (addrGeomList != null) {
            addrPtr = new AddressPtr(areaItem.getAreaID());
            for (AddressGeomItem addrGeomItem : addrGeomList) {
                if (!searchBounds.intersects(addrGeomItem.getBounds())) continue;
                addrPtr.addAddressID(addrGeomItem.getID());
                added = true;
            }
        }
        return added ? addrPtr : null;
    }

    private List<AddressGeomItem> readAddressGeomItems(AreaGeomItem areaItem) throws SuggestFailureException {
        ICGGEConcurrentDataInputStream stream = this.m_quadTreeDataStream.duplicate();
        List<AddressGeomItem> addressGeomItems = null;
        try {
            addressGeomItems = areaItem.readAddressItemsAtOffset((ICGGEDataInputStream)stream);
        }
        catch (IOException ioe) {
            throw new SuggestFailureException(ioe);
        }
        return addressGeomItems;
    }

    public SearchAreas getSearchAreas(Rectangle searchBounds, double[] location) {
        SearchAreas areas = new SearchAreas(location);
        this.getQuadTree().findValues(searchBounds, location, areas);
        return areas;
    }

    SearchResults makeResultCopyForRequest(SearchRequest req, SearchResults copyFromResults) throws SuggestFailureException {
        AddressPtrFilter valueFilter = this.makeAddressPtrFilter(req);
        return copyFromResults.copyWithNewRequestAndFilter(req, valueFilter);
    }

    public Iterator<SimpleAddress> getAddressIterator(SearchResult sr, IAddressFilter addrFilter) {
        return this.getAddressIterator(sr, addrFilter, -1);
    }

    public Iterator<SimpleAddress> getAddressIterator(SearchResult sr, IAddressFilter addrFilter, int max) {
        return this.makeSearchResultAddressItr(sr, addrFilter, max);
    }

    Iterator<SimpleAddress> makeSearchResultAddressItr(SearchResult sr, IAddressFilter addrFilter, int max) {
        return new SearchResultAddressIterator(sr, addrFilter, this.getDataSetReader(), max);
    }

    public AddressMetaData getAddressMetaData() {
        return this.getDataSetReader().getMetaData();
    }

    public List<Integer> getAddressFields() {
        ArrayList<Integer> fieldIDs = new ArrayList<Integer>(this.getRadixTreeMetaData().getFieldIDs());
        Collections.sort(fieldIDs);
        return fieldIDs;
    }

    public String getFieldName(int fieldID) {
        return this.getRadixTreeMetaData().getFieldName(fieldID);
    }

    public int getDataSetType() {
        return this.getRadixTreeMetaData().getDataType();
    }

    public SubstitutionSetManager getSubstitutionSetManager() {
        return this.m_substitutionSetManager;
    }

    public int hashCode() {
        int result = 31;
        if (this.m_metaData != null) {
            result = 31 * result + this.m_metaData.hashCode();
        }
        if (this.m_quadTree != null) {
            result = 31 * result + this.m_quadTree.hashCode();
        }
        if (this.m_radixTree != null) {
            result = 31 * result + this.m_radixTree.hashCode();
        }
        return result;
    }

    public CategoryInfoManager getCategoryInfoManager() {
        return this.m_categoryInfoManager;
    }

    public boolean isCustomData() {
        return this.m_metaData.isCustomData();
    }

    public List<SimpleAddress> doPointBoundsSearch(DirectPosition origin, double radius, int maxResults) throws SuggestFailureException {
        ArrayList<SimpleAddress> results = new ArrayList<SimpleAddress>();
        TreeMap sortedAddrData = new TreeMap();
        if (radius <= 0.0 || radius >= 2.003758E7) {
            radius = 2.003758E7;
        }
        int currentMaxDist = new Double(radius).intValue();
        int currentRadius = 500;
        double[] location = new double[]{origin.getX(), origin.getY()};
        Rectangle bounds = new Rectangle(location, location);
        HashSet<Integer> staleAreas = new HashSet<Integer>();
        do {
            bounds.buffer(GeomUtil.calcDeltaLongLatDegrees(currentRadius *= 2, IAutoSuggestConstraints.DistanceUnits.METERS, origin));
            for (AreaGeomItem area : this.getSearchAreas(bounds, location)) {
                if (staleAreas.contains(area.getAreaID())) continue;
                staleAreas.add(area.getAreaID());
                for (AddressGeomItem addr : this.readAddressGeomItems(area)) {
                    int dist = addr.getBounds().distancesFromPoint(location).getStart();
                    if (dist > currentMaxDist) continue;
                    Integer[] ids = new Integer[]{area.getAreaID(), addr.getID()};
                    if (sortedAddrData.containsKey(dist)) {
                        ((List)sortedAddrData.get(dist)).add(ids);
                    } else {
                        ArrayList<Integer[]> container = new ArrayList<Integer[]>();
                        container.add(ids);
                        sortedAddrData.put(dist, container);
                    }
                    if (sortedAddrData.size() <= maxResults) continue;
                    sortedAddrData.remove(sortedAddrData.lastKey());
                    currentMaxDist = (Integer)sortedAddrData.lastKey();
                }
            }
        } while (sortedAddrData.size() < maxResults && (double)currentRadius <= radius);
        int resultCount = 0;
        for (Integer distKey : sortedAddrData.keySet()) {
            for (Integer[] idPair : (List)sortedAddrData.get(distKey)) {
                SimpleAddress addr = null;
                try {
                    addr = this.m_dataSetReader.getAddress(idPair[0], idPair[1], null);
                }
                catch (IOException ioe) {
                    StringBuilder message = new StringBuilder();
                    message.append("Failed to read address: areaID: ").append(idPair[0]);
                    message.append(", addressID: ").append(idPair[1]);
                    throw new SuggestFailureException(message.toString(), ioe);
                }
                addr.setDistance(distKey.intValue());
                if (this.m_categoryInfoManager != null) {
                    this.m_categoryInfoManager.setCategoryFieldsInAddress(addr);
                }
                results.add(addr);
                ++resultCount;
            }
            if (resultCount < maxResults) continue;
            break;
        }
        return results;
    }

    @Override
    protected RadixTree<AddressPtrMap> getRadixTree() {
        return this.m_radixTree;
    }

    @Override
    protected NodeFilter<AddressPtrMap> makeEmptyValueNodeFilter(NodeFilter<AddressPtrMap> nodeFilter) {
        return new NodeFilter<AddressPtrMap>(nodeFilter.getKeyFilter(), new EmptyValueFilter());
    }

    private static final class EmptyValueFilter
    implements INodeValueFilter<AddressPtrMap>,
    IAddressPtrMapReadingFilter {
        private EmptyValueFilter() {
        }

        @Override
        public IAreaIDReadingFilter getAddressIDReadingFilter(int fieldID) {
            return null;
        }

        @Override
        public AddressPtrMap filter(AddressPtrMap v) {
            return null;
        }
    }
}

