/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.WeightedInternalResultFetcher;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.AppendableIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class BandedInternalResultFetcher
extends AppendableIterator<AddressSearchInternalResult> {
    static final int[] DEFAULT_SEARCH_BANDS = new int[]{5000, 10000, 25000, 50000};
    static final int SEARCH_DISTANCE_INCREMENT = 100000;
    private static final int MIN_INITIAL_SEARCH_DISTANCE = 1;
    private int m_minDistance = 0;
    private int m_maxDistance = 0;
    private int m_optimalMaxDistance = 0;
    private SearchAreas m_searchAreas;
    private SearchAreas m_currentSearchArea;
    private int m_currentSearchBandNdx = 0;
    private Iterable<AddressSearchInternalResult> m_savedResults;
    private boolean m_fetchInBands;

    BandedInternalResultFetcher(Iterable<AddressSearchInternalResult> searchResults, SearchAreas searchAreas, boolean fetchInBands) {
        super(searchResults);
        this.m_searchAreas = searchAreas;
        this.m_savedResults = searchResults;
        this.m_fetchInBands = fetchInBands;
        this.setInitialMinimumStartDistance(searchAreas);
    }

    private void setInitialMinimumStartDistance(SearchAreas searchAreas) {
        this.m_minDistance = 0;
        if (searchAreas != null) {
            this.m_maxDistance = this.m_fetchInBands ? searchAreas.minimumDistance() : searchAreas.maximumDistance();
        }
    }

    private boolean setNextSearchBandArea() {
        this.setMark();
        boolean areaAvailable = true;
        if (this.m_fetchInBands && this.m_searchAreas != null) {
            do {
                int newMaxDistance = this.getNextMaximumDistance();
                this.increamentDistanceBand(newMaxDistance);
                int minDistance = this.getMinimumDistance();
                if (minDistance < newMaxDistance) {
                    SearchAreas subAreas = this.m_searchAreas.subSet(minDistance, newMaxDistance);
                    if (subAreas != null) {
                        this.setSearchAreasForResults(subAreas);
                        areaAvailable = true;
                        continue;
                    }
                    areaAvailable = false;
                    continue;
                }
                return false;
            } while (!areaAvailable);
            if (this.moreBandsAvailable()) {
                this.add(this.m_savedResults);
            }
        }
        return true;
    }

    private boolean moreBandsAvailable() {
        return this.m_maxDistance < this.m_searchAreas.maximumDistance();
    }

    protected int getNextMaximumDistance() {
        int currMax;
        int max = currMax = this.getMaximumDistance();
        max = this.m_currentSearchBandNdx < DEFAULT_SEARCH_BANDS.length ? (max += DEFAULT_SEARCH_BANDS[this.m_currentSearchBandNdx++]) : (this.m_searchAreas.minimumDistance() < 100000 ? (max += this.getMinimumDistance()) : (max += 100000));
        if (this.m_searchAreas != null) {
            max = this.m_searchAreas.minimumDistance() == this.m_searchAreas.maximumDistance() ? Math.min(max, this.m_searchAreas.maximumDistance() + 1) : Math.min(max, this.m_searchAreas.maximumDistance());
        }
        if (this.m_optimalMaxDistance > 0 && this.m_optimalMaxDistance < max) {
            max = this.m_optimalMaxDistance;
        }
        return max;
    }

    private void setSearchAreasForResults(final SearchAreas searchAreas) {
        this.m_currentSearchArea = searchAreas;
        Iterator<Object> internalItems = this.getInternalItemIterator();
        if (internalItems != null) {
            IAreaIDReadingFilter subAreaFilter = new IAreaIDReadingFilter(){
                final SearchAreas subAreas;
                {
                    this.subAreas = searchAreas;
                }

                @Override
                public boolean readArea(int areaID) {
                    return this.subAreas != null && this.subAreas.containsArea(areaID);
                }
            };
            List<IAreaIDReadingFilter> areaFilters = Arrays.asList(subAreaFilter);
            while (internalItems.hasNext()) {
                Object internalItem = internalItems.next();
                if (!(internalItem instanceof WeightedInternalResultFetcher)) continue;
                ((WeightedInternalResultFetcher)internalItem).setAreaFilters(areaFilters);
            }
        }
    }

    protected void increamentDistanceBand(int max) {
        this.m_minDistance = this.m_maxDistance;
        this.m_maxDistance = max;
    }

    int getMinimumDistance() {
        return this.m_minDistance;
    }

    int getMaximumDistance() {
        return this.m_maxDistance;
    }

    SearchAreas getCurrentSearchAreas() {
        return this.m_currentSearchArea;
    }

    void setOptimalMaxDistance(int max) {
        if (max < -1) {
            throw new IllegalArgumentException();
        }
        if (this.m_optimalMaxDistance == 0 || max < this.m_optimalMaxDistance) {
            this.m_optimalMaxDistance = max;
        }
    }

    int getOptimalMaxDistance() {
        return this.m_optimalMaxDistance;
    }

    @Override
    protected Object nextMainItem() {
        if (!this.isNextItemBeforeMarker() && !this.setNextSearchBandArea()) {
            return null;
        }
        return super.nextMainItem();
    }

    @Override
    protected boolean isIterable(Object item) {
        return !(item instanceof AddressSearchInternalResult);
    }

    @Override
    protected boolean isIterator(Object item) {
        return !(item instanceof AddressSearchInternalResult);
    }
}

