/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import java.util.List;

public class FieldValueMatcher {
    private final String fieldValueToMatch;
    private final boolean matchFull;
    private final int fieldIDtoMatch;

    FieldValueMatcher(String valueToMatch, int fieldToMatch, boolean matchFull) {
        this.fieldIDtoMatch = fieldToMatch;
        this.fieldValueToMatch = valueToMatch;
        this.matchFull = matchFull;
    }

    public boolean match(InternalSimpleAddress addrObj) {
        List<String> values = addrObj.getField(this.fieldIDtoMatch);
        if (values != null) {
            for (String value : values) {
                if (!this.match(value)) continue;
                return true;
            }
        }
        return false;
    }

    public int matchValueNdx(InternalSimpleAddress addrObj) {
        List<String> values = addrObj.getField(this.fieldIDtoMatch);
        if (values != null) {
            int c = values.size();
            for (int valueNdx = 0; valueNdx < c; ++valueNdx) {
                if (!this.match(values.get(valueNdx))) continue;
                return valueNdx;
            }
        }
        return -1;
    }

    private boolean match(String value) {
        if (this.matchFull) {
            return StringNormalizer.normalise(value).equalsIgnoreCase(StringNormalizer.normalise(this.fieldValueToMatch));
        }
        boolean flag = StringNormalizer.normalise(value).toUpperCase().startsWith(StringNormalizer.normalise(this.fieldValueToMatch).toUpperCase());
        if (!flag) {
            String[] fieldToMatchArray = StringNormalizer.normalise(this.fieldValueToMatch).toUpperCase().split(" ");
            String[] valueArray = StringNormalizer.normalise(value).toUpperCase().split(" ");
            int matcheditems = 0;
            int numberofWholeWordsMatched = 0;
            if (fieldToMatchArray.length == valueArray.length) {
                for (int i = 0; i < valueArray.length; ++i) {
                    if (!valueArray[i].startsWith(fieldToMatchArray[i]) && !fieldToMatchArray[i].startsWith(valueArray[i])) continue;
                    ++matcheditems;
                    if (!valueArray[i].equalsIgnoreCase(fieldToMatchArray[i])) continue;
                    ++numberofWholeWordsMatched;
                }
            }
            if (matcheditems == fieldToMatchArray.length && numberofWholeWordsMatched > 0) {
                flag = true;
            }
        }
        return flag;
    }

    public int getMatchFieldID() {
        return this.fieldIDtoMatch;
    }

    public String getMatchString() {
        return this.fieldValueToMatch;
    }
}

