/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressFieldPrefixMatcher;
import com.mapinfo.mapmarker.autosuggest.AddressSearchHandler;
import com.mapinfo.mapmarker.autosuggest.AddressSearchInternalResult;
import com.mapinfo.mapmarker.autosuggest.FieldMatchInfo;
import com.mapinfo.mapmarker.autosuggest.IAddressFilter;
import com.mapinfo.mapmarker.autosuggest.SearchInput;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressUtil;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryInfoManager;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.cgge.utils.RomanNumeral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MatchedAddressIterator
extends ReadOnlyIterator<SimpleAddress> {
    private static final Logger LOG = LoggerFactory.getLogger((String)MatchedAddressIterator.class.getName());
    private final Iterator<SimpleAddress> m_internalItr;
    private final AddressSearchInternalResult m_addrSearchIntRes;
    private final int m_max;
    private int m_fetched;
    private SimpleAddress m_next;
    private final AddressFieldPrefixMatcher m_addrFieldPrefixMatcher;
    private final IAddressFilter m_addrFilter;
    private SimpleAddress m_lastAddress;
    private String m_searchString;
    private CategoryInfoManager m_categoryManager;

    MatchedAddressIterator(Iterator<SimpleAddress> addrItr, AddressSearchInternalResult addrSearchIntRes, IAddressFilter addrFilter, int maxRequired, AddressFieldPrefixMatcher addrFieldPrefixMatcher, String searchString, CategoryInfoManager catInfoManager) {
        this.m_internalItr = addrItr;
        this.m_addrSearchIntRes = addrSearchIntRes;
        this.m_max = maxRequired;
        this.m_addrFieldPrefixMatcher = addrFieldPrefixMatcher;
        this.m_addrFilter = addrFilter;
        this.m_searchString = searchString;
        this.m_categoryManager = catInfoManager;
        this.init();
    }

    void init() {
        this.m_next = this.getNext();
    }

    int getMax() {
        return this.m_max;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public SimpleAddress next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SimpleAddress curr = this.m_next;
        this.m_next = this.getNext();
        return curr;
    }

    private SimpleAddress getNext() {
        SimpleAddress addr = null;
        Iterator<SimpleAddress> internalIt = this.getInternalIterator();
        if (this.canGetMore(internalIt)) {
            while (internalIt.hasNext()) {
                addr = internalIt.next();
                if ((addr = this.updateAddress(addr)) == null) continue;
                ++this.m_fetched;
                break;
            }
        }
        return addr;
    }

    private boolean canGetMore(Iterator<SimpleAddress> it) {
        if (it.hasNext()) {
            int max = this.getMax();
            return max > -1 ? this.m_fetched < max : true;
        }
        return false;
    }

    SimpleAddress updateAddress(SimpleAddress addr) {
        int matchedField;
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateAddress(" + addr + ")");
        }
        IAddressFilter addrFilter = this.getAddressFilter();
        AddressMetaData metaData = addrFilter.getAddressMetaData();
        boolean groupAreaRecords = addrFilter.groupAreaRecords();
        AddressSearchInternalResult addrSearchIntRes = this.getAddressSearchInternalResult();
        CategoryInfoManager catInfoManager = this.getCategoryInfoManager();
        if (catInfoManager != null) {
            catInfoManager.setCategoryFieldsInAddress(addr);
        }
        if (addrSearchIntRes.isPsuedoResult() && (matchedField = this.checkAndUpdateWithPrefixMatch(addr, addrSearchIntRes)) < 0) {
            return null;
        }
        addr.addFieldMatchInfos(this.processFieldMatchInfos(addr, addrSearchIntRes));
        addr.setStreetFormatFields(metaData.getStreetFormatFields());
        addr.setLastlineFormatFields(metaData.getLastlineFormatFields());
        addr.setStreetFormatFieldsPattern(metaData.getStreetFormatPattern());
        addr.setLastlineFormatFieldsPattern(metaData.getLastLinetFormatPattern());
        addr.setMatchScore(addrSearchIntRes.getMatchWeight());
        if (groupAreaRecords) {
            if (null == (addr = this.groupAreaCands(addr, metaData)) || addr.getFields().isEmpty()) {
                return null;
            }
        } else {
            String hnr = addrFilter.getHNRString();
            if (hnr != null && addr.hnrMatched()) {
                if (AddressUtil.isExtendedHnr(hnr) && !AddressUtil.possibleExtendedHNRMatch(addr.getFirstRange(), hnr)) {
                    return null;
                }
                addr.setHNR(hnr);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateAddress(" + addr + "): done");
        }
        return addr;
    }

    int checkAndUpdateWithPrefixMatch(SimpleAddress addr, AddressSearchInternalResult addrSearchIntresult) {
        FieldMatchInfo fieldMatchInfo;
        int matchedField = -1;
        if (addrSearchIntresult.isPsuedoResult() && (fieldMatchInfo = this.getAddressPrefixMatcher().getMatchedFieldInfo(addr, addrSearchIntresult.getPreviousResult().getSearchWordEnd())) != null) {
            addr.addFieldMatchInfo(fieldMatchInfo);
            return fieldMatchInfo.getFieldID();
        }
        return matchedField;
    }

    IAddressFilter getAddressFilter() {
        return this.m_addrFilter;
    }

    AddressSearchInternalResult getAddressSearchInternalResult() {
        return this.m_addrSearchIntRes;
    }

    AddressFieldPrefixMatcher getAddressPrefixMatcher() {
        return this.m_addrFieldPrefixMatcher;
    }

    String getSearchString() {
        return this.m_searchString;
    }

    Iterator<SimpleAddress> getInternalIterator() {
        return this.m_internalItr;
    }

    private String getSearchedChars(AddressSearchInternalResult result, String mainSearchStr, int searchStart) {
        SearchInput searchInput = result.getSearchInput();
        String searchFullString = "";
        searchFullString = searchInput.isMainFieldInput() ? mainSearchStr : searchInput.getStdString();
        int searchLen = searchFullString.length();
        if (searchStart < searchLen) {
            int matchEnd = result.getSearchWordEnd();
            if (searchInput != null && searchInput.getLastWordAlts() != null && searchInput.getLastWordAlts().length > 0) {
                String[] altArray = result.getSearchInput().getLastWordAlts();
                for (int i = 0; i < altArray.length; ++i) {
                    if (10 != RomanNumeral.getNumber((String)altArray[i])) continue;
                    matchEnd = searchLen;
                }
            }
            return searchFullString.substring(searchStart, matchEnd > searchLen ? searchLen : matchEnd).trim();
        }
        return "";
    }

    List<FieldMatchInfo> processFieldMatchInfos(SimpleAddress addr, AddressSearchInternalResult AddressSearchInternalResult2) {
        AddressFieldPrefixMatcher addrFieldPrefixMatcher = this.getAddressPrefixMatcher();
        ArrayList<FieldMatchInfo> fieldMatchInfos = new ArrayList<FieldMatchInfo>(5);
        AddressSearchInternalResult currResult = AddressSearchInternalResult2.isPsuedoResult() ? AddressSearchInternalResult2.getPreviousResult() : AddressSearchInternalResult2;
        boolean last = true;
        String searchStr = this.getSearchString();
        while (currResult != null) {
            AddressSearchInternalResult prevResult = currResult.getPreviousResult();
            SearchInput searchInput = currResult.getSearchInput();
            int matchStart = AddressSearchHandler.calculateLastSearchWordEnd(prevResult, searchInput);
            String searchChars = this.getSearchedChars(currResult, searchStr, matchStart);
            String matchedChars = currResult.getMatchedString();
            int matchedValueNdx = this.getMatchingFieldValueIndex(addr, currResult.getMatchedFieldType(), matchedChars == null ? searchChars : matchedChars, !last, addrFieldPrefixMatcher);
            boolean isHnrField = currResult.getMatchedFieldType() == 4;
            boolean hasHnrMatch = false;
            if (isHnrField) {
                SimpleRange range;
                boolean rangeMatched = false;
                Iterator<SimpleRange> iterator = addr.getRanges().iterator();
                while (iterator.hasNext() && !(rangeMatched = (range = iterator.next()).isInputNumberMatched())) {
                }
                boolean bl = hasHnrMatch = searchChars.equals(addr.getHNR()) || rangeMatched;
            }
            if (!isHnrField || hasHnrMatch) {
                FieldMatchInfo fieldMatchInfo = new FieldMatchInfo(currResult.getMatchedFieldType(), searchInput.getInputField(), searchChars, matchStart, matchedValueNdx);
                fieldMatchInfos.add(fieldMatchInfo);
                addr.setLowestMatchedFieldInAddrHierarchy(currResult.getMatchedFieldType());
            }
            currResult = prevResult;
            last = false;
        }
        return fieldMatchInfos;
    }

    private int getMatchingFieldValueIndex(SimpleAddress addr, int matchField, String prefixChars, boolean matchFully, AddressFieldPrefixMatcher addrFieldPrefixMatcher) {
        List<String> fieldValues = addr.getField(matchField);
        int ndx = 0;
        if (fieldValues != null && fieldValues.size() > 1) {
            ndx = addrFieldPrefixMatcher.getMatchingPrefixFieldNdx(fieldValues, prefixChars, matchFully);
        }
        return ndx;
    }

    private SimpleAddress groupAreaCands(SimpleAddress addr, AddressMetaData metaData) {
        Map<Integer, List<String>> fields = addr.getFields();
        Iterator<Map.Entry<Integer, List<String>>> fieldIT = fields.entrySet().iterator();
        while (fieldIT.hasNext()) {
            if (metaData.isAreaField(fieldIT.next().getKey())) continue;
            fieldIT.remove();
        }
        if (addr.getHNR() != null) {
            addr.setHNR(null);
        }
        List<Integer> areaNamePriorityList = metaData.getAreaFieldPriorityList();
        for (Integer fieldID : areaNamePriorityList) {
            if (addr.matchedOnField(fieldID)) break;
            fields.remove(fieldID);
        }
        if (this.m_lastAddress != null && this.m_lastAddress.hasSameAddressFields(addr)) {
            addr = null;
        } else {
            this.m_lastAddress = addr;
        }
        if (addr != null) {
            addr.setIsAreaAddressGroup(true);
            addr.setRanges(null);
        }
        return addr;
    }

    void setCategoryInfoManager(CategoryInfoManager catManager) {
        this.m_categoryManager = catManager;
    }

    CategoryInfoManager getCategoryInfoManager() {
        return this.m_categoryManager;
    }
}

