/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressListMatcher;
import com.mapinfo.mapmarker.autosuggest.UnitFilter;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressUtil;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeFilter {
    private int m_hnr;
    private boolean m_acceptOnlyHNRInRange = true;
    private boolean matchOnField = false;
    private UnitFilter unitFilter;
    private final AddressListMatcher addrListMatcher;
    private final AddressMetaData addressMetaData;

    public RangeFilter(int fieldID, String word, int hnr, AddressMetaData addressMetaData) {
        this.addrListMatcher = new AddressListMatcher(fieldID, word);
        this.m_hnr = hnr;
        this.m_acceptOnlyHNRInRange = this.hasInputHnr();
        this.addressMetaData = addressMetaData;
        this.setValueMatcherAndUnitFilter(fieldID);
    }

    void setValueMatcherAndUnitFilter(int fieldID) {
        this.matchOnField = false;
        FieldType.FieldLevel fl = this.addressMetaData.getLevel(fieldID);
        if (fl == FieldType.FieldLevel.LEVEL_RANGE) {
            this.matchOnField = true;
        } else if (fl == FieldType.FieldLevel.LEVEL_UNIT) {
            this.matchOnField = true;
            this.unitFilter = new UnitFilter(this.addrListMatcher.getMatchFieldID(), this.addrListMatcher.getMatchString());
        }
    }

    public void setUnitFilter(UnitFilter filter) {
        this.unitFilter = filter;
    }

    public void setMustMatchOnRangeField(boolean b) {
        this.matchOnField = b;
    }

    public boolean isMustMatchOnRangeField() {
        return this.matchOnField;
    }

    public boolean isAcceptOnlyHNRInRange() {
        return this.m_acceptOnlyHNRInRange;
    }

    public void setAcceptonlyHNRInRange(boolean accept) {
        this.m_acceptOnlyHNRInRange = accept;
    }

    public int getHNR() {
        return this.m_hnr;
    }

    public int getFieldID() {
        return this.addrListMatcher.getMatchFieldID();
    }

    public String getWord() {
        return this.addrListMatcher.getMatchString();
    }

    public boolean acceptRange(int hnrOffset) {
        if (this.hasInputHnr()) {
            return this.m_acceptOnlyHNRInRange ? hnrOffset == 0 : hnrOffset > -1;
        }
        return true;
    }

    public boolean hasInputHnr() {
        return this.m_hnr > -1;
    }

    public List<SimpleRange> getMatchingRanges(SimpleStreetAddress addr) {
        List<InternalSimpleAddress> matchedRanges = Collections.emptyList();
        if (this.matchOnField) {
            if (this.unitFilter != null) {
                matchedRanges = this.filterRangesForUnitMatch(addr);
            } else if (this.addrListMatcher.doesItemMatchedInList(addr.getRanges())) {
                matchedRanges = addr.getSubList(addr.getRanges(), this.addrListMatcher.getMatchedItemIndexes());
            }
            for (SimpleRange matchedRange : matchedRanges) {
                matchedRange.setMatchedOnRangeField(true);
            }
        }
        return matchedRanges;
    }

    List<SimpleRange> filterRangesForUnitMatch(SimpleStreetAddress addr) {
        if (this.unitFilter != null) {
            int rangeCount = addr.getRangeCount();
            ArrayList<SimpleRange> matchedRanges = new ArrayList<SimpleRange>();
            for (int rangeNdx = 0; rangeNdx < rangeCount; ++rangeNdx) {
                SimpleRange range = addr.getRangeAt(rangeNdx);
                if (!this.unitFilter.doesItemMatchedInList(range.getUnits())) continue;
                range.setUnits(range.getSubList(range.getUnits(), this.unitFilter.getMatchedItemIndexes()));
                matchedRanges.add(range);
            }
            return matchedRanges;
        }
        return Collections.emptyList();
    }

    public List<SimpleRange> getMatchingRange(SimpleStreetAddress addr) {
        List<SimpleRange> ranges;
        List<SimpleRange> list = ranges = this.matchOnField ? this.getMatchingRanges(addr) : addr.getRanges();
        if (this.hasInputHnr() && ranges != null) {
            return this.getClosestRange(ranges);
        }
        return ranges;
    }

    private List<SimpleRange> getClosestRange(List<SimpleRange> ranges) {
        int closestOffset = Integer.MAX_VALUE;
        int hnr = this.getHNR();
        ArrayList<SimpleRange> closestRanges = new ArrayList<SimpleRange>();
        for (SimpleRange range : ranges) {
            int offset = this.getHNROffset(range, hnr);
            if (!this.acceptRange(offset)) continue;
            if (offset < closestOffset) {
                closestOffset = offset;
                closestRanges.clear();
                closestRanges.add(range);
            } else if (offset == closestOffset) {
                closestRanges.add(range);
            }
            if (offset != 0) continue;
            range.setInputNumberMatched(true);
        }
        return closestRanges;
    }

    private int getHNROffset(SimpleRange range, int hnr) {
        if (this.matchRangeType(range, hnr)) {
            return AddressUtil.getHNROffset(range, hnr);
        }
        return -1;
    }

    private boolean matchRangeType(SimpleRange range, int hnr) {
        boolean inputIsEven;
        int rangeType = range.getOddEvenType();
        if (rangeType == 0) {
            return true;
        }
        boolean bl = inputIsEven = hnr % 2 == 0;
        return inputIsEven ? rangeType == 2 : rangeType == 1;
    }
}

