/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.InputAddress;
import com.mapinfo.mapmarker.autosuggest.SearchAreas;
import com.mapinfo.mapmarker.autosuggest.SearchResults;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SearchInput {
    static final String WORD_DELIM = " ";
    private final InputInfo m_inputInfo;
    private final int m_offset;
    private String m_searchString;
    private final boolean m_stdVersion;
    private List<NumberRange> m_stdWordPositions;
    private boolean m_lastWordAlt = false;

    private SearchInput(SearchInput copyFrom, int offset, boolean stdVersion) {
        this.m_inputInfo = copyFrom.m_inputInfo;
        this.m_stdVersion = stdVersion;
        this.m_offset = offset;
        this.m_searchString = copyFrom.m_searchString;
        this.m_stdWordPositions = copyFrom.m_stdWordPositions;
    }

    SearchInput(SearchInput copyFrom) {
        this(copyFrom, copyFrom.m_offset, copyFrom.m_stdVersion);
    }

    SearchInput(String orginalInputStr, String inputStr, List<String> stdWords, String[] lastWordAlts, boolean inputShortened) {
        List<String> inputWords = Arrays.asList(inputStr.split(WORD_DELIM));
        if (stdWords == null) {
            stdWords = Collections.emptyList();
        }
        this.m_stdVersion = true;
        this.m_offset = 0;
        this.buildStdSearchString(inputWords, stdWords);
        this.m_inputInfo = new InputInfo(orginalInputStr, inputStr, this.m_searchString, inputWords, stdWords, lastWordAlts, inputShortened);
    }

    SearchInput(String inputString, String searchString, List<String> stdWords, String[] lastWordAlts) {
        this(inputString, searchString, stdWords, lastWordAlts, false);
    }

    SearchInput getSubInput(int from) {
        if (from < 0 || from >= this.m_searchString.length()) {
            throw new IndexOutOfBoundsException("start outside the range");
        }
        SearchInput subInput = new SearchInput(this, this.m_offset + from, this.m_stdVersion);
        subInput.updateCurrentSearch(from, -1);
        return subInput;
    }

    SearchInput getStdVersion() {
        if (this.m_stdVersion) {
            return this;
        }
        List<String> stdWords = this.m_inputInfo.getStdWords();
        List<String> inputWords = this.m_inputInfo.getInputWords();
        int wordNdx = this.getWordNdx(this.m_offset, inputWords, stdWords);
        int numSkipWordChars = 0;
        String inputStr = this.m_inputInfo.getInputStr();
        if (!this.isCharAtWordBegining(inputStr, this.m_offset)) {
            if (stdWords.get(wordNdx) != null) {
                return null;
            }
            numSkipWordChars = wordNdx == 0 ? this.m_offset : this.m_offset - inputStr.lastIndexOf(WORD_DELIM, this.m_offset) - 1;
        }
        int stdFrom = this.calculateStdLenUptoWord(wordNdx, stdWords, inputWords) + numSkipWordChars;
        SearchInput stdInput = new SearchInput(this, stdFrom, true);
        stdInput.m_searchString = this.m_inputInfo.m_stdString;
        stdInput.updateCurrentSearch(stdFrom, -1);
        return stdInput;
    }

    SearchInput getPartialStdVersion(int numWordsToStandarise) {
        if (numWordsToStandarise < 0) {
            throw new IllegalArgumentException("numWordsToStandarise cannot be less than 0");
        }
        if (this.m_stdVersion) {
            SearchInput searchInput = new SearchInput(this.m_inputInfo.getOriginalInputStr(), this.m_inputInfo.getInputStr(), new ArrayList<String>(this.m_inputInfo.getStdWords()), this.m_inputInfo.getLastWordAlts());
            searchInput.m_inputInfo.m_resultMap = this.m_inputInfo.m_resultMap;
            searchInput.setSearchAreas(this.getSearchAreas());
            searchInput = searchInput.getSubInput(this.m_offset);
            searchInput.resetStdWords(numWordsToStandarise);
            return searchInput;
        }
        return null;
    }

    private void resetStdWords(int keep) {
        int nStdWords = this.getNumberOfStdWords();
        List<String> inputWords = this.m_inputInfo.getInputWords();
        if (nStdWords > keep) {
            List<NumberRange> stdWordPos = this.m_stdWordPositions;
            int charNdx = stdWordPos.get(keep).getStart();
            List<String> stdWords = this.m_inputInfo.getStdWords();
            int wordCount = inputWords.size();
            StringBuilder sb = new StringBuilder(this.m_searchString);
            sb.delete(charNdx, sb.length());
            for (int wordNdx = this.getWordNdx(this.m_offset + charNdx, inputWords, this.m_inputInfo.getStdWords()); wordNdx < wordCount; ++wordNdx) {
                sb.append(inputWords.get(wordNdx));
                sb.append(WORD_DELIM);
                stdWords.set(wordNdx, null);
            }
            sb.deleteCharAt(sb.length() - 1);
            this.m_searchString = sb.toString();
            this.m_stdWordPositions = stdWordPos.subList(0, keep);
        }
    }

    SearchInput getNonStdVersion() {
        if (this.m_stdVersion && this.hasStandardisedWords()) {
            int subOffset = this.getInputStrOffset(this.m_offset);
            SearchInput subInput = new SearchInput(this, subOffset, false);
            subInput.updateCurrentSearch(subOffset, -1);
            return subInput;
        }
        return null;
    }

    List<SearchInput> getLastWordAltSearchInputs() {
        SearchInput searchInput = this;
        List<SearchInput> lastWordSearchInputs = Collections.emptyList();
        if (searchInput.isOnLastWord()) {
            int altCount;
            String[] alts = this.m_inputInfo.getLastWordAlts();
            int n = altCount = alts == null ? 0 : alts.length;
            if (altCount > 0) {
                lastWordSearchInputs = new ArrayList<SearchInput>(altCount);
                for (String altWord : alts) {
                    SearchInput altSearchInput = new SearchInput(searchInput, searchInput.m_offset, true);
                    altSearchInput.m_searchString = altWord;
                    altSearchInput.m_lastWordAlt = true;
                    lastWordSearchInputs.add(altSearchInput);
                }
            }
        }
        return lastWordSearchInputs;
    }

    boolean isStandardVersion() {
        return this.m_stdVersion;
    }

    private void updateCurrentSearch(int from, int stdWordCount) {
        if (!this.m_stdVersion) {
            this.m_searchString = this.m_inputInfo.getInputStr().substring(this.m_offset);
        } else {
            this.updateStdWords(from, stdWordCount);
            this.m_searchString = this.m_searchString.substring(from);
        }
    }

    boolean hasStandardisedWords() {
        return this.m_stdWordPositions != null && !this.m_stdWordPositions.isEmpty();
    }

    int getNumberOfStdWords() {
        return this.m_stdVersion && this.m_stdWordPositions != null ? this.m_stdWordPositions.size() : 0;
    }

    private void updateStdWords(int offsetAdj, int requiredStdWords) {
        ArrayList<NumberRange> stdWordPositions = new ArrayList<NumberRange>(this.m_stdWordPositions.size());
        int stdWords = 0;
        Iterator<NumberRange> it = this.m_stdWordPositions.iterator();
        while (it.hasNext() && (requiredStdWords == -1 || stdWords < requiredStdWords)) {
            NumberRange stdWordPos = it.next();
            int start = stdWordPos.getStart();
            if (start < offsetAdj) continue;
            stdWordPositions.add(new NumberRange(start - offsetAdj, stdWordPos.getEnd() - offsetAdj));
            ++stdWords;
        }
        this.m_stdWordPositions = stdWordPositions;
    }

    private void buildStdSearchString(List<String> inputWords, List<String> stdWords) {
        int wordCount = inputWords.size();
        StringBuilder sb = new StringBuilder();
        ArrayList<NumberRange> stdWordPositions = new ArrayList<NumberRange>(stdWords.size());
        for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            int currLen = sb.length();
            if (currLen > 0) {
                sb.append(WORD_DELIM);
                ++currLen;
            }
            String word = this.getWordAt(wordNdx, inputWords, stdWords);
            if (this.isStandarisedWord(wordNdx, stdWords)) {
                stdWordPositions.add(new NumberRange(currLen, currLen + word.length()));
            }
            sb.append(word);
        }
        this.m_searchString = sb.toString();
        this.m_stdWordPositions = stdWordPositions;
    }

    private String getWordAt(int wordNdx, List<String> inputWords, List<String> stdWords) {
        String stdWord = null;
        if (this.m_stdVersion && !stdWords.isEmpty()) {
            stdWord = stdWords.get(wordNdx);
        }
        return stdWord == null ? inputWords.get(wordNdx) : stdWord;
    }

    private boolean isStandarisedWord(int wordNdx, List<String> stdWords) {
        return this.m_stdVersion && !stdWords.isEmpty() && stdWords.get(wordNdx) != null;
    }

    private boolean isCharAtWordBegining(int charNdx) {
        return this.isCharAtWordBegining(this.m_searchString, charNdx);
    }

    private boolean isCharAtWordBegining(String str, int charNdx) {
        return charNdx == 0 || str.charAt(charNdx - 1) == ' ';
    }

    private int getWordNdx(int charNdx, List<String> inputWords, List<String> stdWords) {
        if (charNdx == 0) {
            return 0;
        }
        int wordCount = inputWords.size();
        int wordStartNdx = 0;
        for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            String word = this.getWordAt(wordNdx, inputWords, stdWords);
            int wordEndNdx = wordStartNdx + word.length() + 1;
            if (charNdx >= wordStartNdx && charNdx < wordEndNdx) {
                return wordNdx;
            }
            wordStartNdx = wordEndNdx;
        }
        return -1;
    }

    private int getInputStrOffset(int offset) {
        if (offset == 0) {
            return 0;
        }
        int inputStrOffset = offset;
        List<String> inputWords = this.m_inputInfo.getInputWords();
        List<String> stdWords = this.m_inputInfo.getStdWords();
        int wordCount = inputWords.size();
        int wordStartOffset = 0;
        for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            String stdWord = stdWords.get(wordNdx);
            String inputWord = inputWords.get(wordNdx);
            if ((wordStartOffset += (stdWord == null ? inputWord : stdWord).length() + 1) > offset) break;
            if (stdWord == null) continue;
            inputStrOffset += inputWords.get(wordNdx).length() - stdWord.length();
        }
        return inputStrOffset;
    }

    private int calculateStdLenUptoWord(int wordNdx, List<String> stdWords, List<String> inputWords) {
        int len = 0;
        for (int i = 0; i < wordNdx; ++i) {
            String str = stdWords.get(i);
            if (str == null) {
                str = inputWords.get(i);
            }
            len += str.length() + 1;
        }
        return len;
    }

    String getWordStartingAt(int charNdx) {
        if (!this.isCharAtWordBegining(charNdx)) {
            return null;
        }
        List<String> inputWords = this.m_inputInfo.getInputWords();
        List<String> stdWords = this.m_inputInfo.getStdWords();
        int wordNdx = this.getWordNdx(this.m_offset + charNdx, inputWords, stdWords);
        return this.getWordAt(wordNdx, inputWords, stdWords);
    }

    String getInputWordStartingAt(int charNdx) {
        if (!this.isCharAtWordBegining(charNdx)) {
            return null;
        }
        List<String> inputWords = this.m_inputInfo.getInputWords();
        List<String> stdWords = this.m_stdVersion ? this.m_inputInfo.getStdWords() : inputWords;
        int wordNdx = this.getWordNdx(this.m_offset + charNdx, inputWords, stdWords);
        return inputWords.get(wordNdx);
    }

    List<NumberRange> getStdWordPositions() {
        if (this.m_stdVersion) {
            return this.m_stdWordPositions;
        }
        return null;
    }

    boolean isOnLastWord() {
        return this.m_searchString.indexOf(32) < 0;
    }

    String getSearchString() {
        return this.m_searchString;
    }

    String getStdString() {
        return this.m_inputInfo.getStdString();
    }

    String[] getLastWordAlts() {
        return this.m_inputInfo.getLastWordAlts();
    }

    String getInputString() {
        return this.m_inputInfo.getOriginalInputStr();
    }

    String getCleansedString() {
        return this.m_inputInfo.getInputStr();
    }

    boolean isShortenedInput() {
        return this.m_inputInfo.isShortenedInput();
    }

    void setSearchAreas(SearchAreas searchAreas) {
        this.m_inputInfo.setSearchAreas(searchAreas);
    }

    SearchAreas getSearchAreas() {
        return this.m_inputInfo.getSearchAreas();
    }

    boolean isMainFieldInput() {
        return this.m_inputInfo.getInputField() == InputAddress.MAIN_SEARCH_FIELD;
    }

    boolean isSameInputField(SearchInput otherInput) {
        return this.m_inputInfo.getInputField() == otherInput.getInputField();
    }

    void setInputField(int inField) {
        this.m_inputInfo.setInputField(inField);
    }

    int getInputField() {
        return this.m_inputInfo.getInputField();
    }

    SearchResults getResultsForSearchInput(SearchInput searchInput) {
        return this.m_inputInfo.getResultMap().get(searchInput);
    }

    SearchResults getResults() {
        return this.m_inputInfo.getResultMap().get(this);
    }

    void setResults(SearchResults searchResults) {
        this.setResults(this, searchResults);
    }

    void setResults(SearchInput searchInput, SearchResults searchResults) {
        this.m_inputInfo.getResultMap().put(this, searchResults);
    }

    void setResultsForSearchInput(SearchInput searchInput, SearchResults results) {
        this.m_inputInfo.getResultMap().put(searchInput, results);
    }

    public int hashCode() {
        return this.m_searchString.hashCode() * 31 + (this.m_stdVersion ? 1 : 31);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchInput other = (SearchInput)obj;
        return this.m_offset == other.m_offset && this.m_stdVersion == other.m_stdVersion && this.m_searchString.equals(other.m_searchString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("[Search: '");
        sb.append(this.getSearchString());
        sb.append("']");
        sb.append(" [Input: Original='");
        sb.append(this.getInputString());
        sb.append("', Cleansed='");
        sb.append(this.getCleansedString());
        sb.append("', Std='");
        sb.append(this.getStdString());
        sb.append("']");
        if (this.m_stdVersion) {
            List<String> inputWords = this.m_inputInfo.getInputWords();
            List<String> stdWords = this.m_inputInfo.getStdWords();
            int wordCount = inputWords.size();
            sb.append(" [Std Words:");
            int wordStart = 0;
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                if (wordStart >= this.m_offset && this.isStandarisedWord(wordNdx, stdWords)) {
                    sb.append(" '");
                    sb.append(inputWords.get(wordNdx));
                    sb.append("'='");
                    sb.append(stdWords.get(wordNdx));
                    sb.append("'");
                }
                wordStart += this.getWordAt(wordNdx, inputWords, stdWords).length() + 1;
            }
            sb.append("]");
        }
        sb.append(" [Last word alts: ");
        sb.append(Arrays.toString(this.getLastWordAlts()));
        sb.append("]");
        return sb.toString();
    }

    public boolean isLastWordAlt() {
        return this.m_lastWordAlt;
    }

    private static class InputInfo {
        private final String m_originalInputStr;
        private final String m_inputStr;
        private final String m_stdString;
        private final List<String> m_inputWords;
        private final List<String> m_stdWords;
        private final String[] m_lastWordAlts;
        private SearchAreas m_searchAreas;
        private final boolean m_inputShortnened;
        private int m_inputField;
        private Map<SearchInput, SearchResults> m_resultMap;

        InputInfo(String inputString, String cleansedString, String stdString, List<String> inputWords, List<String> stdWords, String[] lastWordAlts, boolean inputShortened) {
            this.m_originalInputStr = inputString;
            this.m_inputStr = cleansedString;
            this.m_stdString = stdString;
            this.m_inputWords = inputWords;
            this.m_stdWords = stdWords;
            this.m_lastWordAlts = lastWordAlts;
            this.m_resultMap = new HashMap<SearchInput, SearchResults>();
            this.m_inputShortnened = inputShortened;
        }

        String getOriginalInputStr() {
            return this.m_originalInputStr;
        }

        String getInputStr() {
            return this.m_inputStr;
        }

        List<String> getInputWords() {
            return this.m_inputWords;
        }

        List<String> getStdWords() {
            return this.m_stdWords;
        }

        String[] getLastWordAlts() {
            return this.m_lastWordAlts;
        }

        SearchAreas getSearchAreas() {
            return this.m_searchAreas;
        }

        void setSearchAreas(SearchAreas searchAreas) {
            this.m_searchAreas = searchAreas;
        }

        Map<SearchInput, SearchResults> getResultMap() {
            return this.m_resultMap;
        }

        boolean isShortenedInput() {
            return this.m_inputShortnened;
        }

        String getStdString() {
            return this.m_stdString;
        }

        void setInputField(int inField) {
            this.m_inputField = inField;
        }

        int getInputField() {
            return this.m_inputField;
        }
    }
}

