/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.SearchRequest;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;

public abstract class SearchResult {
    private final SearchRequest m_searchRequest;

    private SearchResult(SearchRequest searchRequest) {
        this.m_searchRequest = searchRequest;
    }

    static SearchResult getInstance(IMatchResult<AddressPtrMap> matchResult, SearchRequest searchRequest) {
        return new SearchResultFromIMatchResult(matchResult, searchRequest);
    }

    static SearchResult getInstance(String word, AddressPtrMap addrTreeItem, SearchRequest seachRequest, int matchedLen, int matchWeight, boolean inputFullyMatched) {
        return new SearchResultFromAddressPtrMap(word, addrTreeItem, seachRequest, matchedLen, matchWeight, inputFullyMatched);
    }

    SearchResult copy(AddressPtrMap addrTreeItem) {
        return new SearchResultFromAddressPtrMap(this.getWord(), addrTreeItem, this.getSearchRequest(), this.getMatchedLen(), this.getMatchWeight(), this.isFullInputMatch());
    }

    protected SearchRequest getSearchRequest() {
        return this.m_searchRequest;
    }

    public abstract String getWord();

    abstract AddressPtrMap getAddressPtrMap();

    abstract int getMatchedLen();

    abstract boolean isFullInputMatch();

    abstract int getMatchWeight();

    public String toString() {
        return String.format("SearchResult(word: '%s', matchedLen: %d, fullyMatched: %s, addrPtrMap: %s, request: %s)", this.getWord(), this.getMatchedLen(), this.isFullInputMatch(), this.getAddressPtrMap(), this.getSearchRequest());
    }

    private static final class SearchResultFromAddressPtrMap
    extends SearchResult {
        private final String m_word;
        private final AddressPtrMap m_addrPtrMap;
        private final int m_matchedLen;
        private final boolean m_inputFullyMatched;
        private final int m_matchWeight;

        SearchResultFromAddressPtrMap(String word, AddressPtrMap addrTreeItem, SearchRequest seachRequest, int matchedLen, int matchWeight, boolean inputFullyMatched) {
            super(seachRequest);
            this.m_word = word;
            this.m_addrPtrMap = addrTreeItem;
            this.m_matchedLen = matchedLen;
            this.m_inputFullyMatched = inputFullyMatched;
            this.m_matchWeight = matchWeight;
        }

        @Override
        public String getWord() {
            return this.m_word;
        }

        @Override
        public AddressPtrMap getAddressPtrMap() {
            return this.m_addrPtrMap;
        }

        @Override
        public int getMatchedLen() {
            return this.m_matchedLen;
        }

        @Override
        boolean isFullInputMatch() {
            return this.m_inputFullyMatched;
        }

        @Override
        int getMatchWeight() {
            return this.m_matchWeight;
        }
    }

    private static final class SearchResultFromIMatchResult
    extends SearchResult {
        private final IMatchResult<AddressPtrMap> m_matchResult;

        SearchResultFromIMatchResult(IMatchResult<AddressPtrMap> matchResult, SearchRequest searchRequest) {
            super(searchRequest);
            this.m_matchResult = matchResult;
        }

        @Override
        public String getWord() {
            return this.m_matchResult.getKey();
        }

        @Override
        public AddressPtrMap getAddressPtrMap() {
            return this.m_matchResult.getValue();
        }

        @Override
        public int getMatchedLen() {
            return this.m_matchResult.getTargetMatchLen();
        }

        @Override
        boolean isFullInputMatch() {
            return this.m_matchResult.isFullInputMatch();
        }

        @Override
        int getMatchWeight() {
            return this.m_matchResult.getWeight();
        }
    }
}

