/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest;

import com.mapinfo.mapmarker.autosuggest.AddressSearchPreferences;
import com.mapinfo.mapmarker.autosuggest.dp.StringDataItem;
import com.mapinfo.mapmarker.autosuggest.filters.GeocompleteFilters;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenStandardiser {
    private static final Logger LOG = LoggerFactory.getLogger((String)TokenStandardiser.class.getName());
    private final RadixTree<StringDataItem> m_altWordLookupTree;

    public TokenStandardiser(RadixTree<StringDataItem> altWordLookupTree) {
        this.m_altWordLookupTree = altWordLookupTree;
    }

    public String standardiseString(String str) {
        return this.standardiseString(str, false, null);
    }

    public String standardiseString(String str, boolean ignoreLastWord) {
        return this.standardiseString(str, ignoreLastWord, null);
    }

    public String standardiseString(String str, boolean ignoreLastWord, AddressSearchPreferences preferences) {
        String[] tokens = str.split(" ");
        StringBuilder sb = new StringBuilder(str.length());
        int tokenCount = tokens.length;
        for (int i = 0; i < tokenCount - 1; ++i) {
            String stdToken = this.standardiseWord(tokens[i], preferences);
            sb.append(stdToken);
            sb.append(' ');
        }
        String lastWord = tokens[tokenCount - 1];
        if (ignoreLastWord) {
            sb.append(lastWord);
        } else {
            sb.append(this.standardiseWord(lastWord, preferences));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("standardiseString('" + str + "'): found '" + sb.toString() + "'");
        }
        return sb.toString();
    }

    public String standardiseWord(String word) {
        String results = this.standardiseWord(word, null);
        return results;
    }

    public String standardiseWord(String word, AddressSearchPreferences preferences) {
        StringDataItem stdWord = this.m_altWordLookupTree.find(word);
        String result = word;
        if (stdWord != null) {
            result = stdWord.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("standardiseWord('" + word + "'): found '" + result + "' (standard word)");
            }
        } else if (preferences != null && preferences.getFuzzySearch()) {
            if (word.length() > 2) {
                INodeKeyFilter keyFilter = GeocompleteFilters.getKeyFilter(result, null, false, false, preferences);
                NodeFilter nodeFilter = new NodeFilter(keyFilter, null);
                RadixTreeMatchResult<StringDataItem> altWordNodeMatchResult = this.m_altWordLookupTree.find(word, nodeFilter);
                if (null != altWordNodeMatchResult) {
                    ArrayList<IMatchResult<StringDataItem>> dataItemsList = new ArrayList<IMatchResult<StringDataItem>>();
                    for (IMatchResult<StringDataItem> iMatchResult : altWordNodeMatchResult) {
                        int minWordLengthCount = preferences.maxEditDistance() + 1;
                        if (Math.abs(iMatchResult.getKey().length() - word.length()) >= minWordLengthCount || iMatchResult.getKey().charAt(0) != word.charAt(0)) continue;
                        dataItemsList.add(iMatchResult);
                    }
                    if (!dataItemsList.isEmpty()) {
                        if (dataItemsList.size() > 1) {
                            Collections.sort(dataItemsList);
                        }
                        result = ((StringDataItem)((IMatchResult)dataItemsList.get(dataItemsList.size() - 1)).getValue()).getValue();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("standardiseWord('" + word + "'): found " + Arrays.toString(dataItemsList.toArray()) + " (fuzzy matches)");
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("standardiseWord('" + word + "'): found '" + result + "' (fuzzy match without matches)");
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("standardiseWord('" + word + "'): found '" + result + "' (too short for fuzzy matching)");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("standardiseWord('" + word + "'): found '" + result + "' (strict search)");
        }
        return result;
    }

    public Set<String> getStandardisedWordsForPrefix(String prefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getStandardisedWordsForPrefix('" + prefix + "')");
        }
        HashSet<String> results = null;
        if (this.m_altWordLookupTree != null) {
            HashSet<String> stdWordSet = new HashSet<String>();
            RadixTreeMatchResult<StringDataItem> result = this.m_altWordLookupTree.findAll(prefix);
            if (result != null) {
                for (IMatchResult<StringDataItem> iMatchResult : result) {
                    String stdWord = iMatchResult.getValue().getValue();
                    if (stdWord.startsWith(prefix)) continue;
                    stdWordSet.add(stdWord);
                }
                results = stdWordSet;
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("getStandardisedWordsForPrefix('" + prefix + "'): found ");
            if (results == null) {
                sb.append("[ ]");
            } else {
                sb.append(Arrays.toString(results.toArray()));
            }
            LOG.debug(sb.toString());
        }
        return results;
    }
}

