/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.api;

import com.mapinfo.coordsys.CoordSys;
import com.mapinfo.mapmarker.autosuggest.DictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AutoSuggestConstraints
implements IAutoSuggestConstraints {
    public static final int DEFAULT_NUM_CANDIDATES = 5;
    public static final int MAX_CANDIDATES = 100;
    public static final String KEY_SEARCH_WORLD_PLACES_ONLY = "SEARCH_WORLD_PLACES_ONLY";
    private static final String key_coordSys = "Coordinate System";
    private static final String key_boundingBox = "Bounding Box";
    private static final String key_searchDistance = "Search Distance";
    private static final String key_units = "Units";
    private static final String key_maxCandidates = "Max Candidates";
    private static final String key_searchType = "Search Type";
    private static final String key_origin = "Origin";
    private static final String key_dictionarySearchPriority = "Dictionary Search Priority";
    private static final String key_fuzzyMatchMode = "Fuzzy Match Mode";
    private static final String key_locale = "Locale";
    private static final String key_maxRanges = "Max Ranges";
    private static final String key_maxRangeUnits = "Max RangeUnits";
    private static int DEFAULT_SEARCH_TYPE = 124;
    private com.mapinfo.midev.coordsys.CoordSys coordSys;
    private BoundingBox boundingBox;
    private double searchDistance;
    private IAutoSuggestConstraints.DistanceUnits units;
    private int maxCandidates;
    private int searchType;
    private DirectPosition origin;
    private Map<String, String> customValues;
    private BoundingBox boundingBoxWGS84;
    private DirectPosition originWGS84;
    private IDictionarySearchPriority dictionarySearchPriority;
    private IAutoSuggestConstraints.FuzzyMatchMode fuzzyMatchMode = IAutoSuggestConstraints.FuzzyMatchMode.NONE;
    private Locale locale = null;
    private boolean mustMatchAddrNum;
    private boolean compressResults;
    private int maxRanges;
    private int maxUnits;
    private static final int VALUE_ALL_POSSIBLE_RANGES = -1;
    private static final int VALUE_ALL_POSSIBLE_RANGEUNITS = -1;

    public AutoSuggestConstraints() {
        this.init();
    }

    private void init() {
        this.searchType = DEFAULT_SEARCH_TYPE;
        this.maxCandidates = 5;
        this.customValues = new HashMap<String, String>();
        this.coordSys = CoordSysConstants.longLatWGS84;
        this.units = IAutoSuggestConstraints.DistanceUnits.KILOMETERS;
        this.searchDistance = 0.0;
        this.dictionarySearchPriority = null;
        this.mustMatchAddrNum = false;
        this.compressResults = false;
        this.maxRanges = -1;
        this.maxUnits = -1;
    }

    private void appendPair(StringBuffer sb, String key, String value, String sep) {
        sb.append(key);
        sb.append("=");
        sb.append(value);
        sb.append(sep);
    }

    public String toString() {
        String searchTypeAsString;
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        switch (this.getSearchType()) {
            case 65535: {
                searchTypeAsString = "TYPE_ALL";
                break;
            }
            case 3: {
                searchTypeAsString = "TYPE_POINT_OF_INTEREST_COMPLETION";
                break;
            }
            case 124: {
                searchTypeAsString = "TYPE_ADDRESS_COMPLETION";
                break;
            }
            case 8: {
                searchTypeAsString = "TYPE_CITY_COMPLETION";
                break;
            }
            case 32: {
                searchTypeAsString = "TYPE_GEOGRAPHIC_COMPLETION";
                break;
            }
            case 2: {
                searchTypeAsString = "TYPE_POINT_OF_INTEREST_CATEGORY_COMPLETION";
                break;
            }
            case 1: {
                searchTypeAsString = "TYPE_POINT_OF_INTEREST_NAME_COMPLETION";
                break;
            }
            case 4: {
                searchTypeAsString = "TYPE_POSTAL_COMPLETION";
                break;
            }
            case 16: {
                searchTypeAsString = "TYPE_STREET_NAME_COMPLETION";
                break;
            }
            default: {
                searchTypeAsString = String.valueOf(this.getSearchType());
            }
        }
        this.appendPair(sb, key_searchType, searchTypeAsString, lineSeparator);
        this.appendPair(sb, key_fuzzyMatchMode, String.valueOf((Object)this.getFuzzyMatchMode()), lineSeparator);
        this.appendPair(sb, key_maxCandidates, String.valueOf(this.getMaxCandidates()), lineSeparator);
        this.appendPair(sb, key_maxRanges, String.valueOf(this.getMaxRanges()), lineSeparator);
        this.appendPair(sb, key_maxRangeUnits, String.valueOf(this.getMaxRangeUnits()), lineSeparator);
        if (this.getCoordSys() != null) {
            this.appendPair(sb, key_coordSys, MidevConversionUtils.getSRSname((com.mapinfo.midev.coordsys.CoordSys)this.getCoordSysObject()), lineSeparator);
        } else {
            this.appendPair(sb, key_coordSys, "null", lineSeparator);
        }
        this.appendPair(sb, key_origin, String.valueOf(this.getOrigin()), lineSeparator);
        this.appendPair(sb, key_searchDistance, String.valueOf(this.getSearchDistance()), lineSeparator);
        if (this.getUnits() != null) {
            this.appendPair(sb, key_units, this.getUnits().toString(), lineSeparator);
        } else {
            this.appendPair(sb, key_units, "null", lineSeparator);
        }
        if (this.getBoundingBox() != null) {
            String boundingBoxAsString = "[" + this.getBoundingBox().getWesternLimit() + ", " + this.getBoundingBox().getSouthernLimit() + ", " + this.getBoundingBox().getEasternLimit() + ", " + this.getBoundingBox().getNorthernLimit() + "]";
            this.appendPair(sb, key_boundingBox, boundingBoxAsString, lineSeparator);
        } else {
            this.appendPair(sb, key_boundingBox, "null", lineSeparator);
        }
        if (this.getDictionarySearchPriority() != null) {
            this.appendPair(sb, key_dictionarySearchPriority, this.getDictionarySearchPriority().toString(), lineSeparator);
        } else {
            this.appendPair(sb, key_dictionarySearchPriority, "null", lineSeparator);
        }
        this.appendPair(sb, key_locale, "" + this.locale, lineSeparator);
        this.appendPair(sb, "MustMatchAddressNumber", Boolean.toString(this.mustMatchAddrNum), lineSeparator);
        for (String key : this.customValues.keySet()) {
            String val = this.getCustomString(key);
            this.appendPair(sb, key, val, lineSeparator);
        }
        return sb.toString();
    }

    public AutoSuggestConstraints(IAutoSuggestConstraints constraints) {
        Map<String, String> custom;
        IDictionarySearchPriority priority;
        this.init();
        this.coordSys = constraints.getCoordSysObject();
        BoundingBox box = constraints.getBoundingBox();
        if (box != null) {
            this.boundingBox = new BoundingBox(box.getWesternLimit(), box.getSouthernLimit(), box.getEasternLimit(), box.getNorthernLimit());
        }
        this.searchDistance = constraints.getSearchDistance();
        this.units = constraints.getUnits();
        this.maxCandidates = constraints.getMaxCandidates();
        this.searchType = constraints.getSearchType();
        DirectPosition orig = constraints.getOriginPoint();
        if (orig != null) {
            this.origin = orig;
        }
        if ((priority = constraints.getDictionarySearchPriority()) != null) {
            this.dictionarySearchPriority = new DictionarySearchPriority(priority);
        }
        if ((custom = constraints.getCustomValues()) != null && custom.size() > 0) {
            this.customValues.putAll(custom);
        }
        this.fuzzyMatchMode = constraints.getFuzzyMatchMode();
        this.mustMatchAddrNum = constraints.isMustMatchAddressNumber();
        this.compressResults = constraints.isCompressAreaResults();
        this.maxRanges = constraints.getMaxRanges();
        this.maxUnits = constraints.getMaxRangeUnits();
    }

    @Override
    public CoordSys getCoordSys() {
        return MidevConversionUtils.getLegacyCoordSys((com.mapinfo.midev.coordsys.CoordSys)this.coordSys);
    }

    @Override
    public com.mapinfo.midev.coordsys.CoordSys getCoordSysObject() {
        return this.coordSys;
    }

    @Override
    public void setCoordSys(CoordSys coordSys) {
        com.mapinfo.midev.coordsys.CoordSys converted = coordSys == null ? CoordSysConstants.longLatWGS84 : CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSys.getSrsName());
        if (!this.coordSys.equals(converted)) {
            this.coordSys = converted;
            this.originWGS84 = null;
            this.boundingBoxWGS84 = null;
        }
    }

    @Override
    public void setCoordSys(com.mapinfo.midev.coordsys.CoordSys coordSys) {
        if (coordSys == null) {
            coordSys = CoordSysConstants.longLatWGS84;
        }
        if (!this.coordSys.equals(coordSys)) {
            this.coordSys = coordSys;
            this.originWGS84 = null;
            this.boundingBoxWGS84 = null;
        }
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public BoundingBox getBoundingBoxWGS84() {
        if (this.boundingBox == null) {
            return null;
        }
        if (this.boundingBoxWGS84 != null) {
            return this.boundingBoxWGS84;
        }
        if (this.coordSys.equals(CoordSysConstants.longLatWGS84)) {
            this.boundingBoxWGS84 = this.boundingBox;
            return this.boundingBoxWGS84;
        }
        ArrayList<DirectPosition> points = new ArrayList<DirectPosition>();
        points.add(new DirectPosition(this.boundingBox.getWesternLimit(), this.boundingBox.getSouthernLimit()));
        points.add(new DirectPosition(this.boundingBox.getEasternLimit(), this.boundingBox.getNorthernLimit()));
        List converted = CoordConvertor.transformPointsToWGS84((com.mapinfo.midev.coordsys.CoordSys)this.coordSys, points);
        DirectPosition pointSW = (DirectPosition)converted.get(0);
        DirectPosition pointNE = (DirectPosition)converted.get(1);
        this.boundingBoxWGS84 = new BoundingBox(pointSW.getX(), pointSW.getY(), pointNE.getX(), pointNE.getY());
        return this.boundingBoxWGS84;
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        this.boundingBoxWGS84 = null;
    }

    @Override
    public double getSearchDistance() {
        return this.searchDistance;
    }

    @Override
    public void setSearchDistance(double searchDistance) {
        if (searchDistance < 0.0) {
            searchDistance = 0.0;
        }
        this.searchDistance = searchDistance;
    }

    @Override
    public IAutoSuggestConstraints.DistanceUnits getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(IAutoSuggestConstraints.DistanceUnits units) {
        this.units = units;
    }

    @Override
    public int getMaxCandidates() {
        return this.maxCandidates;
    }

    @Override
    public void setMaxCandidates(int maxCandidates) {
        if (maxCandidates == 0) {
            maxCandidates = 5;
        } else if (maxCandidates < 0 || maxCandidates > 100) {
            maxCandidates = 100;
        }
        this.maxCandidates = maxCandidates;
    }

    @Override
    public int getSearchType() {
        return this.searchType;
    }

    @Override
    public void setSearchType(int searchType) {
        this.searchType = searchType;
    }

    @Override
    public DoublePoint getOrigin() {
        if (this.origin == null) {
            return null;
        }
        return new DoublePoint(this.origin.getX(), this.origin.getY());
    }

    @Override
    public DirectPosition getOriginPoint() {
        return this.origin;
    }

    @Override
    public DirectPosition getOriginPointWGS84() {
        if (this.origin == null) {
            return null;
        }
        if (this.originWGS84 != null) {
            return this.originWGS84;
        }
        if (this.coordSys.equals(CoordSysConstants.longLatWGS84)) {
            this.originWGS84 = this.origin;
            return this.origin;
        }
        this.originWGS84 = CoordConvertor.transformPointToWGS84((com.mapinfo.midev.coordsys.CoordSys)this.coordSys, (DirectPosition)this.origin);
        return this.originWGS84;
    }

    @Override
    public DoublePoint getOriginWGS84() {
        DirectPosition pos = this.getOriginPointWGS84();
        if (pos == null) {
            return null;
        }
        return new DoublePoint(pos.getX(), pos.getY());
    }

    @Override
    public void setOrigin(DoublePoint origin) {
        if (origin != null) {
            this.origin = new DirectPosition(origin.x, origin.y);
        }
        this.originWGS84 = null;
    }

    @Override
    public void setOrigin(DirectPosition origin) {
        this.origin = origin;
        this.originWGS84 = null;
    }

    @Override
    public Map<String, String> getCustomValues() {
        return this.customValues;
    }

    @Override
    public String setCustomString(String key, String value) {
        return this.customValues.put(key, value);
    }

    @Override
    public String getCustomString(String key) {
        return this.customValues.get(key);
    }

    @Override
    public String getCustomString(String key, String defaultValue) {
        String ret = this.getCustomString(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public void setDictionarySearchPriority(IDictionarySearchPriority searchPriority) {
        this.dictionarySearchPriority = searchPriority;
    }

    @Override
    public IDictionarySearchPriority getDictionarySearchPriority() {
        return this.dictionarySearchPriority;
    }

    @Override
    public void setFuzzyMatchMode(IAutoSuggestConstraints.FuzzyMatchMode fuzzyMatchMode) {
        this.fuzzyMatchMode = fuzzyMatchMode;
    }

    @Override
    public IAutoSuggestConstraints.FuzzyMatchMode getFuzzyMatchMode() {
        return this.fuzzyMatchMode;
    }

    @Override
    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setMatchOnAddressNumber(boolean match) {
        this.mustMatchAddrNum = match;
    }

    @Override
    public boolean isMustMatchAddressNumber() {
        return this.mustMatchAddrNum;
    }

    @Override
    public boolean isCompressAreaResults() {
        return this.compressResults;
    }

    @Override
    public void setCompressAreaResults(boolean b) {
        this.compressResults = b;
    }

    @Override
    public int getMaxRanges() {
        return this.maxRanges;
    }

    @Override
    public void setMaxRanges(int maxRanges) {
        this.maxRanges = maxRanges;
    }

    @Override
    public int getMaxRangeUnits() {
        return this.maxUnits;
    }

    @Override
    public void setMaxRangeUnits(int maxUnits) {
        this.maxUnits = maxUnits;
    }
}

