/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.AutoSuggestHandler;
import com.mapinfo.mapmarker.autosuggest.DictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.IDictionarySearchPriority;
import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestDictionaryMetaData;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.exception.InitializationFailureException;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.wrapper.WrapperDataInfo;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class AutoSuggestFactorySettingsProvider {
    public static final String KEY_DIRECTORY_ADDRESS = "directory_address";
    public static final String KEY_INDEX_ADDRESS = "tdx_address";
    public static final String KEY_DICTIONARY_INDEX_FILE = "dictionary_index_file";
    public static final String KEY_DIRECTORY_POI = "directory_POI";
    public static final String KEY_INDEX_POI = "tdx_POI";
    private static final String DEFAULT_COUNTRY = null;
    private String m_defaultCountry = null;
    protected HashMap<String, List<WrapperDataInfo>> m_countryDictionaryList = new HashMap();
    protected HashMap<String, List<String>> m_countryDictionaryNameList;
    protected List<WrapperDataInfo> m_configuredDictionaryList = new ArrayList<WrapperDataInfo>();
    private static AutoSuggestFactorySettingsProvider m_provider;

    private AutoSuggestFactorySettingsProvider() {
        this.m_countryDictionaryNameList = new HashMap();
        this.setDefaultCountry(DEFAULT_COUNTRY);
    }

    public static AutoSuggestFactorySettingsProvider getInstance() {
        if (m_provider == null) {
            m_provider = new AutoSuggestFactorySettingsProvider();
        }
        return m_provider;
    }

    public String getDefaultCountry() {
        return this.m_defaultCountry;
    }

    public void setDefaultCountry(String country) {
        ISO3166 ISOCountry = ISO3166.findCountryByISO3((String)country);
        this.m_defaultCountry = ISOCountry != null || "XWG".equals(country) ? country : DEFAULT_COUNTRY;
    }

    public void setDataSettingsForCountry(String country, Properties dataSettings) throws InitializationFailureException {
        List<String> dictionaries = this.m_countryDictionaryNameList.get(country);
        if (dictionaries == null) {
            dictionaries = new ArrayList<String>();
            this.m_countryDictionaryNameList.put(country, dictionaries);
        } else {
            List<WrapperDataInfo> countryWrappers = this.m_countryDictionaryList.get(country);
            if (countryWrappers != null) {
                for (WrapperDataInfo wrapperDataInfo : countryWrappers) {
                    this.m_configuredDictionaryList.remove(wrapperDataInfo);
                }
                countryWrappers.clear();
            }
            dictionaries.clear();
        }
        this.addDictionariesToList(dataSettings, dictionaries);
        this.loadAddressHandlersForCountry(country, dictionaries);
    }

    protected void addDictionariesToList(Properties dataSettings, List<String> dictionaries) {
        boolean bOldStyle = false;
        String fileDir = (String)dataSettings.get(KEY_DIRECTORY_ADDRESS);
        String tdxFileLoc = (String)dataSettings.get(KEY_INDEX_ADDRESS);
        if (fileDir != null && tdxFileLoc != null) {
            bOldStyle = true;
            dictionaries.add(tdxFileLoc);
        }
        String poiFileDir = (String)dataSettings.get(KEY_DIRECTORY_POI);
        String poiTdxFileLoc = (String)dataSettings.get(KEY_INDEX_POI);
        if (poiFileDir != null && poiTdxFileLoc != null) {
            bOldStyle = true;
            dictionaries.add(poiTdxFileLoc);
        }
        if (!bOldStyle) {
            this.addIncrementingKeys(null, dataSettings, dictionaries);
        }
    }

    private void loadAddressHandlersForCountry(String country, List<String> dictionaries) throws InitializationFailureException {
        if (dictionaries == null) {
            return;
        }
        for (int i = 0; i < dictionaries.size(); ++i) {
            String index = dictionaries.get(i);
            country = country.toUpperCase();
            if (index == null) {
                AutoSuggestLog.getLog().info((Object)("No dictionary index file provided for " + country));
                return;
            }
            AutoSuggestHandler handler = new AutoSuggestHandler();
            String path = this.stripPath(index);
            handler.load(index, path);
            WrapperDataInfo dataSet = new WrapperDataInfo(handler, country);
            List<WrapperDataInfo> wrapperList = this.m_countryDictionaryList.get(country);
            if (wrapperList == null) {
                wrapperList = new ArrayList<WrapperDataInfo>();
                this.m_countryDictionaryList.put(country, wrapperList);
            }
            wrapperList.add(dataSet);
            this.m_configuredDictionaryList.add(dataSet);
        }
    }

    protected String stripPath(String indexFile) {
        StringBuilder sb = new StringBuilder(indexFile);
        int lastSlash = sb.lastIndexOf("/");
        int lastBackslash = sb.lastIndexOf("\\");
        if (lastSlash > 0) {
            if (lastBackslash > lastSlash) {
                lastSlash = lastBackslash;
            }
        } else if (lastBackslash > 0) {
            lastSlash = lastBackslash;
        }
        if (lastSlash > 0) {
            sb.setLength(lastSlash);
        }
        return sb.toString();
    }

    public WrapperDataInfo getPOIHandlerForCountry(String country) {
        List<WrapperDataInfo> list = this.m_countryDictionaryList.get(country.toUpperCase());
        for (WrapperDataInfo wrapperDataInfo : list) {
            if (!wrapperDataInfo.canUseDataForSearchType(3)) continue;
            return wrapperDataInfo;
        }
        return null;
    }

    public WrapperDataInfo getAddressHandlerForCountry(String country) {
        List<WrapperDataInfo> list = this.m_countryDictionaryList.get(country.toUpperCase());
        for (WrapperDataInfo wrapperDataInfo : list) {
            if (!wrapperDataInfo.canUseDataForSearchType(124)) continue;
            return wrapperDataInfo;
        }
        return null;
    }

    public Set<String> getCountriesWithAddressData() {
        ArrayList<String> countries = new ArrayList<String>();
        for (WrapperDataInfo wrapperDataInfo : this.m_configuredDictionaryList) {
            if (!wrapperDataInfo.canUseDataForSearchType(124)) continue;
            countries.add(wrapperDataInfo.getCountry());
        }
        return new HashSet<String>(countries);
    }

    public Set<String> getCountriesWithPOIData() {
        ArrayList<String> countries = new ArrayList<String>();
        for (WrapperDataInfo wrapperDataInfo : this.m_configuredDictionaryList) {
            if (!wrapperDataInfo.canUseDataForSearchType(3)) continue;
            countries.add(wrapperDataInfo.getCountry());
        }
        return new HashSet<String>(countries);
    }

    public List<WrapperDataInfo> getUsableDictionaryWrappersForCountry(String country, int searchType, IAutoSuggestConstraints constraints) {
        if (StringUtilities.isEmpty((String)country)) {
            return null;
        }
        ArrayList<WrapperDataInfo> handlers = new ArrayList<WrapperDataInfo>();
        IDictionarySearchPriority priority = null;
        if (constraints != null) {
            priority = constraints.getDictionarySearchPriority();
        }
        StringTokenizer st = new StringTokenizer(country.toUpperCase());
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            List<WrapperDataInfo> wrappers = this.m_countryDictionaryList.get(tok);
            if (wrappers == null || wrappers.isEmpty()) continue;
            for (WrapperDataInfo wrapperDataInfo : wrappers) {
                if (priority != null && !priority.isDictionaryAvailableForSearch(wrapperDataInfo.getDictionaryName()) || !wrapperDataInfo.canUseDataForSearchType(searchType)) continue;
                handlers.add(wrapperDataInfo);
            }
        }
        if (handlers.size() > 1 && priority != null) {
            Collections.sort(handlers, new DictionaryPrioritizer(priority));
        }
        return handlers;
    }

    public List<WrapperDataInfo> getUsableConfiguredDictionaryWrappers(int searchType, IAutoSuggestConstraints constraints) {
        ArrayList<WrapperDataInfo> handlers = new ArrayList<WrapperDataInfo>();
        if (this.m_configuredDictionaryList.isEmpty()) {
            return handlers;
        }
        IDictionarySearchPriority priority = null;
        if (constraints != null) {
            priority = constraints.getDictionarySearchPriority();
        }
        for (WrapperDataInfo wrapperDataInfo : this.m_configuredDictionaryList) {
            if (priority != null && !priority.isDictionaryAvailableForSearch(wrapperDataInfo.getDictionaryName()) || !wrapperDataInfo.canUseDataForSearchType(searchType)) continue;
            handlers.add(wrapperDataInfo);
        }
        if (handlers.size() > 1 && priority != null) {
            Collections.sort(handlers, new DictionaryPrioritizer(priority));
        }
        return handlers;
    }

    public List<WrapperDataInfo> getConfiguredDictionaryList() {
        ArrayList<WrapperDataInfo> copy = new ArrayList<WrapperDataInfo>(this.m_configuredDictionaryList.size());
        copy.addAll(this.m_configuredDictionaryList);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConfiguredDictionaryOrder(List<WrapperDataInfo> newList) {
        if (newList == null || newList.size() != this.m_configuredDictionaryList.size()) {
            return false;
        }
        if (!this.m_configuredDictionaryList.containsAll(newList) || !newList.containsAll(this.m_configuredDictionaryList)) {
            return false;
        }
        if (this.m_configuredDictionaryList.isEmpty()) {
            return newList.isEmpty();
        }
        HashMap tempCountryWrapperListMap = new HashMap();
        for (WrapperDataInfo wrapperDataInfo : newList) {
            String country = wrapperDataInfo.getCountry();
            if (tempCountryWrapperListMap.get(country) == null) {
                tempCountryWrapperListMap.put(country, new ArrayList());
            }
            ((List)tempCountryWrapperListMap.get(country)).add(wrapperDataInfo);
        }
        AutoSuggestFactorySettingsProvider autoSuggestFactorySettingsProvider = this;
        synchronized (autoSuggestFactorySettingsProvider) {
            this.m_configuredDictionaryList.clear();
            this.m_configuredDictionaryList.addAll(newList);
            for (Map.Entry entry : tempCountryWrapperListMap.entrySet()) {
                this.m_countryDictionaryList.put((String)entry.getKey(), (List<WrapperDataInfo>)entry.getValue());
            }
        }
        return true;
    }

    protected void decodeProperties(Properties properties) {
        HashSet<String> processedCountries = new HashSet<String>();
        for (Object key : properties.keySet()) {
            int startPos;
            boolean bOldStyle = false;
            String strKey = (String)key;
            if (strKey.startsWith(KEY_DICTIONARY_INDEX_FILE)) {
                startPos = KEY_DICTIONARY_INDEX_FILE.length() + 1;
            } else {
                if (!this.isOldStyleKey(strKey)) continue;
                bOldStyle = true;
                startPos = strKey.length() - 3;
            }
            String country = strKey.substring(startPos, startPos + 3);
            if (processedCountries.contains(country)) continue;
            processedCountries.add(country);
            if (bOldStyle) {
                this.m_countryDictionaryNameList.put(country, this.decodeOldStylePropertiesForCountry(country, properties));
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            this.addIncrementingKeys(country, properties, list);
            this.m_countryDictionaryNameList.put(country, list);
        }
    }

    protected boolean isOldStyleKey(String key) {
        return key.startsWith(KEY_DIRECTORY_ADDRESS) || key.startsWith(KEY_DIRECTORY_POI) || key.startsWith(KEY_INDEX_ADDRESS) || key.startsWith(KEY_INDEX_POI);
    }

    protected void addIncrementingKeys(String country, Properties properties, List<String> list) {
        StringBuilder index = new StringBuilder(KEY_DICTIONARY_INDEX_FILE);
        index.append('_');
        if (!StringUtilities.isEmpty((String)country)) {
            index.append(country);
            index.append('_');
        }
        int baseIndexLen = index.length();
        int entryNum = 1;
        while (true) {
            index.setLength(baseIndexLen);
            index.append(entryNum);
            String idxVal = properties.getProperty(index.toString());
            if (idxVal == null) break;
            list.add(idxVal);
            ++entryNum;
        }
    }

    protected List<String> decodeOldStylePropertiesForCountry(String country, Properties properties) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder key = new StringBuilder(KEY_DIRECTORY_ADDRESS);
        key.append('_');
        key.append(country);
        String value = properties.getProperty(key.toString());
        key = new StringBuilder(KEY_INDEX_ADDRESS);
        key.append('_');
        key.append(country);
        String indexValue = properties.getProperty(key.toString());
        if (!StringUtilities.isEmpty((String)value) && !StringUtilities.isEmpty((String)indexValue)) {
            list.add(indexValue);
        }
        key = new StringBuilder(KEY_DIRECTORY_POI);
        key.append('_');
        key.append(country);
        value = properties.getProperty(key.toString());
        key = new StringBuilder(KEY_INDEX_POI);
        key.append('_');
        key.append(country);
        indexValue = properties.getProperty(key.toString());
        if (!StringUtilities.isEmpty((String)value) && !StringUtilities.isEmpty((String)indexValue)) {
            list.add(indexValue);
        }
        return list;
    }

    public IDictionarySearchPriority getDictionarySearchPriority() {
        List<WrapperDataInfo> dictionaries = this.getConfiguredDictionaryList();
        DictionarySearchPriority aDSP = new DictionarySearchPriority(dictionaries.size());
        for (int i = 0; i < dictionaries.size(); ++i) {
            WrapperDataInfo wrapperDataInfo = dictionaries.get(i);
            String dictName = wrapperDataInfo.getDictionaryName();
            int cfgIdx = i + 1;
            aDSP.addDictionary(cfgIdx, true, dictName, cfgIdx, wrapperDataInfo.isCustomData());
        }
        return aDSP;
    }

    public static List<File> findDictionaryFiles(String baseName) throws FileNotFoundException {
        FileFilter childFilter;
        File[] children;
        if (baseName == null) {
            throw new FileNotFoundException("invalid path for rdx files: null");
        }
        File base = new File(baseName);
        if (!base.exists()) {
            throw new FileNotFoundException("invalid path for rdx files: " + baseName);
        }
        ArrayList<File> rdxFiles = new ArrayList<File>();
        FilenameFilter rdxFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rdx");
            }
        };
        File[] theseFiles = base.listFiles(rdxFilter);
        if (theseFiles != null && theseFiles.length > 0) {
            rdxFiles.addAll(Arrays.asList(theseFiles));
        }
        if ((children = base.listFiles(childFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                rdxFiles.addAll(AutoSuggestFactorySettingsProvider.findDictionaryFiles(children[i].getAbsolutePath()));
            }
        }
        return rdxFiles;
    }

    public static boolean isUserDictionary(File aDictionary) throws InitializationFailureException {
        return AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary).isCustomData();
    }

    public static List<String> getSupportedCountriesFromDictionary(File aDictionary) throws InitializationFailureException {
        String sc;
        ArrayList<String> countries = new ArrayList<String>();
        AddressMetaData theMetaData = AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary).getAddressMetaData();
        if (theMetaData != null && (sc = theMetaData.getSupportedCountries()) != null && sc.length() > 0) {
            countries.addAll(Arrays.asList(sc.split("\\W+")));
        }
        return countries;
    }

    public static Set<String> getSupportedCountries(String directory) throws InitializationFailureException {
        TreeSet<String> countries = new TreeSet<String>();
        try {
            for (File aFile : AutoSuggestFactorySettingsProvider.findDictionaryFiles(directory)) {
                countries.addAll(AutoSuggestFactorySettingsProvider.getSupportedCountriesFromDictionary(aFile));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new InitializationFailureException(fnfe);
        }
        return countries;
    }

    public static int getDictionaryType(File aDictionary) throws InitializationFailureException {
        return AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary).getDataSetType();
    }

    public static String getDictionaryDataVintage(File aDictionary) throws InitializationFailureException {
        return AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary).getAddressMetaData().getDataVintage();
    }

    public static String getDictionaryDataProductCode(File aDictionary) throws InitializationFailureException {
        return AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary).getAddressMetaData().getDataProductCode();
    }

    public static AutoSuggestDictionaryMetaData getAutoSuggestDictionaryMetaData(File aDictionary) throws InitializationFailureException {
        return new AutoSuggestDictionaryMetaData(AutoSuggestFactorySettingsProvider.getMetaDataHandlerForDictionary(aDictionary), aDictionary);
    }

    static AutoSuggestHandler getMetaDataHandlerForDictionary(File aDictionary) throws InitializationFailureException {
        try {
            if (aDictionary == null) {
                throw new FileNotFoundException("dictionary file not found: 'null'");
            }
            if (!aDictionary.getName().endsWith(".rdx")) {
                throw new FileNotFoundException("expected .rdx file, but got: '" + aDictionary.getAbsolutePath() + "'");
            }
            if (!aDictionary.exists() || !aDictionary.isFile()) {
                throw new FileNotFoundException("dictionary file not found: '" + aDictionary.getAbsolutePath() + "'");
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new InitializationFailureException(fnfe);
        }
        AutoSuggestHandler theHandler = new AutoSuggestHandler();
        theHandler.loadMetadata(aDictionary.getPath(), aDictionary.getParent());
        return theHandler;
    }

    private static class DictionaryPrioritizer
    implements Comparator<WrapperDataInfo> {
        IDictionarySearchPriority priority;

        public DictionaryPrioritizer(IDictionarySearchPriority priority) {
            this.priority = priority;
            if (priority == null) {
                throw new RuntimeException("Do not create DictionaryPrioritizer with null priority");
            }
        }

        @Override
        public int compare(WrapperDataInfo o1, WrapperDataInfo o2) {
            int order2;
            String name1 = o1.getDictionaryName();
            String name2 = o2.getDictionaryName();
            int order1 = this.priority.getSearchPriorityForDictionary(name1);
            if (order1 > (order2 = this.priority.getSearchPriorityForDictionary(name2))) {
                return 1;
            }
            if (order2 > order1) {
                return -1;
            }
            return 0;
        }
    }
}

