/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.RangeFilter;
import com.mapinfo.mapmarker.autosuggest.SimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.IDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.compress.StringCompressor;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGESeekableStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.cgge.utils.io.ReadOnlyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddressIOHandler
implements IDataReader {
    public static String ADDRESS_DICT_SUFFIX = ".add";
    public static final int DEFAULT_AREA_ID = 100;
    private ICGGEDataInputStream dataStream;
    private IOUtil.IO_MODE mode;
    private CustomIndexArray areaIdOffsets;
    private AddressMetaData metaData = new AddressMetaData();

    public static AddressIOHandler create(String dataPath, String dataName, AddressMetaData metaData, StringCompressor strCompressor) throws IOException {
        ICGGEDataStream dataStream = (ICGGEDataStream)AddressIOHandler.getDataStream(dataPath, dataName, IOUtil.IO_MODE.READ_WRITE, strCompressor);
        long streamLength = new File(AddressIOHandler.getFullPath(dataPath, dataName)).length();
        return AddressIOHandler.create(dataStream, streamLength, metaData);
    }

    public static AddressIOHandler create(ICGGEDataStream dataStream, long streamLength, AddressMetaData metaData) throws IOException {
        metaData.write((ICGGEDataOutput)dataStream);
        AddressIOHandler handler = new AddressIOHandler();
        handler.dataStream = dataStream;
        handler.mode = IOUtil.IO_MODE.READ_WRITE;
        handler.metaData = metaData;
        return handler;
    }

    private static ICGGESeekableStream getDataStream(String dataPath, String dataName, IOUtil.IO_MODE mode, StringCompressor strCompressor) throws IOException {
        String fullPath = AddressIOHandler.getFullPath(dataPath, dataName);
        if (mode == IOUtil.IO_MODE.READ_WRITE) {
            if (strCompressor != null) {
                return DataStreamFactory.getCompressedDataStream((String)fullPath, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (StringCompressor)strCompressor);
            }
            return DataStreamFactory.getDataStream((String)fullPath, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
        }
        if (strCompressor != null) {
            return DataStreamFactory.getCompressedDataInputStream((String)fullPath, (StringCompressor)strCompressor, (int)2048);
        }
        return DataStreamFactory.getInputDataStream((String)fullPath);
    }

    public void load(String dataPath, String dataName, StringCompressor compressor) throws IOException {
        ICGGEDataInputStream dataInputStream = (ICGGEDataInputStream)AddressIOHandler.getDataStream(dataPath, dataName, IOUtil.IO_MODE.READ_ONLY, compressor);
        long streamLength = new File(AddressIOHandler.getFullPath(dataPath, dataName)).length();
        this.load(dataInputStream, streamLength);
    }

    void load(ICGGEDataInputStream dataStream, long streamLength) throws IOException {
        this.metaData.read((ICGGEDataInput)dataStream);
        long offset = dataStream.seekEnd();
        dataStream.seek(offset - 8L);
        long groupOffsetStart = dataStream.readLong();
        dataStream.seek(groupOffsetStart);
        this.areaIdOffsets = this.readAreaIDs((ICGGEDataInput)dataStream, streamLength);
        this.mode = IOUtil.IO_MODE.READ_ONLY;
        this.dataStream = dataStream;
    }

    @Override
    public AddressMetaData getMetaData() {
        return this.metaData;
    }

    private static String getFullPath(String dataPath, String dataName) {
        return MMUtils.appendToPath((String)dataPath, (String)(dataName + ADDRESS_DICT_SUFFIX));
    }

    private CustomIndexArray readAreaIDs(ICGGEDataInput in, long streamLength) throws IOException {
        int size = in.readInt();
        CustomIndexArray areaIdArray = new CustomIndexArray(size + 1, 100, streamLength);
        for (int i = 0; i < size; ++i) {
            int id = in.readInt();
            long offset = in.readVUnsignedLong();
            areaIdArray.setValue(id, offset);
        }
        return areaIdArray;
    }

    private void writeAreaIDs(ICGGEDataOutput out) throws IOException {
        out.writeInt(this.areaIdOffsets.size());
        for (int id : this.areaIdOffsets.keySet()) {
            out.writeInt(id);
            out.writeVUnsignedLong(this.areaIdOffsets.getValue(id));
        }
    }

    public void prepareAreaIdStorage(Collection<Integer> ids) {
        int minimum = Integer.MAX_VALUE;
        for (int i : ids) {
            if (i >= minimum) continue;
            minimum = i;
        }
        this.areaIdOffsets = new CustomIndexArray(ids.size(), minimum, 0L);
    }

    public long writeAddressGroup(List<SimpleStreetAddress> addrs, int areaId, int geoHash) throws IOException {
        this.checkWritable();
        ICGGEDataStream dataStream = this.getWritableDataStream();
        long groupOffset = dataStream.offset();
        dataStream.writeInt(geoHash);
        int addrCount = addrs.size();
        dataStream.writeVUnsignedInt(addrCount);
        long addressOffsets = dataStream.offset();
        this.writeOffset(new int[addrCount], (ICGGEDataOutput)dataStream);
        int[] addrOffsets = this.writeAddresses(addrs, dataStream, groupOffset);
        long endOffset = dataStream.offset();
        dataStream.seek(addressOffsets);
        this.writeOffset(addrOffsets, (ICGGEDataOutput)dataStream);
        this.areaIdOffsets.setValue(areaId, groupOffset);
        dataStream.seek(endOffset);
        return groupOffset;
    }

    private ICGGEDataStream getWritableDataStream() {
        if (this.dataStream instanceof ICGGEDataStream) {
            return (ICGGEDataStream)this.dataStream;
        }
        return null;
    }

    private void writeOffset(int[] offsets, ICGGEDataOutput out) throws IOException {
        for (int offset : offsets) {
            out.writeInt(offset);
        }
    }

    private int[] writeAddresses(List<SimpleStreetAddress> addrs, ICGGEDataStream out, long startOffset) throws IOException {
        int addrCount = addrs.size();
        int[] addrOffsets = new int[addrCount];
        for (int i = 0; i < addrCount; ++i) {
            addrOffsets[i] = (int)(out.offset() - startOffset);
            addrs.get(i).write((ICGGEDataOutput)out);
        }
        return addrOffsets;
    }

    public List<SimpleStreetAddress> readAddressGroup(int areaId) throws IOException {
        return this.readAddressGroup(areaId, null);
    }

    public List<SimpleStreetAddress> readAddressGroup(int areaId, int ... requiredAddressIDs) throws IOException {
        long offset = this.areaIdOffsets.getValue(areaId);
        if (offset == 0L) {
            throw new IllegalArgumentException("group id does not exist");
        }
        List<SimpleStreetAddress> addresses = this.readAddressGroupAtOffset(offset, requiredAddressIDs);
        for (SimpleStreetAddress address : addresses) {
            AddressPtr addrPtr = address.getAddressPtr();
            if (addrPtr == null) continue;
            address.getAddressPtr().setAreaId(areaId);
        }
        return addresses;
    }

    public SimpleStreetAddress readAddress(int areaId, int addrID) throws IOException {
        long offset = this.areaIdOffsets.getValue(areaId);
        if (offset == 0L) {
            throw new IllegalArgumentException("group id does not exist");
        }
        AddressPtr addrPtr = new AddressPtr(areaId, addrID);
        SimpleStreetAddress addr = this.readAddressGroupAtOffset(offset, addrID);
        addr.setAddressPtr(addrPtr);
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SimpleStreetAddress> readAddressGroupAtOffset(long offset, int ... requiredAddressIDs) throws IOException {
        ICGGEDataInputStream iCGGEDataInputStream = this.dataStream;
        synchronized (iCGGEDataInputStream) {
            this.dataStream.seek(offset);
            int geoHash = this.dataStream.readInt();
            int addrCount = this.dataStream.readVUnsignedInt();
            int[] addressOffsets = this.readOffsets(addrCount, (ICGGEDataInput)this.dataStream);
            addressOffsets = this.filterAddressOffsets(addressOffsets, requiredAddressIDs);
            List<SimpleStreetAddress> addresses = this.readAddresses(addressOffsets, this.dataStream, offset, geoHash);
            if (requiredAddressIDs != null) {
                for (int i = 0; i < requiredAddressIDs.length; ++i) {
                    if (addresses.get(i) == null) continue;
                    AddressPtr ptr = new AddressPtr(-1, requiredAddressIDs[i]);
                    addresses.get(i).setAddressPtr(ptr);
                }
            } else {
                for (int i = 0; i < addresses.size(); ++i) {
                    if (addresses.get(i) == null) continue;
                    AddressPtr ptr = new AddressPtr(-1, i);
                    addresses.get(i).setAddressPtr(ptr);
                }
            }
            return addresses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleStreetAddress readAddressGroupAtOffset(long offset, int addrID) throws IOException {
        ICGGEDataInputStream iCGGEDataInputStream = this.dataStream;
        synchronized (iCGGEDataInputStream) {
            this.dataStream.seek(offset);
            int geoHash = this.dataStream.readInt();
            int addrCount = this.dataStream.readVUnsignedInt();
            return this.readAddressAtOffset(this.dataStream, offset + (long)this.readAddressOffset(this.dataStream, addrID));
        }
    }

    private int readAddressOffset(ICGGEDataInputStream dataStream, int addrID) throws IOException {
        dataStream.skipBytes(addrID * 4);
        return dataStream.readInt();
    }

    public void commit() throws IOException {
        if (this.mode == IOUtil.IO_MODE.READ_WRITE) {
            ICGGEDataStream dataStream = this.getWritableDataStream();
            long offset = dataStream.seekEnd();
            this.writeAreaIDs((ICGGEDataOutput)dataStream);
            dataStream.writeLong(offset);
            this.mode = IOUtil.IO_MODE.READ_ONLY;
        }
    }

    private void checkWritable() {
        if (this.mode != IOUtil.IO_MODE.READ_WRITE) {
            throw new ReadOnlyException();
        }
    }

    public void close() throws IOException {
        this.dataStream.close();
    }

    private int[] filterAddressOffsets(int[] addressOffsets, int[] requiredAddressIDs) {
        int reqSize;
        int n = reqSize = requiredAddressIDs == null ? 0 : requiredAddressIDs.length;
        if (reqSize == 0 || addressOffsets.length == reqSize) {
            return addressOffsets;
        }
        int[] newAddressOffsets = new int[reqSize];
        for (int i = 0; i < reqSize; ++i) {
            newAddressOffsets[i] = addressOffsets[requiredAddressIDs[i]];
        }
        return newAddressOffsets;
    }

    private int[] readOffsets(int size, ICGGEDataInput in) throws IOException {
        int[] offsets = new int[size];
        in.readInts(offsets);
        return offsets;
    }

    private List<SimpleStreetAddress> readAddresses(int[] addressOffsets, ICGGEDataInputStream in, long startOffset, int geoHash) throws IOException {
        ArrayList<SimpleStreetAddress> addrList = new ArrayList<SimpleStreetAddress>(addressOffsets.length);
        for (int offset : addressOffsets) {
            SimpleStreetAddress addr = this.readAddressAtOffset(in, startOffset + (long)offset);
            addr.setGeoHash(geoHash);
            addrList.add(addr);
        }
        return addrList;
    }

    private SimpleStreetAddress readAddressAtOffset(ICGGEDataInputStream in, long offset) throws IOException {
        SimpleStreetAddress addr = this.getNewStreetAddress();
        in.seek(offset);
        addr.read((ICGGEDataInput)in);
        return addr;
    }

    private SimpleStreetAddress getNewStreetAddress() {
        return new SimpleStreetAddress();
    }

    public Collection<Integer> getSacs() {
        return this.areaIdOffsets.keySet();
    }

    @Override
    public SimpleAddress getAddress(int sac, int id, RangeFilter rangeFilter) throws IOException {
        SimpleStreetAddress addr = this.readAddress(sac, id);
        List<SimpleRange> matchingRanges = this.getMatchingRange(addr, rangeFilter);
        if (rangeFilter != null && rangeFilter.hasInputHnr() && (matchingRanges == null || matchingRanges.isEmpty())) {
            return null;
        }
        SimpleAddress simpleAddr = new SimpleAddress();
        this.copyAddressFields(simpleAddr, addr, matchingRanges == null || matchingRanges.isEmpty() ? addr.getFirstRange() : matchingRanges.get(0));
        this.addRanges(simpleAddr, matchingRanges == null || matchingRanges.isEmpty() ? addr.getRanges() : matchingRanges);
        Rectangle bounds = addr.getBounds();
        simpleAddr.setBounds(bounds);
        double[] midPoint = bounds.getMidPoint();
        simpleAddr.setCentroid(midPoint);
        return simpleAddr;
    }

    List<SimpleRange> getMatchingRange(SimpleStreetAddress addr, RangeFilter rangeFilter) {
        List<SimpleRange> ranges = null;
        if (rangeFilter != null) {
            ranges = rangeFilter.getMatchingRange(addr);
        }
        if (ranges == null) {
            ranges = Collections.emptyList();
        }
        return ranges;
    }

    private void addRanges(SimpleAddress addr, List<SimpleRange> ranges) {
        SimpleRange matchedRange;
        addr.addRange(ranges);
        if (ranges != null && !ranges.isEmpty() && ((matchedRange = ranges.get(0)).isInputNumberMatched() || matchedRange.isMatchedOnRangeField())) {
            addr.setMatchedRange(matchedRange);
        }
    }

    public void copyAddressFields(SimpleAddress addr, SimpleStreetAddress streetAddr, SimpleRange range) {
        HashMap<Integer, List<String>> fields = new HashMap<Integer, List<String>>(streetAddr.getFields());
        if (range != null) {
            Map<Integer, List<String>> rangeFields = range.getFields();
            if (rangeFields != null) {
                fields.putAll(rangeFields);
            }
            if (range.getFrom() != null && range.getTo() == null) {
                addr.setHNR(range.getFrom());
            }
            addr.setHnrMatched(range.isInputNumberMatched());
        }
        addr.setFields(fields);
        addr.setAddressPtr(streetAddr.getAddressPtr());
    }

    @Override
    public String getFieldName(int fieldID) {
        return this.metaData.getFieldName(fieldID);
    }

    @Override
    public int getFieldID(String fieldName) {
        return this.metaData.getFieldID(fieldName);
    }

    @Override
    public Map<Integer, String> getFields() {
        return this.metaData.getFieldMap();
    }

    class CustomIndexArray {
        private long[] storageLong;
        private int[] storageInt;
        private int offset;
        private boolean useLong = true;

        CustomIndexArray(int size, int startingIndex, long maxValue) {
            this.offset = startingIndex;
            boolean bl = this.useLong = maxValue > Integer.MAX_VALUE || maxValue < 1L;
            if (this.useLong) {
                this.storageLong = new long[size];
            } else {
                this.storageInt = new int[size];
            }
        }

        void setValue(int index, long value) {
            if (this.useLong) {
                this.storageLong[index - this.offset] = value;
            } else {
                if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                    throw new IllegalArgumentException(value + ": value exceeds int capacity. index = " + index);
                }
                this.storageInt[index - this.offset] = (int)value;
            }
        }

        long getValue(int index) {
            return this.useLong ? this.storageLong[index - this.offset] : (long)this.storageInt[index - this.offset];
        }

        Collection<Integer> keySet() {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            if (this.useLong) {
                for (int i = this.offset; i < this.offset + this.storageLong.length; ++i) {
                    indices.add(i);
                }
            } else {
                for (int i = this.offset; i < this.offset + this.storageInt.length; ++i) {
                    indices.add(i);
                }
            }
            return indices;
        }

        int size() {
            return this.useLong ? this.storageLong.length : this.storageInt.length;
        }
    }
}

