/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddressMetaData
implements IDataItem {
    public static final int CURRENT_VERSION = 8;
    private static final Set<Integer> areaFieldIDs;
    private static final Set<Integer> addressFieldIDs;
    private static final Set<Integer> rangeFieldIDs;
    private static final Set<Integer> unitFieldIDs;
    private static final List<Integer> areaFieldPriorityList;
    public static final String DATA_VINTAGE_KEY_NAME = "dataVintage";
    public static final String SUPPORTED_COUNTRIES_KEY_NAME = "supportedCountries";
    public static final String DATA_PRODUCT_CODE_KEY_NAME = "dataProductCode";
    public static final String DATA_TYPE_KEY_NAME = "dataType";
    public static final String IS_CUSTOM_DICT_KEY_NAME = "isCustomDict";
    public static final String DATA_LANGUAGE_KEY_NAME = "dataLanguage";
    public static final String CATEGORY_FIELD_NAME;
    public static final String SUB_CATEGORY_FIELD_NAME;
    private Map<String, Object> additionalMetaData;
    private int[] lastLineFormatFields;
    private int[] streetFormatFields;
    private String streetFormatPattern = "";
    private String lastLineFormatPattern = "";
    private int version = 8;
    private Map<Integer, String> fieldNameMap;
    private String dataName;
    public static final String KEY_ADDITIONALFIELDS = "additionalFields";
    private Map<String, FieldType> additionalSeachfieldNameMap;

    public AddressMetaData(String dataName, Map<Integer, String> fieldNameMap, int[] streetFormatFields, int[] lastlineFormatFields) {
        this.dataName = dataName;
        this.fieldNameMap = fieldNameMap;
        this.streetFormatFields = streetFormatFields;
        this.lastLineFormatFields = lastlineFormatFields;
        this.additionalMetaData = new HashMap<String, Object>(10);
    }

    public AddressMetaData() {
        this("", new HashMap<Integer, String>(10), null, null);
    }

    public AddressMetaData(String dataName, Map<Integer, String> fieldNameMap) {
        this(dataName, fieldNameMap, null, null);
    }

    public AddressMetaData(String dataName, Map<Integer, String> fieldNameMap, int[] streetFormatFields, int[] lastlineFormatFields, Map<String, Object> additionalMetaData) {
        this(dataName, fieldNameMap, streetFormatFields, lastlineFormatFields);
        this.additionalMetaData = additionalMetaData;
    }

    public AddressMetaData(String dataName, Map<Integer, String> fieldNameMap, int[] streetFormatFields, int[] lastlineFormatFields, Map<String, Object> additionalMetaData, String streetFormatPattern, String lastLineFormatPattern) {
        this(dataName, fieldNameMap, streetFormatFields, lastlineFormatFields, additionalMetaData);
        this.lastLineFormatPattern = lastLineFormatPattern;
        this.streetFormatPattern = streetFormatPattern;
    }

    public void read(ICGGEDataInput in) throws IOException {
        short value;
        int i;
        this.version = in.readInt();
        this.dataName = in.readUTF();
        int fieldCount = in.readInt();
        this.fieldNameMap = new HashMap<Integer, String>(10);
        for (i = 0; i < fieldCount; ++i) {
            this.fieldNameMap.put(in.readInt(), in.readUTF());
        }
        if (this.version >= 2) {
            fieldCount = in.readInt();
            if (fieldCount != 0) {
                this.streetFormatFields = new int[fieldCount];
                for (i = 0; i < fieldCount; ++i) {
                    this.streetFormatFields[i] = in.readInt();
                }
            }
            if ((fieldCount = in.readInt()) != 0) {
                this.lastLineFormatFields = new int[fieldCount];
                for (i = 0; i < fieldCount; ++i) {
                    this.lastLineFormatFields[i] = in.readInt();
                }
            }
        }
        if (this.version >= 3 && (value = in.readShort()) == 1) {
            this.additionalMetaData.put(SUPPORTED_COUNTRIES_KEY_NAME, in.readUTF());
        }
        if (this.version >= 4 && (value = in.readShort()) == 1) {
            this.additionalMetaData.put(DATA_VINTAGE_KEY_NAME, in.readUTF());
        }
        if (this.version >= 5) {
            value = in.readShort();
            if (value == 1) {
                this.additionalMetaData.put(DATA_PRODUCT_CODE_KEY_NAME, in.readUTF());
            }
            if ((value = in.readShort()) == 1) {
                this.additionalMetaData.put(DATA_TYPE_KEY_NAME, in.readInt());
            }
            this.additionalMetaData.put(IS_CUSTOM_DICT_KEY_NAME, in.readBoolean());
        }
        if (this.version >= 6 && (value = in.readShort()) == 1) {
            this.additionalMetaData.put(DATA_LANGUAGE_KEY_NAME, in.readUTF());
        }
        this.readAdditionalFields(in);
        this.readFormatingPatternForStreetAndLocation(in);
    }

    private void readAdditionalFields(ICGGEDataInput in) throws IOException {
        if (this.version >= 7) {
            int value = in.readShort();
            this.additionalSeachfieldNameMap = new HashMap<String, FieldType>(10);
            for (int i = 0; i < value; ++i) {
                int fieldKey = in.readInt();
                int level = in.readInt();
                String name = in.readUTF();
                if (StringUtilities.isEmpty((String)name)) continue;
                FieldType type = new FieldType(fieldKey, FieldType.FieldLevel.getLevelAsEnum((int)level), name);
                this.additionalSeachfieldNameMap.put(type.getName(), type);
            }
        }
    }

    private void readFormatingPatternForStreetAndLocation(ICGGEDataInput in) throws IOException {
        if (this.version >= 8) {
            this.streetFormatPattern = in.readUTF();
            this.lastLineFormatPattern = in.readUTF();
        }
    }

    public void write(ICGGEDataOutput out) throws IOException {
        out.writeInt(this.version);
        out.writeUTF(this.dataName);
        out.writeInt(this.fieldNameMap.size());
        for (Map.Entry<Integer, String> en : this.fieldNameMap.entrySet()) {
            out.writeInt(en.getKey().intValue());
            out.writeUTF(en.getValue());
        }
        if (this.streetFormatFields == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.streetFormatFields.length);
            for (int i = 0; i < this.streetFormatFields.length; ++i) {
                out.writeInt(this.streetFormatFields[i]);
            }
        }
        if (this.lastLineFormatFields == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.lastLineFormatFields.length);
            for (int i = 0; i < this.lastLineFormatFields.length; ++i) {
                out.writeInt(this.lastLineFormatFields[i]);
            }
        }
        if (!this.additionalMetaData.containsKey(SUPPORTED_COUNTRIES_KEY_NAME)) {
            out.writeShort(0);
        } else {
            out.writeShort(1);
            out.writeUTF((String)this.additionalMetaData.get(SUPPORTED_COUNTRIES_KEY_NAME));
        }
        if (!this.additionalMetaData.containsKey(DATA_VINTAGE_KEY_NAME)) {
            out.writeShort(0);
        } else {
            out.writeShort(1);
            out.writeUTF((String)this.additionalMetaData.get(DATA_VINTAGE_KEY_NAME));
        }
        if (!this.additionalMetaData.containsKey(DATA_PRODUCT_CODE_KEY_NAME)) {
            out.writeShort(0);
        } else {
            out.writeShort(1);
            out.writeUTF((String)this.additionalMetaData.get(DATA_PRODUCT_CODE_KEY_NAME));
        }
        if (!this.additionalMetaData.containsKey(DATA_TYPE_KEY_NAME)) {
            out.writeShort(0);
        } else {
            out.writeShort(1);
            out.writeInt(((Integer)this.additionalMetaData.get(DATA_TYPE_KEY_NAME)).intValue());
        }
        Boolean isCustomData = this.additionalMetaData.containsKey(IS_CUSTOM_DICT_KEY_NAME) ? (Boolean)this.additionalMetaData.get(IS_CUSTOM_DICT_KEY_NAME) : false;
        out.writeBoolean(isCustomData.booleanValue());
        if (!this.additionalMetaData.containsKey(DATA_LANGUAGE_KEY_NAME)) {
            out.writeShort(0);
        } else {
            out.writeShort(1);
            out.writeUTF((String)this.additionalMetaData.get(DATA_LANGUAGE_KEY_NAME));
        }
        this.writeAdditionalFields(out);
        this.writeFormatingPatternForStreetAndLocation(out);
    }

    private void writeAdditionalFields(ICGGEDataOutput out) throws IOException {
        if (!this.additionalMetaData.containsKey(KEY_ADDITIONALFIELDS)) {
            out.writeShort(0);
        } else {
            Map additioanlFieldMap = (Map)this.additionalMetaData.get(KEY_ADDITIONALFIELDS);
            out.writeShort(additioanlFieldMap.size());
            for (Map.Entry en : additioanlFieldMap.entrySet()) {
                out.writeInt(((FieldType)en.getValue()).getKey());
                out.writeInt(((FieldType)en.getValue()).getLevel().getLevelAsInt());
                out.writeUTF(((FieldType)en.getValue()).getName());
            }
        }
    }

    private void writeFormatingPatternForStreetAndLocation(ICGGEDataOutput out) throws IOException {
        out.writeUTF(this.streetFormatPattern);
        out.writeUTF(this.lastLineFormatPattern);
    }

    public <T extends IDataItem> T getNewInstance() {
        return (T)new AddressMetaData();
    }

    public String getFieldName(int fieldID) {
        Map<Integer, String> fields = this.getFieldMap();
        if (fields != null) {
            return fields.get(fieldID);
        }
        return null;
    }

    public int getFieldID(String fieldName) {
        Map<Integer, String> fields = this.getFieldMap();
        if (fields != null) {
            for (Map.Entry<Integer, String> fieldEn : fields.entrySet()) {
                if (!fieldEn.getValue().equals(fieldName)) continue;
                return fieldEn.getKey();
            }
        }
        return -1;
    }

    public boolean isAreaField(int fieldID) {
        return areaFieldIDs.contains(fieldID);
    }

    public FieldType.FieldLevel getLevel(int fieldID) {
        FieldType knownType = FieldType.getPredefinedField((int)fieldID);
        if (knownType != null) {
            return knownType.getLevel();
        }
        return this.getLevelForAdditionalField(fieldID);
    }

    public void setFieldMap(Map<Integer, String> fieldMap) {
        this.fieldNameMap = fieldMap;
    }

    public void setDataName(String name) {
        this.dataName = name;
    }

    public int getVersion() {
        return this.version;
    }

    public Map<Integer, String> getFieldMap() {
        return this.fieldNameMap;
    }

    public String getDataName() {
        return this.dataName;
    }

    public List<Integer> getAreaFieldPriorityList() {
        return areaFieldPriorityList;
    }

    public int[] getStreetFormatFields() {
        return this.streetFormatFields;
    }

    public int[] getLastlineFormatFields() {
        return this.lastLineFormatFields;
    }

    public String getSupportedCountries() {
        return this.additionalMetaData.containsKey(SUPPORTED_COUNTRIES_KEY_NAME) ? (String)this.additionalMetaData.get(SUPPORTED_COUNTRIES_KEY_NAME) : "";
    }

    public String getDataVintage() {
        return this.additionalMetaData.containsKey(DATA_VINTAGE_KEY_NAME) ? (String)this.additionalMetaData.get(DATA_VINTAGE_KEY_NAME) : "";
    }

    public String getDataProductCode() {
        return this.additionalMetaData.containsKey(DATA_PRODUCT_CODE_KEY_NAME) ? (String)this.additionalMetaData.get(DATA_PRODUCT_CODE_KEY_NAME) : "";
    }

    public int getDataSetType() {
        return this.additionalMetaData.containsKey(DATA_TYPE_KEY_NAME) ? (Integer)this.additionalMetaData.get(DATA_TYPE_KEY_NAME) : -1;
    }

    public boolean isCustomData() {
        return this.additionalMetaData.containsKey(IS_CUSTOM_DICT_KEY_NAME) ? (Boolean)this.additionalMetaData.get(IS_CUSTOM_DICT_KEY_NAME) : false;
    }

    public String getLanguage() {
        return this.additionalMetaData.containsKey(DATA_LANGUAGE_KEY_NAME) ? (String)this.additionalMetaData.get(DATA_LANGUAGE_KEY_NAME) : "";
    }

    public List<Integer> getAdditionalFieldsForLevel(int level) {
        ArrayList<Integer> fieldList = new ArrayList<Integer>();
        if (this.additionalSeachfieldNameMap != null) {
            for (Map.Entry<String, FieldType> en : this.additionalSeachfieldNameMap.entrySet()) {
                int fieldLevel = en.getValue().getLevel().getLevelAsInt();
                if (level != fieldLevel) continue;
                fieldList.add(en.getValue().getKey());
            }
        }
        return fieldList;
    }

    private FieldType.FieldLevel getLevelForAdditionalField(int fieldID) {
        if (this.additionalSeachfieldNameMap != null) {
            for (Map.Entry<String, FieldType> en : this.additionalSeachfieldNameMap.entrySet()) {
                FieldType type = en.getValue();
                if (type.getKey() != fieldID) continue;
                return en.getValue().getLevel();
            }
        }
        return FieldType.FieldLevel.LEVEL_UNKNOWN;
    }

    public Map<String, FieldType> getAdditionalFields() {
        return this.additionalSeachfieldNameMap;
    }

    public String getStreetFormatPattern() {
        return this.streetFormatPattern;
    }

    public String getLastLinetFormatPattern() {
        return this.lastLineFormatPattern;
    }

    static {
        addressFieldIDs = new HashSet<Integer>();
        rangeFieldIDs = new HashSet<Integer>();
        unitFieldIDs = new HashSet<Integer>();
        CATEGORY_FIELD_NAME = FieldType.GENERIC_FIELD_3_FIELD_TYPE.getName();
        SUB_CATEGORY_FIELD_NAME = FieldType.GENERIC_FIELD_4_FIELD_TYPE.getName();
        List areaFields = FieldType.getPredefinedFieldTypes((FieldType.FieldLevel)FieldType.FieldLevel.LEVEL_POSTAL);
        HashSet<Integer> areaFieldIds = new HashSet<Integer>(areaFields.size());
        for (FieldType type : areaFields) {
            areaFieldIds.add(type.getKey());
        }
        areaFieldIDs = areaFieldIds;
        areaFieldPriorityList = Arrays.asList(FieldType.AREA_NAME_4_FIELD_TYPE.getKey(), FieldType.POST_CODE_FIELD_TYPE.getKey(), FieldType.AREA_NAME_3_FIELD_TYPE.getKey(), FieldType.AREA_NAME_2_FIELD_TYPE.getKey(), FieldType.AREA_NAME_1_FIELD_TYPE.getKey());
    }
}

