/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AddressPtr
implements IDataItem,
Iterable<SubLevelIterator.Pair<Integer, Integer>> {
    private int areaId;
    private List<NumberRange> addrIDRanges;
    private byte addrNumRangeHash;

    public AddressPtr() {
        this(0);
    }

    public AddressPtr(int areaID) {
        this.areaId = areaID;
        this.setAddressIDRanges(new ArrayList<NumberRange>(1));
    }

    public AddressPtr(int areaID, int addrID) {
        this(areaID);
        this.addAddressID(addrID);
    }

    public AddressPtr(int areaID, int[] addrIds) {
        this(areaID, 0, addrIds);
    }

    public AddressPtr(int areaID, byte addrNumRangeHash, int[] addrIds) {
        this(areaID);
        for (int addrId : addrIds) {
            this.addAddressID(addrId);
        }
        this.setAreaAddrNumberRangeHash(addrNumRangeHash);
    }

    public void setAreaId(int areaID) {
        this.areaId = areaID;
    }

    public int getAreaID() {
        return this.areaId;
    }

    public void addAddressID(int addrID) {
        if (addrID < 0) {
            throw new IllegalArgumentException("Address id cannot be nagative");
        }
        this.addToIDRange(addrID, addrID, this.getAddressIDRanges());
    }

    public int getAddressIDCount() {
        int count = 0;
        for (NumberRange range : this.getAddressIDRanges()) {
            count += range.getEnd() - range.getStart() + 1;
        }
        return count;
    }

    public boolean containsAddrID(int addrID) {
        int n = this.findRangeHighestRange(addrID);
        if (n > -1) {
            List<NumberRange> addrIDRanges = this.getAddressIDRanges();
            NumberRange range = addrIDRanges.get(n);
            return range.inRange(addrID);
        }
        return false;
    }

    private int findRangeHighestRange(int id) {
        NumberRange range;
        int start;
        List<NumberRange> addrIDRanges = this.getAddressIDRanges();
        int n = addrIDRanges.size();
        int nextRange = -1;
        int i = 0;
        while (i < n && (start = (range = addrIDRanges.get(i)).getStart()) <= id) {
            nextRange = i++;
        }
        return nextRange;
    }

    public AddressPtr getIntersectingAddressIDs(AddressPtr otherAddrPtr) {
        return this.localGetIntersectingAddressIDs(otherAddrPtr);
    }

    private AddressPtr localGetIntersectingAddressIDs(AddressPtr otherAddrPtr) {
        List<NumberRange> interSectingRanges;
        List<NumberRange> range1 = this.getAddressIDRanges();
        List<NumberRange> range2 = otherAddrPtr.getAddressIDRanges();
        List<NumberRange> list = interSectingRanges = range1.size() > range2.size() ? this.getIntersectingRanges(range2, range1) : this.getIntersectingRanges(range1, range2);
        if (!interSectingRanges.isEmpty()) {
            return this.copy(interSectingRanges);
        }
        return null;
    }

    private List<NumberRange> getIntersectingRanges(List<NumberRange> ranges1, List<NumberRange> ranges2) {
        int s1 = ranges1.size();
        int s2 = ranges2.size();
        ArrayList<NumberRange> interSectingRanges = new ArrayList<NumberRange>(Math.min(s1, s2));
        int i = 0;
        int j = 0;
        while (i < s1 && j < s2) {
            NumberRange range2;
            NumberRange range1 = ranges1.get(i);
            int cmp = this.compareForIntersection(range1, range2 = ranges2.get(j));
            if (cmp > 0) {
                ++j;
                continue;
            }
            if (cmp < 0) {
                ++i;
                continue;
            }
            int start1 = range1.getStart();
            int end1 = range1.getEnd();
            int start2 = range2.getStart();
            int end2 = range2.getEnd();
            interSectingRanges.add(new NumberRange(Math.max(start1, start2), Math.min(end1, end2)));
            if (end1 < end2) {
                ++i;
                continue;
            }
            if (end1 > end2) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return interSectingRanges;
    }

    private int compareForIntersection(NumberRange range1, NumberRange range2) {
        int end1;
        int start1 = range1.getStart();
        if (range2.intersects(start1, end1 = range1.getEnd())) {
            return 0;
        }
        if (end1 > range2.getStart()) {
            return 1;
        }
        return -1;
    }

    private int addToIDRange(int start, int end, List<NumberRange> idRangeList) {
        NumberRange range;
        NumberRange rangeToAdd = new NumberRange(start, end);
        if (idRangeList.isEmpty()) {
            idRangeList.add(rangeToAdd);
            return 0;
        }
        int addRangeAt = ListUtils.positionInSortedList(idRangeList, (Comparable)rangeToAdd);
        for (int i = addRangeAt - 1; i >= 0 && (range = idRangeList.get(i)).getEnd() >= start - 1; --i) {
            if (start > range.getStart()) {
                rangeToAdd.setStart(range.getStart());
            }
            idRangeList.remove(i);
            --addRangeAt;
        }
        int rangeCount = idRangeList.size();
        if (addRangeAt == rangeCount) {
            idRangeList.add(rangeToAdd);
        } else {
            NumberRange currRangeAtAddPos = idRangeList.get(addRangeAt);
            if (rangeToAdd.getStart() > currRangeAtAddPos.getEnd() || rangeToAdd.getEnd() < currRangeAtAddPos.getStart() - 1) {
                idRangeList.add(addRangeAt, rangeToAdd);
            } else {
                NumberRange nextRange;
                currRangeAtAddPos.setStart(rangeToAdd.getStart());
                if (currRangeAtAddPos.getEnd() < end) {
                    currRangeAtAddPos.setEnd(end);
                }
                if (addRangeAt < rangeCount - 1 && end + 1 == (nextRange = idRangeList.get(addRangeAt + 1)).getStart()) {
                    currRangeAtAddPos.setEnd(nextRange.getEnd());
                    idRangeList.remove(addRangeAt + 1);
                }
            }
        }
        return addRangeAt;
    }

    public void setAddressIDs(List<Integer> addrIDs) {
        ArrayList<NumberRange> addrIDRanges = new ArrayList<NumberRange>(3);
        for (int i : addrIDs) {
            this.addToIDRange(i, i, addrIDRanges);
        }
        this.setAddressIDRanges(addrIDRanges);
    }

    public Collection<Integer> getAddressIDs() {
        List<NumberRange> addrNumRange = this.getAddressIDRanges();
        return addrNumRange == null || addrNumRange.isEmpty() ? null : new AddressNdxCollection();
    }

    public int getFirstAddressID() {
        List<NumberRange> addrNumRange = this.getAddressIDRanges();
        if (addrNumRange == null || addrNumRange.isEmpty()) {
            throw new NoSuchElementException();
        }
        return addrNumRange.get(0).getStart();
    }

    public void write(ICGGEDataOutput out) throws IOException {
        out.writeVUnsignedLong((long)this.areaId);
        this.writeExcludingAreaID(out);
    }

    public void writeExcludingAreaID(ICGGEDataOutput out) throws IOException {
        out.writeByte((int)this.getAreaAddrNumberRangeHash());
        this.writeAddressNdxs(out);
    }

    public void read(ICGGEDataInput in) throws IOException {
        this.areaId = (int)in.readVUnsignedLong();
        this.readExcludingAreaID(in);
    }

    public void readExcludingAreaID(ICGGEDataInput in) throws IOException {
        this.setAreaAddrNumberRangeHash(in.readByte());
        this.readAddressNdxs(in);
    }

    private void writeAddressNdxs(ICGGEDataOutput out) throws IOException {
        this.writeNdxRanges(out, this.getAddressIDRanges());
    }

    void readAddressNdxs(ICGGEDataInput in) throws IOException {
        this.setAddressIDRanges(this.readNdxRanges(in));
    }

    private List<NumberRange> getNonRanges(List<NumberRange> ranges) {
        ArrayList<NumberRange> singleNumberRanges = new ArrayList<NumberRange>(ranges.size());
        for (NumberRange range : ranges) {
            if (range.count() != 1) continue;
            singleNumberRanges.add(range);
        }
        return singleNumberRanges;
    }

    private List<NumberRange> removeNonRanges(List<NumberRange> ranges) {
        ArrayList<NumberRange> realRanges = new ArrayList<NumberRange>(ranges.size());
        for (NumberRange range : ranges) {
            if (range.count() <= 1) continue;
            realRanges.add(range);
        }
        return realRanges;
    }

    private void writeNdxRanges(ICGGEDataOutput out, List<NumberRange> ranges) throws IOException {
        int flag;
        List<NumberRange> nonRanges = this.getNonRanges(ranges);
        int nonRangeSize = nonRanges.size();
        int rangeSize = ranges.size() - nonRangeSize;
        int n = flag = nonRangeSize > 0 ? 1 : 0;
        if (nonRangeSize > 0 && nonRangeSize < 64) {
            flag |= nonRangeSize << 2;
        }
        if (rangeSize > 0) {
            flag |= 2;
            if (nonRangeSize == 0 && rangeSize < 64) {
                flag |= rangeSize << 2;
            }
        }
        out.write(flag);
        if (nonRangeSize > 0) {
            if (nonRangeSize >= 64) {
                out.writeVUnsignedInt(nonRangeSize);
            }
            for (NumberRange range : nonRanges) {
                out.writeVUnsignedInt(range.getStart());
            }
        }
        if (rangeSize > 0) {
            ranges = this.removeNonRanges(ranges);
            if (nonRangeSize != 0 || rangeSize >= 64) {
                out.writeVUnsignedInt(ranges.size());
            }
            for (NumberRange range : ranges) {
                out.writeVUnsignedInt(range.getStart());
                out.writeVUnsignedInt(range.getEnd());
            }
        }
    }

    private List<NumberRange> readNdxRanges(ICGGEDataInput in) throws IOException {
        int size;
        int flag = in.readUnsignedByte();
        boolean hasNonRanges = (flag & 1) == 1;
        boolean hasRanges = (flag & 2) == 2;
        int sizeFromFlag = (flag & 0xFC) >> 2;
        List<NumberRange> nonRanges = null;
        List<NumberRange> ranges = null;
        if (hasNonRanges) {
            size = sizeFromFlag > 0 ? sizeFromFlag : in.readVUnsignedInt();
            sizeFromFlag = 0;
            nonRanges = this.readAddressIDRanges(in, size, true);
        }
        if (hasRanges) {
            size = sizeFromFlag > 0 ? sizeFromFlag : in.readVUnsignedInt();
            ranges = this.readAddressIDRanges(in, size, false);
        }
        if (nonRanges != null && ranges != null) {
            this.combineAddressUniqueSortedIDRanges(ranges, nonRanges);
            return ranges;
        }
        if (nonRanges != null) {
            return nonRanges;
        }
        return ranges;
    }

    private List<NumberRange> readAddressIDRanges(ICGGEDataInput in, int size, boolean singleNumber) throws IOException {
        int readSize = singleNumber ? size : size * 2;
        int[] addrIdRangeArray = new int[readSize];
        in.readVUnsignedInts(addrIdRangeArray);
        ArrayList<NumberRange> ranges = new ArrayList<NumberRange>(size);
        int inc = singleNumber ? 1 : 2;
        int i = 0;
        int j = 0;
        while (i < size) {
            int n = addrIdRangeArray[j];
            ranges.add(new NumberRange(n, singleNumber ? n : addrIdRangeArray[j + 1]));
            ++i;
            j += inc;
        }
        return ranges;
    }

    public boolean fromSameArea(AddressPtr otherAddrPtr) {
        return this.areaId == otherAddrPtr.getAreaID();
    }

    public void combine(AddressPtr addrPtr) {
        this.localCombine(addrPtr);
        this.setAreaAddrNumberRangeHash((byte)(this.getAreaAddrNumberRangeHash() | addrPtr.getAreaAddrNumberRangeHash()));
    }

    private void localCombine(AddressPtr addrPtr) {
        List<NumberRange> addrNumRanges = this.getAddressIDRanges();
        if (addrNumRanges.isEmpty()) {
            this.copyAddressIDRanges(addrPtr);
        } else {
            this.combineAddressIDRanges(addrNumRanges, addrPtr.getAddressIDRanges());
        }
    }

    private void combineAddressIDRanges(List<NumberRange> list1, List<NumberRange> list2) {
        int rangeCount = list2.size();
        int addAfter = 0;
        for (int i = 0; i < rangeCount; ++i) {
            NumberRange otherRange = list2.get(i);
            List<NumberRange> subList = list1.subList(addAfter, list1.size());
            int addedAt = this.addToIDRange(otherRange.getStart(), otherRange.getEnd(), subList);
            addAfter += addedAt;
        }
    }

    private void combineAddressUniqueSortedIDRanges(List<NumberRange> list1, List<NumberRange> list2) {
        int rangeCount1 = list1.size();
        int rangeCount2 = list2.size();
        int addAt = 0;
        for (int i = 0; i < rangeCount2; ++i) {
            boolean added = false;
            NumberRange rangeToAdd = list2.get(i);
            while (addAt < rangeCount1) {
                NumberRange range = list1.get(addAt);
                if (rangeToAdd.getEnd() < range.getStart()) {
                    list1.add(addAt, rangeToAdd);
                    ++rangeCount1;
                    added = true;
                    break;
                }
                ++addAt;
            }
            if (added) continue;
            list1.add(rangeToAdd);
        }
    }

    public AddressPtr copy() {
        AddressPtr copy = new AddressPtr(this.getAreaID());
        copy.setAreaAddrNumberRangeHash(this.getAreaAddrNumberRangeHash());
        copy.copyAddressIDRanges(this);
        return copy;
    }

    private AddressPtr copy(List<NumberRange> newRanges) {
        AddressPtr copy = new AddressPtr(this.getAreaID());
        copy.setAreaAddrNumberRangeHash(this.getAreaAddrNumberRangeHash());
        copy.setAddressIDRanges(newRanges);
        return copy;
    }

    private void copyAddressIDRanges(AddressPtr addrPtr) {
        List<NumberRange> otherRanges = addrPtr.getAddressIDRanges();
        int copyCount = otherRanges.size();
        ArrayList<NumberRange> addrIDRanges = new ArrayList<NumberRange>(copyCount);
        for (int i = 0; i < copyCount; ++i) {
            NumberRange otherRange = otherRanges.get(i);
            addrIDRanges.add(new NumberRange(otherRange.getStart(), otherRange.getEnd()));
        }
        this.setAddressIDRanges(addrIDRanges);
    }

    public AddressPtr getNewInstance() {
        return new AddressPtr();
    }

    @Override
    public Iterator<SubLevelIterator.Pair<Integer, Integer>> iterator() {
        final Iterator addrIDit = SubLevelIterator.getFromIterableSubList(this.getAddressIDRanges());
        return new ReadOnlyIterator<SubLevelIterator.Pair<Integer, Integer>>(){

            @Override
            public boolean hasNext() {
                return addrIDit.hasNext();
            }

            @Override
            public SubLevelIterator.Pair<Integer, Integer> next() {
                return new SubLevelIterator.Pair<Integer, Integer>(AddressPtr.this.areaId, (Integer)addrIDit.next());
            }
        };
    }

    public byte getAreaAddrNumberRangeHash() {
        return this.addrNumRangeHash;
    }

    public void setAreaAddrNumberRangeHash(byte hash) {
        this.addrNumRangeHash = hash;
    }

    void setAddressIDRanges(List<NumberRange> addrIDRanges) {
        this.addrIDRanges = addrIDRanges;
    }

    List<NumberRange> getAddressIDRanges() {
        return this.addrIDRanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AddressPtr: ");
        sb.append(this.areaId);
        List<NumberRange> addrNumRange = this.getAddressIDRanges();
        if (addrNumRange == null || addrNumRange.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append(Arrays.toString(new AddressNdxCollection().toArray()));
        }
        return sb.toString();
    }

    private class AddressNdxCollection
    extends AbstractCollection<Integer> {
        private AddressNdxCollection() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return SubLevelIterator.getFromIterableSubList(AddressPtr.this.getAddressIDRanges());
        }

        @Override
        public int size() {
            int n = 0;
            List<NumberRange> addrIDRanges = AddressPtr.this.getAddressIDRanges();
            if (addrIDRanges != null) {
                for (NumberRange ndxRange : addrIDRanges) {
                    n += ndxRange.count();
                }
            }
            return n;
        }
    }
}

