/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.exception.DataFetchException;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import java.util.List;

public class AddressPtrEx
extends AddressPtr {
    private byte[] m_dataBytes;

    public AddressPtrEx(int areaID, byte[] dataBytes) {
        super(areaID);
        this.m_dataBytes = dataBytes;
        this.setAreaAddrNumberRangeHash(dataBytes[0]);
    }

    @Override
    List<NumberRange> getAddressIDRanges() {
        if (this.m_dataBytes != null) {
            try {
                ICGGEDataInputStream dataInput = DataStreamFactory.getInputDataStream((byte[])this.m_dataBytes);
                dataInput.skipBytes(1);
                this.readAddressNdxs((ICGGEDataInput)dataInput);
            }
            catch (Exception ioe) {
                throw new DataFetchException(ioe);
            }
            this.m_dataBytes = null;
        }
        return super.getAddressIDRanges();
    }

    @Override
    public AddressPtr copy() {
        if (this.m_dataBytes == null) {
            return super.copy();
        }
        AddressPtrEx copy = new AddressPtrEx(this.getAreaID(), this.m_dataBytes);
        copy.setAreaAddrNumberRangeHash(this.getAreaAddrNumberRangeHash());
        return copy;
    }
}

