/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrEx;
import com.mapinfo.mapmarker.autosuggest.dp.IAddressPtrMapReadingFilter;
import com.mapinfo.mapmarker.autosuggest.dp.IAreaIDReadingFilter;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IFilterableNodeValue;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeValueFilter;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddressPtrMap
implements IFilterableNodeValue,
Iterable<AddressPtr> {
    private Map<Integer, List<AddressPtr>> m_addrPtrMap = new HashMap<Integer, List<AddressPtr>>();
    private boolean m_fullyRead = false;

    public void read(ICGGEDataInput in) throws IOException {
        this.read(in, null);
    }

    @Override
    public void read(ICGGEDataInput in, INodeValueFilter<IFilterableNodeValue> filter) throws IOException {
        this.m_fullyRead = true;
        int fields = in.readVUnsignedInt();
        IAddressPtrMapReadingFilter addrMapReadingFilter = this.getAddressMapReadingFilter(filter);
        for (int i = 0; i < fields; ++i) {
            IAreaIDReadingFilter areaIDFilter;
            int fieldID = in.readVUnsignedInt();
            int skipBytes = in.readVUnsignedInt();
            IAreaIDReadingFilter iAreaIDReadingFilter = areaIDFilter = filter == null ? null : addrMapReadingFilter.getAddressIDReadingFilter(fieldID);
            if (filter == null || areaIDFilter != null) {
                List<AddressPtr> addrPtrList = this.readAddressPtrList(in, areaIDFilter);
                if (addrPtrList == null) continue;
                this.m_addrPtrMap.put(fieldID, addrPtrList);
                continue;
            }
            this.m_fullyRead = false;
            in.skipBytes(skipBytes);
        }
    }

    private IAddressPtrMapReadingFilter getAddressMapReadingFilter(INodeValueFilter<IFilterableNodeValue> filter) {
        IAddressPtrMapReadingFilter addrMapFilter = null;
        if (filter != null && filter instanceof IAddressPtrMapReadingFilter) {
            addrMapFilter = (IAddressPtrMapReadingFilter)((Object)filter);
        }
        return addrMapFilter;
    }

    private List<AddressPtr> readAddressPtrList(ICGGEDataInput in, IAreaIDReadingFilter areaIDFilter) throws IOException {
        int size = in.readVUnsignedInt();
        if (size > 0) {
            boolean fullyRead;
            ArrayList<AddressPtr> addrPtrList = new ArrayList<AddressPtr>(areaIDFilter == null ? size : size / 2);
            for (int i = 0; i < size; ++i) {
                int areaID = (int)in.readVUnsignedLong();
                int skipBytes = in.readVUnsignedInt();
                if (areaIDFilter == null || areaIDFilter.readArea(areaID)) {
                    byte[] bytes = new byte[skipBytes];
                    in.readFully(bytes);
                    AddressPtrEx addrPtr = new AddressPtrEx(areaID, bytes);
                    addrPtrList.add(addrPtr);
                    continue;
                }
                in.skipBytes(skipBytes);
            }
            boolean bl = fullyRead = addrPtrList.size() == size;
            if (!fullyRead) {
                addrPtrList.trimToSize();
                this.m_fullyRead = false;
            }
            return addrPtrList.isEmpty() ? null : addrPtrList;
        }
        return null;
    }

    public void write(ICGGEDataOutput out) throws IOException {
        out.writeVUnsignedInt(this.m_addrPtrMap.size());
        ICGGEDataStream dummyStream = DataStreamFactory.getDataStream();
        for (Map.Entry<Integer, List<AddressPtr>> en : this.m_addrPtrMap.entrySet()) {
            int fieldID = en.getKey();
            out.writeVUnsignedInt(fieldID);
            List<AddressPtr> addrPtrList = en.getValue();
            dummyStream.seek(0L);
            this.writeAddressPtrList(addrPtrList, (ICGGEDataOutput)dummyStream);
            out.writeVUnsignedInt((int)dummyStream.offset());
            this.writeAddressPtrList(addrPtrList, out);
        }
    }

    private void writeAddressPtrList(List<AddressPtr> addrPtrList, ICGGEDataOutput out) throws IllegalArgumentException, IOException {
        int size = addrPtrList.size();
        out.writeVUnsignedInt(size);
        ICGGEDataStream dummyStream = DataStreamFactory.getDataStream();
        for (int i = 0; i < size; ++i) {
            AddressPtr addrPtr = addrPtrList.get(i);
            out.writeVUnsignedLong((long)addrPtr.getAreaID());
            dummyStream.seek(0L);
            addrPtr.writeExcludingAreaID((ICGGEDataOutput)dummyStream);
            out.writeVUnsignedInt((int)dummyStream.offset());
            addrPtr.writeExcludingAreaID(out);
        }
    }

    public List<AddressPtr> find(int fieldTypeID) {
        return this.m_addrPtrMap.get(fieldTypeID);
    }

    private void addToAddrPtrList(List<AddressPtr> list, AddressPtr addrPtr) {
        AddressPtr savedAddrPtr = AddressPtrMap.getAddressPtrFromSameArea(list, addrPtr.getAreaID());
        if (savedAddrPtr == null) {
            list.add(addrPtr);
        } else {
            savedAddrPtr.combine(addrPtr);
        }
    }

    public void addAll(int fieldID, List<AddressPtr> addrPtrList) {
        List<AddressPtr> list = this.m_addrPtrMap.get(fieldID);
        if (list == null) {
            this.m_addrPtrMap.put(fieldID, addrPtrList);
        } else {
            for (AddressPtr addrPtr : addrPtrList) {
                this.addToAddrPtrList(list, addrPtr);
            }
        }
    }

    public void add(int fieldID, AddressPtr addrPtr) {
        List<AddressPtr> list = this.m_addrPtrMap.get(fieldID);
        if (list == null) {
            list = new ArrayList<AddressPtr>();
            this.m_addrPtrMap.put(fieldID, list);
        }
        this.addToAddrPtrList(list, addrPtr);
    }

    private static AddressPtr getAddressPtrFromSameArea(List<AddressPtr> list, int areaID) {
        if (list != null) {
            for (AddressPtr addrPtr : list) {
                if (addrPtr.getAreaID() != areaID) continue;
                return addrPtr;
            }
        }
        return null;
    }

    public void combine(AddressPtrMap addrPtrMap) {
        for (Map.Entry<Integer, List<AddressPtr>> en : addrPtrMap.m_addrPtrMap.entrySet()) {
            this.addAll(en.getKey(), en.getValue());
        }
    }

    public Set<Map.Entry<Integer, List<AddressPtr>>> getEntrySet() {
        return this.m_addrPtrMap.entrySet();
    }

    public Map<Integer, List<AddressPtr>> getMap() {
        return this.m_addrPtrMap;
    }

    public void setMap(Map<Integer, List<AddressPtr>> addrPtrMap) {
        this.m_addrPtrMap = addrPtrMap;
    }

    public Collection<Integer> getFields() {
        return this.m_addrPtrMap.keySet();
    }

    public int size() {
        return this.m_addrPtrMap.size();
    }

    public <T extends IDataItem> T getNewInstance() {
        return (T)new AddressPtrMap();
    }

    public Iterator<AddressPtr> getAddressPtrIterator() {
        return SubLevelIterator.getFromIterableSubList(this.m_addrPtrMap.values());
    }

    @Override
    public Iterator<AddressPtr> iterator() {
        return this.getAddressPtrIterator();
    }

    @Override
    public boolean isUsable() {
        return !this.m_addrPtrMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<Integer, List<AddressPtr>> entry : this.m_addrPtrMap.entrySet()) {
            sb.append(" ");
            if (FieldType.getPredefinedName((int)entry.getKey()) != null) {
                sb.append(FieldType.getPredefinedName((int)entry.getKey()));
            } else {
                sb.append(entry.getKey());
            }
            sb.append("->");
            if (entry.getValue() == null) continue;
            sb.append(Arrays.toString(entry.getValue().toArray()));
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public boolean isFullyRead() {
        return this.m_fullyRead;
    }
}

