/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.AbstractRadixTreeSearcher;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryIDDataItem;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryMap;
import com.mapinfo.mapmarker.autosuggest.dp.CategorySearchResult;
import com.mapinfo.mapmarker.autosuggest.dp.RadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.utils.SubLevelIterator;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DiskRadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IMatchResult;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IRadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.NodeFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTreeMatchResult;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryInfoManager
extends AbstractRadixTreeSearcher<CategoryIDDataItem> {
    private RadixTree<CategoryIDDataItem> m_categoryLookup;
    private CategoryMap m_categoryMap = new CategoryMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path, String dataName) throws IOException, CGGELevelException {
        ICGGEDataStream dataStream = null;
        try {
            dataStream = DataStreamFactory.getDataStream((String)this.getFullFilePath(path, dataName));
            this.load((ICGGEDataInputStream)dataStream);
        }
        finally {
            if (dataStream != null) {
                try {
                    dataStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load(ICGGEDataInputStream dataInput) throws IOException, CGGELevelException {
        RadixTreeMetaData metaData = new RadixTreeMetaData();
        DiskRadixTree<CategoryIDDataItem> radixTree = new DiskRadixTree<CategoryIDDataItem>(new CategoryIDDataItem());
        radixTree.load(dataInput, (IRadixTreeMetaData)metaData, false);
        this.m_categoryLookup = radixTree.readFully();
        byte[] catMapBytes = metaData.getAdditionalBytes();
        this.m_categoryMap = new CategoryMap();
        this.m_categoryMap.readFromDataBytes(catMapBytes);
    }

    public void write(String outPath, String dataName) throws IOException {
        this.write(this.m_categoryMap, outPath, dataName);
    }

    public void printCategoryMap(PrintStream stream) {
        this.m_categoryMap.printCategoryMap(stream);
    }

    private String getFullFilePath(String outPath, String dataName) {
        return MMUtils.appendToPath((String)outPath, (String)(dataName + ".cdx"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(CategoryMap catMap, String outPath, String dataName) throws IOException {
        String fullPath = this.getFullFilePath(outPath, dataName);
        try (ICGGEDataStream dataStream = null;){
            dataStream = DataStreamFactory.getDataStream((String)fullPath, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
            this.write(catMap, dataStream);
        }
    }

    void write(CategoryMap catMap, ICGGEDataStream dataOut) throws IOException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("creating category/sub category lookup file");
        RadixTreeMetaData metaData = new RadixTreeMetaData();
        metaData.setAdditionalBytes(catMap.getDataBytes());
        Map<String, CategoryIDDataItem> lookupMap = catMap.getCategoryLookupMap();
        logger.info("\tfound " + lookupMap.size() + " unique categories and sub categories");
        RadixTree<CategoryIDDataItem> radixTree = this.buildSearchTree(catMap);
        DiskRadixTree.write(radixTree, (IRadixTreeMetaData)metaData, dataOut);
        logger.info("created category/sub category lookup file");
    }

    RadixTree<CategoryIDDataItem> buildSearchTree(CategoryMap catMap) {
        Map<String, CategoryIDDataItem> lookupMap = catMap.getCategoryLookupMap();
        RadixTree<CategoryIDDataItem> radixTree = new RadixTree<CategoryIDDataItem>();
        for (Map.Entry<String, CategoryIDDataItem> en : lookupMap.entrySet()) {
            String key = StringNormalizer.normalise(en.getKey());
            CategoryIDDataItem categoryIDItem = en.getValue();
            CategoryIDDataItem savedItem = radixTree.find(key);
            if (savedItem != null) {
                savedItem.combine(categoryIDItem);
                continue;
            }
            radixTree.add(key, categoryIDItem);
        }
        return radixTree;
    }

    void setCategoryLookup(RadixTree<CategoryIDDataItem> radixTree) {
        this.m_categoryLookup = radixTree;
    }

    public CategorySearchType makeCategorySearchType(boolean searchCategory, boolean searchSubCategory) {
        if (searchCategory && searchSubCategory) {
            return CategorySearchType.BOTH;
        }
        if (searchCategory) {
            return CategorySearchType.CATEGORY;
        }
        if (searchSubCategory) {
            return CategorySearchType.SUBCATEGORY;
        }
        return CategorySearchType.NONE;
    }

    Iterator<CategorySearchResult> convertResult(final RadixTreeMatchResult<CategoryIDDataItem> searchResult, final List<Integer> allowedFieldIds) {
        return new SubLevelIterator<IMatchResult<CategoryIDDataItem>, Map.Entry<Integer, Set<Integer>>, CategorySearchResult>(){
            private IMatchResult<CategoryIDDataItem> m_currItem;

            @Override
            public Iterator<Map.Entry<Integer, Set<Integer>>> getSubIterator(IMatchResult<CategoryIDDataItem> mainItem) {
                this.m_currItem = mainItem;
                return mainItem.getValue().getFieldIDCategoryIDIterator(allowedFieldIds);
            }

            @Override
            public CategorySearchResult getItem(Map.Entry<Integer, Set<Integer>> subItem) {
                return new CategorySearchResult(this.m_currItem, subItem.getValue(), subItem.getKey());
            }

            @Override
            public Iterator<IMatchResult<CategoryIDDataItem>> getMainIterator() {
                return searchResult.iterator();
            }
        };
    }

    public int getCategoryIDField() {
        if (this.m_categoryMap != null) {
            return this.m_categoryMap.getCategoryIDField();
        }
        return -1;
    }

    public int getCategoryField() {
        if (this.m_categoryMap != null) {
            return this.m_categoryMap.getCategoryField();
        }
        return -1;
    }

    public int getSubCategoryField() {
        if (this.m_categoryMap != null) {
            return this.m_categoryMap.getSubCategoryField();
        }
        return -1;
    }

    public void setCategoryFieldsInAddress(SimpleStreetAddress addr) {
        List<String> fvList;
        int categoryIDField;
        if (this.m_categoryMap != null && (categoryIDField = this.getCategoryIDField()) > -1 && (fvList = addr.getField(categoryIDField)) != null && !fvList.isEmpty()) {
            try {
                int categoryID = Integer.parseInt(fvList.get(0));
                this.m_categoryMap.addCategoryFields(addr, categoryID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void setCategoryMap(CategoryMap categoryMap) {
        this.m_categoryMap = categoryMap;
    }

    public String makeCategorySearchKey(String categoryID) {
        if (this.m_categoryMap != null) {
            return this.m_categoryMap.makeCategorySearchKey(categoryID);
        }
        return null;
    }

    @Override
    protected RadixTree<CategoryIDDataItem> getRadixTree() {
        return this.m_categoryLookup;
    }

    @Override
    protected NodeFilter<CategoryIDDataItem> makeEmptyValueNodeFilter(NodeFilter<CategoryIDDataItem> nodeFilter) {
        return null;
    }

    public static enum CategorySearchType {
        NONE,
        CATEGORY,
        SUBCATEGORY,
        BOTH;

    }
}

