/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.CategoryIDDataItem;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryMap {
    public static final String CATEGORY_ID_FIELD_NAME = "CategoryID";
    public static final int DEFAULT_CATEGORY_FIELD = 26;
    public static final int DEFAULT_SUB_CATEGORY_FIELD = 27;
    public static final String CATEGORY_ID_KEY_PREFIX = "@";
    public static final String FIELD_SEPERATOR = "\t";
    public static final String CATEGORY_SEPERATOR = ", ";
    private HashMap<Integer, CatPair> m_map = new HashMap();
    private int m_categoryIDField = -1;
    private int m_categoryField = 26;
    private int m_subCategoryField = 27;

    public void setCategoryIDField(int id) {
        this.m_categoryIDField = id;
    }

    public int getCategoryIDField() {
        return this.m_categoryIDField;
    }

    public void setCategoryField(int categoryField) {
        this.m_categoryField = categoryField;
    }

    public void setSubCategoryField(int subCategoryField) {
        this.m_subCategoryField = subCategoryField;
    }

    public void processCategoryInformation(SimpleStreetAddress address) {
        int categoryIDField = this.getCategoryIDField();
        if (categoryIDField < 0) {
            return;
        }
        this.retrieveCategoryInfo(address, categoryIDField);
    }

    public void addCategoryFields(SimpleStreetAddress address, int categoryID) {
        CatPair catPair = this.getCategoryPair(categoryID);
        if (catPair != null) {
            int subCatFieldID;
            int catFieldID = this.getCategoryField();
            if (catFieldID > -1) {
                address.getFields().put(catFieldID, catPair.getCategories());
            }
            if ((subCatFieldID = this.getSubCategoryField()) > -1) {
                address.getFields().put(subCatFieldID, catPair.getSubCategories());
            }
        }
    }

    public void addCategories(int catID, List<String> cats, List<String> subCats) {
        this.m_map.put(catID, new CatPair(cats, subCats));
    }

    private List<String> getCategoryValues(SimpleStreetAddress address) {
        return address.getField(this.getCategoryField());
    }

    private List<String> getSubCategoryValues(SimpleStreetAddress address) {
        return address.getField(this.getSubCategoryField());
    }

    public int getCategoryField() {
        return this.m_categoryField;
    }

    public int getSubCategoryField() {
        return this.m_subCategoryField;
    }

    protected boolean containsCategoryID(int catID) {
        return this.m_map.containsKey(catID);
    }

    private void retrieveCategoryInfo(SimpleStreetAddress address, int categoryIDField) {
        String categoryID;
        Integer codeInt;
        List<String> categoryIDs;
        Map<Integer, List<String>> fields = address.getFields();
        if (fields.containsKey(categoryIDField) && (categoryIDs = fields.get(categoryIDField)) != null && !categoryIDs.isEmpty() && !this.containsCategoryID(codeInt = Integer.valueOf(Integer.parseInt(categoryID = categoryIDs.get(0))))) {
            List<String> categories = this.getCategoryValues(address);
            List<String> subCats = this.getSubCategoryValues(address);
            this.addCategories(codeInt, categories, subCats);
        }
    }

    public void read(DataInput in) throws IOException {
        this.setCategoryIDField(in.readShort());
        this.setCategoryField(in.readShort());
        this.setSubCategoryField(in.readShort());
        int size = in.readShort();
        for (int i = 0; i < size; ++i) {
            Integer key = in.readInt();
            CatPair pair = new CatPair();
            pair.read(in);
            this.m_map.put(key, pair);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.getCategoryIDField());
        out.writeShort(this.getCategoryField());
        out.writeShort(this.getSubCategoryField());
        out.writeShort((short)this.m_map.size());
        for (Integer key : this.m_map.keySet()) {
            out.writeInt(key);
            CatPair pair = this.m_map.get(key);
            pair.write(out);
        }
    }

    public byte[] getDataBytes() throws IOException {
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream();
        this.write((DataOutput)dataStream);
        int byteCount = (int)dataStream.seekEnd();
        dataStream.seek(0L);
        byte[] bytes = new byte[byteCount];
        dataStream.readFully(bytes);
        return bytes;
    }

    public void readFromDataBytes(byte[] dataBytes) throws IOException {
        ICGGEDataInputStream dataStream = DataStreamFactory.getInputDataStream((byte[])dataBytes);
        this.read((DataInput)dataStream);
    }

    protected Map<String, CategoryIDDataItem> getCategoryLookupMap() {
        HashMap<String, CategoryIDDataItem> categoryLookupMap = new HashMap<String, CategoryIDDataItem>();
        for (Map.Entry<Integer, CatPair> en : this.m_map.entrySet()) {
            int catID = en.getKey();
            CatPair catPair = en.getValue();
            this.addToMap(categoryLookupMap, catID, catPair);
        }
        return categoryLookupMap;
    }

    private void addToMap(Map<String, CategoryIDDataItem> categoryLookupMap, int micode, CatPair catPair) {
        this.addToMap(categoryLookupMap, this.getCategoryField(), micode, catPair.getCategories());
        this.addToMap(categoryLookupMap, this.getSubCategoryField(), micode, catPair.getSubCategories());
    }

    private void addToMap(Map<String, CategoryIDDataItem> categoryLookupMap, int categoryFieldID, int micode, List<String> searchKeys) {
        for (String category : searchKeys) {
            CategoryIDDataItem micodeValues = categoryLookupMap.get(category);
            if (micodeValues == null) {
                micodeValues = new CategoryIDDataItem();
                categoryLookupMap.put(category, micodeValues);
            }
            micodeValues.addCategoryID(categoryFieldID, micode);
        }
    }

    public CatPair getCategoryPair(int categoryid) {
        return this.m_map.get(categoryid);
    }

    public String makeCategorySearchKey(String categoryID) {
        return CATEGORY_ID_KEY_PREFIX + categoryID;
    }

    public void printCategoryMap(PrintStream stream) {
        for (Map.Entry<Integer, CatPair> en : this.m_map.entrySet()) {
            int categoryID = en.getKey();
            CatPair catPair = en.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(categoryID);
            sb.append(FIELD_SEPERATOR);
            this.toString(sb, catPair.m_category);
            sb.append(FIELD_SEPERATOR);
            this.toString(sb, catPair.m_subCategory);
            stream.println(sb.toString());
        }
    }

    private void toString(StringBuilder sb, List<String> values) {
        int c = values.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(CATEGORY_SEPERATOR);
            }
            String value = values.get(i);
            sb.append(value);
        }
    }

    static class CatPair {
        private List<String> m_category = new ArrayList<String>();
        private List<String> m_subCategory = new ArrayList<String>();

        public CatPair() {
        }

        public CatPair(List<String> catInfo, List<String> subCatInfo) {
            if (catInfo != null && !catInfo.isEmpty()) {
                this.m_category.addAll(catInfo);
            }
            if (subCatInfo != null && !subCatInfo.isEmpty()) {
                this.m_subCategory.addAll(subCatInfo);
            }
        }

        public void read(DataInput in) throws IOException {
            this.m_category = this.readValues(in);
            this.m_subCategory = this.readValues(in);
        }

        private List<String> readValues(DataInput in) throws IOException {
            int sz = in.readByte();
            ArrayList<String> values = new ArrayList<String>(sz);
            for (int i = 0; i < sz; ++i) {
                values.add(in.readUTF());
            }
            return values;
        }

        public void write(DataOutput out) throws IOException {
            this.writeValues(out, this.m_category);
            this.writeValues(out, this.m_subCategory);
        }

        private void writeValues(DataOutput out, List<String> values) throws IOException {
            int sz = values == null ? 0 : values.size();
            out.writeByte(sz);
            for (int i = 0; i < sz; ++i) {
                out.writeUTF(values.get(i));
            }
        }

        public List<String> getCategories() {
            return this.m_category;
        }

        public List<String> getSubCategories() {
            return this.m_subCategory;
        }
    }
}

