/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InternalSimpleAddress {
    protected Map<Integer, List<String>> fields = new HashMap<Integer, List<String>>(5);

    public Map<Integer, List<String>> getFields() {
        return this.fields;
    }

    public void setFields(Map<Integer, List<String>> fields) {
        this.fields = fields;
    }

    public void addField(int fieldID, String value) {
        List values = this.fields.get(fieldID);
        if (values == null) {
            values = ListUtils.newList((Object)value);
            this.fields.put(fieldID, values);
        } else {
            values.add(value);
        }
    }

    public List<String> getField(int fieldID) {
        return this.fields == null ? null : this.fields.get(fieldID);
    }

    public String getFieldValue(int fieldID) {
        return this.getFieldValue(fieldID, 0);
    }

    public String getFieldValue(int fieldID, int i) {
        List<String> fvs;
        if (i >= 0 && (fvs = this.getField(fieldID)) != null && fvs.size() > i) {
            return fvs.get(i);
        }
        return null;
    }

    public void readFields(ICGGEDataInput in) throws IOException {
        int fieldCount = in.readVUnsignedInt();
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            int fieldID = in.readUnsignedByte();
            int valueCount = in.readVUnsignedInt();
            String[] values = new String[valueCount];
            for (int valueNdx = 0; valueNdx < valueCount; ++valueNdx) {
                values[valueNdx] = in.readUTF();
            }
            map.put(fieldID, Arrays.asList(values));
        }
        this.fields = map;
    }

    public void writeFields(ICGGEDataOutput out) throws IOException {
        int fieldCount = this.fields.size();
        out.writeVUnsignedInt(fieldCount);
        for (Map.Entry<Integer, List<String>> en : this.fields.entrySet()) {
            out.writeByte(en.getKey().intValue());
            List<String> values = en.getValue();
            int valueCount = values.size();
            out.writeVUnsignedInt(valueCount);
            for (String value : values) {
                out.writeUTF(value);
            }
        }
    }

    public boolean hasSameAddressFields(InternalSimpleAddress addr) {
        Map<Integer, List<String>> map1 = this.getFields();
        Map<Integer, List<String>> map2 = addr.getFields();
        if (map1.size() == map2.size()) {
            for (Map.Entry<Integer, List<String>> en : map1.entrySet()) {
                List<String> list1 = en.getValue();
                List<String> list2 = map2.get(en.getKey());
                if (list1 == null || list2 == null || list1.size() == list2.size() && list1.containsAll(list2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareFields(InternalSimpleAddress other) {
        Map<Integer, List<String>> map1 = this.getFields();
        Map<Integer, List<String>> map2 = other.getFields();
        IntArray sortedFields = this.getSortedFieldIDsFromFieldMaps(map1, map2);
        Iterator fieldIt = sortedFields.iterator();
        while (fieldIt.hasNext()) {
            int fieldID = (Integer)fieldIt.next();
            int c = this.compareFieldValues(map1.get(fieldID), map2.get(fieldID));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private IntArray getSortedFieldIDsFromFieldMaps(Map<Integer, List<String>> map1, Map<Integer, List<String>> map2) {
        IntArray array = new IntArray(10);
        for (Integer fieldID : map1.keySet()) {
            array.add(fieldID);
        }
        for (Integer fieldID : map2.keySet()) {
            array.add(fieldID);
        }
        array.sort();
        array.removeDuplicates();
        return array;
    }

    private int compareFieldValues(List<String> fvs1, List<String> fvs2) {
        int s1 = fvs1 == null ? 0 : fvs1.size();
        int s2 = fvs2 == null ? 0 : fvs2.size();
        int smin = Math.min(s1, s2);
        for (int i = 0; i < smin; ++i) {
            int c = MMUtils.compare((Comparable)((Comparable)((Object)fvs1.get(i))), (Comparable)((Comparable)((Object)fvs2.get(i))));
            if (c == 0) continue;
            return c;
        }
        return s1 - s2;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InternalSimpleAddress fields:\n");
        for (Integer fieldId : this.fields.keySet()) {
            sb.append("\t").append(fieldId).append(": '").append(this.fields.get(fieldId)).append("'\n");
        }
        return sb.toString();
    }

    public List<? extends InternalSimpleAddress> getSubList(List<? extends InternalSimpleAddress> list, List<Integer> ndxs) {
        ArrayList<InternalSimpleAddress> newList = new ArrayList<InternalSimpleAddress>(ndxs.size());
        for (int ndx : ndxs) {
            newList.add(list.get(ndx));
        }
        return newList;
    }

    public boolean isEmptyField(int fieldID) {
        List<String> fv = this.getField(fieldID);
        return fv == null || fv.isEmpty();
    }
}

