/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IReadable;
import com.mapinfo.mapmarker.cgge.utils.io.IWritable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleRange
extends InternalSimpleAddress
implements IReadable,
IWritable,
Comparable<SimpleRange> {
    public static final int ODDEVEN_TYPE_MIXED = 0;
    public static final int ODDEVEN_TYPE_ODD = 1;
    public static final int ODDEVEN_TYPE_EVEN = 2;
    private static final int MASK_FROM_IS_AVAILABLE = 1;
    private static final int MASK_FROM_IS_APLHANUM = 2;
    private static final int MASK_TO_IS_AVAILABLE = 4;
    private static final int MASK_TO_IS_APLHANUM = 8;
    private String from;
    private String to;
    private int type;
    private boolean inputNumberMatched = false;
    private boolean matchedOnRangeField = false;
    private List<SimpleUnit> units = new ArrayList<SimpleUnit>();

    public SimpleRange(String from, String to) {
        this.from = from;
        this.to = to;
        this.setOddEvenType(0);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int getOddEvenType() {
        return this.type;
    }

    public void setOddEvenType(int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("Not a valid type value");
        }
        this.type = type;
    }

    public void write(ICGGEDataOutput out) throws IOException {
        int mask = this.getMask();
        out.write(mask);
        if ((mask & 1) == 1) {
            if ((mask & 2) == 2) {
                out.writeUTF(this.from);
            } else {
                out.writeVUnsignedInt(Integer.parseInt(this.from));
            }
        }
        if ((mask & 4) == 4) {
            if ((mask & 8) == 8) {
                out.writeUTF(this.to);
            } else {
                out.writeVUnsignedInt(Integer.parseInt(this.to));
            }
        }
        if (this.getUnitCount() > 0) {
            this.getFields().remove(2);
            this.addField(2, "" + this.getUnitCount());
        }
        this.writeFields(out);
        if (this.getUnitCount() > 0) {
            this.writeUnits(out);
        }
    }

    private void writeUnits(ICGGEDataOutput out) throws IllegalArgumentException, IOException {
        int unitCount = this.units.size();
        out.writeVUnsignedInt(unitCount);
        for (int unitNdx = 0; unitNdx < unitCount; ++unitNdx) {
            this.units.get(unitNdx).write(out);
        }
    }

    private void readUnits(ICGGEDataInput in) throws IOException {
        int unitCount = in.readVUnsignedInt();
        this.units = new ArrayList<SimpleUnit>(unitCount);
        for (int unitNdx = 0; unitNdx < unitCount; ++unitNdx) {
            SimpleUnit unit = new SimpleUnit();
            unit.read(in);
            this.units.add(unit);
        }
    }

    public void read(ICGGEDataInput in) throws IOException {
        byte mask = in.readByte();
        this.type = (mask & 0xF0) >> 4;
        if ((mask & 1) == 1) {
            this.from = (mask & 2) == 2 ? in.readUTF() : Integer.toString(in.readVUnsignedInt());
        }
        if ((mask & 4) == 4) {
            this.to = (mask & 8) == 8 ? in.readUTF() : Integer.toString(in.readVUnsignedInt());
        }
        this.readFields(in);
        if (this.getDataUnitCount() > 0) {
            this.readUnits(in);
        }
    }

    private int getDataUnitCount() {
        List<String> list = this.getField(2);
        if (list != null && !list.isEmpty()) {
            this.getFields().remove(2);
            return Integer.parseInt(list.get(0));
        }
        return 0;
    }

    private int getMask() {
        int mask = this.type << 4;
        if (this.from != null) {
            mask |= 1;
            if (!this.withinUnsignedIntRange(this.from)) {
                mask |= 2;
            }
        }
        if (this.to != null) {
            mask |= 4;
            if (!this.withinUnsignedIntRange(this.to)) {
                mask |= 8;
            }
        }
        return mask;
    }

    protected boolean withinUnsignedIntRange(String str) {
        if (MMUtils.isNumber((String)str)) {
            try {
                int n = Integer.parseInt(str);
                return n > -1 && n <= ICGGEDataOutput.VUNSIGNED_INT_MAXVALUE;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int compareTo(SimpleRange o) {
        int c = this.compareToRangeInfo(o);
        if (c != 0) {
            return c;
        }
        c = this.compareFields(o);
        if (c != 0) {
            return c;
        }
        return this.compareUnits(o);
    }

    public boolean compareRangesExcludingUnits(SimpleRange other) {
        return this.compareToRangeInfo(other) == 0 && this.compareFields(other) == 0;
    }

    private int compareUnits(SimpleRange other) {
        int s2;
        List<SimpleUnit> units1 = this.getUnits();
        List<SimpleUnit> units2 = other.getUnits();
        int s1 = units2 == null ? 0 : units1.size();
        int c = s1 - (s2 = units2 == null ? 0 : units2.size());
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < s1; ++i) {
            c = units1.get(i).compareTo(units2.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private int compareToRangeInfo(SimpleRange o) {
        int c = this.compareRangeNumber(this.from, o.from);
        if (c != 0) {
            return c;
        }
        c = this.compareRangeNumber(this.to, o.to);
        if (c != 0) {
            return c;
        }
        return this.type - o.getOddEvenType();
    }

    private int compareRangeNumber(String num1, String num2) {
        if (num1 == num2) {
            return 0;
        }
        if (num1 != null && num2 != null) {
            return num1.compareTo(num2);
        }
        if (num1 != null) {
            return 1;
        }
        return -1;
    }

    public boolean isInputNumberMatched() {
        return this.inputNumberMatched;
    }

    public void setInputNumberMatched(boolean b) {
        this.inputNumberMatched = b;
    }

    public void setMatchedOnRangeField(boolean b) {
        this.matchedOnRangeField = b;
    }

    public boolean isMatchedOnRangeField() {
        return this.matchedOnRangeField;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[SimpleRange: from: ");
        sb.append(this.from);
        sb.append(", to: ").append(this.to);
        sb.append(", type").append(this.type);
        sb.append("inputNumberMatched: ").append(this.inputNumberMatched).append("]");
        return sb.toString();
    }

    public void addUnit(SimpleUnit unit) {
        this.units.add(unit);
    }

    public void addUnits(List<SimpleUnit> units) {
        this.units.addAll(units);
    }

    public List<SimpleUnit> getUnits() {
        return this.units;
    }

    public int getUnitCount() {
        return this.units == null ? 0 : this.units.size();
    }

    public SimpleUnit getUnitAt(int unitNdx) {
        if (unitNdx > -1 && unitNdx < this.units.size()) {
            return this.units.get(unitNdx);
        }
        return null;
    }

    @Override
    public String getFieldValue(int fieldID) {
        if (fieldID == 5) {
            return this.from;
        }
        if (fieldID == 6) {
            return this.to;
        }
        return super.getFieldValue(fieldID);
    }

    @Override
    public String getFieldValue(int fieldID, int i) {
        if (fieldID == 5) {
            return this.from;
        }
        if (fieldID == 6) {
            return this.to;
        }
        return super.getFieldValue(fieldID, i);
    }

    public void setUnits(List<SimpleUnit> units) {
        this.units = units;
    }
}

