/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IReadable;
import com.mapinfo.mapmarker.cgge.utils.io.IWritable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleStreetAddress
extends InternalSimpleAddress
implements IWritable,
IReadable,
Comparable<SimpleStreetAddress> {
    private Rectangle bounds;
    private List<SimpleRange> ranges;
    private AddressPtr addrPtr;
    private int geoHash;

    public AddressPtr getAddressPtr() {
        return this.addrPtr;
    }

    public void setAddressPtr(AddressPtr addrPtr) {
        this.addrPtr = addrPtr;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void expandBounds(Rectangle bounds) {
        if (bounds != null) {
            if (this.bounds == null) {
                this.bounds = new Rectangle(bounds);
            } else {
                this.bounds.expandToInclude(bounds);
            }
        }
    }

    public void setGeoHash(int geoHash) {
        this.geoHash = geoHash;
    }

    public int getGeoHash() {
        return this.geoHash;
    }

    public void addRange(SimpleRange range) {
        this.ranges = ListUtils.addToList(this.ranges, (Object)range);
    }

    public void addRange(List<SimpleRange> ranges) {
        this.ranges = ListUtils.addToList(this.ranges, ranges);
    }

    public void setRanges(List<SimpleRange> ranges) {
        this.ranges = ranges;
    }

    public void read(ICGGEDataInput in) throws IOException {
        boolean hasBounds = in.readBoolean();
        if (hasBounds) {
            this.bounds = new Rectangle();
            this.bounds.read(in);
        } else {
            this.bounds = null;
        }
        this.readFields(in);
        this.ranges = this.readRanges(in);
    }

    public List<SimpleRange> getRanges() {
        return this.ranges;
    }

    public SimpleRange getRangeAt(int rangeNdx) {
        if (rangeNdx > -1 && rangeNdx < this.ranges.size()) {
            return this.ranges.get(rangeNdx);
        }
        return null;
    }

    public int getRangeCount() {
        return this.ranges != null ? this.ranges.size() : 0;
    }

    private List<SimpleRange> readRanges(ICGGEDataInput in) throws IOException {
        int rangeCount = in.readVUnsignedInt();
        if (rangeCount > 0) {
            ArrayList<SimpleRange> ranges = new ArrayList<SimpleRange>(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                SimpleRange range = new SimpleRange(null, null);
                range.read(in);
                ranges.add(range);
            }
            return ranges;
        }
        return null;
    }

    public void write(ICGGEDataOutput out) throws IOException {
        if (this.bounds != null) {
            out.writeBoolean(true);
            this.bounds.write(out);
        } else {
            out.writeBoolean(false);
        }
        this.writeFields(out);
        this.writeRanges(out, this.ranges);
    }

    private void writeRanges(ICGGEDataOutput out, List<SimpleRange> ranges) throws IOException {
        int rangeCount = ranges == null ? 0 : ranges.size();
        out.writeVUnsignedInt(rangeCount);
        for (int i = 0; i < rangeCount; ++i) {
            ranges.get(i).write(out);
        }
    }

    @Override
    public int compareTo(SimpleStreetAddress o) {
        int c = this.compareFields(o);
        if (c != 0) {
            return c;
        }
        c = this.compareRanges(o);
        if (c != 0) {
            return c;
        }
        return this.compareBounds(o);
    }

    public SimpleRange getFirstRange() {
        List<SimpleRange> ranges = this.getRanges();
        if (ranges != null && !ranges.isEmpty()) {
            return ranges.get(0);
        }
        return null;
    }

    private int compareBounds(SimpleStreetAddress o) {
        Rectangle bounds1 = this.bounds;
        Rectangle bounds2 = o.getBounds();
        if (bounds1 == bounds2) {
            return 0;
        }
        if (bounds1 != null && bounds2 != null) {
            int c = MMUtils.compareDoubleValues((double)bounds1.getLeft(), (double)bounds2.getLeft());
            if (c == 0 && (c = MMUtils.compareDoubleValues((double)bounds1.getBottom(), (double)bounds2.getBottom())) == 0 && (c = MMUtils.compareDoubleValues((double)bounds1.getRight(), (double)bounds2.getRight())) == 0) {
                c = MMUtils.compareDoubleValues((double)bounds1.getTop(), (double)bounds2.getTop());
            }
            return c;
        }
        if (bounds1 != null) {
            return 1;
        }
        return -1;
    }

    private int compareRanges(SimpleStreetAddress other) {
        List<SimpleRange> ranges2;
        int s2;
        List<SimpleRange> ranges1 = this.getRanges();
        int s1 = ranges1 == null ? 0 : ranges1.size();
        int c = s1 - (s2 = (ranges2 = other.getRanges()) == null ? 0 : ranges2.size());
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < s1; ++i) {
            c = ranges1.get(i).compareTo(ranges2.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleStreetAddress components:\n");
        sb.append(super.toString());
        if (this.bounds != null) {
            sb.append("Bounds: ").append(this.bounds.toString()).append("\n");
        }
        if (this.ranges != null) {
            sb.append("Ranges: ").append(this.ranges.toString()).append("\n");
        }
        if (this.addrPtr != null) {
            sb.append(this.addrPtr.toString()).append("\n");
        }
        sb.append("geoHash: ").append(this.geoHash).append("\n");
        return sb.toString();
    }
}

