/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.AddressGeomItem;
import com.mapinfo.mapmarker.autosuggest.dp.AddressIOHandler;
import com.mapinfo.mapmarker.autosuggest.dp.AddressMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.AddressPtrMap;
import com.mapinfo.mapmarker.autosuggest.dp.AreaGeomItem;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryInfoManager;
import com.mapinfo.mapmarker.autosuggest.dp.CategoryMap;
import com.mapinfo.mapmarker.autosuggest.dp.ISourceDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.RadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.dp.StringDataItem;
import com.mapinfo.mapmarker.autosuggest.dp.builder.AddressNumberHasher;
import com.mapinfo.mapmarker.autosuggest.dp.builder.AlternateKeyGenerator;
import com.mapinfo.mapmarker.autosuggest.dp.builder.ProgressLogger;
import com.mapinfo.mapmarker.autosuggest.dp.builder.StringKey;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.StringNormalizer;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.GeoHashTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.DiskRadixTree;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.IRadixTreeMetaData;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.RadixTree;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidPropertyException;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.compress.CompHeader;
import com.mapinfo.mapmarker.cgge.utils.compress.CompHeaderCreatorOutput;
import com.mapinfo.mapmarker.cgge.utils.compress.StringCompressor;
import com.mapinfo.mapmarker.cgge.utils.index.DiskBTree;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInputStream;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataBuilder {
    static final Logger logger = LoggerFactory.getLogger(AbstractDataBuilder.class);
    public static final String SEARCH_FIELDS = "searchFields";
    @Deprecated
    public static final String LASTLINE_FORMAT_FIELDS = "lastlineFormatFields";
    @Deprecated
    public static final String STREET_FORMAT_FIELDS = "streetFormatFields";
    public static final String LOG_FILE_NAME = "databuild_logger.properties";
    public static final String KEY_DATA_AREA_BOUNDS = "dataAreaBounds";
    public static final String KEY_COUNTRY = "country";
    public static final String KEY_DATA_NAME = "dataName";
    public static final String KEY_DATA_PROVIDER = "dataProviderName";
    public static final String KEY_INPUT_PATH = "inputPath";
    public static final String KEY_OUTPUT_PATH = "outputPath";
    public static final String DATA_VINTAGE_FILE_NAME = "dictionarydesc_DATA_NAME.txt";
    private static final String STREET_FORMAT_FIELDS_PATTERN = "set_formatted_street";
    private static final String LASTLINE_FORMAT_FIELDS_PATTERN = "set_formatted_location";
    String dataVintage;
    String dataProductCode;
    private ISourceDataReader m_dataReader;
    private Set<Integer> m_searchFields = null;
    private boolean m_searchAllFields = false;
    private int[] m_streetFormatFields;
    private int[] m_lastlineFormatFields;
    private Logger m_logger;
    private int m_totalRecords = 0;
    private Rectangle m_dataAreaBounds;
    private AlternateKeyGenerator m_altKeyGenerator;
    private static int WORD_TYPES_TO_REMOVE = 41;
    private String m_streetFormatFieldsPattern;
    private String m_lastlineFormatFieldsPattern;

    protected abstract ISourceDataReader getReader(Properties var1) throws InvalidPropertyException, CGGELevelException, IOException, InstantiationException, IllegalAccessException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDictionary(String dataName, String outPath, Properties dataProp) throws IOException, InvalidPropertyException, CGGELevelException, IllegalAccessException, InstantiationException {
        this.initLog();
        this.m_logger.info("==== create dictionary ====");
        this.createOutFolder(outPath);
        File outFolderFile = new File(outPath);
        if (outFolderFile.isDirectory() && outFolderFile.list().length > 0) {
            this.cleanOutFolder(outFolderFile, dataName);
        }
        this.dataProductCode = dataProp.getProperty("dataProductCode", "");
        if (!this.dataProductCode.isEmpty() && this.dataProductCode.contains(",")) {
            String[] dataProductsTokens;
            String thisCountry = dataProp.getProperty("supportedCountries", "");
            if (thisCountry.isEmpty()) {
                throw new InvalidPropertyException("'supportedCountries' is not defined in the databuilder.properties file.");
            }
            for (String countryAndProductCodePair : dataProductsTokens = this.dataProductCode.split(",")) {
                String[] tokens = countryAndProductCodePair.split(":");
                if (!thisCountry.contains(tokens[0])) continue;
                this.dataProductCode = tokens[1];
            }
        }
        this.dataVintage = dataProp.getProperty("dataVintage", "");
        if (!this.dataVintage.isEmpty()) {
            File dataVintageFile = new File(outFolderFile, DATA_VINTAGE_FILE_NAME.replace("DATA_NAME", dataName));
            this.m_logger.debug(String.format(dataVintageFile.getAbsolutePath(), this.dataVintage));
            try (BufferedWriter bufferedWriter = null;){
                bufferedWriter = new BufferedWriter(new FileWriter(dataVintageFile));
                bufferedWriter.write(this.dataVintage);
            }
        }
        long startTime = System.currentTimeMillis();
        this.m_logger.info("loading source data");
        this.m_dataReader = this.getReader(dataProp);
        this.loadSearchFields(dataProp, this.m_dataReader);
        this.loadStreetFormatFields(dataProp, this.m_dataReader);
        this.loadLastlineFormatFields(dataProp, this.m_dataReader);
        this.loadAllowedAreaBounds(dataProp);
        this.loadAltKeyGenerator(dataProp);
        this.m_logger.info("creating typeahead data");
        CompHeaderCreatorOutput outputForCompression = this.getOutputForCompression();
        Rectangle mbr = this.preProcessData(this.m_dataReader, (ICGGEDataOutput)outputForCompression);
        this.createData(this.m_dataReader, outputForCompression, outPath, dataName, mbr);
        this.saveSubstitutionSet(outPath, dataName);
        long stopTime = System.currentTimeMillis();
        this.m_logger.info("created typeahead data in " + this.getTimeString(stopTime - startTime));
    }

    protected void saveSubstitutionSet(String outPath, String dataName) throws IOException {
        if (this.m_altKeyGenerator == null) {
            return;
        }
        String fullName = MMUtils.appendToPath((String)outPath, (String)(dataName + ".ssm"));
        this.m_altKeyGenerator.writeSubstitutionSet(fullName);
    }

    CompHeaderCreatorOutput getOutputForCompression() {
        return new CompHeaderCreatorOutput();
    }

    protected void createData(ISourceDataReader dataReader, CompHeaderCreatorOutput outputForCompression, String outPath, String dataName, Rectangle mbr) throws IOException, CGGELevelException {
        this.m_logger.info("create quad tree");
        QuadTree<AreaGeomItem> quadTree = this.createQuadTree(dataReader, mbr, outPath, dataName);
        this.m_logger.info("create category map");
        CategoryMap catMap = this.getCategoryMap(dataReader);
        this.m_logger.info("create word map");
        Map<StringKey, AddressPtrMap> wordMap = this.createAddressData(dataReader, outputForCompression, outPath, dataName, catMap);
        this.m_logger.info("create radix tree");
        RadixTreeMetaData radixMetaData = this.createRadixTreeMetaData(dataName, dataReader, outputForCompression.getCompressor());
        this.createRadixTree(outPath, dataName, wordMap, radixMetaData);
        if (catMap != null && catMap.getCategoryIDField() > 0) {
            this.m_logger.info("create category lookup");
            this.writeCategoryLookup(outPath, dataName, catMap);
        }
    }

    CategoryMap getCategoryMap(ISourceDataReader dataReader) {
        return this.isPOIData(dataReader) ? new CategoryMap() : null;
    }

    void writeCategoryLookup(String outPath, String dataName, CategoryMap catMap) throws IOException {
        CategoryInfoManager catInfoManager = new CategoryInfoManager();
        catInfoManager.write(catMap, outPath, dataName);
    }

    protected void loadAltKeyGenerator(Properties dataProp) throws IOException {
        AlternateKeyGenerator altkeyGenerator = new AlternateKeyGenerator();
        altkeyGenerator.loadSubstitutionSetManager(dataProp);
        this.setAltKeyGenerator(altkeyGenerator);
    }

    protected void setAltKeyGenerator(AlternateKeyGenerator altKeyGenerator) {
        this.m_altKeyGenerator = altKeyGenerator;
    }

    protected AlternateKeyGenerator getAltKeyGenerator() {
        return this.m_altKeyGenerator;
    }

    protected void createOutFolder(String outPath) {
        outPath = MMUtils.appendToPath((String)outPath, (String)"");
        File file = new File(outPath);
        file.mkdirs();
    }

    protected void cleanOutFolder(File outputFolder, final String dataName) throws IOException {
        File[] filesToDelete;
        final Pattern filenameTokensPattern = Pattern.compile("\\.(?=[^\\.]+$)");
        for (File fileToDelete : filesToDelete = outputFolder.listFiles(new FilenameFilter(){
            List<String> fileExtList = Arrays.asList(".qad", ".rdx", ".ssm", ".cdx", AddressIOHandler.ADDRESS_DICT_SUFFIX);

            @Override
            public boolean accept(File file, String filename) {
                String[] filenameToks = filenameTokensPattern.split(filename);
                File currentFile = new File(file, filename);
                boolean isAdataFile = currentFile.isFile() && this.fileExtList.contains("." + filenameToks[1]) && filenameToks[0].equalsIgnoreCase(dataName);
                return isAdataFile || filename.equalsIgnoreCase(AbstractDataBuilder.DATA_VINTAGE_FILE_NAME.replace("DATA_NAME", dataName));
            }
        })) {
            if (fileToDelete.getCanonicalFile().getName().equalsIgnoreCase(fileToDelete.getName())) {
                if (fileToDelete.delete()) continue;
                String message = "Could not delete " + fileToDelete.getAbsolutePath();
                this.m_logger.error(message);
                throw new IOException(message);
            }
            String message = "File " + fileToDelete.getAbsolutePath() + " needs to be removed to continue.";
            this.m_logger.error(message);
            throw new IOException(message);
        }
    }

    protected void createRadixTree(String dataPath, String dataName, Map<StringKey, AddressPtrMap> wordMap, RadixTreeMetaData metaData) throws IOException {
        this.m_logger.info("creating prefix tree");
        byte[] altLookupStreamBytes = this.getBytesOfAlternateLookupTree(this.getAltKeyGenerator().getAltTokenRadixTree());
        metaData.setAdditionalBytes(altLookupStreamBytes);
        String fullPath = MMUtils.appendToPath((String)dataPath, (String)(dataName + ".rdx"));
        DiskRadixTree.createRTree(wordMap, (IRadixTreeMetaData)metaData, fullPath);
        this.m_logger.info("created prefix tree");
    }

    protected byte[] getBytesOfAlternateLookupTree(RadixTree<StringDataItem> altLookupTree) throws IOException {
        ICGGEDataStream altLookupStream = DataStreamFactory.getDataStream();
        RadixTreeMetaData metaData = new RadixTreeMetaData();
        DiskRadixTree.write(this.getAltKeyGenerator().getAltTokenRadixTree(), (IRadixTreeMetaData)metaData, altLookupStream);
        int byteCount = (int)altLookupStream.seekEnd();
        altLookupStream.seek(0L);
        byte[] bytes = new byte[byteCount];
        altLookupStream.readFully(bytes);
        return bytes;
    }

    protected void initLog() {
        this.m_logger = LoggerFactory.getLogger(this.getClass());
    }

    public static String getRequiredPropertyValue(Properties prop, String key) throws InvalidPropertyException {
        String value = prop.getProperty(key);
        if (MMUtils.isEmpty((String)value)) {
            throw new InvalidPropertyException("value required for " + key);
        }
        return value.trim();
    }

    protected AddressIOHandler getAddressIOHandler(String outPath, String dataName, ISourceDataReader dataReader, AddressMetaData metaData, CompHeader compHeader) throws IOException {
        return AddressIOHandler.create(outPath, dataName, metaData, new StringCompressor(compHeader));
    }

    protected void loadSearchFields(Properties dataProp, ISourceDataReader dataReader) throws InvalidPropertyException {
        String fieldsStr = dataProp.getProperty(SEARCH_FIELDS);
        if (MMUtils.isEmpty((String)fieldsStr)) {
            this.m_searchAllFields = true;
        } else {
            String[] fields = fieldsStr.split(",");
            this.m_searchFields = new HashSet<Integer>(fields.length);
            for (String field : fields) {
                if (MMUtils.isEmpty((String)(field = field.trim()))) continue;
                int fieldID = this.getFieldID(dataReader, field);
                if (fieldID < 0) {
                    String message = field + " in search fields is not available in source data";
                    this.m_logger.error(message);
                    throw new InvalidPropertyException(message);
                }
                this.m_searchFields.add(fieldID);
            }
            if (this.m_searchFields.size() == 0) {
                this.m_searchFields = null;
                this.m_searchAllFields = true;
            }
        }
    }

    protected boolean searchAllFields() {
        return this.m_searchAllFields;
    }

    private Collection<Integer> getSearchFields() {
        return this.m_searchFields;
    }

    protected void loadLastlineFormatFields(Properties dataProp, ISourceDataReader dataReader) throws InvalidPropertyException {
        String fieldsStr = dataProp.getProperty(LASTLINE_FORMAT_FIELDS);
        if (!MMUtils.isEmpty((String)fieldsStr)) {
            String[] fields = fieldsStr.split(",");
            this.m_lastlineFormatFields = new int[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (MMUtils.isEmpty((String)(field = field.trim()))) continue;
                int fieldID = this.getFieldID(dataReader, field);
                if (fieldID < 0) {
                    throw new InvalidPropertyException(field + " in lastline format fields is not available");
                }
                this.m_lastlineFormatFields[i] = fieldID;
            }
            if (this.m_lastlineFormatFields.length == 0) {
                this.m_lastlineFormatFields = null;
            }
        }
        this.m_lastlineFormatFieldsPattern = this.loadStreetAndLocationFormatPattern(dataProp, dataReader, LASTLINE_FORMAT_FIELDS_PATTERN);
    }

    @Deprecated
    protected int[] getLastlineFormatFields() {
        return this.m_lastlineFormatFields;
    }

    protected void loadStreetFormatFields(Properties dataProp, ISourceDataReader dataReader) throws InvalidPropertyException {
        String fieldsStr = dataProp.getProperty(STREET_FORMAT_FIELDS);
        if (!MMUtils.isEmpty((String)fieldsStr)) {
            String[] fields = fieldsStr.split(",");
            this.m_streetFormatFields = new int[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (MMUtils.isEmpty((String)(field = field.trim()))) continue;
                int fieldID = this.getFieldID(dataReader, field);
                if (fieldID < 0) {
                    if (FieldType.ADDRESS_NUMBER_FIELD_TYPE.getName().equalsIgnoreCase(field)) {
                        this.m_streetFormatFields[i] = FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey();
                        continue;
                    }
                    throw new InvalidPropertyException(field + " in street format fields is not available");
                }
                this.m_streetFormatFields[i] = fieldID;
            }
            if (this.m_streetFormatFields.length == 0) {
                this.m_streetFormatFields = null;
            }
        }
        this.m_streetFormatFieldsPattern = this.loadStreetAndLocationFormatPattern(dataProp, dataReader, STREET_FORMAT_FIELDS_PATTERN);
    }

    protected String loadStreetAndLocationFormatPattern(Properties dataProp, ISourceDataReader dataReader, String property) throws InvalidPropertyException {
        String[] formattedPattern = null;
        String fieldsStr = dataProp.getProperty(property);
        if (!MMUtils.isEmpty((String)fieldsStr)) {
            String[] fields = this.parseFormatString(fieldsStr);
            formattedPattern = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (!MMUtils.isEmpty((String)(field = field.trim()))) {
                    if (field.startsWith("{") && field.endsWith("}")) {
                        formattedPattern[i] = field;
                        continue;
                    }
                    int fieldID = this.getFieldID(dataReader, field);
                    if (fieldID < 0) {
                        if (FieldType.ADDRESS_NUMBER_FIELD_TYPE.getName().equalsIgnoreCase(field)) {
                            formattedPattern[i] = "[" + FieldType.ADDRESS_NUMBER_FIELD_TYPE.getKey() + "]";
                            continue;
                        }
                        throw new InvalidPropertyException(field + " in street format fields is not available");
                    }
                    formattedPattern[i] = "[" + fieldID + "]";
                    continue;
                }
                formattedPattern[i] = "";
            }
        }
        StringBuilder builder = new StringBuilder();
        if (formattedPattern != null) {
            for (String string : formattedPattern) {
                builder.append(string);
            }
        }
        return builder.toString();
    }

    private String[] parseFormatString(String format) {
        String[] parsed = null;
        if (!StringUtilities.isEmpty((String)format)) {
            StringTokenizer tokenizer = new StringTokenizer(format, "[]");
            parsed = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                parsed[i] = tokenizer.nextToken();
                ++i;
            }
        }
        return parsed;
    }

    @Deprecated
    protected int[] getStreetFormatFields() {
        return this.m_streetFormatFields;
    }

    protected String getStreetFormatPattern() {
        return this.m_streetFormatFieldsPattern;
    }

    protected String getLastLineFormatPattern() {
        return this.m_lastlineFormatFieldsPattern;
    }

    private int getFieldID(ISourceDataReader dataReader, String fieldName) {
        Map<Integer, String> fields = dataReader.getFields();
        for (Map.Entry<Integer, String> en : fields.entrySet()) {
            if (!en.getValue().equals(fieldName)) continue;
            return en.getKey();
        }
        return -1;
    }

    protected Rectangle preProcessData(ISourceDataReader dataReader, ICGGEDataOutput outputForCompression) throws IOException, CGGELevelException {
        Rectangle mbr = null;
        this.m_logger.info("pre processing records");
        this.m_totalRecords = 0;
        ProgressLogger progressLogger = new ProgressLogger(this.m_logger, 100000, "pre processed", "records");
        Collection<Integer> areaIDs = dataReader.getAreaIDs();
        int recordRejected = 0;
        for (int areaID : areaIDs) {
            Iterator<SimpleStreetAddress> addrIt = dataReader.getAddressIterator(areaID);
            while (addrIt.hasNext()) {
                SimpleStreetAddress addr = addrIt.next();
                if (this.acceptAddress(addr)) {
                    mbr = GeomUtil.getExpandedRectangle(mbr, addr.getBounds());
                    addr.write(outputForCompression);
                } else {
                    ++recordRejected;
                }
                progressLogger.logProgress(++this.m_totalRecords);
            }
        }
        this.m_logger.info("pre processed " + this.m_totalRecords + " records");
        if (recordRejected > 0) {
            this.m_logger.warn(recordRejected + " records were rejected");
        }
        this.m_logger.info("pre processing completed");
        this.m_logger.info("data set MBR : " + mbr);
        return mbr;
    }

    protected boolean acceptAddress(SimpleStreetAddress addr) {
        Rectangle bounds = this.getDataAreaBounds();
        if (bounds != null) {
            return bounds.fullyContains(addr.getBounds());
        }
        return true;
    }

    protected Rectangle getDataAreaBounds() {
        return this.m_dataAreaBounds;
    }

    protected QuadTree<AreaGeomItem> createQuadTree(ISourceDataReader dataReader, Rectangle mbr, String dataPath, String dataName) throws IOException, CGGELevelException {
        this.m_logger.info("creating spatial index");
        QuadTree<AreaGeomItem> geoHashTree = this.createNewQuadTree(mbr);
        ProgressLogger progressLogger = new ProgressLogger(this.m_logger, this.m_totalRecords, 5, "\t processed ", null);
        Collection<Integer> areaIDs = dataReader.getAreaIDs();
        int addrFetched = 0;
        ArrayList<AddressGeomItem> addrGeomItems = new ArrayList<AddressGeomItem>(100);
        for (int areaID : areaIDs) {
            Iterator<SimpleStreetAddress> addrIt = dataReader.getAddressIterator(areaID);
            Rectangle areaBounds = null;
            addrGeomItems.clear();
            while (addrIt.hasNext()) {
                SimpleStreetAddress addr = addrIt.next();
                if (!this.acceptAddress(addr)) continue;
                Rectangle addrBounds = addr.getBounds();
                AddressPtr addrPtr = addr.getAddressPtr();
                AddressGeomItem addrGeomItem = new AddressGeomItem(addrPtr.getFirstAddressID(), addrBounds);
                addrGeomItems.add(addrGeomItem);
                areaBounds = GeomUtil.getExpandedRectangle(areaBounds, addrBounds);
                progressLogger.logPercentageCompleted(++addrFetched);
            }
            if (areaBounds == null) continue;
            AreaGeomItem areaGeomItem = this.getAreaGeomItem(areaID, areaBounds, addrGeomItems);
            geoHashTree.addItem(areaGeomItem);
        }
        this.writeQuadTree(geoHashTree, dataPath, dataName);
        this.m_logger.info("created spatial index");
        return this.loadQuadTree(dataPath, dataName);
    }

    AreaGeomItem getAreaGeomItem(int areaID, Rectangle areaBounds, List<AddressGeomItem> addrItems) {
        AreaGeomItem areaGeomItem = null;
        if (!addrItems.isEmpty()) {
            areaGeomItem = new AreaGeomItem(areaID, areaBounds);
            for (AddressGeomItem addrItem : addrItems) {
                areaGeomItem.addAddressItem(addrItem);
            }
        }
        return areaGeomItem;
    }

    protected QuadTree<AreaGeomItem> createNewQuadTree(Rectangle dataMBR) {
        return new GeoHashTree<AreaGeomItem>(50, new AreaGeomItem(-1, null), dataMBR);
    }

    protected Map<StringKey, AddressPtrMap> createAddressData(ISourceDataReader dataReader, CompHeaderCreatorOutput outputForCompression, String dataPath, String dataName, CategoryMap catMap) throws IOException, CGGELevelException {
        AddressMetaData addrMetaData = this.createAddressMetaData(dataName, dataReader);
        addrMetaData.write((ICGGEDataOutput)outputForCompression);
        if (catMap != null) {
            this.initCategoryMap(catMap, addrMetaData);
        }
        AddressIOHandler addrIoHandler = this.getAddressIOHandler(dataPath, dataName, dataReader, addrMetaData, outputForCompression.getCompressor());
        return this.createAddressData(dataReader, addrIoHandler, dataPath, catMap);
    }

    private void initCategoryMap(CategoryMap catMap, AddressMetaData addrMetaData) {
        int categoryIDField = addrMetaData.getFieldID("CategoryID");
        logger.debug("categoryID field is " + categoryIDField);
        catMap.setCategoryIDField(categoryIDField);
        if (this.m_searchFields == null) {
            this.m_searchFields = new HashSet<Integer>();
            this.m_searchAllFields = true;
        }
        this.getSearchFields().add(categoryIDField);
    }

    protected Map<StringKey, AddressPtrMap> createAddressData(ISourceDataReader dataReader, AddressIOHandler addrIoHandler, String dataPath) throws IOException, CGGELevelException {
        return this.createAddressData(dataReader, addrIoHandler, dataPath, null);
    }

    protected Map<StringKey, AddressPtrMap> createAddressData(ISourceDataReader dataReader, AddressIOHandler addrIoHandler, String dataPath, CategoryMap catMap) throws IOException, CGGELevelException {
        this.m_logger.info("creating address data set");
        AddressNumberHasher addrNumHasher = this.getNewAddressNumberHasher();
        Map<StringKey, AddressPtrMap> wordAddressLinkMap = this.createTempWordLinkMap(dataPath);
        ProgressLogger progressLogger = new ProgressLogger(this.m_logger, this.m_totalRecords, 5, "\t processed", null);
        int processed = 0;
        Collection<Integer> areaIDs = dataReader.getAreaIDs();
        addrIoHandler.prepareAreaIdStorage(areaIDs);
        for (int areaID : areaIDs) {
            HashMap<String, AddressPtrMap> areaWordLinkMap = new HashMap<String, AddressPtrMap>(100);
            List<SimpleStreetAddress> addrs = this.getFilteredAddresses(dataReader, areaID);
            if (addrs.isEmpty()) continue;
            addrNumHasher.setAddressNumberHashes(addrs);
            for (SimpleStreetAddress addr : addrs) {
                if (catMap != null) {
                    this.processCategoryInformation(catMap, areaWordLinkMap, addr);
                }
                this.processAddressWordLinks(areaWordLinkMap, addr);
                progressLogger.logPercentageCompleted(++processed);
            }
            addrIoHandler.writeAddressGroup(addrs, areaID, 0);
            this.copyWords(areaWordLinkMap, wordAddressLinkMap);
        }
        addrIoHandler.commit();
        addrIoHandler.close();
        addrNumHasher.logStats(this.m_logger);
        return wordAddressLinkMap;
    }

    protected List<SimpleStreetAddress> getFilteredAddresses(ISourceDataReader dataReader, int areaID) throws CGGELevelException, IOException {
        Iterator<SimpleStreetAddress> addrIt = dataReader.getAddressIterator(areaID);
        ArrayList<SimpleStreetAddress> addrList = new ArrayList<SimpleStreetAddress>(100);
        while (addrIt.hasNext()) {
            SimpleStreetAddress addr = addrIt.next();
            if (!this.acceptAddress(addr)) continue;
            addrList.add(addr);
        }
        return addrList;
    }

    protected void writeQuadTree(QuadTree<AreaGeomItem> quadTree, String outPath, String dataName) throws IOException {
        String fullName = MMUtils.appendToPath((String)outPath, (String)(dataName + ".qad"));
        DiskQuadTree.write(fullName, quadTree);
    }

    protected QuadTree<AreaGeomItem> loadQuadTree(String outPath, String dataName) throws IOException {
        String fullPath = MMUtils.appendToPath((String)outPath, (String)(dataName + ".qad"));
        ICGGEDataStream stream = DataStreamFactory.getDataStream((String)fullPath);
        return DiskQuadTree.read((ICGGEDataInputStream)stream, new AreaGeomItem(-1, null));
    }

    protected void processAddressWordLinks(Map<String, AddressPtrMap> wordLinkMap, SimpleStreetAddress addr) {
        AddressPtr addrPtr = addr.getAddressPtr();
        this.processAddressWordLinks(wordLinkMap, addr, addrPtr);
        this.processRangeWordLinks(wordLinkMap, addr, addrPtr);
    }

    private void processRangeWordLinks(Map<String, AddressPtrMap> wordLinkMap, SimpleStreetAddress addr, AddressPtr addrPtr) {
        int rangeCount = addr.getRangeCount();
        for (int i = 0; i < rangeCount; ++i) {
            SimpleRange range = addr.getRangeAt(i);
            this.processAddressWordLinks(wordLinkMap, range, addrPtr);
            this.processUnitWordLinks(wordLinkMap, range, addrPtr);
        }
    }

    private void processUnitWordLinks(Map<String, AddressPtrMap> wordLinkMap, SimpleRange range, AddressPtr addrPtr) {
        int unitCount = range.getUnitCount();
        for (int i = 0; i < unitCount; ++i) {
            this.processAddressWordLinks(wordLinkMap, range.getUnitAt(i), addrPtr);
        }
    }

    protected void processAddressWordLinks(Map<String, AddressPtrMap> wordLinkMap, InternalSimpleAddress addrObj, AddressPtr addressPtr) {
        Map<Integer, List<String>> fields = addrObj.getFields();
        if (fields != null) {
            for (Map.Entry<Integer, List<String>> en : fields.entrySet()) {
                int fieldID = en.getKey();
                if (!this.isSearchField(fieldID)) continue;
                for (String str : en.getValue()) {
                    AddressPtr addrPtrCopy = addressPtr.copy();
                    try {
                        this.addWord(wordLinkMap, str, fieldID, addrPtrCopy);
                    }
                    catch (RuntimeException re) {
                        logger.debug("Failed processing address: " + addrObj, (Throwable)re);
                        throw new RuntimeException("Failed processing address: " + addrObj, re);
                    }
                }
            }
        }
    }

    protected void processCategoryInformation(CategoryMap catMap, Map<String, AddressPtrMap> wordLinkMap, SimpleStreetAddress addr) {
        List<String> ids;
        catMap.processCategoryInformation(addr);
        int categoryIDField = catMap.getCategoryIDField();
        if (categoryIDField > 0 && (ids = addr.getField(categoryIDField)) != null) {
            for (String id : ids) {
                AddressPtr addrPtrCopy = addr.getAddressPtr().copy();
                String idKey = catMap.makeCategorySearchKey(id);
                this.addWord0(wordLinkMap, idKey, categoryIDField, addrPtrCopy);
            }
            addr.getFields().remove(catMap.getCategoryField());
            addr.getFields().remove(catMap.getSubCategoryField());
        }
    }

    protected boolean isSearchField(int fieldID) {
        if (this.searchAllFields()) {
            return true;
        }
        Collection<Integer> searchFields = this.getSearchFields();
        return searchFields == null ? true : searchFields.contains(fieldID);
    }

    private boolean isPOIData(ISourceDataReader dataReader) {
        return dataReader.getDataType() == 1;
    }

    protected void addWord(Map<String, AddressPtrMap> wordMap, String str, int fieldType, AddressPtr addrPtr) {
        if (!MMUtils.isEmpty((String)(str = StringNormalizer.normalise(str)))) {
            String stdStr = this.getAltKeyGenerator().standardise(str, fieldType);
            if (MMUtils.isEmpty((String)stdStr)) {
                throw new RuntimeException("standardised " + str + " is an empty string");
            }
            this.addWord0(wordMap, stdStr, fieldType, addrPtr);
            String shortStr = this.getAltKeyGenerator().getShortestVersion(stdStr, WORD_TYPES_TO_REMOVE);
            if (!StringUtilities.isEmpty((String)shortStr) && !stdStr.equals(shortStr)) {
                AddressPtr addrPtrCopy = addrPtr.copy();
                this.addWord0(wordMap, shortStr, fieldType, addrPtrCopy);
            }
        }
    }

    protected void addWord0(Map<String, AddressPtrMap> wordMap, String str, int fieldType, AddressPtr addrPtr) {
        AddressPtrMap addrPtrMap = wordMap.get(str);
        if (addrPtrMap == null) {
            addrPtrMap = new AddressPtrMap();
            wordMap.put(str, addrPtrMap);
        }
        addrPtrMap.add(fieldType, addrPtr);
    }

    protected void copyWords(Map<String, AddressPtrMap> wordMap, Map<StringKey, AddressPtrMap> map) {
        if (!wordMap.isEmpty()) {
            for (Map.Entry<String, AddressPtrMap> en : wordMap.entrySet()) {
                StringKey key = new StringKey(en.getKey());
                AddressPtrMap addrPtrs = map.get(key);
                if (addrPtrs == null) {
                    addrPtrs = en.getValue();
                } else {
                    addrPtrs.combine(en.getValue());
                }
                map.put(key, addrPtrs);
            }
        }
    }

    protected Map<StringKey, AddressPtrMap> createTempWordLinkMap(String outPath) throws IOException {
        File tempFile = File.createTempFile("ud-words", ".tmp");
        tempFile.deleteOnExit();
        this.m_logger.info("created temp file: " + tempFile.getAbsolutePath());
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream((File)tempFile, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
        DiskBTree map = DiskBTree.create((ICGGEDataStream)dataStream, (IDiskTreeKey)new StringKey(""), (IDataItem)new AddressPtrMap(), (int)50);
        map.setCachedItemCount(15000);
        map.setCachedNodeCount(25);
        return map.getMap();
    }

    protected void loadAllowedAreaBounds(Properties prop) throws InvalidPropertyException {
        String strBounds = prop.getProperty(KEY_DATA_AREA_BOUNDS);
        this.m_dataAreaBounds = null;
        if (!MMUtils.isEmpty((String)strBounds)) {
            String[] strCoords = strBounds.trim().split(",");
            if (strCoords == null || strCoords.length != 4) {
                throw new InvalidPropertyException("invalid area bounds specified for dataAreaBounds");
            }
            double[] areaBounds = new double[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    areaBounds[i] = Double.parseDouble(strCoords[i]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    throw new InvalidPropertyException("invalid value specified for dataAreaBounds");
                }
            }
            this.m_dataAreaBounds = new Rectangle(areaBounds[0], areaBounds[1], areaBounds[2], areaBounds[3]);
        }
    }

    protected AddressMetaData createAddressMetaData(String dataName, ISourceDataReader dataReader) {
        HashMap<String, Object> additionalMetaData = new HashMap<String, Object>();
        additionalMetaData.put("supportedCountries", dataReader.getSupportedCountries());
        additionalMetaData.put("dataVintage", this.dataVintage);
        additionalMetaData.put("dataProductCode", this.dataProductCode);
        additionalMetaData.put("dataType", dataReader.getDataType());
        additionalMetaData.put("isCustomDict", dataReader.isCustomData());
        additionalMetaData.put("dataLanguage", dataReader.getLanguage());
        additionalMetaData.put("additionalFields", dataReader.getAdditionalFields());
        return new AddressMetaData(dataName, dataReader.getFields(), this.getStreetFormatFields(), this.getLastlineFormatFields(), additionalMetaData, this.getStreetFormatPattern(), this.getLastLineFormatPattern());
    }

    protected RadixTreeMetaData createRadixTreeMetaData(String dataName, ISourceDataReader dataReader, CompHeader compHeader) {
        RadixTreeMetaData radixMetaData = new RadixTreeMetaData(dataName, dataReader.getDataType(), compHeader, dataReader.isCustomData());
        Map<Integer, String> fields = dataReader.getFields();
        for (Map.Entry<Integer, String> en : fields.entrySet()) {
            Integer fieldID = en.getKey();
            if (!this.isSearchField(fieldID)) continue;
            radixMetaData.addFieldName(fieldID, en.getValue());
        }
        return radixMetaData;
    }

    private String getTimeString(long millis) {
        int seconds = (int)(millis / 1000L);
        int hours = seconds / 3600;
        int mins = seconds % 3600 / 60;
        int secs = seconds % 3600 % 60;
        return hours + ":" + mins + ":" + secs;
    }

    AddressNumberHasher getNewAddressNumberHasher() {
        return new AddressNumberHasher();
    }
}

