/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.AddressUtil;
import com.mapinfo.mapmarker.autosuggest.dp.NumberRangeHasher;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.cgge.utils.BitArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class AddressNumberHasher {
    private Map<Byte, AtomicInteger> m_hashAreaCountMap = new HashMap<Byte, AtomicInteger>();
    private Map<Byte, AtomicInteger> m_hashAddrCountMap = new HashMap<Byte, AtomicInteger>();
    private NumberRangeHasher m_numberRangeHasher;

    public AddressNumberHasher() {
        this.setNumberRangeHasher(new NumberRangeHasher());
    }

    public void setAddressNumberHashes(List<SimpleStreetAddress> areaAddrs) {
        byte areaHash = this.setHashForEachAddress(areaAddrs);
        this.increamentAreaCount(areaHash);
    }

    public void logStats(Logger logger) {
        logger.info("Address Number hashes and area count");
        this.log(this.m_hashAreaCountMap, logger);
        logger.info("Address Number hashes and address count");
        this.log(this.m_hashAddrCountMap, logger);
    }

    void setNumberRangeHasher(NumberRangeHasher numRangeHasher) {
        this.m_numberRangeHasher = numRangeHasher;
    }

    NumberRangeHasher getNumberRangeHasher() {
        return this.m_numberRangeHasher;
    }

    private byte setHashForEachAddress(List<SimpleStreetAddress> areaAddrs) {
        int areaHash = 0;
        NumberRangeHasher numRangeHasher = this.getNumberRangeHasher();
        for (SimpleStreetAddress addr : areaAddrs) {
            int hash = 0;
            List<SimpleRange> ranges = addr.getRanges();
            if (!ListUtils.isEmpty(ranges)) {
                List<NumberRange> numRanges = this.getNumberRanges(ranges);
                hash |= numRangeHasher.hash(numRanges);
            }
            this.increamentAddrCount((byte)hash);
            addr.getAddressPtr().setAreaAddrNumberRangeHash((byte)hash);
            areaHash |= hash;
        }
        return (byte)areaHash;
    }

    private void increamentAddrCount(byte hash) {
        this.increamentHashCount(this.m_hashAddrCountMap, hash);
    }

    private void increamentAreaCount(byte hash) {
        this.increamentHashCount(this.m_hashAreaCountMap, hash);
    }

    private void increamentHashCount(Map<Byte, AtomicInteger> map, byte hash) {
        AtomicInteger count = map.get(hash);
        if (count == null) {
            count = new AtomicInteger(1);
            map.put(hash, count);
        } else {
            count.incrementAndGet();
        }
    }

    private List<NumberRange> getNumberRanges(List<SimpleRange> ranges) {
        ArrayList<NumberRange> numRanges = new ArrayList<NumberRange>(ranges.size());
        for (SimpleRange range : ranges) {
            NumberRange numRange = AddressUtil.convertToNumericRange(range);
            if (numRange == null) continue;
            numRanges.add(numRange);
        }
        return numRanges;
    }

    private void log(Map<Byte, AtomicInteger> map, Logger logger) {
        for (Map.Entry<Byte, AtomicInteger> en : map.entrySet()) {
            logger.info("\t\t" + BitArray.fromByte((byte)en.getKey()).toString() + " : " + en.getValue().get());
        }
    }
}

