/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.dp.builder;

import com.mapinfo.mapmarker.autosuggest.dp.AddressPtr;
import com.mapinfo.mapmarker.autosuggest.dp.ISourceDataReader;
import com.mapinfo.mapmarker.autosuggest.dp.InternalSimpleAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleRange;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleStreetAddress;
import com.mapinfo.mapmarker.autosuggest.dp.SimpleUnit;
import com.mapinfo.mapmarker.autosuggest.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.autosuggest.dp.builder.IntKey;
import com.mapinfo.mapmarker.autosuggest.dp.builder.ProgressLogger;
import com.mapinfo.mapmarker.autosuggest.exception.CGGELevelException;
import com.mapinfo.mapmarker.autosuggest.exception.DataFetchException;
import com.mapinfo.mapmarker.autosuggest.utils.AbstractReadOnlyIterator;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidPropertyException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.utils.ArrayUtils;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.cgge.utils.index.DiskBTree;
import com.mapinfo.mapmarker.cgge.utils.index.IDiskTreeKey;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IDataItem;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceDataReader
implements ISourceDataReader {
    public static final String KEY_READER_CLASS = "dataReader";
    public static final int DEFAULT_AREA_ID = 100;
    public static final String KEY_UNIT_ADDITIONAL_FIELDS = "UnitAdditionalFields";
    public static final String KEY_RANGE_ADDITIONAL_FIELDS = "RangeAdditionalFields";
    public static final String KEY_STREET_ADDITIONAL_FIELDS = "StreetAdditionalFields";
    public static final String KEY_POSTAL_ADDITIONAL_FIELDS = "PostalAdditionalFields";
    public static final String KEY_DATA_TYPE = "dictionaryType";
    public static final String KEY_IS_CUSTOM_DICTIONARY = "userDictionary";
    public static final String KEY_DATA_LANGUAGE = "dataLanguage";
    public static final String KEY_DATA_TYPE_STREET = "street";
    public static final String KEY_DATA_TYPE_POI = "poi";
    public static final String KEY_SUPPORTED_COUNTRIES = "supportedCountries";
    private RawDataReader internalReader = null;
    public static Logger logger = LoggerFactory.getLogger(SourceDataReader.class);
    private int[] areasForAreaID = null;
    private int nextAreaID = 101;
    private Map<String, Integer> uniqueAreaMap = null;
    private Map<Integer, String> dataFields = null;
    private Map<IntKey, OffsetLink> areaToAddrOffsetMap;
    private ICGGEDataStream tempAddrFile;
    private int dataType;
    private boolean isCustomData;
    private String supportedCountries;
    private String country;
    private String language;
    private Map<String, FieldType> additionalFieldsMap = null;

    protected void init() {
        this.dataFields = new HashMap<Integer, String>(10);
        this.additionalFieldsMap = new HashMap<String, FieldType>(10);
        this.uniqueAreaMap = new HashMap<String, Integer>(1000);
        this.nextAreaID = 101;
        int[] areasForAreaID = new int[]{FieldType.AREA_NAME_1_FIELD_TYPE.getKey(), FieldType.AREA_NAME_2_FIELD_TYPE.getKey(), FieldType.AREA_NAME_3_FIELD_TYPE.getKey(), FieldType.AREA_NAME_4_FIELD_TYPE.getKey(), FieldType.POST_CODE_FIELD_TYPE.getKey()};
        this.setAreasForAreaID(areasForAreaID);
    }

    @Override
    public void load(Properties dataProp) throws InvalidPropertyException, CGGELevelException, IOException, IllegalAccessException, InstantiationException {
        this.init();
        logger.info("Loading source data and creating temp files");
        String outPath = DataBuilder.getRequiredPropertyValue(dataProp, "outputPath");
        this.country = dataProp.getProperty("country");
        this.setSupportedCountries(dataProp.getProperty(KEY_SUPPORTED_COUNTRIES, this.country));
        this.setDataType(this.getDataTypeFromConfig(dataProp));
        this.isCustomData = this.getCustomDataFlag(dataProp);
        this.language = dataProp.getProperty(KEY_DATA_LANGUAGE, "");
        this.additionalFieldsMap = this.processAdditionalFields(dataProp);
        RawDataReader internalReader = this.getReader(dataProp, this.additionalFieldsMap);
        this.setInternalReader(internalReader);
        this.createAreaToAddressOffsetMap(outPath);
        this.createTempAddressFile(outPath);
        this.processData(internalReader, this.getAreaToAddrOffsetMap(), this.getTempAddressStream());
        this.finaliseDataLoading();
        logger.info("Loading source data and creating temp files completed");
    }

    void finaliseDataLoading() throws IOException {
        Map<IntKey, OffsetLink> map = this.getAreaToAddrOffsetMap();
        if (map instanceof DiskBTree) {
            ((DiskBTree)map).commit();
        }
        this.getInternalReader().close();
    }

    RawDataReader getInternalReader() {
        return this.internalReader;
    }

    void setInternalReader(RawDataReader rawDataReader) {
        this.internalReader = rawDataReader;
    }

    boolean getCustomDataFlag(Properties dataProp) {
        return PropertiesUtil.getBooleanPropertyValue((Properties)dataProp, (String)KEY_IS_CUSTOM_DICTIONARY, (boolean)false);
    }

    protected int getDataTypeFromConfig(Properties dataProp) throws InvalidPropertyException {
        int dataType = 0;
        String strDataType = dataProp.getProperty(KEY_DATA_TYPE);
        if (!MMUtils.isEmpty((String)strDataType)) {
            if (KEY_DATA_TYPE_STREET.equalsIgnoreCase(strDataType)) {
                dataType = 0;
            } else if (KEY_DATA_TYPE_POI.equalsIgnoreCase(strDataType)) {
                dataType = 1;
            } else {
                throw new InvalidPropertyException("Invalid dictionary type in property file :" + dataType);
            }
        }
        return dataType;
    }

    protected void setDataType(int dataType) {
        this.dataType = dataType;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isCustomData() {
        return this.isCustomData;
    }

    protected void processData(RawDataReader reader, Map<IntKey, OffsetLink> areaOffsetMap, ICGGEDataStream addrFile) throws IOException {
        int processed = 0;
        ProgressLogger progressLogger = new ProgressLogger(logger, 100000, "\t processed", null);
        String wgs84Name = "epsg:4326";
        CoordTransform transformer = null;
        String datum = reader.getCoordSysString();
        if (datum != null && datum.length() > 0 && !"epsg:4326".equals(datum)) {
            transformer = new CoordTransform(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(datum), CoordSysFactory.getDefaultCoordSysFactory().getCoordSys("epsg:4326"));
        }
        while (reader.loadNextFileSet()) {
            RawAddress rawAddress = null;
            while ((rawAddress = reader.getNextRecord()) != null) {
                if (transformer != null) {
                    DirectPosition[] coordList = rawAddress.getCoordinates();
                    if (coordList != null && coordList.length > 0) {
                        for (int i = 0; i < coordList.length; ++i) {
                            transformer.transform(coordList[i], coordList[i]);
                        }
                    }
                    rawAddress.setCoordinates(coordList);
                }
                if (!this.country.equals(this.supportedCountries)) {
                    AddressFieldValue value = (AddressFieldValue)rawAddress.getField(FieldType.COUNTRY_FIELD_TYPE);
                    if (this.supportedCountries.indexOf((String)value.getFieldValue()) <= -1) continue;
                    processed = this.dataProcess(areaOffsetMap, addrFile, processed, progressLogger, rawAddress);
                    continue;
                }
                processed = this.dataProcess(areaOffsetMap, addrFile, processed, progressLogger, rawAddress);
            }
        }
        logger.info("\ttotal " + processed + " records (left + right) processed");
    }

    private int dataProcess(Map<IntKey, OffsetLink> areaOffsetMap, ICGGEDataStream addrFile, int processed, ProgressLogger progressLogger, RawAddress rawAddress) throws IOException {
        this.convertAndWrite(rawAddress, areaOffsetMap, addrFile);
        progressLogger.logProgress(++processed);
        return processed;
    }

    protected void convertAndWrite(RawAddress rawAddress, Map<IntKey, OffsetLink> areaMap, ICGGEDataStream addrStream) throws IOException {
        SimpleStreetAddress streetAddr = this.convert(rawAddress);
        int areaID = this.getAreaID(streetAddr);
        this.writeAddressAndSetOffset(streetAddr, areaID, addrStream, areaMap);
    }

    protected void writeAddressAndSetOffset(SimpleStreetAddress streetAddr, int areaID, ICGGEDataStream addrStream, Map<IntKey, OffsetLink> areaMap) throws IOException {
        long offset = addrStream.seekEnd();
        streetAddr.write((ICGGEDataOutput)addrStream);
        OffsetLink newOffsetLink = new OffsetLink(offset);
        IntKey areaIDKey = new IntKey(areaID);
        OffsetLink link = areaMap.get(new IntKey(areaID));
        if (link != null) {
            newOffsetLink.next = link;
        }
        areaMap.put(areaIDKey, newOffsetLink);
    }

    protected SimpleStreetAddress convert(RawAddress addr) {
        SimpleStreetAddress internalAddr = new SimpleStreetAddress();
        SimpleRange range = this.makeRange(addr);
        SimpleUnit unit = this.makeUnit(addr);
        this.copyFields(addr, internalAddr, range, unit);
        if (this.isValidUnit(unit)) {
            range.addUnit(unit);
        }
        if (this.isValidRange(range)) {
            internalAddr.addRange(range);
        }
        internalAddr.setBounds(GeomUtil.getBounds(addr.getCoordinates()));
        return internalAddr;
    }

    private boolean isValidUnit(SimpleUnit unit) {
        return unit.getUnit() != null || unit.getFieldCount() > 0;
    }

    protected SimpleUnit makeUnit(RawAddress addr) {
        SimpleUnit unit = new SimpleUnit();
        if (!addr.isEmpty(FieldType.UNIT_INFO_FIELD_TYPE)) {
            unit.setUnit((String)((AddressFieldValue)addr.getField(FieldType.UNIT_INFO_FIELD_TYPE)).getFieldValue());
        }
        return unit;
    }

    protected boolean isValidRange(SimpleRange range) {
        if (!range.getFields().isEmpty()) {
            return true;
        }
        return this.isValidHouseNumber(range.getFrom());
    }

    protected boolean isValidHouseNumber(String str) {
        if (str != null) {
            if (MMUtils.isNumber((String)str)) {
                try {
                    int n = Integer.parseInt(str);
                    return n > -1;
                }
                catch (NumberFormatException NFEX) {
                    logger.info("Too large an input housenumber: " + str);
                    return false;
                }
            }
            if (!MMUtils.isEmpty((String)str)) {
                return true;
            }
        }
        return false;
    }

    protected void copyFields(RawAddress srcAddr, SimpleStreetAddress addr, SimpleRange range, SimpleUnit unit) {
        Map inFields = srcAddr.getFields();
        HashMap<Integer, List<String>> streetFields = new HashMap<Integer, List<String>>(5);
        HashMap<Integer, List<String>> rangeFields = new HashMap<Integer, List<String>>(5);
        HashMap<Integer, List<String>> unitFields = new HashMap<Integer, List<String>>(5);
        if (inFields != null) {
            for (Map.Entry en : inFields.entrySet()) {
                FieldType fieldType = (FieldType)en.getKey();
                if (this.isStreetLevel(fieldType)) {
                    this.addToMap(fieldType, (AddressFieldValue)en.getValue(), streetFields);
                    continue;
                }
                if (range != null && this.isRangeLevel(fieldType)) {
                    this.addToMap(fieldType, (AddressFieldValue)en.getValue(), rangeFields);
                    continue;
                }
                if (unit == null || !this.isUnitLevel(fieldType)) continue;
                this.addToMap(fieldType, (AddressFieldValue)en.getValue(), unitFields);
            }
        }
        addr.setFields(streetFields);
        range.setFields(rangeFields);
        unit.setFields(unitFields);
    }

    private void addToMap(FieldType ft, AddressFieldValue fv, Map<Integer, List<String>> map) {
        List<String> fvs = this.convertFieldValues(fv);
        int fieldID = ft.getKey();
        if (fvs != null) {
            map.put(fieldID, fvs);
            this.addToFields(fieldID, ft.getName());
        }
    }

    private void addToFields(Map<String, FieldType> fieldMap) {
        if (fieldMap != null) {
            for (Map.Entry<String, FieldType> en : fieldMap.entrySet()) {
                String fieldName = en.getKey();
                int fieldID = en.getValue().getKey();
                this.addToFields(fieldID, fieldName);
            }
        }
    }

    private void addToFields(int fieldID, String name) {
        if (!this.dataFields.containsKey(fieldID)) {
            this.dataFields.put(fieldID, name);
        }
    }

    protected SimpleRange makeRange(RawAddress addr) {
        AddressFieldValue fv = (AddressFieldValue)addr.getField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE);
        String from = null;
        String to = null;
        if (fv != null) {
            from = (String)fv.getFieldValue();
            if (this.isValidHouseNumber(from)) {
                fv = (AddressFieldValue)addr.getField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE);
                if (fv != null) {
                    to = (String)fv.getFieldValue();
                }
            } else {
                from = null;
            }
        }
        SimpleRange r = new SimpleRange(from, to);
        if (from != null && to != null) {
            this.setOddEvenType(r, addr.getOddEvenType());
        }
        return r;
    }

    void setOddEvenType(SimpleRange r, int type) {
        int internalType = 0;
        switch (type) {
            case 2: {
                internalType = 2;
                break;
            }
            case 3: {
                internalType = 1;
                break;
            }
            case 4: {
                internalType = 0;
                break;
            }
            case 5: {
                internalType = 0;
                break;
            }
            default: {
                internalType = this.checkRangeType(r);
            }
        }
        r.setOddEvenType(internalType);
    }

    private int checkRangeType(SimpleRange r) {
        String from = r.getFrom();
        String to = r.getTo();
        if (MMUtils.isNumber((String)from) && MMUtils.isNumber((String)to)) {
            int f = Integer.parseInt(from);
            int t = Integer.parseInt(to);
            if (this.isEven(f) && this.isEven(t)) {
                return 2;
            }
            if (this.isOdd(f) && this.isOdd(t)) {
                return 1;
            }
        }
        return 0;
    }

    private boolean isOdd(int number) {
        return number % 2 != 0;
    }

    private boolean isEven(int number) {
        return number % 2 == 0;
    }

    protected boolean isStreetLevel(FieldType type) {
        FieldType.FieldLevel level = type.getLevel();
        return level == FieldType.FieldLevel.LEVEL_POSTAL || level == FieldType.FieldLevel.LEVEL_STREET;
    }

    protected boolean isUnitLevel(FieldType type) {
        FieldType.FieldLevel level = type.getLevel();
        if (level == FieldType.FieldLevel.LEVEL_UNIT || level == FieldType.FieldLevel.LEVEL_UNIT) {
            return type != FieldType.UNIT_INFO_FIELD_TYPE;
        }
        return false;
    }

    protected boolean isRangeLevel(FieldType type) {
        FieldType.FieldLevel level = type.getLevel();
        if (level == FieldType.FieldLevel.LEVEL_RANGE) {
            return type != FieldType.ADDRESS_NUMBER_FIELD_TYPE && type != FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE && type != FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE;
        }
        return false;
    }

    protected List<String> convertFieldValues(AddressFieldValue fv) {
        List fieldValues = null;
        if (fv != null) {
            String str = (String)fv.getFieldValue();
            if (!MMUtils.isEmpty((String)str)) {
                fieldValues = ListUtils.addToList(fieldValues, (Object)str);
            }
            if (fv.hasAlternates()) {
                HashSet<String> currentValues = new HashSet<String>();
                if (fieldValues != null) {
                    currentValues.addAll(fieldValues);
                }
                for (String alt : (String[])fv.getAlternateValues()) {
                    if (MMUtils.isEmpty((String)alt) || currentValues.contains(alt)) continue;
                    fieldValues = ListUtils.addToList((List)fieldValues, (Object)alt);
                    currentValues.add(alt);
                }
            }
        }
        return fieldValues;
    }

    protected int getAreaID(InternalSimpleAddress addr) {
        Integer areaID = null;
        String areaCodeString = this.makeAreaCodeString(addr);
        if (areaCodeString != null) {
            areaID = this.uniqueAreaMap.get(areaCodeString);
            if (areaID == null) {
                areaID = this.nextAreaID++;
                this.uniqueAreaMap.put(areaCodeString, areaID);
            }
        } else {
            areaID = 100;
        }
        return areaID;
    }

    protected int[] getAreasForAreaID() {
        return this.areasForAreaID;
    }

    protected void setAreasForAreaID(int[] areas) {
        this.areasForAreaID = areas;
    }

    protected String makeAreaCodeString(InternalSimpleAddress addr) {
        StringBuilder sb = new StringBuilder();
        for (int fieldID : this.getAreasForAreaID()) {
            List<String> list = addr.getField(fieldID);
            if (list == null || list.isEmpty()) continue;
            sb.append(list.get(0).toUpperCase().trim());
        }
        String areaCodeString = sb.toString();
        return MMUtils.isEmpty((String)areaCodeString) ? null : areaCodeString.trim();
    }

    public Map<String, FieldType> processAdditionalFields(Properties prop) {
        String[] unitAdditionalFieldNames = this.split(prop.getProperty(KEY_UNIT_ADDITIONAL_FIELDS));
        String[] rangeAdditionalFieldNames = this.split(prop.getProperty(KEY_RANGE_ADDITIONAL_FIELDS));
        Object[] streetAdditionalFieldNames = this.split(prop.getProperty(KEY_STREET_ADDITIONAL_FIELDS));
        String[] postalAdditionalFieldNames = this.split(prop.getProperty(KEY_POSTAL_ADDITIONAL_FIELDS));
        if (this.getDataType() == 1) {
            streetAdditionalFieldNames = (String[])ArrayUtils.combineArrays((Object[])streetAdditionalFieldNames, (Object[])new String[]{"CategoryID"});
        }
        HashMap<String, FieldType> additionalFieldsMap = new HashMap<String, FieldType>(10);
        int idStart = 30;
        idStart += this.createTypeForAdditionFields(additionalFieldsMap, unitAdditionalFieldNames, FieldType.FieldLevel.LEVEL_UNIT, idStart);
        idStart += this.createTypeForAdditionFields(additionalFieldsMap, rangeAdditionalFieldNames, FieldType.FieldLevel.LEVEL_RANGE, idStart);
        idStart += this.createTypeForAdditionFields(additionalFieldsMap, (String[])streetAdditionalFieldNames, FieldType.FieldLevel.LEVEL_STREET, idStart);
        idStart += this.createTypeForAdditionFields(additionalFieldsMap, postalAdditionalFieldNames, FieldType.FieldLevel.LEVEL_POSTAL, idStart);
        this.addToFields(additionalFieldsMap);
        return additionalFieldsMap;
    }

    private int createTypeForAdditionFields(Map<String, FieldType> additionalFieldNames, String[] fields, FieldType.FieldLevel level, int idStart) {
        int added = 0;
        if (additionalFieldNames != null && fields != null) {
            for (String field : fields) {
                if (MMUtils.isEmpty((String)field) || this.addedAsKnownType(additionalFieldNames, field = field.trim())) continue;
                FieldType newType = new FieldType(idStart + added++, level, field);
                additionalFieldNames.put(field, newType);
            }
        }
        return added;
    }

    private boolean addedAsKnownType(Map<String, FieldType> additionalFieldNames, String field) {
        FieldType[] types;
        for (FieldType type : types = FieldType.getPredefinedFieldTypes()) {
            if (!type.getName().equals(field)) continue;
            additionalFieldNames.put(field, type);
            return true;
        }
        return false;
    }

    private String[] split(String values) {
        String[] tokens = null;
        if (values != null && values.trim().length() > 0) {
            tokens = values.split(",");
        }
        return tokens;
    }

    public RawDataReader getReader(Properties dataProp, Map<String, FieldType> addFields) throws InvalidPropertyException, CGGELevelException, InstantiationException, IllegalAccessException {
        String readerClass = dataProp.getProperty(KEY_READER_CLASS);
        if (MMUtils.isEmpty((String)readerClass)) {
            throw new InvalidPropertyException("missing required dataReader");
        }
        RawDataReader reader = this.createReader(readerClass);
        try {
            reader.setAdditionalFields(addFields);
            reader.loadData(dataProp);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InvalidFieldMappingException) {
                logger.error("Could not set additional fields.");
            } else {
                logger.error("Could not load data.");
            }
            throw new CGGELevelException(e);
        }
        reader.rewind();
        return reader;
    }

    protected RawDataReader createReader(String className) throws InvalidPropertyException, IllegalAccessException, InstantiationException {
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            String message = className == null ? "className is null" : className + " can not be found";
            message = "Cannot create reader object, " + message;
            logger.error(message);
            throw new InvalidPropertyException(message, (Throwable)cnfe);
        }
        RawDataReader rawDataReader = null;
        rawDataReader = (RawDataReader)clz.newInstance();
        return rawDataReader;
    }

    @Override
    public Iterator<SimpleStreetAddress> getAddressIterator(int areaID) throws IOException {
        OffsetLink addrLinks = this.areaToAddrOffsetMap.get(new IntKey(areaID));
        if (addrLinks == null) {
            throw new DataFetchException("area does not exist");
        }
        ArrayList<SimpleStreetAddress> addrs = new ArrayList<SimpleStreetAddress>(50);
        for (long offset : addrLinks) {
            this.tempAddrFile.seek(offset);
            SimpleStreetAddress addr = new SimpleStreetAddress();
            addr.read((ICGGEDataInput)this.tempAddrFile);
            addrs.add(addr);
        }
        List<SimpleStreetAddress> mergedList = this.mergeRanges(addrs);
        this.setAddressPtr(mergedList, areaID);
        return mergedList.iterator();
    }

    private void setAddressPtr(List<SimpleStreetAddress> mergedList, int areaID) {
        int c = mergedList.size();
        for (int addrNdx = 0; addrNdx < c; ++addrNdx) {
            AddressPtr addrPtr = new AddressPtr(areaID);
            addrPtr.addAddressID(addrNdx);
            mergedList.get(addrNdx).setAddressPtr(addrPtr);
        }
    }

    @Override
    public Map<Integer, String> getFields() {
        return this.dataFields;
    }

    @Override
    public Collection<Integer> getAreaIDs() {
        ArrayList<Integer> areaIDs = new ArrayList<Integer>(this.areaToAddrOffsetMap.size());
        for (IntKey key : this.areaToAddrOffsetMap.keySet()) {
            areaIDs.add(key.value());
        }
        Collections.sort(areaIDs);
        return areaIDs;
    }

    protected List<SimpleStreetAddress> mergeRanges(List<SimpleStreetAddress> addrs) {
        int c = addrs.size();
        if (c > 1) {
            Collections.sort(addrs);
            ArrayList<SimpleStreetAddress> mergedList = new ArrayList<SimpleStreetAddress>(c / 3);
            SimpleStreetAddress lastStreetAddr = addrs.get(0);
            mergedList.add(lastStreetAddr);
            List<SimpleRange> ranges = new ArrayList<SimpleRange>();
            this.addRanges(ranges, lastStreetAddr);
            for (int i = 1; i < c; ++i) {
                SimpleStreetAddress streetAddress = addrs.get(i);
                if (lastStreetAddr.hasSameAddressFields(streetAddress)) {
                    this.addRanges(ranges, streetAddress);
                    lastStreetAddr.expandBounds(streetAddress.getBounds());
                    continue;
                }
                ranges = this.mergeUnits(ranges);
                lastStreetAddr.setRanges(ranges);
                mergedList.add(streetAddress);
                lastStreetAddr = streetAddress;
                ranges = new ArrayList();
                this.addRanges(ranges, streetAddress);
            }
            ranges = this.mergeUnits(ranges);
            lastStreetAddr.setRanges(ranges);
            return mergedList;
        }
        return addrs;
    }

    private void addRanges(List<SimpleRange> ranges, SimpleStreetAddress addr) {
        List<SimpleRange> streetRanges = addr.getRanges();
        if (streetRanges != null) {
            ranges.addAll(streetRanges);
        }
    }

    private List<SimpleRange> mergeUnits(List<SimpleRange> ranges) {
        int rangeCount = ranges.size();
        if (rangeCount < 2) {
            return ranges;
        }
        ArrayList<SimpleRange> mergedRanges = new ArrayList<SimpleRange>();
        SimpleRange lastRange = ranges.get(0);
        mergedRanges.add(lastRange);
        for (int rangeNdx = 1; rangeNdx < rangeCount; ++rangeNdx) {
            SimpleRange range = ranges.get(rangeNdx);
            if (range.compareRangesExcludingUnits(lastRange)) {
                lastRange.addUnits(range.getUnits());
                continue;
            }
            mergedRanges.add(range);
            lastRange = range;
        }
        return mergedRanges;
    }

    protected void createAreaToAddressOffsetMap(String outPath) throws IOException {
        File tempFile = File.createTempFile("ud-area", ".tmp");
        tempFile.deleteOnExit();
        logger.info("created temp file: " + tempFile.getAbsolutePath());
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream((File)tempFile, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
        DiskBTree map = DiskBTree.create((ICGGEDataStream)dataStream, (IDiskTreeKey)new IntKey(0), (IDataItem)new OffsetLink(0L), (int)50);
        map.setCachedItemCount(1000);
        this.setAreaToAddrOffsetMap((Map<IntKey, OffsetLink>)map);
    }

    void setAreaToAddrOffsetMap(Map<IntKey, OffsetLink> map) {
        this.areaToAddrOffsetMap = map;
    }

    protected Map<IntKey, OffsetLink> getAreaToAddrOffsetMap() {
        return this.areaToAddrOffsetMap;
    }

    protected void createTempAddressFile(String outPath) throws IOException {
        File tempFile = File.createTempFile("ud-addr", ".tmp");
        tempFile.deleteOnExit();
        logger.info("created temp file: " + tempFile.getAbsolutePath());
        ICGGEDataStream dataStream = DataStreamFactory.getDataStream((File)tempFile, (IOUtil.IO_MODE)IOUtil.IO_MODE.READ_WRITE, (boolean)false);
        this.setTempAddressStream(dataStream);
    }

    protected void setTempAddressStream(ICGGEDataStream dataStream) {
        this.tempAddrFile = dataStream;
    }

    protected ICGGEDataStream getTempAddressStream() {
        return this.tempAddrFile;
    }

    public void setSupportedCountries(String str) {
        this.supportedCountries = str;
    }

    @Override
    public String getSupportedCountries() {
        return this.supportedCountries;
    }

    public void setCountry(String str) {
        this.country = str;
    }

    public String getCountry() {
        return this.country;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Map<String, FieldType> getAdditionalFields() {
        return this.additionalFieldsMap;
    }

    static class OffsetLink
    implements IDataItem,
    Iterable<Long> {
        private long offset;
        private OffsetLink next;

        OffsetLink(long offset) {
            this.offset = offset;
        }

        void setNext(OffsetLink next) {
            this.next = next;
        }

        OffsetLink getNext() {
            return this.next;
        }

        public <T extends IDataItem> T getNewInstance() {
            return (T)new OffsetLink(0L);
        }

        public void read(ICGGEDataInput in) throws IOException {
            int c = in.readVUnsignedInt();
            this.offset = in.readLong();
            OffsetLink last = this;
            for (int i = 1; i < c; ++i) {
                OffsetLink next;
                long offset = in.readLong();
                last.next = next = new OffsetLink(offset);
                last = next;
            }
        }

        public void write(ICGGEDataOutput out) throws IOException {
            int c = this.offsetCount();
            out.writeVUnsignedInt(c);
            int written = 0;
            for (Long offset : this) {
                out.writeLong(offset.longValue());
                ++written;
            }
        }

        int offsetCount() {
            int c = 0;
            OffsetLink next = this;
            do {
                ++c;
            } while ((next = next.next) != null);
            return c;
        }

        private Iterator<Long> getIterator(final OffsetLink link) {
            return new AbstractReadOnlyIterator<Long>(){
                private OffsetLink nextLink;

                @Override
                public void init() {
                    this.nextLink = link;
                }

                @Override
                public Long getNextItem() {
                    if (this.nextLink != null) {
                        Long l = this.nextLink.offset;
                        this.nextLink = this.nextLink.next;
                        return l;
                    }
                    return null;
                }
            };
        }

        @Override
        public Iterator<Long> iterator() {
            return this.getIterator(this);
        }
    }
}

