/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.filters;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.INodeKeyFilter;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;

public class KeyFilter
implements INodeKeyFilter {
    private final IMatcher m_keyMatcher;
    private final boolean m_exactMatch;

    KeyFilter(IMatcher matcher) {
        this(matcher, false);
    }

    KeyFilter(IMatcher matcher, boolean exactMatch) {
        this.m_keyMatcher = matcher;
        this.m_exactMatch = exactMatch;
    }

    @Override
    public String getTargetString() {
        return this.m_keyMatcher.getTargetString();
    }

    @Override
    public boolean acceptKey(String key) {
        this.m_keyMatcher.setEvaluatedString(key);
        if (!this.m_keyMatcher.matches()) {
            return this.m_keyMatcher.targetPrefixMatches();
        }
        return true;
    }

    @Override
    public boolean acceptIntermediateKey(String key) {
        this.m_keyMatcher.setEvaluatedString(key);
        return this.m_keyMatcher.prefixMatches(false);
    }

    @Override
    public int targetMatchLength(String key) {
        this.m_keyMatcher.setEvaluatedString(key);
        return this.targetMatchLength();
    }

    @Override
    public int targetMatchLength() {
        return this.m_keyMatcher.targetMatchLength(false);
    }

    @Override
    public boolean prefixMatch(String key) {
        this.m_keyMatcher.setEvaluatedString(key);
        return this.m_keyMatcher.prefixMatches(true);
    }

    @Override
    public boolean onlyAllowExactMatches() {
        return this.m_exactMatch;
    }

    @Override
    public int getWeight(String str) {
        this.m_keyMatcher.setEvaluatedString(new String(str));
        return this.m_keyMatcher.getMatchWeight();
    }

    @Override
    public int getWeight() {
        return this.m_keyMatcher.getMatchWeight();
    }

    public IMatcher getMatcher() {
        return this.m_keyMatcher;
    }

    @Override
    public MatchStats getMatchStats(String key) {
        this.m_keyMatcher.setEvaluatedString(key);
        return this.m_keyMatcher.getMatchStats();
    }

    public String toString() {
        return "keyFilter." + this.m_keyMatcher;
    }
}

