/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.IPeekableIterator;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.NoSuchElementException;

public abstract class AbstractPeekableIterator<E>
extends ReadOnlyIterator<E>
implements IPeekableIterator<E> {
    private E nextItem;
    private boolean nextItemFetched = false;
    private int fetchCount = 0;

    @Override
    public boolean hasNext() {
        this.checkItem();
        return this.nextItem != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextItemFetched = false;
        E currItem = this.nextItem;
        this.nextItem = null;
        ++this.fetchCount;
        return currItem;
    }

    @Override
    public E peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextItem;
    }

    private void checkItem() {
        if (!this.nextItemFetched) {
            if (this.fetchCount == 0) {
                this.init();
            }
            this.nextItem = this.getNextItem();
            this.nextItemFetched = true;
        }
    }

    protected void init() {
    }

    protected abstract E getNextItem();

    public int getFetchedCount() {
        return this.fetchCount;
    }
}

