/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AccentHelper {
    protected static final Map<Character, String> m_substitutionMap;
    protected static final String A_VALUES = "\u00e6\u00e5\u00e4\u00e3\u00e2\u00e1\u00e0";
    protected static final String E_VALUES = "\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b";
    protected static final String I_VALUES = "\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u0133";
    protected static final String O_VALUES = "\u00f2\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u0153\u00f8";
    protected static final String U_VALUES = "\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173";
    protected static final String C_VALUES = "\u00e7\u0107\u0109\u010b\u010d";
    protected static final String D_VALUES = "\u010f\u0111\u00f0";
    protected static final String G_VALUES = "\u011d\u011f\u0121\u0123";
    protected static final String H_VALUES = "\u0125\u0127";
    protected static final String J_VALUES = "\u0135";
    protected static final String K_VALUES = "\u0137\u0138";
    protected static final String L_VALUES = "\u013a\u013c\u013e\u0140\u0142";
    protected static final String N_VALUES = "\u00f1\u0144\u0146\u0148\u0149\u014b";
    protected static final String R_VALUES = "\u0155\u0157\u0159";
    protected static final String S_VALUES = "\u015b\u015d\u015f\u0161\u017f";
    protected static final String T_VALUES = "\u0163\u0165\u0167\u00fe";
    protected static final String W_VALUES = "\u0175";
    protected static final String Y_VALUES = "\u00fd\u00ff\u0177";
    protected static final String Z_VALUES = "\u017a\u017c\u017e";

    public static Set<Character> keySet() {
        return m_substitutionMap.keySet();
    }

    public static char getUnaccentedChar(char c) {
        char upper = Character.toUpperCase(c);
        if (m_substitutionMap.containsKey(Character.valueOf(upper))) {
            return upper;
        }
        for (char key : m_substitutionMap.keySet()) {
            String values = m_substitutionMap.get(Character.valueOf(key));
            if (values.indexOf(upper) < 0) continue;
            return key;
        }
        return upper;
    }

    public static String getAccentedVersions(char c) {
        char upper = Character.toUpperCase(c);
        if (m_substitutionMap.containsKey(Character.valueOf(upper))) {
            return m_substitutionMap.get(Character.valueOf(upper));
        }
        return null;
    }

    public static String getUppercaseAccentedVersions(char c) {
        char upper = Character.toUpperCase(c);
        if (m_substitutionMap.containsKey(Character.valueOf(upper))) {
            return m_substitutionMap.get(Character.valueOf(upper)).toUpperCase();
        }
        return null;
    }

    public static String buildRegexRuleString(char key) {
        String value = AccentHelper.getUppercaseAccentedVersions(key);
        if (value.length() == 1) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean bFirst = true;
        for (char c : value.toCharArray()) {
            if (c == key) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("|");
            }
            sb.append(c);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String convert(String str) {
        if (str == null) {
            return null;
        }
        int idx = str.indexOf("\\u");
        if (idx < 0 || idx > str.length() - 6) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int totalSubLen = 6;
        while (idx >= 0) {
            if (idx >= str.length() + totalSubLen) {
                sb.append(str.substring(start));
                start = str.length();
                break;
            }
            sb.append(str, start, idx);
            int value = AccentHelper.getHex(str, idx + 2);
            sb.append((char)value);
            start = idx + totalSubLen;
            idx = str.indexOf("\\u", start);
        }
        if (start < str.length()) {
            sb.append(str.substring(start));
        }
        return sb.toString();
    }

    protected static int getHex(String str, int idx) {
        if (idx + 4 > str.length()) {
            return 0;
        }
        int total = Character.getNumericValue(str.charAt(idx)) * 4096;
        total += Character.getNumericValue(str.charAt(idx + 1)) * 256;
        total += Character.getNumericValue(str.charAt(idx + 2)) * 16;
        return total += Character.getNumericValue(str.charAt(idx + 3));
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('A'), A_VALUES.toUpperCase());
        map.put(Character.valueOf('E'), E_VALUES.toUpperCase());
        map.put(Character.valueOf('I'), I_VALUES.toUpperCase());
        map.put(Character.valueOf('O'), O_VALUES.toUpperCase());
        map.put(Character.valueOf('U'), U_VALUES.toUpperCase());
        map.put(Character.valueOf('C'), C_VALUES.toUpperCase());
        map.put(Character.valueOf('D'), D_VALUES.toUpperCase());
        map.put(Character.valueOf('G'), G_VALUES.toUpperCase());
        map.put(Character.valueOf('H'), H_VALUES.toUpperCase());
        map.put(Character.valueOf('J'), J_VALUES.toUpperCase());
        map.put(Character.valueOf('K'), K_VALUES.toUpperCase());
        map.put(Character.valueOf('L'), L_VALUES.toUpperCase());
        map.put(Character.valueOf('N'), N_VALUES.toUpperCase());
        map.put(Character.valueOf('R'), R_VALUES.toUpperCase());
        map.put(Character.valueOf('S'), S_VALUES.toUpperCase() + "\u00df");
        map.put(Character.valueOf('T'), T_VALUES.toUpperCase());
        map.put(Character.valueOf('W'), W_VALUES.toUpperCase());
        map.put(Character.valueOf('Y'), Y_VALUES.toUpperCase());
        map.put(Character.valueOf('Z'), Z_VALUES.toUpperCase());
        m_substitutionMap = Collections.unmodifiableMap(map);
    }
}

