/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.IAppendableIterator;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class AppendableIterator<E>
extends ReadOnlyIterator<E>
implements IAppendableIterator<E> {
    private final LinkedList<Object> m_list = new LinkedList();
    private int m_retrieved = 0;
    private Iterator<E> m_currIt;
    private int m_mark = -1;

    public AppendableIterator() {
    }

    public AppendableIterator(E e) {
        this();
        if (e != null) {
            this.add(e);
        }
    }

    public AppendableIterator(Iterator<E> it) {
        this();
        if (it != null) {
            this.add(it);
        }
    }

    public AppendableIterator(Iterable<E> it) {
        this();
        if (it != null) {
            this.add(it);
        }
    }

    @Override
    public void add(Iterable<E> iterable) {
        this.add0(iterable);
    }

    @Override
    public void add(Iterator<E> it) {
        this.add0(it);
    }

    @Override
    public void add(E e) {
        this.add0(e);
    }

    private void add0(Object obj) {
        this.m_list.add(obj);
    }

    @Override
    public void insertBeforeMarker(E e) {
        this.insertBeforeMarker0(e);
    }

    @Override
    public void insertBeforeMarker(Iterator<E> it) {
        this.insertBeforeMarker0(it);
    }

    private void insertBeforeMarker0(Object obj) {
        if (this.m_mark == -1) {
            this.setMark();
        }
        int ndx = Math.max(0, this.m_mark - this.m_retrieved);
        this.m_list.add(ndx, obj);
        ++this.m_mark;
    }

    @Override
    public void removeAllPreMarkItems() {
        if (this.m_mark > -1 && this.m_retrieved <= this.m_mark) {
            int currentRamining = this.m_mark - this.m_retrieved;
            for (int i = 0; i < currentRamining; ++i) {
                this.m_list.remove();
            }
            this.m_mark = -1;
            this.m_retrieved = 0;
            if (this.m_currIt != null) {
                this.m_currIt = null;
            }
        }
    }

    @Override
    public void setMark() {
        this.m_mark = this.m_list.size();
        this.m_retrieved = 0;
    }

    @Override
    public boolean isNextItemBeforeMarker() {
        if (this.m_retrieved == this.m_mark) {
            return this.m_currIt != null && this.m_currIt.hasNext();
        }
        return this.m_retrieved < this.m_mark;
    }

    @Override
    public boolean hasNext() {
        return this.m_list.size() > 0 || this.m_currIt != null && this.m_currIt.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextItem();
    }

    private E nextItem() {
        if (this.m_currIt != null && this.m_currIt.hasNext()) {
            return this.m_currIt.next();
        }
        return this.moveNext();
    }

    protected E moveNext() {
        Object nextItem = this.nextMainItem();
        while (nextItem != null) {
            if (this.isIterable(nextItem)) {
                this.m_currIt = ((Iterable)nextItem).iterator();
            } else if (this.isIterator(nextItem)) {
                this.m_currIt = (Iterator)nextItem;
            } else {
                return (E)nextItem;
            }
            if (this.m_currIt != null && this.m_currIt.hasNext()) {
                return this.m_currIt.next();
            }
            nextItem = this.nextMainItem();
        }
        return null;
    }

    protected Object nextMainItem() {
        this.m_currIt = null;
        Object nextItem = null;
        if (!this.m_list.isEmpty()) {
            nextItem = this.m_list.poll();
            ++this.m_retrieved;
        }
        return nextItem;
    }

    protected boolean isIterable(Object item) {
        return item instanceof Iterable;
    }

    protected boolean isIterator(Object item) {
        return item instanceof Iterator;
    }

    @Override
    public void removeAll() {
        int s = this.m_list.size();
        for (int i = 0; i < s; ++i) {
            this.m_list.remove();
        }
        this.setMark();
        this.m_currIt = null;
    }

    @Override
    public Iterator<Object> getInternalItemIterator() {
        return this.m_list.isEmpty() ? null : this.m_list.iterator();
    }
}

