/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ConditionalIterator<E>
implements Iterator<E> {
    private E m_next;
    private final Iterator<E> m_originalIt;
    private boolean m_init = false;

    public ConditionalIterator(Iterator<E> originalIt) {
        this.m_originalIt = originalIt;
    }

    @Override
    public boolean hasNext() {
        if (!this.m_init) {
            this.moveNext();
            this.m_init = true;
        }
        return this.m_next != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E curr = this.internalNextItem();
        this.moveNext();
        return curr;
    }

    private void moveNext() {
        this.m_next = null;
        while (this.m_originalIt.hasNext()) {
            this.m_next = this.updateItem(this.m_originalIt.next());
            if (this.m_next == null) continue;
            break;
        }
    }

    public abstract E updateItem(E var1);

    @Override
    public void remove() {
        this.m_originalIt.remove();
    }

    protected E internalNextItem() {
        return this.m_next;
    }
}

