/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.utils.AutoSuggestLog;
import com.mapinfo.mapmarker.autosuggest.utils.LongLatBox;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.XYDirectPositionArray;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;

public class GeomUtil {
    private static final SpatialInfo SI = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final LinearUnit UNIT_ROUNDING = LinearUnit.MILLIMETER;
    public static final int COORD_TO_METER_FACTOR = 111111;
    public static final double DEGREE_TO_RADIANS = Math.PI / 180;

    public static double getDistance(double[] position, double[] points) {
        GeometryFactory factory = new GeometryFactory(SI);
        LineString segmentGeometry = factory.newLineString(GeomUtil.makePositionList(points));
        Length length = GeometryOperations.distance((IGeometry)factory.newPoint(position[0], position[1]), (IGeometry)segmentGeometry, (ComputationType)ComputationType.SPHERICAL);
        return GeomUtil.roundedDistance(length);
    }

    public static double getDistance(double[] position, Rectangle rect) {
        double[] corners = new double[]{rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop()};
        return GeomUtil.getDistance(position, corners);
    }

    private static double roundedDistance(Length length) {
        return (double)Math.round(length.getValue(UNIT_ROUNDING)) * UNIT_ROUNDING.getMetersPerUnit();
    }

    private static IDirectPositionList makePositionList(double[] points) {
        int nPoints = points.length / 2;
        XYDirectPositionArray list = new XYDirectPositionArray(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            int ndx = i * 2;
            list.add(new DirectPosition(points[ndx], points[ndx + 1]));
        }
        return list;
    }

    public static Rectangle getBounds(double[] line) {
        LongLatBox bounds = null;
        int n = line.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Invalid line argument");
        }
        for (int i = 0; i < n; i += 2) {
            if (bounds == null) {
                bounds = new Rectangle(line[i], line[i + 1], line[i], line[i + 1]);
                continue;
            }
            bounds.expandToInclude(line[i], line[i + 1]);
        }
        return bounds;
    }

    public static Rectangle getBounds(DirectPosition[] line) {
        LongLatBox bounds = null;
        if (line == null) {
            return new Rectangle();
        }
        int n = line.length;
        for (int i = 0; i < n; ++i) {
            if (bounds == null) {
                bounds = new Rectangle(line[i].getX(), line[i].getY(), line[i].getX(), line[i].getY());
                continue;
            }
            bounds.expandToInclude(line[i].getX(), line[i].getY());
        }
        return bounds;
    }

    public static Rectangle quadSplit(Rectangle rect, Direction quadPos) {
        double[] midPoint = rect.getMidPoint();
        double midX = midPoint[0];
        double midY = midPoint[1];
        Rectangle quadRect = null;
        switch (quadPos) {
            case NW: {
                quadRect = new Rectangle(rect.getLeft(), midY, midX, rect.getTop());
                break;
            }
            case NE: {
                quadRect = new Rectangle(midX, midY, rect.getRight(), rect.getTop());
                break;
            }
            case SW: {
                quadRect = new Rectangle(rect.getLeft(), rect.getBottom(), midX, midY);
                break;
            }
            case SE: {
                quadRect = new Rectangle(midX, rect.getBottom(), rect.getRight(), midY);
            }
        }
        return quadRect;
    }

    public static int area(Rectangle rect) {
        return (int)(rect.getHeight() * rect.getWidth() * 111111.0);
    }

    public static Rectangle[] quadSplit(Rectangle rect) {
        Rectangle[] rects = new Rectangle[4];
        int added = 0;
        for (Direction dir : Direction.values()) {
            rects[added++] = GeomUtil.quadSplit(rect, dir);
        }
        return rects;
    }

    public static Rectangle getExpandedRectangle(Rectangle rect1, Rectangle rect2) {
        if (rect2 != null) {
            if (rect1 == null) {
                rect1 = new Rectangle(rect2);
            } else {
                rect1.expandToInclude(rect2);
            }
        }
        return rect1;
    }

    public static double convertToMeters(double distance, IAutoSuggestConstraints.DistanceUnits units) {
        if (units == null) {
            units = IAutoSuggestConstraints.DistanceUnits.KILOMETERS;
        }
        switch (units) {
            case MILES: {
                distance /= 6.21371E-4;
                break;
            }
            case METERS: {
                break;
            }
            case FEET: {
                distance /= 3.28084;
                break;
            }
            default: {
                distance *= 1000.0;
            }
        }
        return distance;
    }

    public static double convertFromMeters(double distance, IAutoSuggestConstraints.DistanceUnits units) {
        if (units == null) {
            units = IAutoSuggestConstraints.DistanceUnits.KILOMETERS;
        }
        switch (units) {
            case MILES: {
                distance *= 6.21371E-4;
                break;
            }
            case FEET: {
                distance *= 3.28084;
                break;
            }
            case KILOMETERS: {
                distance *= 0.001;
            }
        }
        return distance;
    }

    public static DirectPosition calcDeltaLongLatDegrees(double dist, IAutoSuggestConstraints.DistanceUnits units, DirectPosition origin) {
        if (origin == null) {
            return null;
        }
        dist = GeomUtil.convertToMeters(dist, units);
        double saveLat = origin.getY();
        origin.setY(Math.max(-89.9999999, Math.min(origin.getY(), 89.9999999)));
        if (Double.compare(origin.getY(), saveLat) != 0) {
            AutoSuggestLog.getLog().debug((Object)"Changed latitude to be < 90 or > -90");
        }
        double latRadian = Math.toRadians(origin.getY());
        double longDelta = dist / 111320.0 / Math.cos(latRadian);
        double latDelta = dist / 111320.0;
        return new DirectPosition(longDelta, latDelta);
    }

    public static int xDegreesToMeters(double x, double y) {
        return (int)(x * 111111.0 * Math.cos(y * (Math.PI / 180)));
    }

    public static int yDegreesToMeters(double x, double y) {
        return (int)(y * 111111.0);
    }

    public static CoordTransform getWGS84Transformer(String coordSysString) {
        CoordSys coordSys = null;
        if (coordSysString != null && coordSysString.length() > 0) {
            coordSys = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(coordSysString);
        }
        return GeomUtil.getWGS84Transformer(coordSys);
    }

    public static CoordTransform getWGS84Transformer(CoordSys coordSys) {
        CoordSys wgs84 = CoordSysConstants.longLatWGS84;
        CoordTransform transformer = null;
        if (coordSys != null && coordSys != wgs84) {
            transformer = new CoordTransform(coordSys, wgs84);
        }
        return transformer;
    }

    public static enum Direction {
        NW,
        NE,
        SW,
        SE;

    }
}

