/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.ArrayIterator;
import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class LinkedTailItem
implements Iterable<LinkedTailItem> {
    private int m_level;
    private LinkedTailItem m_prev;

    public LinkedTailItem(LinkedTailItem previous) {
        this.setPrevious(previous);
    }

    public LinkedTailItem previous() {
        return this.m_prev;
    }

    public LinkedTailItem getHead() {
        LinkedTailItem head = null;
        for (LinkedTailItem current = this; current != null; current = current.previous()) {
            head = current;
        }
        return head;
    }

    public void setPrevious(LinkedTailItem previous) {
        this.m_level = previous != null ? previous.m_level + 1 : 0;
        this.m_prev = previous;
    }

    @Override
    public Iterator<LinkedTailItem> iterator() {
        return new LinkedItemIt(this);
    }

    public Iterator<LinkedTailItem> reverseIterator() {
        LinkedTailItem[] items = new LinkedTailItem[this.m_level + 1];
        LinkedTailItem prevItem = this;
        for (int i = this.m_level; i >= 0; --i) {
            items[i] = prevItem;
            prevItem = prevItem.m_prev;
        }
        return new ArrayIterator<LinkedTailItem>(items);
    }

    public <T extends LinkedTailItem> boolean replace(LinkedTailItem target, LinkedTailItem replacement) {
        LinkedTailItem current = this;
        while (current != null) {
            LinkedTailItem previous = current.previous();
            if (previous == target) {
                current.setPrevious(replacement);
                replacement.setPrevious(previous.previous());
                return true;
            }
            current = previous;
        }
        return false;
    }

    private static class LinkedItemIt
    extends ReadOnlyIterator<LinkedTailItem> {
        private LinkedTailItem m_nextLink;

        public LinkedItemIt(LinkedTailItem startItem) {
            this.m_nextLink = startItem;
        }

        @Override
        public boolean hasNext() {
            return this.m_nextLink != null;
        }

        @Override
        public LinkedTailItem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LinkedTailItem returnItem = this.m_nextLink;
            this.m_nextLink = this.m_nextLink.m_prev;
            return returnItem;
        }
    }
}

