/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.api.BoundingBox;
import com.mapinfo.mapmarker.autosuggest.utils.GeomUtil;
import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IReadable;
import com.mapinfo.mapmarker.cgge.utils.io.IWritable;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;

public class LongLatBox
implements IReadable,
IWritable {
    public static final int PRECISION_FACTOR = 100000;
    public static final double FULL_EARTH_LONGITUDE_START = -179.99999;
    public static final double FULL_EARTH_LONGITUDE_END = 180.0;
    private int longWest;
    private int longEast;
    private int latSouth;
    private int latNorth;

    public LongLatBox() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public LongLatBox(double west, double south, double east, double north) {
        this.setWest(west);
        this.setSouth(south);
        this.setEast(east);
        this.setNorth(north);
        this.adjust();
    }

    public LongLatBox(LongLatBox orig) {
        this.longWest = orig.longWest;
        this.latSouth = orig.latSouth;
        this.longEast = orig.longEast;
        this.latNorth = orig.latNorth;
        this.adjust();
    }

    public LongLatBox(BoundingBox boundingBox) {
        this();
        if (boundingBox != null) {
            this.setWest(boundingBox.getWesternLimit());
            this.setSouth(boundingBox.getSouthernLimit());
            this.setEast(boundingBox.getEasternLimit());
            this.setNorth(boundingBox.getNorthernLimit());
            this.adjust();
        }
    }

    public void buffer(double dist) {
        this.setNorth(this.getNorth() + dist);
        this.setSouth(this.getSouth() - dist);
        if (this.getWest() <= this.getEast()) {
            this.setWest(this.getWest() - dist);
            this.setEast(this.getEast() + dist);
        } else {
            if (this.getWest() > 0.0) {
                this.setWest(this.getWest() - dist);
            } else {
                this.setWest(this.getWest() + dist);
            }
            if (this.getEast() > 0.0) {
                this.setEast(this.getEast() + dist);
            } else {
                this.setEast(this.getEast() + dist);
            }
        }
        this.adjust();
    }

    public void buffer(DirectPosition longLatDelta) {
        double deltaLong = longLatDelta.getX();
        double deltaLat = longLatDelta.getY();
        this.setNorth(this.getNorth() + deltaLat);
        this.setSouth(this.getSouth() - deltaLat);
        if (this.getWest() <= this.getEast()) {
            this.setWest(this.getWest() - deltaLong);
            this.setEast(this.getEast() + deltaLong);
        } else {
            if (this.getWest() > 0.0) {
                this.setWest(this.getWest() - deltaLong);
            } else {
                this.setWest(this.getWest() + deltaLong);
            }
            if (this.getEast() > 0.0) {
                this.setEast(this.getEast() + deltaLong);
            } else {
                this.setEast(this.getEast() + deltaLong);
            }
        }
        this.adjust();
    }

    public void expandToInclude(LongLatBox box) {
        this.expandToInclude(box.getWest(), box.getSouth(), box.getEast(), box.getNorth());
    }

    public void expandToInclude(double x, double y) {
        this.expandToInclude(x, y, x, y);
    }

    protected void expandToInclude(double west, double south, double east, double north) {
        if (north < south) {
            double tmp = north;
            north = south;
            south = tmp;
        }
        if (north > this.getNorth()) {
            this.setNorth(north);
        }
        if (south < this.getSouth()) {
            this.setSouth(south);
        }
        boolean isWestPointInBox = this.valueWithinBoxLongitude(west);
        boolean isEastPointInBox = this.valueWithinBoxLongitude(east);
        if (isWestPointInBox && isEastPointInBox) {
            if (west == east) {
                return;
            }
            if (this.boxWithinBoxLongitude(west, east)) {
                return;
            }
            this.setWest(-179.99999);
            this.setEast(180.0);
            this.adjust();
            return;
        }
        if (isWestPointInBox && !isEastPointInBox) {
            this.setEast(east);
        } else if (!isWestPointInBox && isEastPointInBox) {
            this.setWest(west);
        } else {
            this.expandForNonOverlappingLongitude(west, east);
        }
    }

    protected void expandForNonOverlappingLongitude(double west, double east) {
        boolean isNewEastClosestToWest;
        double westToNewWest;
        boolean isPoint;
        boolean bl = isPoint = west == east;
        if (!isPoint && this.longWest == this.longEast) {
            double tmp = this.getEast();
            this.setWest(west);
            this.setEast(east);
            west = tmp;
            east = tmp;
            isPoint = true;
        }
        if (isPoint) {
            double eastToNewWest;
            westToNewWest = this.minimumLongitudeDistance(this.getWest(), west);
            if (westToNewWest == (eastToNewWest = this.minimumLongitudeDistance(this.getEast(), west))) {
                if (west < -90.0 && this.getWest() > 90.0) {
                    this.setEast(west);
                } else if (west < this.getWest() || west > 90.0 && this.getWest() < -90.0) {
                    this.setWest(west);
                } else {
                    this.setEast(west);
                }
            } else if (westToNewWest < eastToNewWest) {
                this.setWest(west);
            } else {
                this.setEast(west);
            }
            return;
        }
        westToNewWest = this.minimumLongitudeDistance(this.getWest(), west);
        double westToNewEast = this.minimumLongitudeDistance(this.getWest(), east);
        double eastToNewWest = this.minimumLongitudeDistance(this.getEast(), west);
        double eastToNewEast = this.minimumLongitudeDistance(this.getEast(), east);
        boolean isNewWestClosestToWest = westToNewWest <= eastToNewWest;
        boolean bl2 = isNewEastClosestToWest = westToNewEast <= eastToNewEast;
        if (isNewWestClosestToWest) {
            this.setWest(west);
            if (!isNewEastClosestToWest) {
                if (east > west) {
                    this.setEast(east);
                } else {
                    this.setWest(east);
                }
            }
        } else {
            this.setEast(east);
        }
    }

    public boolean pointInRect(double x, double y) {
        return this.valueWithinBoxLatitude(y) && this.valueWithinBoxLongitude(x);
    }

    public boolean pointInRect(double[] dp) {
        return this.valueWithinBoxLongitude(dp[0]) && this.valueWithinBoxLatitude(dp[1]);
    }

    public boolean intersects(BoundingBox rect) {
        return this.intersects(new LongLatBox(rect));
    }

    public boolean intersects(LongLatBox rect) {
        boolean yIntersects;
        boolean bl = yIntersects = this.valueWithinBoxLatitude(rect.getNorth()) || this.valueWithinBoxLatitude(rect.getSouth()) || rect.valueWithinBoxLatitude(this.getNorth()) || rect.valueWithinBoxLatitude(this.getSouth());
        if (!yIntersects) {
            return false;
        }
        if (this.valueWithinBoxLongitude(rect.getWest()) || this.valueWithinBoxLongitude(rect.getEast())) {
            return true;
        }
        return rect.valueWithinBoxLongitude(this.getWest()) || rect.valueWithinBoxLongitude(this.getEast());
    }

    public boolean fullyContains(LongLatBox rect) {
        return this.pointInRect(rect.getWest(), rect.getNorth()) && this.pointInRect(rect.getWest(), rect.getSouth()) && this.pointInRect(rect.getEast(), rect.getNorth()) && this.pointInRect(rect.getEast(), rect.getSouth());
    }

    public void write(ICGGEDataOutput out) throws IOException {
        boolean isPoint = this.isPoint();
        out.writeByte(isPoint ? 1 : 0);
        out.writeInt(this.longWest);
        out.writeInt(this.latSouth);
        if (!isPoint) {
            out.writeInt(this.longEast);
            out.writeInt(this.latNorth);
        }
    }

    public void read(ICGGEDataInput in) throws IOException {
        boolean isPoint = in.readByte() == 1;
        this.longWest = in.readInt();
        this.latSouth = in.readInt();
        if (!isPoint) {
            this.longEast = in.readInt();
            this.latNorth = in.readInt();
        } else {
            this.longEast = this.longWest;
            this.latNorth = this.latSouth;
        }
    }

    public int convertToInt(double d) {
        return (int)(d * 100000.0);
    }

    public double convertFromInt(int i) {
        return (double)i / 100000.0;
    }

    public boolean isPoint() {
        return this.longWest == this.longEast && this.latNorth == this.latSouth;
    }

    public double[] getMidPoint() {
        double longitude = this.getWest() + this.getWidth() * 0.5;
        return new double[]{this.adjustLongitudeValue(longitude), this.getSouth() + this.getHeight() * 0.5};
    }

    public double getHeight() {
        return this.getNorth() - this.getSouth();
    }

    public double getWidth() {
        if (this.longEast > this.longWest) {
            return this.getEast() - this.getWest();
        }
        return this.minimumLongitudeDistance(this.getWest(), this.getEast());
    }

    public double getEast() {
        return this.convertFromInt(this.longEast);
    }

    public double getWest() {
        return this.convertFromInt(this.longWest);
    }

    public double getNorth() {
        return this.convertFromInt(this.latNorth);
    }

    public double getSouth() {
        return this.convertFromInt(this.latSouth);
    }

    public void setNorth(double value) {
        this.latNorth = this.convertToInt(value);
    }

    public void setSouth(double value) {
        this.latSouth = this.convertToInt(value);
    }

    public void setEast(double value) {
        this.longEast = this.convertToInt(value);
    }

    public void setWest(double value) {
        this.longWest = this.convertToInt(value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongLatBox) {
            LongLatBox other = (LongLatBox)obj;
            return this.longWest == other.longWest && this.longEast == other.longEast && this.latNorth == other.latNorth && this.latSouth == other.latSouth;
        }
        return false;
    }

    public int hashCode() {
        double value = 17.0;
        value = 31.0 * value + (double)this.longWest;
        value = 31.0 * value + (double)this.longEast;
        value = 31.0 * value + (double)this.latNorth;
        value = 31.0 * value + (double)this.latSouth;
        long l = Double.doubleToLongBits(value);
        return (int)(l >>> 32 ^ l);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getWest());
        sb.append(", ");
        sb.append(this.getSouth());
        sb.append(", ");
        sb.append(this.getEast());
        sb.append(", ");
        sb.append(this.getNorth());
        sb.append("]");
        return sb.toString();
    }

    protected void adjust() {
        if (this.latNorth < this.latSouth) {
            int tempMax = this.latSouth;
            this.latSouth = this.latNorth;
            this.latNorth = tempMax;
        }
        if (this.getNorth() > 90.0) {
            this.setNorth(90.0);
        }
        if (this.getSouth() < -90.0) {
            this.setSouth(-90.0);
        }
        if (this.getWest() == -180.0 && this.getEast() == 180.0) {
            this.setWest(-179.99999);
            this.setEast(180.0);
        } else {
            this.setWest(this.adjustLongitudeValue(this.getWest()));
            this.setEast(this.adjustLongitudeValue(this.getEast()));
        }
    }

    protected double adjustLongitudeValue(double value) {
        if ((value %= 360.0) > 180.0) {
            value = -180.0 + Math.abs(value % 180.0);
        }
        if (value <= -180.0) {
            value = 180.0 - Math.abs(value % 180.0);
        }
        return value;
    }

    protected double getClosestLatitude(double input) {
        double dmax;
        double dmin = Math.abs(this.getSouth() - input);
        if (dmin < (dmax = Math.abs(this.getNorth() - input))) {
            return this.getSouth();
        }
        return this.getNorth();
    }

    protected double getClosestLongitude(double input) {
        double dmax;
        double dmin = this.minimumLongitudeDistance(input, this.getWest());
        if (dmin < (dmax = this.minimumLongitudeDistance(input, this.getEast()))) {
            return this.getWest();
        }
        return this.getEast();
    }

    private double minimumLongitudeDistance(double p1, double p2) {
        double raw = Math.abs(p1 - p2) % 360.0;
        return 180.0 - Math.abs(raw - 180.0);
    }

    protected boolean valueWithinBoxLatitude(double value) {
        return value >= this.getSouth() && value <= this.getNorth();
    }

    protected boolean valueWithinBoxLongitude(double value) {
        boolean isInBounds = false;
        isInBounds = this.getWest() == -179.99999 && this.getEast() == 180.0 ? true : (this.getWest() == this.getEast() ? value == this.getEast() : (this.getWest() < this.getEast() ? this.getWest() <= value && value <= this.getEast() : value <= this.getEast() || this.getWest() <= value));
        return isInBounds;
    }

    protected boolean boxWithinBoxLongitude(double xStart, double xEnd) {
        boolean isWestLessThanEast;
        boolean isStartLessThanEnd = xStart <= xEnd;
        boolean bl = isWestLessThanEast = this.longWest <= this.longEast;
        if (isStartLessThanEnd && isWestLessThanEast) {
            return xStart >= this.getWest() && xEnd <= this.getEast();
        }
        if (isStartLessThanEnd && !isWestLessThanEast) {
            return xStart >= this.getWest() && xEnd >= this.getWest() || xStart <= this.getEast() && xEnd <= this.getEast();
        }
        if (!isStartLessThanEnd && isWestLessThanEast) {
            return false;
        }
        return xStart >= this.getWest() && xEnd <= this.getEast();
    }

    public NumberRange distancesFromPoint(double[] point) {
        double x = point[0];
        double y = point[1];
        boolean xWithin = this.valueWithinBoxLongitude(x);
        boolean yWithin = this.valueWithinBoxLatitude(y);
        if (xWithin && yWithin) {
            return new NumberRange(0, (int)this.distanceToFurthestCorner(x, y));
        }
        if (xWithin) {
            return new NumberRange((int)this.verticalDistanceToNearestSide(x, y), (int)this.verticalDistanceToFurthestSide(x, y));
        }
        if (yWithin) {
            return new NumberRange((int)this.horizontalDistanceToNearestSide(x, y), (int)this.horizontalDistanceToFurthestSide(x, y));
        }
        return new NumberRange((int)this.distanceToNearestCorner(x, y), (int)this.distanceToFurthestCorner(x, y));
    }

    private double distanceToNearestCorner(double x, double y) {
        double xDelta = this.horizontalDistanceToNearestSide(x, y);
        double yDelta = this.verticalDistanceToNearestSide(x, y);
        return Math.sqrt(Math.pow(xDelta, 2.0) + Math.pow(yDelta, 2.0));
    }

    private double horizontalDistanceToNearestSide(double x, double y) {
        double dist = this.getMinDifference(x, this.getWest(), this.getEast());
        return GeomUtil.xDegreesToMeters(dist, y);
    }

    private double verticalDistanceToNearestSide(double x, double y) {
        double dist = this.getMinDifference(y, this.getSouth(), this.getNorth());
        return GeomUtil.yDegreesToMeters(x, dist);
    }

    private double getMinDifference(double d, double d1, double d2) {
        double dist2;
        double dist1 = Math.abs(d - d1);
        return dist1 < (dist2 = Math.abs(d - d2)) ? dist1 : dist2;
    }

    private double getMaxDifference(double d, double d1, double d2) {
        double dist2;
        double dist1 = Math.abs(d - d1);
        return dist1 > (dist2 = Math.abs(d - d2)) ? dist1 : dist2;
    }

    private double distanceToFurthestCorner(double x, double y) {
        double xDelta = this.horizontalDistanceToFurthestSide(x, y);
        double yDelta = this.verticalDistanceToFurthestSide(x, y);
        return Math.sqrt(Math.pow(xDelta, 2.0) + Math.pow(yDelta, 2.0));
    }

    private double horizontalDistanceToFurthestSide(double x, double y) {
        double dist = this.getMaxDifference(x, this.getWest(), this.getEast());
        return GeomUtil.xDegreesToMeters(dist, y);
    }

    private double verticalDistanceToFurthestSide(double x, double y) {
        double d = this.getMaxDifference(y, this.getSouth(), this.getNorth());
        return GeomUtil.yDegreesToMeters(x, d);
    }
}

