/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils;

import com.mapinfo.mapmarker.autosuggest.utils.ReadOnlyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NumberRange
implements Iterable<Integer>,
Comparable<NumberRange> {
    private int start;
    private int end;

    public NumberRange(int start, int end) {
        this.setStartEnd(start, end);
    }

    public boolean inRange(int num) {
        return this.inRange(this.start, this.end, num);
    }

    public boolean isWithinRangeOf(int from, int to) {
        return this.inRange(from, to, this.start) && this.inRange(from, to, this.end);
    }

    public boolean isStartWithinRangeOf(int from, int to) {
        return this.inRange(from, to, this.start);
    }

    private final boolean inRange(int start, int end, int num) {
        return num >= start && num <= end;
    }

    public boolean intersects(int from, int to) {
        if (this.inRange(from) || this.inRange(to)) {
            return true;
        }
        return this.inRange(from, to, this.start);
    }

    public void setStartEnd(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start value greater than end value");
        }
        this.start = start;
        this.end = end;
    }

    public void setStart(int start) {
        if (start > this.end) {
            throw new IllegalArgumentException("start value greater than end value");
        }
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        if (end < this.start) {
            throw new IllegalArgumentException("start value greater than end value");
        }
        this.end = end;
    }

    public int getEnd() {
        return this.end;
    }

    public int count() {
        return this.end - this.start + 1;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ReadOnlyIterator<Integer>(){
            int current;
            {
                this.current = NumberRange.this.start;
            }

            @Override
            public boolean hasNext() {
                return NumberRange.this.end >= this.current;
            }

            @Override
            public Integer next() {
                if (this.hasNext()) {
                    return this.current++;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(15);
        sb.append(this.start);
        sb.append('-');
        sb.append(this.end);
        return sb.toString();
    }

    @Override
    public int compareTo(NumberRange o) {
        int d = this.start - o.start;
        if (d == 0) {
            d = this.end - o.end;
        }
        return d;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberRange other = (NumberRange)obj;
        return this.end == other.end && this.start == other.start;
    }
}

