/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class CharFrequencyMatcher
implements IMatcher {
    private String m_target;
    private List<Map<Character, Integer>> m_targetCharFreqMapList;
    private String m_eval;
    private int m_cost;
    private int m_prefixCost;
    private boolean m_evalWordsMatch;

    public CharFrequencyMatcher(String target) {
        this.setTargetString(target);
    }

    @Override
    public void setTargetString(String target) {
        this.m_targetCharFreqMapList = this.getCharFreqMap(target);
        this.m_target = target;
    }

    @Override
    public void setEvaluatedString(String eval) {
        this.m_eval = eval;
        this.computeCosts();
    }

    @Override
    public void appendChars(char[] chars) {
        this.m_eval = this.m_eval + chars;
        this.computeCosts();
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        if (!partial) {
            return this.m_evalWordsMatch;
        }
        return this.m_prefixCost == 0;
    }

    @Override
    public boolean matches() {
        return this.m_cost == 0;
    }

    @Override
    public boolean targetPrefixMatches() {
        return this.m_prefixCost == 0;
    }

    @Override
    public int getMatchWeight() {
        if (this.m_cost == 0) {
            return 100;
        }
        return 100 - this.m_cost * 100 / (this.m_target.length() + this.m_eval.length());
    }

    private void computeCosts() {
        List<Map<Character, Integer>> eCharFreqMap = this.getCharFreqMap(this.m_eval);
        this.m_prefixCost = 0;
        this.m_cost = 0;
        this.m_evalWordsMatch = false;
        int wordCount = this.m_targetCharFreqMapList.size();
        for (int w = 0; w < wordCount; ++w) {
            Map<Character, Integer> evalMap;
            Map<Character, Integer> targetMap = this.m_targetCharFreqMapList.get(w);
            Map<Character, Integer> map = evalMap = eCharFreqMap.size() < w + 1 ? null : eCharFreqMap.get(w);
            if (w == eCharFreqMap.size()) {
                boolean bl = this.m_evalWordsMatch = this.m_cost == 0;
            }
            if (evalMap != null) {
                for (Map.Entry<Character, Integer> en : evalMap.entrySet()) {
                    Character ch = en.getKey();
                    Integer freq1 = targetMap.get(ch);
                    int freqDiff = en.getValue() - (freq1 == null ? 0 : freq1);
                    this.m_cost += Math.abs(freqDiff);
                    this.m_prefixCost += Math.max(0, freqDiff);
                }
            }
            HashSet<Character> charSet = new HashSet<Character>(targetMap.keySet());
            if (evalMap != null) {
                charSet.removeAll(evalMap.keySet());
            }
            for (Character ch : charSet) {
                this.m_cost += targetMap.get(ch).intValue();
            }
        }
        if (!this.m_evalWordsMatch && this.m_cost == 0) {
            this.m_evalWordsMatch = true;
        }
    }

    private List<Map<Character, Integer>> getCharFreqMap(String str) {
        String[] strs = str.trim().split(" ");
        int words = strs.length;
        ArrayList<Map<Character, Integer>> list = new ArrayList<Map<Character, Integer>>(words);
        for (int w = 0; w < words; ++w) {
            String word = strs[w];
            int n = word.length();
            HashMap<Character, Integer> charFreqMap = new HashMap<Character, Integer>(n);
            for (int i = 0; i < n; ++i) {
                Character ch;
                Integer freq = (Integer)charFreqMap.get(ch = Character.valueOf(word.charAt(i)));
                charFreqMap.put(ch, (freq == null ? 0 : freq) + 1);
            }
            list.add(charFreqMap);
        }
        return list;
    }

    @Override
    public String getTargetString() {
        return this.m_target;
    }

    @Override
    public String getEvaluatedString() {
        return this.m_eval;
    }

    @Override
    public int targetMatchLength(boolean partial) {
        throw new UnsupportedOperationException("not implemeneted yet");
    }

    @Override
    public MatchStats getMatchStats() {
        int targetMatchLen = this.targetMatchLength(false);
        return new MatchStats(targetMatchLen == this.m_target.length(), this.getMatchWeight(), targetMatchLen);
    }

    public String toString() {
        return "charFrequency(" + this.m_target + ")";
    }
}

