/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;

class ExactMatcher
implements IMatcher {
    private String m_target;
    private String m_eval;
    private boolean m_matchWholeWord;
    private boolean m_matchFully;

    public ExactMatcher(String target, boolean matchWholeWord, boolean matchFully) {
        this.setTargetString(target);
        this.m_matchWholeWord = matchWholeWord;
        this.m_matchFully = matchFully;
    }

    public ExactMatcher(String target, boolean matchWholeWord) {
        this(target, matchWholeWord, false);
    }

    @Override
    public void setTargetString(String target) {
        this.m_target = target;
    }

    @Override
    public String getTargetString() {
        return this.m_target;
    }

    @Override
    public void setEvaluatedString(String eval) {
        this.m_eval = eval;
    }

    @Override
    public String getEvaluatedString() {
        return this.m_eval;
    }

    @Override
    public void appendChars(char[] chars) {
        if (this.m_eval == null) {
            this.m_eval = new String(chars);
        } else {
            StringBuilder sb = new StringBuilder(this.m_eval);
            sb.append(chars);
            this.m_eval = sb.toString();
        }
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        int eLen = this.m_eval.length();
        if (this.m_target.length() <= eLen) {
            return this.m_eval.startsWith(this.m_target);
        }
        if (!partial && (this.m_eval.charAt(eLen - 1) == ' ' ? this.m_target.charAt(eLen - 1) != ' ' : this.m_target.charAt(eLen) != ' ')) {
            return false;
        }
        return this.m_target.startsWith(this.m_eval);
    }

    @Override
    public int targetMatchLength(boolean partial) {
        int eLen = this.m_eval.length();
        int tLen = this.m_target.length();
        if (tLen <= eLen) {
            if (this.m_eval.startsWith(this.m_target)) {
                return tLen;
            }
        } else if (this.m_target.startsWith(this.m_eval) && (partial || this.m_target.charAt(eLen) == ' ')) {
            return eLen;
        }
        return 0;
    }

    @Override
    public boolean matches() {
        int eLen = this.m_eval.length();
        int tLen = this.m_target.length();
        if ((this.m_matchFully || this.m_matchWholeWord) && (eLen < tLen || eLen > tLen && this.m_eval.charAt(tLen) != ' ')) {
            return false;
        }
        if (eLen >= tLen) {
            return this.m_eval.startsWith(this.m_target);
        }
        if (this.m_eval.charAt(eLen - 1) == ' ' || this.m_target.charAt(eLen) == ' ') {
            return this.m_target.startsWith(this.m_eval);
        }
        return false;
    }

    @Override
    public int getMatchWeight() {
        return 100;
    }

    public boolean matchWholeWord() {
        return this.m_matchWholeWord;
    }

    @Override
    public boolean targetPrefixMatches() {
        int tLen;
        int eLen;
        if (this.m_matchWholeWord && ((eLen = this.m_eval.length()) < (tLen = this.m_target.length()) || eLen > tLen && this.m_eval.charAt(tLen) != ' ')) {
            return false;
        }
        return this.m_eval.startsWith(this.m_target);
    }

    public String toString() {
        return "exact(" + this.m_target + ")";
    }

    @Override
    public MatchStats getMatchStats() {
        int targetMatchLen = this.targetMatchLength(false);
        return new MatchStats(targetMatchLen == this.m_target.length(), this.getMatchWeight(), targetMatchLen);
    }
}

