/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.EditDistance;
import java.util.List;

class ExactRegionDistanceMatcher
extends EditDistance {
    private final List<NumberRange> m_exactMatchRegions;

    ExactRegionDistanceMatcher(String target, List<NumberRange> exactMatchRegions, int max, int minCharacterMatch, boolean matchFirstChar) {
        super(target, max, minCharacterMatch, matchFirstChar);
        if (exactMatchRegions == null) {
            throw new NullPointerException();
        }
        this.m_exactMatchRegions = exactMatchRegions;
    }

    @Override
    public boolean matches() {
        if (super.matches()) {
            return this.checkExactMatchRanges();
        }
        return false;
    }

    @Override
    public boolean prefixMatches(boolean partial) {
        if (super.prefixMatches(partial)) {
            return this.checkExactMatchRanges();
        }
        return false;
    }

    @Override
    public boolean targetPrefixMatches() {
        if (super.targetPrefixMatches()) {
            return this.checkExactMatchRanges();
        }
        return false;
    }

    private boolean checkExactMatchRanges() {
        int lastMatchedChar = this.bestMatchedTargetCharNdx();
        for (NumberRange region : this.m_exactMatchRegions) {
            int endCost;
            int startCost;
            int startNdx = region.getStart();
            int endNdx = region.getEnd() - 1;
            if (startNdx > lastMatchedChar || (startCost = startNdx == 0 ? 0 : this.getBestTragetCharCost(startNdx - 1)) >= (endCost = this.getBestTragetCharCost(endNdx > lastMatchedChar ? lastMatchedChar : endNdx))) continue;
            return false;
        }
        return true;
    }
}

