/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.radixtree.MatchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JPNMatcher
implements IMatcher {
    private static final Logger LOG = LoggerFactory.getLogger((String)JPNMatcher.class.getName());
    private String m_rawTarget;
    private String m_cookedTarget;
    private String m_rawEval;
    private String m_cookedEval;

    public JPNMatcher(String target) {
        this.setTargetString(target);
    }

    @Override
    public void setTargetString(String target) {
        this.m_rawTarget = target;
        this.m_cookedTarget = target.replaceAll(" ", "");
    }

    @Override
    public String getTargetString() {
        return this.m_rawTarget;
    }

    @Override
    public void setEvaluatedString(String eval) {
        this.m_rawEval = eval;
        this.m_cookedEval = eval.replaceAll(" ", "");
    }

    @Override
    public String getEvaluatedString() {
        return this.m_rawEval;
    }

    @Override
    public void appendChars(char[] chars) {
        if (this.m_rawEval == null) {
            this.setEvaluatedString("");
        } else {
            this.m_rawEval = this.m_rawEval + new String(chars);
            this.m_cookedEval = this.m_rawEval.replaceAll(" ", "");
        }
    }

    @Override
    public boolean prefixMatches(boolean ignored) {
        Boolean results = null;
        int eLen = this.m_cookedEval.length();
        int tLen = this.m_cookedTarget.length();
        results = tLen == eLen && this.m_cookedEval.equals(this.m_cookedTarget) ? Boolean.valueOf(true) : (tLen < eLen ? Boolean.valueOf(this.m_cookedEval.startsWith(this.m_cookedTarget)) : Boolean.valueOf(this.m_cookedTarget.startsWith(this.m_cookedEval)));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("prefix matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public boolean matches() {
        int tLen;
        Boolean results = null;
        int eLen = this.m_cookedEval.length();
        results = eLen == (tLen = this.m_cookedTarget.length()) ? Boolean.valueOf(this.m_cookedEval.equals(this.m_cookedTarget)) : (eLen > tLen ? Boolean.valueOf(this.m_cookedEval.startsWith(this.m_cookedTarget)) : Boolean.valueOf(false));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public int getMatchWeight() {
        return 100;
    }

    @Override
    public boolean targetPrefixMatches() {
        Boolean results = this.m_cookedEval.startsWith(this.m_cookedTarget);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("target prefix matches(): |%s| |%s| -> %s", this.m_rawTarget, this.m_rawEval, results));
        }
        return results;
    }

    @Override
    public int targetMatchLength(boolean partial) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public MatchStats getMatchStats() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String toString() {
        return "jpn(" + this.m_rawTarget + ")";
    }
}

