/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.matcher;

import com.mapinfo.mapmarker.autosuggest.utils.NumberRange;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.CharFrequencyMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.EditDistance;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.ExactMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.ExactRegionDistanceMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.IDMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.IMatcher;
import com.mapinfo.mapmarker.autosuggest.utils.matcher.SoundexMatcher;
import java.util.List;

public class Matchers {
    public static IMatcher getExactMatcher(String target, boolean matchWholeWord) {
        return new ExactMatcher(target, matchWholeWord);
    }

    public static IMatcher getExactMatcher(String target, boolean matchWholeWord, boolean matchFully) {
        return new ExactMatcher(target, matchWholeWord, matchFully);
    }

    public static IMatcher getEditDistanceMatcher(String target, int maxEdits, int minCharsMatch, boolean matchFirstChar) {
        return new EditDistance(target, maxEdits, minCharsMatch, matchFirstChar);
    }

    public static IMatcher getEditDistanceMatcher(String target, int maxEdits, int minCharsMatch, boolean matchFirstChar, List<NumberRange> exactMatchRegions) {
        if (exactMatchRegions != null && !exactMatchRegions.isEmpty()) {
            return new ExactRegionDistanceMatcher(target, exactMatchRegions, maxEdits, minCharsMatch, matchFirstChar);
        }
        return new EditDistance(target, maxEdits, minCharsMatch, matchFirstChar);
    }

    public static IMatcher getSoundexMatcher(String target) {
        return new SoundexMatcher(target);
    }

    public static IMatcher getCharacterFrequencyMatcher(String target) {
        return new CharFrequencyMatcher(target);
    }

    public static IMatcher getIDMatcher(String target) {
        return new IDMatcher(target);
    }
}

