/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.autosuggest.utils.quadtree;

import com.mapinfo.mapmarker.autosuggest.exception.DataFetchException;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTree;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.DiskQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.IQuadTreeItem;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.QuadLeaf;
import com.mapinfo.mapmarker.autosuggest.utils.quadtree.Rectangle;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DiskQuadLeaf<T extends DiskQuadTreeItem>
extends QuadLeaf {
    public DiskQuadLeaf(Rectangle bounds, DiskQuadTree<T> tree, int quadID) {
        super(bounds, tree, quadID);
    }

    @Override
    public void writeChildren(ICGGEDataOutput out) throws IOException {
        int count = this.getChildCount();
        out.writeVUnsignedInt(count);
        if (count > 0) {
            List<IQuadTreeItem> children = this.getChildren();
            for (int i = 0; i < count; ++i) {
                ((DiskQuadTreeItem)children.get(i)).write(out);
            }
        }
    }

    @Override
    public void readChildren(ICGGEDataInput in) throws IOException {
        int count = in.readVUnsignedInt();
        IQuadTreeItem[] children = new IQuadTreeItem[count];
        for (int i = 0; i < count; ++i) {
            children[i] = this.readChild(in);
        }
        this.setChildren(Arrays.asList(children));
    }

    private IQuadTreeItem readChild(ICGGEDataInput in) throws IOException {
        DiskQuadTreeItem item = ((DiskQuadTree)this.getTree()).getValueType();
        try {
            item = (DiskQuadTreeItem)item.getNewInstance();
        }
        catch (RuntimeException runE) {
            throw runE;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new DataFetchException(e);
        }
        item.read(in);
        return item;
    }
}

